/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BUTTON_IMAGELIST;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text = "";
    String message = "";
    Image image;
    Image image2;
    Image disabledImage;
    ImageList imageList;
    boolean ignoreMouse;
    boolean grayed;
    static final int MARGIN = 4;
    static final int CHECK_WIDTH;
    static final int CHECK_HEIGHT;
    static final int ICON_WIDTH = 128;
    static final int ICON_HEIGHT = 128;
    static boolean COMMAND_LINK;
    static final long ButtonProc;
    static final TCHAR ButtonClass;

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    void _setImage(Image image) {
        if ((this.style & 0x400000) != 0) {
            return;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            if (this.imageList != null) {
                this.imageList.dispose();
            }
            this.imageList = null;
            if (image != null) {
                int n;
                this.imageList = new ImageList(this.style & 0x4000000);
                if (OS.IsWindowEnabled(this.handle)) {
                    this.imageList.add(image);
                } else {
                    if (this.disabledImage != null) {
                        this.disabledImage.dispose();
                    }
                    this.disabledImage = new Image((Device)this.display, image, 1);
                    this.imageList.add(this.disabledImage);
                }
                BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
                bUTTON_IMAGELIST.himl = this.imageList.getHandle();
                int n2 = n = OS.GetWindowLong(this.handle, -16);
                n2 &= 0xFFFFFCFF;
                if ((this.style & 0x4000) != 0) {
                    n2 |= 0x100;
                }
                if ((this.style & 0x1000000) != 0) {
                    n2 |= 0x300;
                }
                if ((this.style & 0x20000) != 0) {
                    n2 |= 0x200;
                }
                if (this.text.length() == 0) {
                    if ((this.style & 0x4000) != 0) {
                        bUTTON_IMAGELIST.uAlign = 0;
                    }
                    if ((this.style & 0x1000000) != 0) {
                        bUTTON_IMAGELIST.uAlign = 4;
                    }
                    if ((this.style & 0x20000) != 0) {
                        bUTTON_IMAGELIST.uAlign = 1;
                    }
                } else {
                    bUTTON_IMAGELIST.uAlign = 0;
                    bUTTON_IMAGELIST.margin_left = this.computeLeftMargin();
                    bUTTON_IMAGELIST.margin_right = 4;
                    n2 &= 0xFFFFFCFF;
                    n2 |= 0x100;
                }
                if (n2 != n) {
                    OS.SetWindowLong(this.handle, -16, n2);
                    OS.InvalidateRect(this.handle, null, true);
                }
                OS.SendMessage(this.handle, 5634, 0L, bUTTON_IMAGELIST);
            } else {
                OS.SendMessage(this.handle, 5634, 0L, 0L);
            }
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n;
            if (this.image2 != null) {
                this.image2.dispose();
            }
            this.image2 = null;
            long l = 0L;
            int n3 = 0;
            int n4 = 0;
            if (image != null) {
                Rectangle rectangle;
                switch (image.type) {
                    case 0: {
                        rectangle = image.getBounds();
                        ImageData imageData = image.getImageData();
                        switch (imageData.getTransparencyType()) {
                            case 4: {
                                if (rectangle.width <= 128 && rectangle.height <= 128) {
                                    this.image2 = new Image((Device)this.display, imageData, imageData.getTransparencyMask());
                                    l = this.image2.handle;
                                    n3 = 64;
                                    n4 = 1;
                                    break;
                                }
                            }
                            case 1: {
                                this.image2 = new Image((Device)this.display, rectangle.width, rectangle.height);
                                GC gC = new GC(this.image2);
                                gC.setBackground(this.getBackground());
                                gC.fillRectangle(rectangle);
                                gC.drawImage(image, 0, 0);
                                gC.dispose();
                                l = this.image2.handle;
                                n3 = 128;
                                n4 = 0;
                                break;
                            }
                            case 0: {
                                l = image.handle;
                                n3 = 128;
                                n4 = 0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        l = image.handle;
                        n3 = 64;
                        n4 = 1;
                    }
                }
                if ((this.style & 0x4000000) != 0 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                    rectangle = image.getBounds();
                    long l2 = OS.GetDC(this.handle);
                    long l3 = OS.CreateCompatibleDC(l2);
                    long l4 = OS.CreateCompatibleBitmap(l2, rectangle.width, rectangle.height);
                    long l5 = OS.SelectObject(l3, l4);
                    OS.SetLayout(l3, 1);
                    if (n4 == 0) {
                        long l6 = OS.CreateCompatibleDC(l2);
                        long l7 = OS.SelectObject(l6, l);
                        OS.SetLayout(l3, 0);
                        OS.BitBlt(l3, 0, 0, rectangle.width, rectangle.height, l6, 0, 0, 0xCC0020);
                        OS.SelectObject(l6, l7);
                        OS.DeleteDC(l6);
                    } else {
                        Control control = this.findBackgroundControl();
                        if (control == null) {
                            control = this;
                        }
                        long l8 = OS.CreateSolidBrush(control.getBackgroundPixel());
                        long l9 = OS.SelectObject(l3, l8);
                        OS.PatBlt(l3, 0, 0, rectangle.width, rectangle.height, 15728673);
                        OS.DrawIconEx(l3, 0, 0, l, 0, 0, 0, 0L, 3);
                        OS.SelectObject(l3, l9);
                        OS.DeleteObject(l8);
                    }
                    OS.SelectObject(l3, l5);
                    OS.DeleteDC(l3);
                    OS.ReleaseDC(this.handle, l2);
                    if (this.image2 != null) {
                        this.image2.dispose();
                    }
                    this.image2 = Image.win32_new(this.display, 0, l4);
                    n3 = 128;
                    n4 = 0;
                    l = l4;
                }
            }
            int n5 = n = OS.GetWindowLong(this.handle, -16);
            n &= 0xFFFFFF3F;
            if ((n |= n3) != n5) {
                OS.SetWindowLong(this.handle, -16, n);
            }
            OS.SendMessage(this.handle, 247, (long)n4, l);
        }
    }

    void _setText(String string) {
        Object object;
        int n;
        int n2 = n = OS.GetWindowLong(this.handle, -16);
        if (OS.COMCTL32_MAJOR >= 6) {
            n2 &= 0xFFFFFCFF;
            if ((this.style & 0x4000) != 0) {
                n2 |= 0x100;
            }
            if ((this.style & 0x1000000) != 0) {
                n2 |= 0x300;
            }
            if ((this.style & 0x20000) != 0) {
                n2 |= 0x200;
            }
            if (this.imageList != null) {
                object = new BUTTON_IMAGELIST();
                ((BUTTON_IMAGELIST)object).himl = this.imageList.getHandle();
                if (string.length() == 0) {
                    if ((this.style & 0x4000) != 0) {
                        ((BUTTON_IMAGELIST)object).uAlign = 0;
                    }
                    if ((this.style & 0x1000000) != 0) {
                        ((BUTTON_IMAGELIST)object).uAlign = 4;
                    }
                    if ((this.style & 0x20000) != 0) {
                        ((BUTTON_IMAGELIST)object).uAlign = 1;
                    }
                } else {
                    ((BUTTON_IMAGELIST)object).uAlign = 0;
                    ((BUTTON_IMAGELIST)object).margin_left = this.computeLeftMargin();
                    ((BUTTON_IMAGELIST)object).margin_right = 4;
                    n2 &= 0xFFFFFCFF;
                    n2 |= 0x100;
                }
                OS.SendMessage(this.handle, 5634, 0L, (BUTTON_IMAGELIST)object);
            }
        } else {
            n2 &= 0xFFFFFF3F;
        }
        if (n2 != n) {
            OS.SetWindowLong(this.handle, -16, n2);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            string = OS.IsWindowEnabled(this.handle) ? string : " " + string + " ";
        }
        object = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, (TCHAR)object);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.CallWindowProc(ButtonProc, l, n, l2, l3);
    }

    static int checkStyle(int n) {
        if (((n = Button.checkBits(n, 8, 4, 32, 16, 2, COMMAND_LINK ? 0x400000 : 0)) & 0xA) != 0) {
            return Button.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Button.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n & 4) != 0) {
            return Button.checkBits(n |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n;
    }

    void click() {
        this.ignoreMouse = true;
        OS.SendMessage(this.handle, 245, 0L, 0L);
        this.ignoreMouse = false;
    }

    int computeLeftMargin() {
        if (OS.COMCTL32_MAJOR < 6) {
            return 4;
        }
        if ((this.style & 0xA) == 0) {
            return 4;
        }
        int n = 0;
        if (this.image != null && this.text.length() != 0) {
            Rectangle rectangle = this.image.getBounds();
            n += rectangle.width + 8;
            long l = 0L;
            long l2 = OS.GetDC(this.handle);
            long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l3 != 0L) {
                l = OS.SelectObject(l2, l3);
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), this.text, true);
            RECT rECT = new RECT();
            int n2 = 1056;
            OS.DrawText(l2, tCHAR, -1, rECT, n2);
            n += rECT.right - rECT.left;
            if (l3 != 0L) {
                OS.SelectObject(l2, l);
            }
            OS.ReleaseDC(this.handle, l2);
            OS.GetClientRect(this.handle, rECT);
            n = Math.max(4, (rECT.right - rECT.left - n) / 2);
        }
        return n;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getBorderWidth();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x480) != 0) {
                n3 += OS.GetSystemMetrics(2);
                n4 += OS.GetSystemMetrics(20);
            } else {
                n3 += OS.GetSystemMetrics(21);
                n4 += OS.GetSystemMetrics(3);
            }
        } else if ((this.style & 0x400000) != 0) {
            SIZE sIZE = new SIZE();
            if (n != -1) {
                sIZE.cx = n;
                OS.SendMessage(this.handle, 5633, 0L, sIZE);
                n3 = sIZE.cx;
                n4 = sIZE.cy;
            } else {
                OS.SendMessage(this.handle, 5633, 0L, sIZE);
                n3 = sIZE.cy;
                n4 = sIZE.cy;
                sIZE.cy = 0;
                while (sIZE.cy != n4) {
                    sIZE.cx = n3++;
                    sIZE.cy = 0;
                    OS.SendMessage(this.handle, 5633, 0L, sIZE);
                }
            }
        } else {
            int n6 = 0;
            boolean bl2 = this.image != null;
            boolean bl3 = true;
            if (OS.COMCTL32_MAJOR < 6 && (this.style & 8) == 0) {
                int n7 = OS.GetWindowLong(this.handle, -16);
                boolean bl4 = bl2 = (n7 & 0xC0) != 0;
                if (bl2) {
                    bl3 = false;
                }
            }
            if (bl2 && this.image != null) {
                Rectangle rectangle = this.image.getBounds();
                n3 = rectangle.width;
                if (bl3 && this.text.length() != 0) {
                    n3 += 8;
                }
                n4 = rectangle.height;
                n6 = 8;
            }
            if (bl3) {
                long l = 0L;
                long l2 = OS.GetDC(this.handle);
                long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
                if (l3 != 0L) {
                    l = OS.SelectObject(l2, l3);
                }
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(l2, tEXTMETRIC);
                int n8 = this.text.length();
                if (n8 == 0) {
                    n4 = Math.max(n4, tEXTMETRIC.tmHeight);
                } else {
                    n6 = Math.max(8, tEXTMETRIC.tmAveCharWidth);
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), this.text, true);
                    RECT rECT = new RECT();
                    int n9 = 1056;
                    if ((this.style & 0x40) != 0 && n != -1) {
                        n9 = 1040;
                        rECT.right = n - n3 - 2 * n5;
                        rECT.right = (this.style & 0x30) != 0 ? (rECT.right -= CHECK_WIDTH + 3) : (rECT.right -= 6);
                        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
                            rECT.right -= 2;
                            if ((this.style & 0x30) != 0) {
                                rECT.right -= 2;
                            }
                        }
                    }
                    OS.DrawText(l2, tCHAR, -1, rECT, n9);
                    n3 += rECT.right - rECT.left;
                    n4 = Math.max(n4, rECT.bottom - rECT.top);
                }
                if (l3 != 0L) {
                    OS.SelectObject(l2, l);
                }
                OS.ReleaseDC(this.handle, l2);
            }
            if ((this.style & 0x30) != 0) {
                n3 += CHECK_WIDTH + n6;
                n4 = Math.max(n4, CHECK_HEIGHT + 3);
            }
            if ((this.style & 0xA) != 0) {
                n3 += 12;
                n4 += 10;
            }
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    void createHandle() {
        this.parent.state |= 0x100000;
        super.createHandle();
        this.parent.state &= 0xFFEFFFFF;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0)) {
                this.state |= 0x100;
            } else if ((this.style & 0xA) == 0) {
                this.state |= 0x100;
            }
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (this.style & 0x10) != 0) {
            this.state |= 0x200;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && !OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) && (this.style & 0xA) != 0) {
            this.state |= 0x200;
        }
    }

    int defaultBackground() {
        if ((this.style & 0xA) != 0) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_BTNTEXT);
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            boolean bl2;
            int n = OS.GetWindowLong(this.handle, -16);
            boolean bl3 = bl2 = (n & 0xC0) != 0;
            if (!bl2) {
                String string = bl ? this.text : " " + this.text + " ";
                TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
                OS.SetWindowText(this.handle, tCHAR);
            }
        }
        this.updateImageList();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        int n = OS.GetWindowLong(this.handle, -16);
        return (n & 1) != 0;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getMessage() {
        this.checkWidget();
        return this.message;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        long l = OS.SendMessage(this.handle, 240, 0L, 0L);
        return l != 0L;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    boolean isTabItem() {
        if ((this.style & 8) != 0) {
            return this.isTabGroup();
        }
        return super.isTabItem();
    }

    boolean mnemonicHit(char c) {
        if (!this.setFocus()) {
            return false;
        }
        if ((this.style & 0x10) == 0) {
            this.click();
        }
        return true;
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
        }
        this.disabledImage = null;
        if (this.image2 != null) {
            this.image2.dispose();
        }
        this.image2 = null;
        this.text = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if (this == control) continue;
            control.setRadioSelection(false);
        }
        this.setSelection(true);
    }

    public void setAlignment(int n) {
        int n2;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n & 0x24480;
            OS.InvalidateRect(this.handle, null, true);
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n3 = n2 = OS.GetWindowLong(this.handle, -16);
        n3 &= 0xFFFFFCFF;
        if ((this.style & 0x4000) != 0) {
            n3 |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            n3 |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            n3 |= 0x200;
        }
        if (OS.COMCTL32_MAJOR >= 6 && this.imageList != null) {
            BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
            bUTTON_IMAGELIST.himl = this.imageList.getHandle();
            if (this.text.length() == 0) {
                if ((this.style & 0x4000) != 0) {
                    bUTTON_IMAGELIST.uAlign = 0;
                }
                if ((this.style & 0x1000000) != 0) {
                    bUTTON_IMAGELIST.uAlign = 4;
                }
                if ((this.style & 0x20000) != 0) {
                    bUTTON_IMAGELIST.uAlign = 1;
                }
            } else {
                bUTTON_IMAGELIST.uAlign = 0;
                bUTTON_IMAGELIST.margin_left = this.computeLeftMargin();
                bUTTON_IMAGELIST.margin_right = 4;
                n3 &= 0xFFFFFCFF;
                n3 |= 0x100;
            }
            OS.SendMessage(this.handle, 5634, 0L, bUTTON_IMAGELIST);
        }
        if (n3 != n2) {
            OS.SetWindowLong(this.handle, -16, n3);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    void setDefault(boolean bl) {
        if ((this.style & 8) == 0) {
            return;
        }
        long l = this.menuShell().handle;
        int n = OS.GetWindowLong(this.handle, -16);
        if (bl) {
            n |= 1;
            OS.SendMessage(l, 1025, this.handle, 0L);
        } else {
            n &= 0xFFFFFFFE;
            OS.SendMessage(l, 1025, 0L, 0L);
        }
        OS.SendMessage(this.handle, 244, (long)n, 1L);
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x10) != 0 && !this.getSelection() && this.display.fixFocus) {
            return false;
        }
        return super.setFocus();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        this._setImage(image);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = bl;
        long l = OS.SendMessage(this.handle, 240, 0L, 0L);
        if (bl) {
            if (l == 1L) {
                this.updateSelection(2);
            }
        } else if (l == 2L) {
            this.updateSelection(1);
        }
    }

    void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if (OS.COMCTL32_VERSION >= OS.VERSION(6, 1) && (this.style & 0x400000) != 0) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            OS.SendMessage(this.handle, 5641, 0L, cArray);
        }
    }

    boolean setRadioFocus(boolean bl) {
        if ((this.style & 0x10) == 0 || !this.getSelection()) {
            return false;
        }
        return bl ? this.setTabItemFocus() : this.setFocus();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    boolean setSavedFocus() {
        if ((this.style & 0x10) != 0 && !this.getSelection()) {
            return false;
        }
        return super.setSavedFocus();
    }

    public void setSelection(boolean bl) {
        int n;
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int n2 = n = bl ? 1 : 0;
        if ((this.style & 0x20) != 0 && bl && this.grayed) {
            n = 2;
        }
        this.updateSelection(n);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        this._setText(string);
    }

    void updateImageList() {
        if (OS.COMCTL32_MAJOR >= 6 && this.imageList != null) {
            BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
            OS.SendMessage(this.handle, 5635, 0L, bUTTON_IMAGELIST);
            if (this.imageList != null) {
                this.imageList.dispose();
            }
            this.imageList = new ImageList(this.style & 0x4000000);
            if (OS.IsWindowEnabled(this.handle)) {
                this.imageList.add(this.image);
            } else {
                if (this.disabledImage != null) {
                    this.disabledImage.dispose();
                }
                this.disabledImage = new Image((Device)this.display, this.image, 1);
                this.imageList.add(this.disabledImage);
            }
            bUTTON_IMAGELIST.himl = this.imageList.getHandle();
            OS.SendMessage(this.handle, 5634, 0L, bUTTON_IMAGELIST);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    void updateOrientation() {
        super.updateOrientation();
        this.updateImageList();
    }

    void updateSelection(int n) {
        if ((long)n != OS.SendMessage(this.handle, 240, 0L, 0L)) {
            int n2 = OS.GetWindowLong(this.handle, -16);
            if ((this.style & 0x20) != 0) {
                if (n == 2) {
                    n2 &= 0xFFFFFFFD;
                    n2 |= 5;
                } else {
                    n2 |= 2;
                    n2 &= 0xFFFFFFFA;
                }
                if (n2 != OS.GetWindowLong(this.handle, -16)) {
                    OS.SetWindowLong(this.handle, -16, n2);
                }
            }
            OS.SendMessage(this.handle, 241, (long)n, 0L);
            if (n2 != OS.GetWindowLong(this.handle, -16)) {
                OS.SetWindowLong(this.handle, -16, n2);
            }
        }
    }

    int widgetStyle() {
        int n = super.widgetStyle();
        if ((this.style & 0x800000) != 0) {
            n |= 0x8000;
        }
        if ((this.style & 4) != 0) {
            return n | 0xB;
        }
        if ((this.style & 0x4000) != 0) {
            n |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            n |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            n |= 0x200;
        }
        if ((this.style & 0x40) != 0) {
            n |= 0x2000;
        }
        if ((this.style & 8) != 0) {
            return n | 0 | 0x10000;
        }
        if ((this.style & 0x20) != 0) {
            return n | 2 | 0x10000;
        }
        if ((this.style & 0x10) != 0) {
            return n | 4;
        }
        if ((this.style & 2) != 0) {
            return n | 0x1000 | 2 | 0x10000;
        }
        if ((this.style & 0x400000) != 0) {
            return n | 0xE | 0x10000;
        }
        return n | 0 | 0x10000;
    }

    TCHAR windowClass() {
        return ButtonClass;
    }

    long windowProc() {
        return ButtonProc;
    }

    LRESULT WM_ERASEBKGND(long l, long l2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6 && (this.style & 0x30) != 0 && this.findImageControl() != null) {
            this.drawBackground(l);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(long l, long l2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 4) != 0) {
            return new LRESULT(256L);
        }
        return lRESULT;
    }

    LRESULT WM_GETOBJECT(long l, long l2) {
        if ((this.style & 0x10) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(l, l2);
    }

    LRESULT WM_KILLFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(l, l2);
        if ((this.style & 8) != 0 && this.getDefault()) {
            this.menuShell().setDefaultButton(null, false);
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONDOWN(l, l2);
    }

    LRESULT WM_LBUTTONUP(long l, long l2) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONUP(l, l2);
    }

    LRESULT WM_SETFOCUS(long l, long l2) {
        int n = 0;
        if ((this.style & 0x10) != 0) {
            n = OS.GetWindowLong(this.handle, -16);
        }
        LRESULT lRESULT = super.WM_SETFOCUS(l, l2);
        if ((this.style & 0x10) != 0) {
            OS.SetWindowLong(this.handle, -16, n);
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(long l, long l2) {
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6 && (this.style & 0xA) != 0 && this.imageList != null && this.text.length() != 0) {
            BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
            OS.SendMessage(this.handle, 5635, 0L, bUTTON_IMAGELIST);
            bUTTON_IMAGELIST.uAlign = 0;
            bUTTON_IMAGELIST.margin_left = this.computeLeftMargin();
            bUTTON_IMAGELIST.margin_right = 4;
            OS.SendMessage(this.handle, 5634, 0L, bUTTON_IMAGELIST);
        }
        return lRESULT;
    }

    LRESULT WM_SYSCOLORCHANGE(long l, long l2) {
        LRESULT lRESULT = super.WM_SYSCOLORCHANGE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.image2 != null) {
            this._setImage(this.image);
        }
        return lRESULT;
    }

    LRESULT WM_UPDATEUISTATE(long l, long l2) {
        LRESULT lRESULT = super.WM_UPDATEUISTATE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && (this.style & 0x32) != 0) {
            boolean bl;
            boolean bl2 = bl = this.findImageControl() != null;
            if (!bl) {
                if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                    boolean bl3 = bl = this.findThemeControl() != null;
                }
                if (!bl) {
                    boolean bl4 = bl = this.findBackgroundControl() != null;
                }
            }
            if (bl) {
                OS.InvalidateRect(this.handle, null, false);
                long l3 = OS.DefWindowProc(this.handle, 296, l, l2);
                return new LRESULT(l3);
            }
        }
        if ((this.style & 0xA) != 0 && (this.hooks(9) || this.filters(9))) {
            OS.InvalidateRect(this.handle, null, true);
        }
        return lRESULT;
    }

    LRESULT wmCommandChild(long l, long l2) {
        int n = OS.HIWORD(l);
        switch (n) {
            case 0: 
            case 5: {
                if ((this.style & 0x22) != 0) {
                    this.setSelection(!this.getSelection());
                } else if ((this.style & 0x10) != 0) {
                    if ((this.parent.getStyle() & 0x400000) != 0) {
                        this.setSelection(!this.getSelection());
                    } else {
                        this.selectRadio();
                    }
                }
                this.sendSelectionEvent(13);
            }
        }
        return super.wmCommandChild(l, l2);
    }

    LRESULT wmColorChild(long l, long l2) {
        LRESULT lRESULT = super.wmColorChild(l, l2);
        if (OS.COMCTL32_MAJOR < 6 && (this.style & 0x30) != 0 && this.findImageControl() != null) {
            OS.SetBkMode(l, 1);
            return new LRESULT(OS.GetStockObject(5));
        }
        return lRESULT;
    }

    LRESULT wmDrawChild(long l, long l2) {
        if ((this.style & 4) == 0) {
            return super.wmDrawChild(l, l2);
        }
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, l2, DRAWITEMSTRUCT.sizeof);
        RECT rECT = new RECT();
        OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, dRAWITEMSTRUCT.right, dRAWITEMSTRUCT.bottom);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n = 9;
            switch (this.style & 0x24480) {
                case 128: {
                    n = 1;
                    break;
                }
                case 1024: {
                    n = 5;
                    break;
                }
                case 16384: {
                    n = 9;
                    break;
                }
                case 131072: {
                    n = 13;
                }
            }
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && (this.style & 0x8000000) != 0 && (this.style & 0x24000) != 0) {
                int n2 = n = n == 13 ? 9 : 13;
            }
            if (!this.getEnabled()) {
                n += 3;
            }
            if ((dRAWITEMSTRUCT.itemState & 1) != 0) {
                n += 2;
            }
            OS.DrawThemeBackground(this.display.hScrollBarTheme(), dRAWITEMSTRUCT.hDC, 1, n, rECT, null);
        } else {
            int n = 2;
            switch (this.style & 0x24480) {
                case 128: {
                    n = 0;
                    break;
                }
                case 1024: {
                    n = 1;
                    break;
                }
                case 16384: {
                    n = 2;
                    break;
                }
                case 131072: {
                    n = 3;
                }
            }
            if (!this.getEnabled()) {
                n |= 0x100;
            }
            if ((this.style & 0x800000) == 0x800000) {
                n |= 0x4000;
            }
            if ((dRAWITEMSTRUCT.itemState & 1) != 0) {
                n |= 0x200;
            }
            OS.DrawFrameControl(dRAWITEMSTRUCT.hDC, rECT, 3, n);
        }
        return null;
    }

    static {
        Object object;
        COMMAND_LINK = false;
        ButtonClass = new TCHAR(0, "BUTTON", true);
        long l = OS.LoadBitmap(0L, 32759L);
        if (l == 0L) {
            CHECK_WIDTH = OS.GetSystemMetrics(OS.IsWinCE ? 49 : 2);
            CHECK_HEIGHT = OS.GetSystemMetrics(OS.IsWinCE ? 50 : 20);
        } else {
            object = new BITMAP();
            OS.GetObject(l, BITMAP.sizeof, (BITMAP)object);
            OS.DeleteObject(l);
            CHECK_WIDTH = ((BITMAP)object).bmWidth / 4;
            CHECK_HEIGHT = ((BITMAP)object).bmHeight / 3;
        }
        object = new WNDCLASS();
        OS.GetClassInfo(0L, ButtonClass, (WNDCLASS)object);
        ButtonProc = ((WNDCLASS)object).lpfnWndProc;
    }
}

