/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkplugBPayloadDataMap
extends SparkplugBPayload {
    private static Logger logger = LoggerFactory.getLogger(SparkplugBPayloadDataMap.class.getName());
    private final Map<String, Metric> metricMap;
    private final Set<String> metricIdSet;
    private final Object mapLock = new Object();

    public SparkplugBPayloadDataMap() {
        this.metricMap = new ConcurrentSkipListMap<String, Metric>();
        this.metricIdSet = ConcurrentHashMap.newKeySet();
    }

    public SparkplugBPayloadDataMap(Date timestamp, List<Metric> metrics, long seq, String uuid, byte[] body) {
        super(timestamp, null, seq, uuid, body);
        this.metricMap = new ConcurrentSkipListMap<String, Metric>();
        this.metricIdSet = ConcurrentHashMap.newKeySet();
        for (Metric metric : metrics) {
            try {
                this.metricMap.put(metric.getKey(), metric);
                this.metricIdSet.add(metric.hasName() ? metric.getName() : metric.getAlias().toString());
            }
            catch (Exception e) {
                logger.error("Failed to init Metric: {}", (Object)metric);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(Metric metric) {
        Object object = this.mapLock;
        synchronized (object) {
            try {
                if (logger.isDebugEnabled() && this.metricMap.containsKey(metric.getKey())) {
                    logger.debug("Metric key: {}", (Object)metric.getKey());
                    logger.debug("\tOverwriting existing metric: {}", (Object)this.metricMap.get(metric.getKey()));
                    logger.debug("\twith new metric: {}", (Object)metric);
                }
                this.metricMap.put(metric.getKey(), metric);
                this.metricIdSet.add(metric.hasName() ? metric.getName() : metric.getAlias().toString());
            }
            catch (Exception e) {
                logger.error("Failed to add Metric: {}", (Object)metric);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(int index, Metric metric) {
        Object object = this.mapLock;
        synchronized (object) {
            try {
                this.metricMap.put(metric.getKey(), metric);
                this.metricIdSet.add(metric.hasName() ? metric.getName() : metric.getAlias().toString());
            }
            catch (Exception e) {
                logger.error("Failed to init Metric at {}: {}", (Object)index, (Object)metric);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetrics(List<Metric> metrics) {
        Object object = this.mapLock;
        synchronized (object) {
            for (Metric metric : metrics) {
                this.addMetric(metric);
            }
        }
    }

    @Override
    public Metric removeMetric(int index) {
        logger.error("removeMetric(int index) isn't supported by the SparkplugBPayloadDataMap");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMetric(Metric metric) {
        Object object = this.mapLock;
        synchronized (object) {
            boolean foundMetric = false;
            if (metric != null) {
                Iterator<String> it = this.metricMap.keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next();
                    if (metric.hasName() && key.contains("_" + metric.getName())) {
                        try {
                            long timestamp = Long.parseLong(key.substring(0, key.indexOf("_")));
                            logger.debug("Removing metric: {}", (Object)metric);
                            it.remove();
                            foundMetric = true;
                        }
                        catch (Exception e) {
                            logger.trace("This isn't the metric we are looking for with key={}: {}", (Object)key, (Object)metric);
                        }
                        continue;
                    }
                    if (!metric.hasAlias() || !key.contains("_" + metric.getAlias())) continue;
                    try {
                        long timestamp = Long.parseLong(key.substring(0, key.indexOf("_")));
                        logger.debug("Removing metric: {}", (Object)metric);
                        it.remove();
                        foundMetric = true;
                    }
                    catch (Exception e) {
                        logger.trace("This isn't the metric we are looking for with key={}: {}", (Object)key, (Object)metric);
                    }
                }
            }
            return foundMetric;
        }
    }

    @Override
    public List<Metric> getMetrics() {
        return new ArrayList<Metric>(this.metricMap.values());
    }

    @Override
    @JsonIgnore
    public Integer getMetricCount() {
        return this.metricMap.size();
    }

    @Override
    public void setMetrics(List<Metric> metrics) {
        this.metricMap.clear();
        for (Metric metric : metrics) {
            this.addMetric(metric);
        }
    }

    @JsonIgnore
    public Map<String, Metric> getMetricMap() {
        return this.metricMap;
    }

    @JsonIgnore
    public Set<String> getMetricIdSet() {
        return this.metricIdSet;
    }

    public void updateMetricTimestamps(Date date) {
        for (Metric metric : this.metricMap.values()) {
            logger.debug("Updating metric timestamp for {} to {}", (Object)metric, (Object)date.getTime());
            metric.setTimestamp(date);
            if (metric.getDataType() != MetricDataType.Template || metric.getValue() == null) continue;
            this.updateTemplateTimestamps((Template)metric.getValue(), date);
        }
    }

    private void updateTemplateTimestamps(Template template, Date date) {
        if (template != null && template.getMetrics() != null) {
            for (Metric metric : template.getMetrics()) {
                logger.debug("Updating metric timestamp for {} to {}", (Object)metric, (Object)date.getTime());
                metric.setTimestamp(date);
                if (metric.getDataType() != MetricDataType.Template || metric.getValue() == null) continue;
                this.updateTemplateTimestamps((Template)metric.getValue(), date);
            }
        }
    }

    public void uptickMetricTimestamps(Date birthTimestamp) {
        for (Metric metric : this.metricMap.values()) {
            Date uptickedTimestamp = new Date(metric.getTimestamp().getTime() + 1L);
            if (birthTimestamp.before(uptickedTimestamp)) {
                logger.debug("Updating metric timestamp for {} to birthTimestamp -> {}", (Object)metric, (Object)uptickedTimestamp.getTime());
                metric.setTimestamp(birthTimestamp);
            } else {
                logger.debug("Updating metric timestamp for {} to uptickedTimestamp -> {}", (Object)metric, (Object)uptickedTimestamp.getTime());
                metric.setTimestamp(uptickedTimestamp);
            }
            if (metric.getDataType() != MetricDataType.Template || metric.getValue() == null) continue;
            this.uptickTemplateTimestamps((Template)metric.getValue(), birthTimestamp);
        }
    }

    private void uptickTemplateTimestamps(Template template, Date birthTimestamp) {
        if (template != null && template.getMetrics() != null) {
            for (Metric metric : template.getMetrics()) {
                Date uptickedTimestamp = new Date(metric.getTimestamp().getTime() + 1L);
                if (birthTimestamp.before(uptickedTimestamp)) {
                    logger.debug("Updating metric timestamp for {} to birthTimestamp -> {}", (Object)metric, (Object)uptickedTimestamp.getTime());
                    metric.setTimestamp(birthTimestamp);
                } else {
                    logger.debug("Updating metric timestamp for {} to uptickedTimestamp -> {}", (Object)metric, (Object)uptickedTimestamp.getTime());
                    metric.setTimestamp(uptickedTimestamp);
                }
                if (metric.getDataType() != MetricDataType.Template || metric.getValue() == null) continue;
                this.updateTemplateTimestamps((Template)metric.getValue(), birthTimestamp);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SparkplugBPayloadMap [timestamp=");
        builder.append(super.getTimestamp() != null ? Long.valueOf(super.getTimestamp().getTime()) : "null");
        builder.append(", metrics=");
        builder.append(this.getMetrics());
        builder.append(", seq=");
        builder.append(super.getSeq());
        builder.append(", uuid=");
        builder.append(super.getUuid());
        builder.append(", body=");
        builder.append(Arrays.toString(super.getBody()));
        builder.append("]");
        return builder.toString();
    }

    public static class SparkplugBPayloadDataMapBuilder {
        private Date timestamp;
        private List<Metric> metrics;
        private long seq = -1L;
        private String uuid;
        private byte[] body;

        public SparkplugBPayloadDataMapBuilder(long sequenceNumber) {
            this.seq = sequenceNumber;
            this.metrics = new ArrayList<Metric>();
        }

        public SparkplugBPayloadDataMapBuilder() {
            this.metrics = new ArrayList<Metric>();
        }

        public SparkplugBPayloadDataMapBuilder addMetric(Metric metric) {
            this.metrics.add(metric);
            return this;
        }

        public SparkplugBPayloadDataMapBuilder addMetrics(Collection<Metric> metrics) {
            this.metrics.addAll(metrics);
            return this;
        }

        public SparkplugBPayloadDataMapBuilder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SparkplugBPayloadDataMapBuilder setSeq(long seq) {
            this.seq = seq;
            return this;
        }

        public SparkplugBPayloadDataMapBuilder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public SparkplugBPayloadDataMapBuilder setBody(byte[] body) {
            this.body = body;
            return this;
        }

        public SparkplugBPayloadDataMap createPayload() {
            return new SparkplugBPayloadDataMap(this.timestamp, this.metrics, this.seq, this.uuid, this.body);
        }
    }
}

