/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.MessageType;
import org.eclipse.tahu.message.model.SparkplugDescriptor;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Topic {
    private final String namespace;
    @JsonIgnore
    private final SparkplugDescriptor sparkplugDescriptor;
    private final EdgeNodeDescriptor edgeNodeDescriptor;
    private final String groupId;
    private final String edgeNodeId;
    private final String deviceId;
    private final String hostApplicationId;
    private final MessageType type;

    public Topic() {
        this.namespace = null;
        this.sparkplugDescriptor = null;
        this.edgeNodeDescriptor = null;
        this.groupId = null;
        this.edgeNodeId = null;
        this.deviceId = null;
        this.hostApplicationId = null;
        this.type = null;
    }

    public Topic(String namespace, String groupId, String edgeNodeId, String deviceId, MessageType type) {
        this.namespace = namespace;
        this.sparkplugDescriptor = deviceId == null ? new EdgeNodeDescriptor(groupId, edgeNodeId) : new DeviceDescriptor(groupId, edgeNodeId, deviceId);
        this.edgeNodeDescriptor = new EdgeNodeDescriptor(groupId, edgeNodeId);
        this.groupId = groupId;
        this.edgeNodeId = edgeNodeId;
        this.deviceId = deviceId;
        this.hostApplicationId = null;
        this.type = type;
    }

    public Topic(String namespace, String groupId, String edgeNodeId, MessageType type) {
        this.namespace = namespace;
        this.sparkplugDescriptor = new EdgeNodeDescriptor(groupId, edgeNodeId);
        this.edgeNodeDescriptor = new EdgeNodeDescriptor(groupId, edgeNodeId);
        this.groupId = groupId;
        this.edgeNodeId = edgeNodeId;
        this.deviceId = null;
        this.hostApplicationId = null;
        this.type = type;
    }

    public Topic(String namespace, DeviceDescriptor deviceDescriptor, MessageType type) {
        this(namespace, deviceDescriptor.getGroupId(), deviceDescriptor.getEdgeNodeId(), deviceDescriptor.getDeviceId(), type);
    }

    public Topic(String namespace, EdgeNodeDescriptor edgeNodeDescriptor, MessageType type) {
        this(namespace, edgeNodeDescriptor.getGroupId(), edgeNodeDescriptor.getEdgeNodeId(), type);
    }

    public Topic(String namespace, String hostApplicationId, MessageType type) {
        this.namespace = namespace;
        this.hostApplicationId = hostApplicationId;
        this.type = type;
        this.sparkplugDescriptor = null;
        this.edgeNodeDescriptor = null;
        this.groupId = null;
        this.edgeNodeId = null;
        this.deviceId = null;
    }

    public static Topic parseTopic(String[] splitTopic) throws TahuException {
        StringBuilder sb = new StringBuilder();
        if (splitTopic != null && splitTopic.length > 0) {
            for (int i = 0; i < splitTopic.length; ++i) {
                sb.append(splitTopic[i]);
                if (i - 1 >= splitTopic.length) continue;
                sb.append("/");
            }
            return Topic.parseTopic(sb.toString());
        }
        throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Split topic is null or empty");
    }

    public static Topic parseTopic(String topicString) throws TahuException {
        try {
            if (topicString == null || topicString.isEmpty() || !topicString.startsWith("spBv1.0") || !topicString.contains("/")) {
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid Sparkplug topic String: ''" + topicString);
            }
            String[] splitTopic = topicString.split("/");
            if (splitTopic.length == 3) {
                if ("spBv1.0".equals(splitTopic[0]) && "STATE".equals(splitTopic[1])) {
                    return new Topic("spBv1.0", splitTopic[2], MessageType.STATE);
                }
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid Sparkplug STATE topic String: ''" + topicString);
            }
            if (splitTopic.length == 4) {
                MessageType messageType = MessageType.parseMessageType(splitTopic[2]);
                if ("spBv1.0".equals(splitTopic[0]) && (messageType == MessageType.NBIRTH || messageType == MessageType.NCMD || messageType == MessageType.NDATA || messageType == MessageType.NDEATH || messageType == MessageType.NRECORD)) {
                    return new Topic("spBv1.0", splitTopic[1], splitTopic[3], messageType);
                }
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid Sparkplug Edge Node topic String: ''" + topicString);
            }
            if (splitTopic.length == 5) {
                MessageType messageType = MessageType.parseMessageType(splitTopic[2]);
                if ("spBv1.0".equals(splitTopic[0]) && (messageType == MessageType.DBIRTH || messageType == MessageType.DCMD || messageType == MessageType.DDATA || messageType == MessageType.DDEATH || messageType == MessageType.DRECORD)) {
                    return new Topic("spBv1.0", splitTopic[1], splitTopic[3], messageType);
                }
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid Sparkplug Device topic String: ''" + topicString);
            }
            throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid topic String length: ''" + topicString);
        }
        catch (Exception e) {
            throw new TahuException(TahuErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public SparkplugDescriptor getSparkplugDescriptor() {
        return this.sparkplugDescriptor;
    }

    public EdgeNodeDescriptor getEdgeNodeDescriptor() {
        return this.edgeNodeDescriptor;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getEdgeNodeId() {
        return this.edgeNodeId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getHostApplicationId() {
        return this.hostApplicationId;
    }

    public MessageType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hostApplicationId == null) {
            sb.append(this.getNamespace()).append("/").append(this.getGroupId()).append("/").append((Object)this.getType()).append("/").append(this.getEdgeNodeId());
            if (this.getDeviceId() != null) {
                sb.append("/").append(this.getDeviceId());
            }
        } else {
            sb.append(this.getNamespace()).append("/").append((Object)this.getType()).append("/").append(this.hostApplicationId);
        }
        return sb.toString();
    }

    public boolean isType(MessageType type) {
        return this.type != null && this.type.equals((Object)type);
    }
}

