/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.mqtt;

import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;

public class MqttServerUrl {
    private final String mqttServerUrl;
    private final String protocol;
    private final String fqdn;
    private final Integer port;

    public MqttServerUrl(String mqttServerUrl) throws TahuException {
        block6: {
            this.mqttServerUrl = mqttServerUrl;
            try {
                String[] fqdnParts;
                if (mqttServerUrl.contains("://")) {
                    String[] protocolParts = mqttServerUrl.split("://");
                    this.protocol = protocolParts[0];
                    fqdnParts = protocolParts[1].split(":");
                } else {
                    this.protocol = "tcp";
                    fqdnParts = mqttServerUrl.split(":");
                }
                if (fqdnParts.length == 1) {
                    this.fqdn = fqdnParts[0];
                    this.port = 1883;
                    break block6;
                }
                if (fqdnParts.length == 2) {
                    this.fqdn = fqdnParts[0];
                    this.port = Integer.parseInt(fqdnParts[1]);
                    break block6;
                }
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid MQTT Server URL: " + mqttServerUrl);
            }
            catch (Exception e) {
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid MQTT Server URL: " + mqttServerUrl, e);
            }
        }
    }

    public MqttServerUrl(String protocol, String fqdn, Integer port) throws TahuException {
        if (protocol == null || fqdn == null || port == null) {
            throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid MQTT Server URL: protocol=" + protocol + " FQDN=" + fqdn + " port=" + port);
        }
        this.mqttServerUrl = protocol + "://" + fqdn + ":" + port;
        this.protocol = protocol;
        this.fqdn = fqdn;
        this.port = port;
    }

    public static MqttServerUrl getMqttServerUrlSafe(String mqttServerUrl) {
        try {
            return new MqttServerUrl(mqttServerUrl);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMqttServerUrl() {
        return this.mqttServerUrl;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getFqdn() {
        return this.fqdn;
    }

    public Integer getPort() {
        return this.port;
    }

    public String toString() {
        return this.mqttServerUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mqttServerUrl == null ? 0 : this.mqttServerUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MqttServerUrl other = (MqttServerUrl)obj;
        return !(this.mqttServerUrl == null ? other.mqttServerUrl != null : !this.mqttServerUrl.equals(other.mqttServerUrl));
    }
}

