/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.progress.UIJob;

public final class SyncInfoCompareInput
extends CompareEditorInput
implements IResourceChangeListener {
    private MyDiffNode node;
    private String description;
    private IResource resource;
    private long timestamp;
    private boolean isSaving = false;
    private ISynchronizeParticipant participant;
    static /* synthetic */ Class class$0;

    public SyncInfoCompareInput(String description, SyncInfo sync) {
        super(SyncInfoCompareInput.getDefaultCompareConfiguration());
        Assert.isNotNull((Object)sync);
        Assert.isNotNull((Object)description);
        this.description = description;
        this.resource = sync.getLocal();
        this.timestamp = this.resource.getLocalTimeStamp();
        this.node = new MyDiffNode(null, sync);
        this.initializeContentChangeListeners();
    }

    public SyncInfoCompareInput(ISynchronizeParticipant participant, SyncInfo sync) {
        this(participant.getName(), sync);
        this.participant = participant;
    }

    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.timestamp = this.resource.getLocalTimeStamp();
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SyncInfoCompareInput.this.dispose();
            }
        });
        return control;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter) && this.resource.getType() == 1) {
            return (IFile)this.resource;
        }
        return super.getAdapter(adapter);
    }

    private static CompareConfiguration getDefaultCompareConfiguration() {
        CompareConfiguration cc = new CompareConfiguration();
        return cc;
    }

    private void initializeContentChangeListeners() {
        ITypedElement te = this.node.getLeft();
        if (te instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)te).addContentChangeListener(new IContentChangeListener(){

                public void contentChanged(IContentChangeNotifier source) {
                    try {
                        if (!SyncInfoCompareInput.this.isSaving) {
                            SyncInfoCompareInput.this.saveChanges((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (CoreException coreException) {}
                }
            });
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta resourceDelta;
        IResourceDelta delta = event.getDelta();
        if (delta != null && (resourceDelta = delta.findMember(this.resource.getFullPath())) != null) {
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    SyncInfoCompareInput.this.isSaveNeeded();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private void dispose() {
    }

    public Image getTitleImage() {
        ImageRegistry reg = TeamUIPlugin.getPlugin().getImageRegistry();
        Image image = reg.get("eview16/synch_synch.gif");
        if (image == null) {
            image = this.getImageDescriptor().createImage();
            reg.put("eview16/synch_synch.gif", image);
        }
        return image;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.setTitle(this.getTitle());
        monitor.beginTask(TeamUIMessages.SyncInfoCompareInput_3, 100);
        monitor.setTaskName(TeamUIMessages.SyncInfoCompareInput_3);
        try {
            try {
                if (this.participant != null) {
                    this.participant.prepareCompareInput(this.node, this.getCompareConfiguration(), Policy.subMonitorFor(monitor, 100));
                } else {
                    Utils.updateLabels(this.node.getSyncInfo(), this.getCompareConfiguration());
                    this.node.cacheContents(Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (TeamException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
        return this.node;
    }

    public String getTitle() {
        return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_title, (Object[])new String[]{this.node.getName()});
    }

    public ImageDescriptor getImageDescriptor() {
        return TeamUIPlugin.getImageDescriptor("eview16/synch_synch.gif");
    }

    public String getToolTipText() {
        return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_tooltip, (Object[])new String[]{Utils.shortenText(30, this.description), this.node.getResource().getFullPath().toString()});
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SyncInfoCompareInput) {
            SyncInfo otherSyncInfo = ((SyncInfoCompareInput)((Object)other)).getSyncInfo();
            SyncInfo thisSyncInfo = this.getSyncInfo();
            IResource otherResource = otherSyncInfo.getLocal();
            return thisSyncInfo.equals((Object)otherSyncInfo) && this.timestamp == otherResource.getLocalTimeStamp();
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveChanges(IProgressMonitor pm) throws CoreException {
        if (this.checkUpdateConflict()) {
            return;
        }
        try {
            this.isSaving = true;
            super.saveChanges(pm);
            if (this.node != null) {
                SyncInfoCompareInput.commit(pm, this.node);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.node.fireChange();
            this.setDirty(false);
            this.isSaving = false;
            this.timestamp = this.resource.getLocalTimeStamp();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.node.fireChange();
        }
        this.setDirty(false);
        this.isSaving = false;
        this.timestamp = this.resource.getLocalTimeStamp();
    }

    private boolean checkUpdateConflict() {
        long newTimestamp = this.resource.getLocalTimeStamp();
        if (newTimestamp != this.timestamp) {
            MessageDialog dialog = new MessageDialog(TeamUIPlugin.getStandardDisplay().getActiveShell(), TeamUIMessages.SyncInfoCompareInput_0, null, TeamUIMessages.SyncInfoCompareInput_1, 3, new String[]{TeamUIMessages.SyncInfoCompareInput_2, IDialogConstants.CANCEL_LABEL}, 0);
            int retval = dialog.open();
            switch (retval) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return false;
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        ITypedElement right;
        ITypedElement left = node.getLeft();
        if (left instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)right).commit(pm);
        }
    }

    public SyncInfo getSyncInfo() {
        return this.node.getSyncInfo();
    }

    private static class MyDiffNode
    extends SyncInfoModelElement {
        public MyDiffNode(IDiffContainer parent, SyncInfo info) {
            super(parent, info);
        }

        public void fireChange() {
            super.fireChange();
        }
    }
}

