/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.embedder.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.sisu.equinox.embedder.EquinoxRuntimeLocator;
import org.eclipse.sisu.equinox.embedder.internal.EquinoxEmbedderException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=EquinoxServiceFactory.class)
public class DefaultEquinoxEmbedder
extends AbstractLogEnabled
implements EquinoxServiceFactory,
EmbeddedEquinox,
Disposable {
    @Requirement(role=EquinoxLifecycleListener.class)
    private Map<String, EquinoxLifecycleListener> lifecycleListeners;
    @Requirement
    private EquinoxRuntimeLocator equinoxLocator;
    private BundleContext frameworkContext;
    private File tempSecureStorage;
    private File tempConfigDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        if (this.frameworkContext != null) {
            return;
        }
        if ("Eclipse".equals(System.getProperty("org.osgi.framework.vendor"))) {
            throw new IllegalStateException("Nested Equinox instance is not supported");
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            this.doStart();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected void doStart() throws Exception {
        List<File> locations = this.equinoxLocator.getRuntimeLocations();
        if (locations == null || locations.isEmpty() || !locations.get(0).isDirectory()) {
            throw new RuntimeException("Equinox runtime location is missing or invalid");
        }
        File frameworkDir = locations.get(0);
        String frameworkLocation = frameworkDir.getAbsolutePath();
        System.setProperty("osgi.framework.useSystemProperties", "false");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osgi.install.area", frameworkLocation);
        properties.put("osgi.syspath", frameworkLocation + "/plugins");
        properties.put("osgi.configuration.area", this.copyToTempFolder(new File(frameworkDir, "configuration")));
        StringBuilder bundles = new StringBuilder();
        this.addBundlesDir(bundles, new File(frameworkDir, "plugins").listFiles(), false);
        for (int i = 1; i < locations.size(); ++i) {
            File location = locations.get(i);
            if (location.isDirectory()) {
                this.addBundlesDir(bundles, location.listFiles(), true);
                continue;
            }
            bundles.append(',').append(this.getReferenceUrl(location));
        }
        properties.put("osgi.bundles", bundles.toString());
        properties.put("osgi.parentClassloader", "fwk");
        List<String> packagesExtra = this.equinoxLocator.getSystemPackagesExtra();
        if (packagesExtra.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String pkg : packagesExtra) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(pkg);
            }
            properties.put("org.osgi.framework.system.packages.extra", sb.toString());
        }
        EclipseStarter.setInitialProperties(properties);
        EclipseStarter.startup((String[])this.getNonFrameworkArgs(), null);
        this.frameworkContext = EclipseStarter.getSystemBundleContext();
        this.activateBundlesInWorkingOrder();
        for (EquinoxLifecycleListener listener : this.lifecycleListeners.values()) {
            listener.afterFrameworkStarted(this);
        }
    }

    private String copyToTempFolder(File configDir) throws IOException {
        File tempDir = File.createTempFile("config", "equinox");
        if (!tempDir.delete() || !tempDir.mkdirs()) {
            throw new IOException("Could not create temp dir " + tempDir);
        }
        FileUtils.copyFileToDirectory((File)new File(configDir, "config.ini"), (File)tempDir);
        this.tempConfigDir = tempDir;
        return tempDir.getAbsolutePath();
    }

    private void activateBundlesInWorkingOrder() {
        this.tryActivateBundle("org.eclipse.equinox.ds");
        this.tryActivateBundle("org.eclipse.equinox.registry");
        this.tryActivateBundle("org.eclipse.core.net");
    }

    private void tryActivateBundle(String symbolicName) {
        for (Bundle bundle : this.frameworkContext.getBundles()) {
            if (!symbolicName.equals(bundle.getSymbolicName())) continue;
            try {
                bundle.start(1);
            }
            catch (BundleException e) {
                this.getLogger().warn("Could not start bundle " + bundle.getSymbolicName(), (Throwable)e);
            }
        }
    }

    private void addBundlesDir(StringBuilder bundles, File[] files, boolean absolute) {
        if (files != null) {
            for (File file : files) {
                if (file.getName().startsWith("org.eclipse.osgi_")) continue;
                if (bundles.length() > 0) {
                    bundles.append(',');
                }
                if (absolute) {
                    bundles.append(this.getReferenceUrl(file));
                    continue;
                }
                String name = file.getName();
                int verIdx = name.indexOf(95);
                if (verIdx > 0) {
                    bundles.append(name.substring(0, verIdx));
                    continue;
                }
                throw new EquinoxEmbedderException("File name doesn't match expected pattern: " + file);
            }
        }
    }

    String getReferenceUrl(File file) {
        return "reference:file:" + file.getAbsoluteFile().toURI().normalize().getPath();
    }

    private String[] getNonFrameworkArgs() {
        try {
            this.tempSecureStorage = File.createTempFile("tycho", "secure_storage");
            this.tempSecureStorage.deleteOnExit();
        }
        catch (IOException e) {
            throw new EquinoxEmbedderException("Could not create Tycho secure store file in temp dir " + System.getProperty("java.io.tmpdir"), e);
        }
        ArrayList<String> nonFrameworkArgs = new ArrayList<String>();
        nonFrameworkArgs.add("-eclipse.keyring");
        nonFrameworkArgs.add(this.tempSecureStorage.getAbsolutePath());
        if (this.getLogger().isDebugEnabled()) {
            nonFrameworkArgs.add("-debug");
            nonFrameworkArgs.add("-consoleLog");
        }
        return nonFrameworkArgs.toArray(new String[0]);
    }

    public <T> T getService(Class<T> clazz) {
        return this.getService(clazz, null);
    }

    public <T> T getService(Class<T> clazz, String filter) {
        ServiceReference[] serviceReferences;
        this.checkStarted();
        try {
            serviceReferences = this.frameworkContext.getServiceReferences(clazz.getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (serviceReferences == null || serviceReferences.length == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Service is not registered class='").append(clazz).append("'");
            if (filter != null) {
                sb.append("filter='").append(filter).append("'");
            }
            throw new IllegalStateException(sb.toString());
        }
        return clazz.cast(this.frameworkContext.getService(serviceReferences[0]));
    }

    private void checkStarted() {
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void registerService(Class<T> clazz, T service) {
        this.registerService(clazz, service, new Hashtable(1));
    }

    @Override
    public <T> void registerService(Class<T> clazz, T service, Dictionary<String, ?> properties) {
        this.frameworkContext.registerService(clazz, service, properties);
    }

    public void dispose() {
        if (this.frameworkContext != null) {
            try {
                EclipseStarter.shutdown();
            }
            catch (Exception e) {
                this.getLogger().error("Exception while shutting down equinox", (Throwable)e);
            }
            this.tempSecureStorage.delete();
            try {
                FileUtils.deleteDirectory((File)this.tempConfigDir);
            }
            catch (IOException e) {
                this.getLogger().warn("Exception while deleting temp folder " + this.tempConfigDir, (Throwable)e);
            }
            this.frameworkContext = null;
        }
    }

    @Override
    public EquinoxServiceFactory getServiceFactory() {
        return this;
    }
}

