/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.equinox.launching.internal;

import java.io.File;
import java.io.IOException;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.equinox.launching.EquinoxInstallation;
import org.eclipse.tycho.equinox.launching.EquinoxInstallationDescription;
import org.osgi.framework.Version;

public class DefaultEquinoxInstallation
implements EquinoxInstallation {
    private final File location;
    private final EquinoxInstallationDescription Description;

    public DefaultEquinoxInstallation(EquinoxInstallationDescription installationDescription, File location) {
        this.Description = installationDescription;
        this.location = location;
    }

    public File getLocation() {
        return this.location;
    }

    public File getLauncherJar() {
        ArtifactDescriptor systemBundle = this.Description.getSystemBundle();
        Version osgiVersion = Version.parseVersion((String)systemBundle.getKey().getVersion());
        if (osgiVersion.compareTo(EquinoxInstallationDescription.EQUINOX_VERSION_3_3_0) < 0) {
            throw new IllegalArgumentException("Eclipse 3.2 and earlier are not supported.");
        }
        ArtifactDescriptor launcher = this.Description.getBundle("org.eclipse.equinox.launcher", null);
        if (launcher == null) {
            throw new IllegalArgumentException("Could not find org.eclipse.equinox.launcher bundle in the test runtime.");
        }
        try {
            return launcher.getLocation().getCanonicalFile();
        }
        catch (IOException e) {
            return launcher.getLocation().getAbsoluteFile();
        }
    }

    public EquinoxInstallationDescription getInstallationDescription() {
        return this.Description;
    }
}

