/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.blint.support.contributors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.bundlor.blint.support.Validator;
import org.eclipse.virgo.bundlor.util.BundleManifestUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public final class VersionedExportsValidator
implements Validator {
    private static final String MESSAGE = "The export of package %s does not specify a version";

    @Override
    public Set<String> validate(ManifestContents manifest) {
        BundleManifest bundleManifest = BundleManifestUtils.createBundleManifest((ManifestContents)manifest);
        HashSet<String> warnings = new HashSet<String>();
        for (ExportedPackage packageExport : bundleManifest.getExportPackage().getExportedPackages()) {
            if (packageExport.getAttributes().get("version") != null) continue;
            warnings.add(String.format(MESSAGE, packageExport.getPackageName()));
        }
        return warnings;
    }
}

