/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IVersion;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.util.UnknownVersion;
import org.eclipse.wst.common.project.facet.core.internal.util.Versionable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionExpr<T extends IVersion>
implements IVersionExpr {
    private static final int SM1_START = 0;
    private static final int SM1_PARSING_START_VERSION = 1;
    private static final int SM1_PARSING_END_VERSION = 2;
    private static final int SM1_FINISHED_RANGE_INCLUSIVE = 3;
    private static final int SM1_FINISHED_RANGE_EXCLUSIVE = 4;
    private static final int SM1_PARSING_WILDCARD = 5;
    private static final int SM2_VERSION_START = 0;
    private static final int SM2_VERSION_CONTINUING = 1;
    private static final int SM2_ESCAPE = 2;
    private final Versionable<T> versionable;
    private final List<ISubExpr> subexprs;
    private final String usedInPlugin;

    public VersionExpr(Object versionable, String expr, String usedInPlugin) throws CoreException {
        this((Versionable)versionable, expr, usedInPlugin);
    }

    public VersionExpr(Versionable<T> versionable, String expr, String usedInPlugin) throws CoreException {
        this.versionable = versionable;
        this.subexprs = new ArrayList<ISubExpr>();
        this.usedInPlugin = usedInPlugin;
        int state = 0;
        Range range = null;
        boolean usingDeprecatedSyntax = false;
        MutableInteger position = new MutableInteger();
        while (position.value < expr.length()) {
            char ch = expr.charAt(position.value);
            switch (state) {
                case 0: {
                    if (ch == '[') {
                        range = new Range();
                        range.includesStartVersion = true;
                        state = 1;
                        break;
                    }
                    if (ch == '(') {
                        range = new Range();
                        range.includesStartVersion = false;
                        state = 1;
                        break;
                    }
                    if (ch == '*') {
                        this.subexprs.add(new Wildcard());
                        state = 5;
                        break;
                    }
                    if (ch == ' ' || ch == ',') break;
                    StringBuffer buf = new StringBuffer();
                    int exitState = this.parseVersion(expr, position, buf);
                    if (exitState == 0) {
                        String vstr = buf.toString();
                        Range r = new Range();
                        if (vstr.startsWith(">=")) {
                            r.startVersion = this.parseVersion(vstr.substring(2));
                            r.includesStartVersion = true;
                            usingDeprecatedSyntax = true;
                        } else if (vstr.startsWith(">")) {
                            r.startVersion = this.parseVersion(vstr.substring(1));
                            r.includesStartVersion = false;
                            usingDeprecatedSyntax = true;
                        } else if (vstr.startsWith("<=")) {
                            r.endVersion = this.parseVersion(vstr.substring(2));
                            r.includesEndVersion = true;
                            usingDeprecatedSyntax = true;
                        } else if (vstr.startsWith("<")) {
                            r.endVersion = this.parseVersion(vstr.substring(1));
                            r.includesEndVersion = false;
                            usingDeprecatedSyntax = true;
                        } else {
                            r.startVersion = this.parseVersion(vstr);
                            r.includesStartVersion = true;
                            r.endVersion = r.startVersion;
                            r.includesEndVersion = true;
                        }
                        this.subexprs.add(r);
                        break;
                    }
                    if (exitState == 3 || exitState == 4) {
                        range = new Range();
                        range.endVersion = this.parseVersion(buf.toString());
                        state = exitState;
                        --position.value;
                        break;
                    }
                    throw VersionExpr.createInvalidVersionExprException(expr);
                }
                case 1: {
                    StringBuffer buf = new StringBuffer();
                    int exitState = this.parseVersion(expr, position, buf);
                    if (exitState == 0) {
                        range.startVersion = this.parseVersion(buf.toString());
                        this.subexprs.add(range);
                        range = null;
                        state = exitState;
                        break;
                    }
                    if (exitState == 2) {
                        range.startVersion = this.parseVersion(buf.toString());
                        state = exitState;
                        break;
                    }
                    throw VersionExpr.createInvalidVersionExprException(expr);
                }
                case 2: {
                    StringBuffer buf = new StringBuffer();
                    int exitState = this.parseVersion(expr, position, buf);
                    if (exitState == 3 || exitState == 4) {
                        range.endVersion = this.parseVersion(buf.toString());
                        state = exitState;
                        --position.value;
                        break;
                    }
                    throw VersionExpr.createInvalidVersionExprException(expr);
                }
                case 3: 
                case 4: {
                    range.includesEndVersion = state == 3;
                    this.subexprs.add(range);
                    range = null;
                    state = 0;
                    break;
                }
                case 5: {
                    if (ch != ' ') {
                        if (ch == ',') {
                            state = 0;
                        } else {
                            throw VersionExpr.createInvalidVersionExprException(expr);
                        }
                    }
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++position.value;
        }
        if (usingDeprecatedSyntax) {
            String msg = this.usedInPlugin == null ? Resources.deprecatedSyntaxNoPlugin : NLS.bind((String)Resources.deprecatedSyntax, (Object)this.usedInPlugin);
            FacetCorePlugin.logWarning(msg, true);
        }
    }

    private int parseVersion(String str, MutableInteger position, StringBuffer version) throws CoreException {
        int localState = 0;
        int exitState = -1;
        while (exitState == -1 && position.value < str.length()) {
            char ch = str.charAt(position.value);
            switch (localState) {
                case 0: {
                    if (ch == '[' || ch == '(' || ch == ']' || ch == ')' || ch == '-' || ch == ',') {
                        throw VersionExpr.createInvalidVersionExprException(str);
                    }
                    if (ch == '\\') {
                        localState = 2;
                        break;
                    }
                    if (ch == ' ') break;
                    version.append(ch);
                    localState = 1;
                    break;
                }
                case 1: {
                    if (ch == '[' || ch == '(') {
                        throw VersionExpr.createInvalidVersionExprException(str);
                    }
                    if (ch == '\\') {
                        localState = 2;
                        break;
                    }
                    if (ch == ',') {
                        exitState = 0;
                        break;
                    }
                    if (ch == '-') {
                        exitState = 2;
                        break;
                    }
                    if (ch == ']') {
                        exitState = 3;
                        break;
                    }
                    if (ch == ')') {
                        exitState = 4;
                        break;
                    }
                    if (ch == ' ') break;
                    version.append(ch);
                    break;
                }
                case 2: {
                    version.append(ch);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++position.value;
        }
        --position.value;
        if (exitState != -1) {
            return exitState;
        }
        if (localState == 1) {
            return 0;
        }
        throw VersionExpr.createInvalidVersionExprException(str);
    }

    private IVersion parseVersion(String str) {
        if (this.versionable.hasVersion(str)) {
            return this.versionable.getVersion(str);
        }
        return new UnknownVersion<T>(this.versionable, str);
    }

    @Override
    public boolean check(IVersion ver) {
        for (ISubExpr subexpr : this.subexprs) {
            if (!subexpr.evaluate(ver)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(String ver) {
        return this.check(this.parseVersion(ver));
    }

    public boolean isSingleVersionMatch() {
        ISubExpr subExpr;
        if (this.subexprs.size() == 1 && (subExpr = this.subexprs.get(0)) instanceof Range) {
            Range range = (Range)subExpr;
            if (range.startVersion.equals(range.endVersion) && range.includesStartVersion == range.includesEndVersion) {
                return true;
            }
        }
        return false;
    }

    public boolean isSimpleAllowNewer() {
        ISubExpr subExpr;
        if (this.subexprs.size() == 1 && (subExpr = this.subexprs.get(0)) instanceof Range) {
            Range range = (Range)subExpr;
            if (range.startVersion != null && range.endVersion == null && range.includesStartVersion) {
                return true;
            }
        }
        return false;
    }

    public boolean isWildcard() {
        return this.subexprs.size() == 1 && this.subexprs.get(0) instanceof Wildcard;
    }

    public String getFirstVersion() {
        if (this.isSingleVersionMatch() || this.isSimpleAllowNewer()) {
            Range range = (Range)this.subexprs.get(0);
            return range.startVersion.getVersionString();
        }
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (ISubExpr subexpr : this.subexprs) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(subexpr.toString());
        }
        return buf.toString();
    }

    @Override
    public String toDisplayString() {
        ISubExpr subexpr;
        if (this.subexprs.size() == 1 && (subexpr = this.subexprs.get(0)) instanceof Range) {
            Range r = (Range)subexpr;
            if (r.isSingleVersion()) {
                return r.startVersion.getVersionString();
            }
            if (r.endVersion == null && r.includesStartVersion) {
                return NLS.bind((String)Resources.versionOrNewer, (Object)r.startVersion.getVersionString());
            }
        }
        boolean onlySingleVersions = true;
        for (ISubExpr subexpr2 : this.subexprs) {
            if (subexpr2 instanceof Range && ((Range)subexpr2).isSingleVersion()) continue;
            onlySingleVersions = false;
            break;
        }
        if (onlySingleVersions) {
            StringBuffer buf = new StringBuffer();
            Iterator<ISubExpr> itr = this.subexprs.iterator();
            while (itr.hasNext()) {
                Range r = (Range)itr.next();
                if (buf.length() > 0) {
                    if (itr.hasNext()) {
                        buf.append(", ");
                    } else {
                        buf.append(" or ");
                    }
                }
                buf.append(r.startVersion.getVersionString());
            }
            return buf.toString();
        }
        return this.toString();
    }

    private static CoreException createInvalidVersionExprException(String str) {
        String msg = NLS.bind((String)Resources.invalidVersionExpr, (Object)str);
        IStatus st = FacetCorePlugin.createErrorStatus(msg);
        return new CoreException(st);
    }

    private static interface ISubExpr {
        public boolean evaluate(IVersion var1);
    }

    private static final class MutableInteger {
        public int value = 0;

        private MutableInteger() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Range
    implements ISubExpr {
        public IVersion startVersion = null;
        public boolean includesStartVersion = false;
        public IVersion endVersion = null;
        public boolean includesEndVersion = false;

        private Range() {
        }

        public boolean isSingleVersion() {
            return this.startVersion.equals(this.endVersion) && this.includesStartVersion == this.includesEndVersion;
        }

        @Override
        public boolean evaluate(IVersion version) {
            int res;
            if (!(this.startVersion == null || (res = version.compareTo(this.startVersion)) > 0 || res == 0 && this.includesStartVersion)) {
                return false;
            }
            return this.endVersion == null || (res = version.compareTo(this.endVersion)) < 0 || res == 0 && this.includesEndVersion;
        }

        public String toString() {
            if (this.startVersion.equals(this.endVersion) && this.includesStartVersion == this.includesEndVersion) {
                return this.startVersion.getVersionString();
            }
            StringBuffer buf = new StringBuffer();
            if (this.startVersion != null) {
                buf.append(this.includesStartVersion ? (char)'[' : '(');
                buf.append(this.startVersion.getVersionString());
            }
            if (this.endVersion != null) {
                if (buf.length() != 0) {
                    buf.append('-');
                }
                buf.append(this.endVersion.getVersionString());
                buf.append(this.includesEndVersion ? (char)']' : ')');
            }
            return buf.toString();
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidVersionExpr;
        public static String deprecatedSyntax;
        public static String deprecatedSyntaxNoPlugin;
        public static String versionOrNewer;

        static {
            Resources.initializeMessages((String)VersionExpr.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Wildcard
    implements ISubExpr {
        private Wildcard() {
        }

        @Override
        public boolean evaluate(IVersion version) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }
}

