/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.DefaultVersionComparator;
import org.eclipse.wst.common.project.facet.core.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.util.IndexedSet;
import org.eclipse.wst.common.project.facet.core.internal.util.VersionExpr;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Versionable<T extends IVersion> {
    private static final Comparator<String> DEFAULT_VERSION_COMPARATOR = new DefaultVersionComparator();
    protected final IndexedSet<String, T> versions = new IndexedSet();
    private String versionComparatorClass;
    private Comparator<String> versionComparator;

    public abstract String getPluginId();

    public Set<T> getVersions() {
        return this.versions.getUnmodifiable();
    }

    public Set<T> getVersions(String expr) throws CoreException {
        VersionExpr prepared = new VersionExpr(this, expr, null);
        HashSet<IVersion> result = new HashSet<IVersion>();
        for (IVersion ver : this.versions) {
            if (!prepared.check(ver)) continue;
            result.add(ver);
        }
        return result;
    }

    public T getVersion(String version) {
        IVersion ver = (IVersion)this.versions.get(version);
        if (ver == null) {
            throw new IllegalArgumentException(this.createVersionNotFoundErrMsg(version));
        }
        return (T)ver;
    }

    public T getLatestVersion() {
        if (this.versions.size() > 0) {
            return (T)((IVersion)Collections.max(this.versions));
        }
        return null;
    }

    public boolean hasVersion(String version) {
        return this.versions.containsKey(version);
    }

    public List<T> getSortedVersions(boolean ascending) {
        Comparator comp = ascending ? null : new Comparator<T>(){

            @Override
            public int compare(T ver1, T ver2) {
                return ver1.compareTo(ver2) * -1;
            }
        };
        ArrayList list = new ArrayList(this.versions);
        Collections.sort(list, comp);
        return list;
    }

    public Comparator<String> getVersionComparator() throws CoreException {
        Comparator<String> comp;
        if (this.versionComparatorClass == null) {
            comp = DEFAULT_VERSION_COMPARATOR;
        } else {
            if (this.versionComparator == null) {
                Bundle bundle = Platform.getBundle((String)this.getPluginId());
                try {
                    Class cl = bundle.loadClass(this.versionComparatorClass);
                    this.versionComparator = (Comparator)cl.newInstance();
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)Resources.failedToCreate, (Object)this.versionComparatorClass);
                    IStatus st = FacetCorePlugin.createErrorStatus(msg, e);
                    throw new CoreException(st);
                }
            }
            comp = this.versionComparator;
        }
        return comp;
    }

    public void setVersionComparator(String clname) {
        this.versionComparatorClass = clname;
    }

    public abstract String createVersionNotFoundErrMsg(String var1);

    private static final class Resources
    extends NLS {
        public static String failedToCreate;

        static {
            Resources.initializeMessages((String)Versionable.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

