/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.ProjectComponents;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeNode;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRoot;
import org.eclipse.wst.common.componentcore.internal.impl.WTPModulesResource;
import org.eclipse.wst.common.componentcore.internal.impl.WTPModulesResourceFactory;
import org.eclipse.wst.common.frameworks.internal.SaveFailedException;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;
import org.osgi.framework.Bundle;

public class ModuleStructuralModel
extends EditModel
implements IAdaptable {
    private static final String R0_7_MODULE_META_FILE_NAME = ".component";
    private static final String R1_MODULE_META_FILE_NAME = ".settings/.component";
    public static final String MODULE_CORE_ID = "moduleCoreId";
    private static final String PROJECT_VERSION_1_5 = "1.5.0";
    private boolean useOldFormat = false;

    public ModuleStructuralModel(String editModelID, EMFWorkbenchContext context, boolean readOnly) {
        super(editModelID, context, readOnly);
    }

    protected void release(ReferencedResource aResource) {
        if (this.isReadOnly() && aResource.getReadCount() != 0) {
            aResource.releaseFromRead();
        } else {
            aResource.releaseFromWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeResource(Resource aResource) {
        if (aResource != null) {
            Resource resource = aResource;
            synchronized (resource) {
                aResource.eAdapters().remove((Object)this.resourceAdapter);
                return this.getResources().remove(aResource);
            }
        }
        return false;
    }

    public EObject getPrimaryRootObject() {
        try {
            Resource res = this.prepareProjectModulesIfNecessary();
            if (res == null) {
                return null;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        EObject modelRoot = null;
        modelRoot = super.getPrimaryRootObject();
        if (modelRoot != null) {
            if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
                return modelRoot;
            }
            EList components = ((ProjectComponents)modelRoot).getComponents();
            if (components.size() > 0) {
                WorkbenchComponent wbComp = (WorkbenchComponent)components.get(0);
                if (!this.isVersion15(modelRoot)) {
                    ((ProjectComponents)modelRoot).setVersion(PROJECT_VERSION_1_5);
                    this.cleanupWTPModules(wbComp);
                }
            }
        }
        return modelRoot;
    }

    private boolean isVersion15(EObject modelRoot) {
        return ((ProjectComponents)modelRoot).getVersion().equals(PROJECT_VERSION_1_5);
    }

    public void cleanupWTPModules(WorkbenchComponent wbComp) {
        if (wbComp == null) {
            return;
        }
        ResourceTreeRoot root = ResourceTreeRoot.getSourceResourceTreeRoot(wbComp);
        List rootResources = this.getModuleResources(root);
        if (!wbComp.getResources().containsAll((Collection)rootResources) || wbComp.getResources().size() != rootResources.size()) {
            ModuleStructuralModel model = new ModuleStructuralModel(this.getEditModelID(), this.getEmfContext(), false);
            if (model == null) {
                return;
            }
            boolean jobScheduled = false;
            try {
                Object key = new Object();
                model.access(key);
                wbComp.getResources().clear();
                wbComp.getResources().addAll((Collection)rootResources);
                URI uri = wbComp.eResource().getURI();
                Resource resource = model.getResource(uri);
                resource.setModified(true);
                class SaveJob
                extends Job {
                    private boolean disposedAlready;
                    private final /* synthetic */ ModuleStructuralModel val$model;
                    private final /* synthetic */ Object val$key;

                    public SaveJob(ModuleStructuralModel moduleStructuralModel2, Object object) {
                        this.val$model = moduleStructuralModel2;
                        this.val$key = object;
                        super("Save ModuleStructuralModel Job");
                        this.disposedAlready = false;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            this.val$model.save(this.val$key);
                            IStatus iStatus = OK_STATUS;
                            return iStatus;
                        }
                        finally {
                            this.disposeOnce();
                        }
                    }

                    public void disposeOnce() {
                        if (!this.disposedAlready) {
                            this.disposedAlready = true;
                            this.val$model.dispose();
                        }
                    }
                }
                final SaveJob saveJob = new SaveJob(model, key);
                saveJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
                    {
                    }

                    public void done(IJobChangeEvent event) {
                        saveJob.disposeOnce();
                    }
                });
                saveJob.setSystem(true);
                saveJob.schedule();
                jobScheduled = true;
            }
            finally {
                if (!jobScheduled && model != null) {
                    model.dispose();
                }
            }
        }
    }

    public List getModuleResources(ResourceTreeNode node) {
        if (node.getModuleResources().length > 0) {
            return Arrays.asList(node.getModuleResources());
        }
        ArrayList rootResources = new ArrayList();
        Map children = node.getChildren();
        for (ResourceTreeNode subNode : children.values()) {
            rootResources.addAll(this.getModuleResources(subNode));
        }
        return rootResources;
    }

    public Resource prepareProjectModulesIfNecessary() throws CoreException {
        if (!this.isComponentSynchronizedOrNull()) {
            return null;
        }
        Object res = (XMIResource)this.getPrimaryResource();
        if (res != null && this.resNeedsMigrating((XMIResource)res) && !this.useOldFormat) {
            return null;
        }
        if (res == null) {
            res = this.makeWTPModulesResource();
        }
        try {
            this.addProjectModulesIfNecessary((XMIResource)res);
        }
        catch (IOException e) {
            Platform.getLog((Bundle)ModulecorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.wst.common.modulecore", 4, e.getMessage(), (Throwable)e));
        }
        return res;
    }

    private boolean isComponentSynchronizedOrNull() {
        IFile componentFile = this.getProject().getFile(StructureEdit.MODULE_META_FILE_NAME);
        IPath componentFileLocation = componentFile.getLocation();
        if (!(componentFileLocation == null || componentFileLocation.toFile().exists() || (componentFileLocation = (componentFile = this.getProject().getFile(R1_MODULE_META_FILE_NAME)).getLocation()) == null || componentFileLocation.toFile().exists() || (componentFileLocation = (componentFile = this.getProject().getFile(R0_7_MODULE_META_FILE_NAME)).getLocation()) == null || componentFileLocation.toFile().exists())) {
            return true;
        }
        if (componentFileLocation == null) {
            return true;
        }
        return componentFile.isSynchronized(0);
    }

    public WTPModulesResource makeWTPModulesResource() {
        return (WTPModulesResource)this.createResource(WTPModulesResourceFactory.WTP_MODULES_URI_OBJ);
    }

    protected void runSaveOperation(IWorkspaceRunnable runnable, IProgressMonitor monitor) throws SaveFailedException {
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 1, monitor);
        }
        catch (CoreException e) {
            throw new SaveFailedException((Exception)((Object)e));
        }
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        super.checkActivation(presenter);
    }

    public Resource getPrimaryResource() {
        URI uri = URI.createURI((String)StructureEdit.MODULE_META_FILE_NAME);
        WTPModulesResource res = (WTPModulesResource)this.getResource(uri);
        if (res == null || !res.isLoaded()) {
            this.removeResource((Resource)res);
            uri = URI.createURI((String)R1_MODULE_META_FILE_NAME);
            res = (WTPModulesResource)this.getResource(uri);
            if (res == null || !res.isLoaded()) {
                this.removeResource((Resource)res);
                uri = URI.createURI((String)R0_7_MODULE_META_FILE_NAME);
                res = (WTPModulesResource)this.getResource(uri);
                if (res == null || !res.isLoaded()) {
                    this.removeResource((Resource)res);
                    res = null;
                }
            }
        }
        return res;
    }

    public Object getAdapter(Class anAdapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, anAdapter);
    }

    protected void addProjectModulesIfNecessary(XMIResource aResource) throws IOException {
        if (aResource != null && aResource.getContents().isEmpty()) {
            ProjectComponents projectModules = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createProjectComponents();
            projectModules.setProjectName(this.project.getName());
            aResource.getContents().add((Object)projectModules);
            aResource.setID((EObject)projectModules, MODULE_CORE_ID);
        }
    }

    private boolean resNeedsMigrating(XMIResource res) throws CoreException {
        ProjectComponents components;
        boolean needsMigrating;
        boolean multiComps = false;
        if (this.project == null) {
            return false;
        }
        boolean bl = needsMigrating = !this.project.hasNature("org.eclipse.wst.common.project.facet.core.nature") || res == null || res != null && ((WTPModulesResource)res).getRootObject() == null;
        if (!needsMigrating && res instanceof TranslatorResource && ((TranslatorResource)res).getRootObject() instanceof ProjectComponents && (components = (ProjectComponents)((WTPModulesResource)res).getRootObject()).getComponents() != null) {
            multiComps = components.getComponents().size() > 1;
            return multiComps;
        }
        return needsMigrating;
    }

    protected Resource getAndLoadLocalResource(URI aUri) {
        Resource resource = this.getLocalResource(aUri);
        if (resource != null && !resource.isLoaded()) {
            try {
                resource.load(Collections.EMPTY_MAP);
            }
            catch (IOException iOException) {}
        }
        return resource;
    }

    public void setUseOldFormat(boolean useOldFormat) {
        this.useOldFormat = useOldFormat;
    }
}

