/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.IServerMonitor;
import org.eclipse.wst.server.core.internal.ServerMonitorDelegate;
import org.eclipse.wst.server.core.internal.Trace;

public class ServerMonitor
implements IServerMonitor {
    private IConfigurationElement element;
    private ServerMonitorDelegate delegate;

    public ServerMonitor(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getName() {
        String label = this.element.getAttribute("name");
        if (label == null) {
            return "n/a";
        }
        return label;
    }

    public ServerMonitorDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (ServerMonitorDelegate)this.element.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.trace(3, "Could not create delegate" + this.toString() + ": " + t.getMessage());
            }
        }
        return this.delegate;
    }

    public int startMonitoring(IServer server, ServerPort port, int monitorPort) throws CoreException {
        try {
            return this.getDelegate().startMonitoring(server, port, monitorPort);
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate " + this.toString() + ": " + e.getMessage());
            return -1;
        }
    }

    public void stopMonitoring(IServer server, ServerPort port) {
        try {
            this.getDelegate().stopMonitoring(server, port);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate " + this.toString() + ": " + e.getMessage());
        }
    }

    public String toString() {
        return "Monitor[" + this.getId() + "]";
    }
}

