/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;

public class LaunchableAdapter
implements ILaunchableAdapter {
    private IConfigurationElement element;
    private LaunchableAdapterDelegate delegate;

    public LaunchableAdapter(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public LaunchableAdapterDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (LaunchableAdapterDelegate)this.element.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.trace(3, "Could not create delegate" + this.toString() + ": " + t.getMessage());
            }
        }
        return this.delegate;
    }

    public Object getLaunchable(IServer server, IModuleArtifact object) throws CoreException {
        try {
            return this.getDelegate().getLaunchable(server, object);
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate " + this.toString() + ": " + e.getMessage());
            return null;
        }
    }

    public String toString() {
        return "LaunchableAdapter[" + this.getId() + "]";
    }
}

