/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.compiler.MacroAwareStringConcatenation;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.CodeGenerationContextImpl;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.CodeGenerationParticipant;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.ElementIssueProvider;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.JvmModelGenerator;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ImportingStringConcatenation;
import org.eclipse.xtext.xbase.compiler.output.SharedAppendableState;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XtendGenerator
extends JvmModelGenerator
implements IGenerator2 {
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private ElementIssueProvider.Factory issueProviderFactory;

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        super.doGenerate(input, fsa);
        this.callMacroProcessors(input);
    }

    public void beforeGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        this.issueProviderFactory.attachData(input);
    }

    public void afterGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        this.issueProviderFactory.detachData(input);
    }

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        this.doGenerate(input, (IFileSystemAccess)fsa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void callMacroProcessors(Resource input) {
        ActiveAnnotationContexts ctxs = ActiveAnnotationContexts.find(input);
        if (ctxs == null) {
            return;
        }
        try {
            ctxs.before(ActiveAnnotationContexts.AnnotationCallback.GENERATION);
            Map<JvmAnnotationType, ActiveAnnotationContext> _contexts = ctxs.getContexts();
            Collection<ActiveAnnotationContext> _values = _contexts.values();
            for (ActiveAnnotationContext context : _values) {
                try {
                    Object _processorInstance;
                    Object processor = _processorInstance = context.getProcessorInstance();
                    boolean _matched = false;
                    if (!(processor instanceof CodeGenerationParticipant)) continue;
                    _matched = true;
                    CodeGenerationContextImpl _codeGenerationContextImpl = new CodeGenerationContextImpl();
                    Procedures.Procedure1 _function = it -> {
                        CompilationUnitImpl _compilationUnit = context.getCompilationUnit();
                        it.setUnit(_compilationUnit);
                    };
                    CodeGenerationContextImpl codeGenServices = (CodeGenerationContextImpl)ObjectExtensions.operator_doubleArrow((Object)_codeGenerationContextImpl, (Procedures.Procedure1)_function);
                    List<XtendAnnotationTarget> _annotatedSourceElements = context.getAnnotatedSourceElements();
                    Functions.Function1 _function_1 = it -> {
                        CompilationUnitImpl _compilationUnit = context.getCompilationUnit();
                        return _compilationUnit.toXtendMemberDeclaration((XtendMember)it);
                    };
                    List elements = ListExtensions.map(_annotatedSourceElements, (Functions.Function1)_function_1);
                    ((CodeGenerationParticipant)processor).doGenerateCode(elements, (CodeGenerationContext)codeGenServices);
                }
                catch (Throwable _t) {
                    if (!(_t instanceof Throwable)) throw Exceptions.sneakyThrow((Throwable)_t);
                    Throwable t = _t;
                    this.operationCanceledManager.propagateAsErrorIfCancelException(t);
                    context.handleProcessingError(input, t);
                    continue;
                    return;
                }
            }
        }
        finally {
            ctxs.after(ActiveAnnotationContexts.AnnotationCallback.GENERATION);
        }
    }

    protected ImportingStringConcatenation createImportingStringConcatenation(SharedAppendableState state, ITypeReferenceOwner owner) {
        return new MacroAwareStringConcatenation(state, owner);
    }

    public String doConvertToJavaString(String input) {
        return Strings.convertToJavaString((String)input, (boolean)false);
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmGenericType it) {
        Iterable _xifexpression = null;
        boolean _isLocal = it.isLocal();
        if (_isLocal) {
            EList _members = it.getMembers();
            Functions.Function1 _function = it_1 -> it_1 instanceof JvmOperation;
            _xifexpression = IterableExtensions.filter((Iterable)_members, (Functions.Function1)_function);
        } else {
            _xifexpression = this._getMembersToBeCompiled((JvmDeclaredType)it);
        }
        return _xifexpression;
    }

    protected ArrayList<JvmMember> getAddedDeclarations(JvmGenericType it, AnonymousClass anonymousClass) {
        boolean _greaterEqualsThan;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new JvmMember[0]);
        XConstructorCall _constructorCall = anonymousClass.getConstructorCall();
        JvmConstructor constructor = _constructorCall.getConstructor();
        EList _parameters = constructor.getParameters();
        int _size = _parameters.size();
        boolean bl = _greaterEqualsThan = _size >= 1;
        if (_greaterEqualsThan) {
            result.add(0, constructor);
        }
        Iterable _declaredFields = it.getDeclaredFields();
        Iterables.addAll((Collection)result, (Iterable)_declaredFields);
        Iterable _declaredOperations = it.getDeclaredOperations();
        Functions.Function1 _function = it_1 -> {
            Set _sourceElements = this.getSourceElements((EObject)it_1);
            EObject _head = (EObject)IterableExtensions.head((Iterable)_sourceElements);
            XtendFunction function = (XtendFunction)_head;
            boolean _isOverride = function.isOverride();
            return !_isOverride;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_declaredOperations, (Functions.Function1)_function);
        Iterables.addAll((Collection)result, (Iterable)_filter);
        EList _members = it.getMembers();
        Iterable _filter_1 = Iterables.filter((Iterable)_members, JvmDeclaredType.class);
        Iterables.addAll((Collection)result, (Iterable)_filter_1);
        return result;
    }

    public ITreeAppendable compile(JvmExecutable executable, XExpression expression, JvmTypeReference returnType, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        this.compileLocalTypeStubs((JvmFeature)executable, appendable, config);
        _xblockexpression = super.compile(executable, expression, returnType, appendable, config);
        return _xblockexpression;
    }

    public String reassignThisType(ITreeAppendable b, JvmDeclaredType declaredType) {
        Object element;
        String _xblockexpression = null;
        boolean _hasObject = b.hasObject("this");
        if (_hasObject && (element = b.getObject("this")) instanceof JvmDeclaredType) {
            boolean _isLocal = ((JvmDeclaredType)element).isLocal();
            if (_isLocal) {
                Pair _mappedTo = Pair.of((Object)"this", (Object)((JvmDeclaredType)element));
                boolean _hasName = b.hasName((Object)_mappedTo);
                if (_hasName) {
                    Pair _mappedTo_1 = Pair.of((Object)"this", (Object)((JvmDeclaredType)element));
                    String _name = b.getName((Object)_mappedTo_1);
                    b.declareVariable(element, _name);
                } else {
                    b.declareVariable(element, "");
                }
            } else {
                String _simpleName = ((JvmDeclaredType)element).getSimpleName();
                String proposedName = _simpleName + ".this";
                b.declareVariable(element, proposedName);
            }
        }
        String _xifexpression = null;
        if (declaredType != null) {
            _xifexpression = b.declareVariable((Object)declaredType, "this");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void compileLocalTypeStubs(JvmFeature feature, ITreeAppendable appendable, GeneratorConfig config) {
        EList _localClasses = feature.getLocalClasses();
        Functions.Function1 _function = it -> {
            boolean _isAnonymous = it.isAnonymous();
            return !_isAnonymous;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_localClasses, (Functions.Function1)_function);
        Consumer<JvmGenericType> _function_1 = it -> {
            appendable.newLine();
            Set _sourceElements = this.getSourceElements((EObject)it);
            EObject _head = (EObject)IterableExtensions.head((Iterable)_sourceElements);
            AnonymousClass anonymousClass = (AnonymousClass)_head;
            ITreeAppendable childAppendable = appendable.trace((EObject)anonymousClass);
            childAppendable.append((CharSequence)"abstract class ");
            ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)anonymousClass);
            String _simpleName = it.getSimpleName();
            _traceSignificant.append((CharSequence)_simpleName);
            EList _typeParameters = it.getTypeParameters();
            boolean _isEmpty = _typeParameters.isEmpty();
            if (_isEmpty) {
                childAppendable.append((CharSequence)" ");
            }
            this.generateExtendsClause((JvmDeclaredType)it, childAppendable, null);
            ITreeAppendable _append = childAppendable.append((CharSequence)"{");
            _append.increaseIndentation();
            boolean _needSyntheticThisVariable = this.needSyntheticThisVariable(anonymousClass, (JvmDeclaredType)it);
            if (_needSyntheticThisVariable) {
                Pair _mappedTo = Pair.of((Object)"this", (Object)it);
                String _simpleName_1 = it.getSimpleName();
                String _plus = "_this" + _simpleName_1;
                String thisName = childAppendable.declareSyntheticVariable((Object)_mappedTo, _plus);
                ITreeAppendable _newLine = childAppendable.newLine();
                ITreeAppendable _append_1 = _newLine.append((CharSequence)"final ");
                String _simpleName_2 = it.getSimpleName();
                ITreeAppendable _append_2 = _append_1.append((CharSequence)_simpleName_2);
                ITreeAppendable _append_3 = _append_2.append((CharSequence)" ");
                ITreeAppendable _append_4 = _append_3.append((CharSequence)thisName);
                ITreeAppendable _append_5 = _append_4.append((CharSequence)" = this;");
                _append_5.newLine();
            }
            ArrayList<JvmMember> _addedDeclarations = this.getAddedDeclarations((JvmGenericType)it, anonymousClass);
            Procedures.Procedure1 _function_2 = it_1 -> {
                Functions.Function1 _function_3 = it_2 -> it_2.newLine();
                it_1.setSeparator(_function_3);
            };
            Procedures.Procedure1 _function_3 = it_1 -> {
                ITreeAppendable memberAppendable = this._treeAppendableUtil.traceWithComments(childAppendable, (EObject)it_1);
                memberAppendable.openScope();
                if (it_1 instanceof JvmOperation) {
                    boolean _tripleEquals;
                    ITreeAppendable tracedAppendable = childAppendable.trace((EObject)it_1);
                    tracedAppendable.newLine();
                    this.generateJavaDoc((EObject)it_1, tracedAppendable, config);
                    this.generateVisibilityModifier((JvmMember)it_1, tracedAppendable);
                    tracedAppendable.append((CharSequence)"abstract ");
                    this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it_1, tracedAppendable, null);
                    JvmTypeReference _returnType = ((JvmOperation)it_1).getReturnType();
                    boolean bl = _tripleEquals = _returnType == null;
                    if (_tripleEquals) {
                        tracedAppendable.append((CharSequence)"void");
                    } else {
                        JvmTypeReference _returnType_1 = ((JvmOperation)it_1).getReturnType();
                        this._errorSafeExtensions.serializeSafely(_returnType_1, "Object", tracedAppendable);
                    }
                    tracedAppendable.append((CharSequence)" ");
                    ITreeAppendable _traceSignificant_1 = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it_1);
                    String _simpleName_3 = ((JvmOperation)it_1).getSimpleName();
                    _traceSignificant_1.append((CharSequence)_simpleName_3);
                    tracedAppendable.append((CharSequence)"(");
                    this.generateParameters((JvmExecutable)it_1, tracedAppendable, null);
                    tracedAppendable.append((CharSequence)")");
                    this.generateThrowsClause((JvmExecutable)it_1, tracedAppendable, null);
                    tracedAppendable.append((CharSequence)";");
                } else if (it_1 instanceof JvmField) {
                    boolean _isVolatile;
                    boolean _isTransient;
                    boolean _isStatic;
                    ITreeAppendable tracedAppendable_1 = childAppendable.trace((EObject)it_1);
                    tracedAppendable_1.newLine();
                    this.generateJavaDoc((EObject)it_1, tracedAppendable_1, config);
                    EList _annotations = ((JvmField)it_1).getAnnotations();
                    this.generateAnnotations((Iterable)_annotations, tracedAppendable_1, true, config);
                    if (((JvmField)it_1).isFinal() && ((JvmField)it_1).isStatic()) {
                        tracedAppendable_1.append((CharSequence)"final ");
                    }
                    if (_isStatic = ((JvmField)it_1).isStatic()) {
                        tracedAppendable_1.append((CharSequence)"static ");
                    }
                    if (_isTransient = ((JvmField)it_1).isTransient()) {
                        tracedAppendable_1.append((CharSequence)"transient ");
                    }
                    if (_isVolatile = ((JvmField)it_1).isVolatile()) {
                        tracedAppendable_1.append((CharSequence)"volatile ");
                    }
                    JvmTypeReference _type = ((JvmField)it_1).getType();
                    this._errorSafeExtensions.serializeSafely(_type, "Object", tracedAppendable_1);
                    tracedAppendable_1.append((CharSequence)" ");
                    ITreeAppendable _traceSignificant_2 = this._treeAppendableUtil.traceSignificant(tracedAppendable_1, (EObject)it_1);
                    String _simpleName_4 = ((JvmField)it_1).getSimpleName();
                    _traceSignificant_2.append((CharSequence)_simpleName_4);
                    if (((JvmField)it_1).isFinal() && ((JvmField)it_1).isStatic()) {
                        boolean _tripleNotEquals;
                        Object _constantValue = ((JvmField)it_1).getConstantValue();
                        boolean bl = _tripleNotEquals = _constantValue != null;
                        if (_tripleNotEquals) {
                            tracedAppendable_1.append((CharSequence)" = ");
                            Object _constantValue_1 = ((JvmField)it_1).getConstantValue();
                            this.generateJavaConstant(_constantValue_1, tracedAppendable_1);
                        } else {
                            this.generateInitialization((JvmField)it_1, tracedAppendable_1, config);
                        }
                    }
                    tracedAppendable_1.append((CharSequence)";");
                } else {
                    this.generateMember((JvmMember)it_1, memberAppendable, config);
                }
                memberAppendable.closeScope();
            };
            this._loopExtensions.forEach(childAppendable, _addedDeclarations, _function_2, _function_3);
            ITreeAppendable _decreaseIndentation = childAppendable.decreaseIndentation();
            ITreeAppendable _newLine_1 = _decreaseIndentation.newLine();
            _newLine_1.append((CharSequence)"}");
            appendable.newLine();
        };
        _filter.forEach(_function_1);
    }

    private ITreeAppendable generateJavaConstant(Object value, ITreeAppendable appendable) {
        ITreeAppendable _xifexpression = null;
        if (value instanceof Float) {
            String _string = ((Float)value).toString();
            ITreeAppendable _append = appendable.append((CharSequence)_string);
            _xifexpression = _append.append((CharSequence)"f");
        } else {
            ITreeAppendable _xifexpression_1 = null;
            if (value instanceof Long) {
                String _string_1 = ((Long)value).toString();
                ITreeAppendable _append_1 = appendable.append((CharSequence)_string_1);
                _xifexpression_1 = _append_1.append((CharSequence)"l");
            } else {
                ITreeAppendable _xifexpression_2 = null;
                if (value instanceof Character) {
                    char _charValue = ((Character)value).charValue();
                    String _string_2 = Integer.toString(_charValue);
                    _xifexpression_2 = appendable.append((CharSequence)_string_2);
                } else {
                    ITreeAppendable _xifexpression_3 = null;
                    if (value instanceof CharSequence) {
                        ITreeAppendable _append_2 = appendable.append((CharSequence)"\"");
                        String _string_3 = ((CharSequence)value).toString();
                        String _doConvertToJavaString = this.doConvertToJavaString(_string_3);
                        ITreeAppendable _append_3 = _append_2.append((CharSequence)_doConvertToJavaString);
                        _xifexpression_3 = _append_3.append((CharSequence)"\"");
                    } else {
                        ITreeAppendable _xifexpression_4 = null;
                        if (value instanceof Number || value instanceof Boolean) {
                            String _string_4 = value.toString();
                            _xifexpression_4 = appendable.append((CharSequence)_string_4);
                        } else {
                            _xifexpression_4 = appendable.append((CharSequence)"null /* ERROR: illegal constant value */");
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private boolean needSyntheticThisVariable(AnonymousClass anonymousClass, JvmDeclaredType localType) {
        ArrayList references = Lists.newArrayListWithCapacity((int)1);
        try {
            Set _newImmutableSet = CollectionLiterals.newImmutableSet((Object[])new JvmDeclaredType[]{localType});
            EcoreUtil2.ElementReferenceAcceptor _function = (referrer, referenced, reference, index) -> {
                try {
                    boolean _isEmpty_1;
                    EObject _eContainer_1;
                    XAbstractFeatureCall containingFeature;
                    EObject _eContainer = referrer.eContainer();
                    if (_eContainer instanceof XAbstractFeatureCall && Objects.equal((Object)(containingFeature = (XAbstractFeatureCall)(_eContainer_1 = referrer.eContainer())).getActualReceiver(), (Object)referrer) && containingFeature.getFeature() instanceof JvmMember && !this.isVisible((JvmMember)containingFeature.getFeature(), localType)) {
                        references.clear();
                        throw new StopCollecting();
                    }
                    XtendTypeDeclaration enclosingType = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)referrer, XtendTypeDeclaration.class);
                    if (enclosingType != null && !Objects.equal((Object)enclosingType, (Object)anonymousClass)) {
                        boolean _isEmpty = references.isEmpty();
                        if (_isEmpty) {
                            references.add(referrer);
                        }
                        return;
                    }
                    XClosure enclosingLambda = (XClosure)EcoreUtil2.getContainerOfType((EObject)referrer, XClosure.class);
                    if (enclosingLambda != null && EcoreUtil.isAncestor((EObject)anonymousClass, (EObject)enclosingLambda) && (_isEmpty_1 = references.isEmpty())) {
                        references.add(referrer);
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            EcoreUtil2.findCrossReferences((EObject)anonymousClass, (Set)_newImmutableSet, (EcoreUtil2.ElementReferenceAcceptor)_function);
        }
        catch (Throwable _t) {
            if (_t instanceof StopCollecting) {
                StopCollecting stopCollecting = (StopCollecting)_t;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        boolean _isEmpty = references.isEmpty();
        return !_isEmpty;
    }

    private boolean isVisible(JvmMember member, JvmDeclaredType context) {
        JvmVisibility visibility = member.getVisibility();
        boolean _equals = Objects.equal((Object)visibility, (Object)JvmVisibility.PUBLIC);
        if (_equals) {
            return true;
        }
        JvmDeclaredType _xifexpression = null;
        _xifexpression = member instanceof JvmDeclaredType ? (JvmDeclaredType)member : member.getDeclaringType();
        JvmDeclaredType type = _xifexpression;
        if (Objects.equal((Object)type, (Object)context) || EcoreUtil.isAncestor((EObject)context, (EObject)type)) {
            return true;
        }
        return type != null && (Objects.equal((Object)visibility, (Object)JvmVisibility.DEFAULT) || Objects.equal((Object)visibility, (Object)JvmVisibility.PROTECTED)) && (Strings.isEmpty((String)context.getPackageName()) && Strings.isEmpty((String)type.getPackageName()) || Objects.equal((Object)context.getPackageName(), (Object)type.getPackageName()));
    }

    public ITreeAppendable generateVisibilityModifier(JvmMember it, ITreeAppendable result) {
        ITreeAppendable _xblockexpression = null;
        JvmVisibility _visibility = it.getVisibility();
        boolean _equals = Objects.equal((Object)_visibility, (Object)JvmVisibility.PRIVATE);
        if (_equals) {
            boolean _tripleEquals;
            JvmDeclaredType _declaringType = it.getDeclaringType();
            boolean bl = _tripleEquals = _declaringType == null;
            if (_tripleEquals) {
                return result;
            }
            if (it.getDeclaringType().isLocal() && it instanceof JvmOperation) {
                boolean _not;
                JvmDeclaredType _declaringType_1 = it.getDeclaringType();
                JvmGenericType declarator = (JvmGenericType)_declaringType_1;
                boolean _isAnonymous = declarator.isAnonymous();
                boolean bl2 = _not = !_isAnonymous;
                if (_not) {
                    return result;
                }
            }
        }
        _xblockexpression = super.generateVisibilityModifier(it, result);
        return _xblockexpression;
    }

    public ITreeAppendable generateMembersInBody(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xifexpression = null;
        boolean _isLocal = it.isLocal();
        if (_isLocal) {
            Functions.Function1 _function;
            Iterable _declaredFields;
            Iterable fieldsWithInitializer;
            boolean _isEmpty;
            boolean _not;
            ITreeAppendable _xblockexpression = null;
            ITreeAppendable _append = appendable.append((CharSequence)"{");
            _append.increaseIndentation();
            Set _sourceElements = this.getSourceElements((EObject)it);
            EObject _head = (EObject)IterableExtensions.head((Iterable)_sourceElements);
            AnonymousClass anonymousClass = (AnonymousClass)_head;
            if (!appendable.hasName((Object)Pair.of((Object)"this", (Object)it)) && this.needSyntheticThisVariable(anonymousClass, it)) {
                IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)anonymousClass);
                LightweightTypeReference actualType = resolvedTypes.getActualType((XExpression)anonymousClass);
                Pair _mappedTo = Pair.of((Object)"this", (Object)it);
                String thisName = appendable.declareSyntheticVariable((Object)_mappedTo, "_this");
                ITreeAppendable _newLine = appendable.newLine();
                ITreeAppendable _append_1 = _newLine.append((CharSequence)"final ");
                ITreeAppendable _append_2 = _append_1.append(actualType);
                ITreeAppendable _append_3 = _append_2.append((CharSequence)" ");
                ITreeAppendable _append_4 = _append_3.append((CharSequence)thisName);
                _append_4.append((CharSequence)" = this;");
            }
            boolean bl = _not = !(_isEmpty = IterableExtensions.isEmpty((Iterable)(fieldsWithInitializer = IterableExtensions.filter((Iterable)(_declaredFields = it.getDeclaredFields()), (Functions.Function1)(_function = it_1 -> {
                XExpression expression;
                boolean _not;
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                boolean _xblockexpression_1 = false;
                Procedures.Procedure1 _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it_1);
                boolean bl = _tripleNotEquals = _compilationStrategy != null;
                if (_tripleNotEquals) {
                    return true;
                }
                StringConcatenationClient _compilationTemplate = this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)it_1);
                boolean bl2 = _tripleNotEquals_1 = _compilationTemplate != null;
                if (_tripleNotEquals_1) {
                    return true;
                }
                boolean bl3 = _not = !it_1.isFinal() || !it_1.isStatic();
                if (_not && (expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it_1)) != null && config.isGenerateExpressions()) {
                    return true;
                }
                _xblockexpression_1 = false;
                return _xblockexpression_1;
            })))));
            if (_not) {
                ITreeAppendable _newLine_1 = appendable.newLine();
                ITreeAppendable _append_5 = _newLine_1.append((CharSequence)"{");
                _append_5.increaseIndentation();
                Procedures.Procedure1 _function_1 = it_1 -> {
                    Functions.Function1 _function_2 = it_2 -> it_2.newLine();
                    it_1.setSeparator(_function_2);
                };
                Procedures.Procedure1 _function_2 = it_1 -> {
                    ITreeAppendable memberAppendable = this._treeAppendableUtil.traceWithComments(appendable, (EObject)it_1);
                    memberAppendable.openScope();
                    appendable.newLine();
                    ITreeAppendable tracedAppendable = appendable.trace((EObject)it_1);
                    ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it_1);
                    String _simpleName = it_1.getSimpleName();
                    _traceSignificant.append((CharSequence)_simpleName);
                    this.generateInitialization((JvmField)it_1, tracedAppendable, config);
                    tracedAppendable.append((CharSequence)";");
                    memberAppendable.closeScope();
                };
                this._loopExtensions.forEach(appendable, fieldsWithInitializer, _function_1, _function_2);
                ITreeAppendable _decreaseIndentation = appendable.decreaseIndentation();
                ITreeAppendable _newLine_2 = _decreaseIndentation.newLine();
                _newLine_2.append((CharSequence)"}");
            }
            Iterable _membersToBeCompiled = this.getMembersToBeCompiled(it);
            Procedures.Procedure1 _function_3 = it_1 -> {
                Functions.Function1 _function_4 = it_2 -> it_2.newLine();
                it_1.setSeparator(_function_4);
            };
            Procedures.Procedure1 _function_4 = it_1 -> {
                ITreeAppendable memberAppendable = this._treeAppendableUtil.traceWithComments(appendable, (EObject)it_1);
                memberAppendable.openScope();
                this.generateMember((JvmMember)it_1, memberAppendable, config);
                memberAppendable.closeScope();
            };
            this._loopExtensions.forEach(appendable, _membersToBeCompiled, _function_3, _function_4);
            ITreeAppendable _decreaseIndentation_1 = appendable.decreaseIndentation();
            ITreeAppendable _newLine_3 = _decreaseIndentation_1.newLine();
            _xifexpression = _xblockexpression = _newLine_3.append((CharSequence)"}");
        } else {
            _xifexpression = super.generateMembersInBody(it, appendable, config);
        }
        return _xifexpression;
    }

    private static class StopCollecting
    extends Exception {
        private StopCollecting() {
        }
    }
}

