/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.xtend.core.javaconverter.ASTParserFactory;
import org.eclipse.xtend.core.javaconverter.JavaASTFlattener;
import org.eclipse.xtend.core.javaconverter.JavaCodeAnalyzer;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

public class JavaConverter {
    @Inject
    private JavaCodeAnalyzer codeAnalyzer;
    @Inject
    private ASTParserFactory astParserFactory;
    @Inject
    private Provider<JavaASTFlattener> astFlattenerProvider;
    private boolean fallbackConversionStartegy = false;

    public ConversionResult toXtend(ICompilationUnit cu) {
        try {
            ASTParserFactory.ASTParserWrapper parser = this.astParserFactory.createJavaParser(cu);
            ASTNode root = parser.createAST();
            String _source = cu.getSource();
            String _targetLevel = parser.getTargetLevel();
            return this.executeAstFlattener(_source, root, _targetLevel, false);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ConversionResult toXtend(String unitName, String javaSrc) {
        ConversionResult _xblockexpression = null;
        if (unitName == null) {
            throw new IllegalArgumentException();
        }
        ASTParserFactory.ASTParserWrapper _createJavaParser = this.astParserFactory.createJavaParser(null);
        _xblockexpression = this.internalToXtend(unitName, javaSrc, null, _createJavaParser);
        return _xblockexpression;
    }

    public ConversionResult toXtend(String unitName, String javaSrc, Object classPathContext) {
        ConversionResult _xblockexpression = null;
        if (unitName == null) {
            throw new IllegalArgumentException();
        }
        ASTParserFactory.ASTParserWrapper _createJavaParser = this.astParserFactory.createJavaParser(classPathContext);
        _xblockexpression = this.internalToXtend(unitName, javaSrc, null, _createJavaParser);
        return _xblockexpression;
    }

    public String toXtend(String javaSrc, String[] javaImports, EObject targetElement, Object classPathContext) {
        boolean forceStatement = this.shouldForceStatementMode(targetElement);
        JavaCodeAnalyzer.JavaParseResult<? extends ASTNode> parseResult = this.codeAnalyzer.determinateJavaType(javaSrc);
        if (parseResult == null) {
            return javaSrc;
        }
        ConversionResult conversionResult = null;
        if (forceStatement || parseResult.getType() < 4) {
            ConversionResult _statementToXtend;
            ConversionResult _expressionToXtend;
            boolean _tripleEquals;
            int _type = parseResult.getType();
            boolean bl = _tripleEquals = _type == 1;
            conversionResult = _tripleEquals ? (_expressionToXtend = this.expressionToXtend(javaSrc, classPathContext)) : (_statementToXtend = this.statementToXtend(javaSrc, classPathContext));
        } else {
            ConversionResult _bodyDeclarationToXtend;
            Object _xifexpression = null;
            _xifexpression = javaImports != null ? javaImports : null;
            conversionResult = _bodyDeclarationToXtend = this.bodyDeclarationToXtend(javaSrc, (String[])_xifexpression, classPathContext);
        }
        return conversionResult.getXtendCode();
    }

    public ConversionResult bodyDeclarationToXtend(String javaSrc, String[] imports, Object classPathContext) {
        ASTParserFactory.ASTParserWrapper _createJavaParser = this.astParserFactory.createJavaParser(classPathContext);
        return this.internalToXtend(null, javaSrc, imports, _createJavaParser);
    }

    public ConversionResult statementToXtend(String javaSrc, Object classPathContext) {
        ASTParserFactory.ASTParserWrapper parser = this.astParserFactory.createJavaParser(classPathContext);
        char[] _charArray = javaSrc.toCharArray();
        parser.setSource(_charArray);
        parser.setKind(2);
        ASTNode root = parser.createAST();
        if (root instanceof Block) {
            String _targetLevel = parser.getTargetLevel();
            return this.executeAstFlattener(javaSrc, root, _targetLevel, true);
        }
        String _targetLevel_1 = parser.getTargetLevel();
        return this.executeAstFlattener(javaSrc, root, _targetLevel_1, false);
    }

    public ConversionResult expressionToXtend(String javaSrc, Object classPathContext) {
        ASTParserFactory.ASTParserWrapper parser = this.astParserFactory.createJavaParser(classPathContext);
        char[] _charArray = javaSrc.toCharArray();
        parser.setSource(_charArray);
        parser.setKind(1);
        ASTNode root = parser.createAST();
        String _targetLevel = parser.getTargetLevel();
        return this.executeAstFlattener(javaSrc, root, _targetLevel, false);
    }

    private ConversionResult internalToXtend(String unitName, String javaSrc, String[] imports, ASTParserFactory.ASTParserWrapper parser) {
        StringBuilder javaSrcBuilder = new StringBuilder();
        if (imports != null) {
            Consumer<String> _function = it -> javaSrcBuilder.append("import " + it + ";");
            ((List)Conversions.doWrapArray((Object)imports)).forEach(_function);
        }
        if (unitName == null) {
            parser.setUnitName("MISSING");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("class MISSING { ");
            _builder.append(javaSrc, "");
            _builder.append(" }");
            javaSrcBuilder.append((CharSequence)_builder);
        } else {
            parser.setUnitName(unitName);
            javaSrcBuilder.append(javaSrc);
        }
        parser.setKind(8);
        String preparedJavaSrc = javaSrcBuilder.toString();
        char[] _charArray = preparedJavaSrc.toCharArray();
        parser.setSource(_charArray);
        ASTNode result = parser.createAST();
        String _targetLevel = parser.getTargetLevel();
        return this.executeAstFlattener(preparedJavaSrc, result, _targetLevel, false);
    }

    private ConversionResult executeAstFlattener(String preparedJavaSource, ASTNode parseResult, String targetLevel, boolean synteticBlock) {
        JavaASTFlattener astFlattener = (JavaASTFlattener)((Object)this.astFlattenerProvider.get());
        astFlattener.setTargetlevel(targetLevel);
        astFlattener.useFallBackStrategy(this.fallbackConversionStartegy);
        astFlattener.setJavaSources(preparedJavaSource);
        if (synteticBlock && parseResult instanceof Block) {
            astFlattener.acceptSyntaticBlock((Block)parseResult);
        } else {
            parseResult.accept((ASTVisitor)astFlattener);
        }
        return ConversionResult.create(astFlattener);
    }

    public JavaConverter useRobustSyntax() {
        this.fallbackConversionStartegy = true;
        return this;
    }

    public boolean shouldForceStatementMode(EObject targetElement) {
        return targetElement != null && !(targetElement instanceof XAnnotation) && !(targetElement instanceof XtendExecutable) && EcoreUtil2.getContainerOfType((EObject)targetElement, XtendExecutable.class) != null;
    }

    @Accessors
    public static class ConversionResult {
        private String xtendCode;
        private Iterable<String> problems = CollectionLiterals.newArrayList((Object[])new String[0]);

        public static ConversionResult create(JavaASTFlattener flattener) {
            boolean _tripleNotEquals;
            String _result;
            ConversionResult result = new ConversionResult();
            result.xtendCode = _result = flattener.getResult();
            List<String> _problems = flattener.getProblems();
            boolean bl = _tripleNotEquals = _problems != null;
            if (_tripleNotEquals) {
                List<String> _problems_1 = flattener.getProblems();
                result.problems = _problems_1;
            }
            return result;
        }

        @Pure
        public String getXtendCode() {
            return this.xtendCode;
        }

        public void setXtendCode(String xtendCode) {
            this.xtendCode = xtendCode;
        }

        @Pure
        public Iterable<String> getProblems() {
            return this.problems;
        }

        public void setProblems(Iterable<String> problems) {
            this.problems = problems;
        }
    }
}

