/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.file.MutableFileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class AbstractFileSystemSupport
implements MutableFileSystemSupport {
    @Inject
    @Accessors
    private IEncodingProvider encodingProvider;
    @Inject(optional=true)
    @Accessors
    private IFilePostProcessor postProcessor;
    @Inject
    @Extension
    @Accessors
    private IProjectConfigProvider projectConfigProvider;
    @Accessors
    private ResourceSet context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharSequence getContents(Path path) {
        try {
            InputStream _contentsAsStream = this.getContentsAsStream(path);
            String _charset = this.getCharset(path);
            InputStreamReader reader = new InputStreamReader(_contentsAsStream, _charset);
            IOException threw = null;
            try {
                String string = CharStreams.toString((Readable)reader);
                return string;
            }
            catch (Throwable _t) {
                IOException e;
                if (!(_t instanceof IOException)) throw Exceptions.sneakyThrow((Throwable)_t);
                threw = e = (IOException)_t;
            }
            finally {
                block14: {
                    try {
                        reader.close();
                    }
                    catch (Throwable _t_1) {
                        if (!(_t_1 instanceof IOException)) throw Exceptions.sneakyThrow((Throwable)_t_1);
                        IOException e_1 = (IOException)_t_1;
                        if (threw != null) break block14;
                        threw = e_1;
                    }
                }
            }
            if (threw != null) throw threw;
            throw new AssertionError((Object)"threw cannot be null here");
        }
        catch (Throwable _t_2) {
            if (!(_t_2 instanceof IOException)) throw Exceptions.sneakyThrow((Throwable)_t_2);
            IOException exc = (IOException)_t_2;
            String _message = exc.getMessage();
            throw new IllegalArgumentException(_message, exc);
        }
    }

    public void setContents(Path path, CharSequence contents) {
        URI uri = this.getURI(path);
        if (uri == null) {
            throw new IllegalArgumentException("The file cannot be found: " + path);
        }
        CharSequence _elvis = null;
        CharSequence _postProcess = null;
        if (this.postProcessor != null) {
            _postProcess = this.postProcessor.postProcess(uri, contents);
        }
        _elvis = _postProcess != null ? _postProcess : contents;
        CharSequence processedContents = _elvis;
        try {
            String _string = processedContents.toString();
            String _charset = this.getCharset(path);
            StringInputStream _stringInputStream = new StringInputStream(_string, _charset);
            this.setContentsAsStream(path, (InputStream)_stringInputStream);
        }
        catch (Throwable _t) {
            if (_t instanceof UnsupportedEncodingException) {
                UnsupportedEncodingException exc = (UnsupportedEncodingException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentsAsStream(Path path, InputStream source) {
        URI uri = this.getURI(path);
        if (uri == null) {
            throw new IllegalArgumentException("The file cannot be found: " + path);
        }
        try {
            boolean _markSupported;
            if (this.exists(uri) && this.isFile(uri) && (_markSupported = source.markSupported())) {
                boolean _not;
                InputStream _contentsAsStream = this.getContentsAsStream(path);
                boolean _hasContentsChanged = this.hasContentsChanged(source, _contentsAsStream);
                boolean bl = _not = !_hasContentsChanged;
                if (_not) {
                    return;
                }
                source.reset();
            }
            URIConverter _uRIConverter = this.getURIConverter();
            try (OutputStream out = _uRIConverter.createOutputStream(uri);){
                ByteStreams.copy((InputStream)source, (OutputStream)out);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException exc = (IOException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasContentsChanged(InputStream newContent, InputStream oldContent) {
        boolean contentChanged;
        block15: {
            contentChanged = false;
            try {
                int newByte = newContent.read();
                int oldByte = oldContent.read();
                while (newByte != -1 && oldByte != -1 && newByte == oldByte) {
                    int _read_1;
                    int _read;
                    newByte = _read = newContent.read();
                    oldByte = _read_1 = oldContent.read();
                }
                contentChanged = newByte != oldByte;
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    IOException e = (IOException)_t;
                    contentChanged = true;
                    break block15;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                if (oldContent != null) {
                    try {
                        oldContent.close();
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof IOException) {
                            IOException oldByte = (IOException)_t_1;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
            }
        }
        return contentChanged;
    }

    public Iterable<? extends Path> getChildren(Path path) {
        boolean _equals = Objects.equal((Object)path, (Object)Path.ROOT);
        if (_equals) {
            IProjectConfig _projectConfig = this.projectConfigProvider.getProjectConfig(this.context);
            String _name = _projectConfig.getName();
            Path _absolutePath = path.getAbsolutePath(_name);
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Path[]{_absolutePath}));
        }
        URI uri = this.getURI(path);
        if (uri == null || !this.exists(uri) || !this.isFolder(uri).booleanValue()) {
            return CollectionLiterals.emptyList();
        }
        return this.getChildren(uri, path);
    }

    protected abstract Iterable<? extends Path> getChildren(URI var1, Path var2);

    public void mkdir(Path path) {
    }

    public InputStream getContentsAsStream(Path path) {
        URI uri = this.getURI(path);
        if (uri == null || !this.exists(uri) || !this.isFile(uri)) {
            throw new IllegalArgumentException("The file cannot be found: " + path);
        }
        try {
            URIConverter _uRIConverter = this.getURIConverter();
            return _uRIConverter.createInputStream(uri);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException exc = (IOException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void delete(Path path) {
        URI uri = this.getURI(path);
        if (uri == null) {
            return;
        }
        if (this.isFolder(uri).booleanValue() && !IterableExtensions.isEmpty(this.getChildren(uri, path))) {
            return;
        }
        try {
            URIConverter _uRIConverter = this.getURIConverter();
            _uRIConverter.delete(uri, null);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException exc = (IOException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public boolean exists(Path path) {
        boolean _xblockexpression = false;
        boolean _equals = Objects.equal((Object)path, (Object)Path.ROOT);
        if (_equals) {
            return true;
        }
        URI _uRI = this.getURI(path);
        _xblockexpression = this.exists(_uRI);
        return _xblockexpression;
    }

    protected boolean exists(URI uri) {
        boolean _xifexpression = false;
        if (uri == null) {
            _xifexpression = false;
        } else {
            URIConverter _uRIConverter = this.getURIConverter();
            _xifexpression = _uRIConverter.exists(uri, null);
        }
        return _xifexpression;
    }

    public String getCharset(Path path) {
        URI _uRI = this.getURI(path);
        return this.getCharset(_uRI);
    }

    protected String getCharset(URI uri) {
        return this.encodingProvider.getEncoding(uri);
    }

    public long getLastModification(Path path) {
        URI _uRI = this.getURI(path);
        return this.getLastModification(_uRI);
    }

    protected Long getLastModification(URI uri) {
        Long _xblockexpression = null;
        Object timeStamp = this.getAttribute(uri, "timeStamp");
        Long _xifexpression = null;
        _xifexpression = timeStamp instanceof Long ? (Long)timeStamp : Long.valueOf(0L);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean isFile(Path path) {
        URI _uRI = this.getURI(path);
        return this.isFile(_uRI);
    }

    protected boolean isFile(URI uri) {
        boolean _xblockexpression = false;
        Object directory = this.getAttribute(uri, "directory");
        boolean _xifexpression = false;
        _xifexpression = directory instanceof Boolean ? (Boolean)directory == false : false;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean isFolder(Path path) {
        Boolean _xblockexpression = null;
        boolean _equals = Objects.equal((Object)path, (Object)Path.ROOT);
        if (_equals) {
            return true;
        }
        URI _uRI = this.getURI(path);
        _xblockexpression = this.isFolder(_uRI);
        return _xblockexpression;
    }

    protected Boolean isFolder(URI uri) {
        Boolean _xblockexpression = null;
        Object directory = this.getAttribute(uri, "directory");
        Boolean _xifexpression = null;
        _xifexpression = directory instanceof Boolean ? (Boolean)directory : Boolean.valueOf(false);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public java.net.URI toURI(Path path) {
        java.net.URI _xblockexpression = null;
        URI uri = this.getURI(path);
        java.net.URI _xifexpression = null;
        if (uri != null) {
            _xifexpression = this.toURI(uri);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected java.net.URI toURI(URI uri) {
        java.net.URI _xtrycatchfinallyexpression = null;
        try {
            String _string = uri.toString();
            URL _uRL = new URL(_string);
            _xtrycatchfinallyexpression = _uRL.toURI();
        }
        catch (Throwable _t) {
            if (_t instanceof MalformedURLException) {
                MalformedURLException e = (MalformedURLException)_t;
                String _message = e.getMessage();
                throw new IllegalArgumentException(_message, e);
            }
            if (_t instanceof URISyntaxException) {
                URISyntaxException e_1 = (URISyntaxException)_t;
                String _message_1 = e_1.getMessage();
                throw new IllegalArgumentException(_message_1, e_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    protected URI getURI(Path path) {
        Iterable _tail;
        String _name;
        boolean _notEquals;
        if (path == null || Objects.equal((Object)path, (Object)Path.ROOT)) {
            return null;
        }
        IProjectConfig projectConfig = this.projectConfigProvider.getProjectConfig(this.context);
        if (projectConfig == null) {
            return null;
        }
        URI projectURI = projectConfig.getPath();
        List _segments = path.getSegments();
        String projectName = (String)IterableExtensions.head((Iterable)_segments);
        boolean bl = _notEquals = !Objects.equal((Object)projectName, (Object)(_name = projectConfig.getName()));
        if (_notEquals) {
            return null;
        }
        List _segments_1 = path.getSegments();
        Iterable segments = IterableExtensions.tail((Iterable)_segments_1);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)segments);
        if (_isEmpty) {
            return projectURI;
        }
        String _head = (String)IterableExtensions.head((Iterable)segments);
        URI _createURI = URI.createURI((String)_head);
        URI relativeURI = _createURI.appendSegments((String[])Conversions.unwrapArray((Object)(_tail = IterableExtensions.tail((Iterable)segments)), String.class));
        URI uri = relativeURI.resolve(projectURI);
        Boolean _isFolder = this.isFolder(uri);
        if (_isFolder.booleanValue()) {
            return UriUtil.toFolderURI((URI)uri);
        }
        return uri;
    }

    protected Object getAttribute(URI uri, String attributeName) {
        Object _xblockexpression = null;
        if (uri == null) {
            return null;
        }
        HashMap options = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        options.put("requestedAttributes", Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{attributeName})));
        URIConverter _uRIConverter = this.getURIConverter();
        Map _attributes = _uRIConverter.getAttributes(uri, (Map)options);
        _xblockexpression = _attributes.get(attributeName);
        return _xblockexpression;
    }

    protected URIConverter getURIConverter() {
        return this.context.getURIConverter();
    }

    public Path getPath(Resource res) {
        URI _uRI = res.getURI();
        ResourceSet _resourceSet = res.getResourceSet();
        return this.getPath(_uRI, _resourceSet);
    }

    protected Path getPath(URI uri, ResourceSet context) {
        IProjectConfig projectConfig = this.projectConfigProvider.getProjectConfig(context);
        if (projectConfig == null) {
            return null;
        }
        URI _path = projectConfig.getPath();
        String _name = projectConfig.getName();
        Path _append = Path.ROOT.append(_name);
        return this.getPath(uri, _path, _append);
    }

    protected Path getPath(URI absoluteURI, URI baseURI, Path basePath) {
        Path _xblockexpression = null;
        URI relativeURI = absoluteURI.deresolve(baseURI);
        if (relativeURI.isEmpty() || Objects.equal((Object)relativeURI, (Object)absoluteURI)) {
            return null;
        }
        String _string = relativeURI.toString();
        _xblockexpression = basePath.getAbsolutePath(_string);
        return _xblockexpression;
    }

    @Pure
    public IEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    public void setEncodingProvider(IEncodingProvider encodingProvider) {
        this.encodingProvider = encodingProvider;
    }

    @Pure
    public IFilePostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(IFilePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    @Pure
    public IProjectConfigProvider getProjectConfigProvider() {
        return this.projectConfigProvider;
    }

    public void setProjectConfigProvider(IProjectConfigProvider projectConfigProvider) {
        this.projectConfigProvider = projectConfigProvider;
    }

    @Pure
    public ResourceSet getContext() {
        return this.context;
    }

    public void setContext(ResourceSet context) {
        this.context = context;
    }
}

