/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.AnnotationReferenceBuildContextImpl;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationReferenceImpl;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationTypeDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.XtendAnnotationTypeDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.services.AnnotationReferenceBuildContext;
import org.eclipse.xtend.lib.macro.services.AnnotationReferenceProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class AnnotationReferenceProviderImpl
implements AnnotationReferenceProvider {
    @Extension
    private CompilationUnitImpl compilationUnit;

    public AnnotationReferenceProviderImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public AnnotationReference newAnnotationReference(String annotationTypeName) {
        Procedures.Procedure1 _function = it -> {};
        return this.newAnnotationReference(annotationTypeName, (Procedures.Procedure1<AnnotationReferenceBuildContext>)_function);
    }

    public AnnotationReference newAnnotationReference(Type annotationTypeDelcaration) {
        Procedures.Procedure1 _function = it -> {};
        return this.newAnnotationReference(annotationTypeDelcaration, (Procedures.Procedure1<AnnotationReferenceBuildContext>)_function);
    }

    public AnnotationReference newAnnotationReference(Class<?> annotationClass) {
        Procedures.Procedure1 _function = it -> {};
        return this.newAnnotationReference(annotationClass, (Procedures.Procedure1<AnnotationReferenceBuildContext>)_function);
    }

    public AnnotationReference newAnnotationReference(AnnotationReference annotationReference) {
        Procedures.Procedure1 _function = it -> {};
        return this.newAnnotationReference(annotationReference, (Procedures.Procedure1<AnnotationReferenceBuildContext>)_function);
    }

    public AnnotationReference newAnnotationReference(String annotationTypeName, Procedures.Procedure1<AnnotationReferenceBuildContext> initializer) {
        AnnotationReference _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("annotationTypeName cannot be null");
        Preconditions.checkArgument((annotationTypeName != null ? 1 : 0) != 0, (Object)_builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("initializer cannot be null");
        Preconditions.checkArgument((initializer != null ? 1 : 0) != 0, (Object)_builder_1);
        TypeReferences _typeReferences = this.compilationUnit.getTypeReferences();
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        JvmType _findDeclaredType = _typeReferences.findDeclaredType(annotationTypeName, (Notifier)_xtendFile);
        JvmAnnotationReference jvmAnnotationReference = this.createJvmAnnotationReference(_findDeclaredType);
        if (jvmAnnotationReference == null) {
            return null;
        }
        AnnotationReferenceBuildContextImpl _annotationReferenceBuildContextImpl = new AnnotationReferenceBuildContextImpl();
        Procedures.Procedure1 _function = it -> {
            it.setDelegate(jvmAnnotationReference);
            it.setCompilationUnit(this.compilationUnit);
        };
        AnnotationReferenceBuildContextImpl buildContext = (AnnotationReferenceBuildContextImpl)ObjectExtensions.operator_doubleArrow((Object)_annotationReferenceBuildContextImpl, (Procedures.Procedure1)_function);
        initializer.apply((Object)buildContext);
        _xblockexpression = this.compilationUnit.toAnnotationReference(jvmAnnotationReference);
        return _xblockexpression;
    }

    public AnnotationReference newAnnotationReference(Type annotationTypeDelcaration, Procedures.Procedure1<AnnotationReferenceBuildContext> initializer) {
        Object _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("annotationTypeDelcaration cannot be null");
        Preconditions.checkArgument((annotationTypeDelcaration != null ? 1 : 0) != 0, (Object)_builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("initializer cannot be null");
        Preconditions.checkArgument((initializer != null ? 1 : 0) != 0, (Object)_builder_1);
        JvmDeclaredType _switchResult = null;
        boolean _matched = false;
        if (annotationTypeDelcaration instanceof JvmAnnotationTypeDeclarationImpl) {
            _matched = true;
            _switchResult = (JvmDeclaredType)((JvmAnnotationTypeDeclarationImpl)annotationTypeDelcaration).getDelegate();
        }
        if (!_matched && annotationTypeDelcaration instanceof XtendAnnotationTypeDeclarationImpl) {
            _matched = true;
            IXtendJvmAssociations _jvmModelAssociations = this.compilationUnit.getJvmModelAssociations();
            XtendAnnotationType _delegate = (XtendAnnotationType)((XtendAnnotationTypeDeclarationImpl)annotationTypeDelcaration).getDelegate();
            _switchResult = _jvmModelAssociations.getInferredType(_delegate);
        }
        if (!_matched) {
            throw new IllegalArgumentException("couldn't construct type reference for type " + annotationTypeDelcaration);
        }
        JvmDeclaredType type = _switchResult;
        if (type instanceof JvmAnnotationType) {
            JvmAnnotationReference newJvmAnnotationReference = this.createJvmAnnotationReference((JvmType)type);
            AnnotationReferenceBuildContextImpl _annotationReferenceBuildContextImpl = new AnnotationReferenceBuildContextImpl();
            Procedures.Procedure1 _function = it -> {
                it.setDelegate(newJvmAnnotationReference);
                it.setCompilationUnit(this.compilationUnit);
            };
            AnnotationReferenceBuildContextImpl buildContext = (AnnotationReferenceBuildContextImpl)ObjectExtensions.operator_doubleArrow((Object)_annotationReferenceBuildContextImpl, (Procedures.Procedure1)_function);
            initializer.apply((Object)buildContext);
            return this.compilationUnit.toAnnotationReference(newJvmAnnotationReference);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public AnnotationReference newAnnotationReference(Class<?> annotationClass, Procedures.Procedure1<AnnotationReferenceBuildContext> initializer) {
        AnnotationReference _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("annotationClass cannot be null");
        Preconditions.checkArgument((annotationClass != null ? 1 : 0) != 0, (Object)_builder);
        String _name = annotationClass.getName();
        _xblockexpression = this.newAnnotationReference(_name, initializer);
        return _xblockexpression;
    }

    public AnnotationReference newAnnotationReference(AnnotationReference annotationReference, Procedures.Procedure1<AnnotationReferenceBuildContext> initializer) {
        Object _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("annotationReference cannot be null");
        Preconditions.checkArgument((annotationReference != null ? 1 : 0) != 0, (Object)_builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("initializer cannot be null");
        Preconditions.checkArgument((initializer != null ? 1 : 0) != 0, (Object)_builder_1);
        if (annotationReference instanceof JvmAnnotationReferenceImpl) {
            JvmAnnotationReference baseJvmAnnotationReference = (JvmAnnotationReference)((JvmAnnotationReferenceImpl)annotationReference).getDelegate();
            ConditionUtils.notRemoved((EObject)baseJvmAnnotationReference, "annotationReference");
            JvmAnnotationType _annotation = baseJvmAnnotationReference.getAnnotation();
            JvmAnnotationReference newJvmAnnotationReference = this.createJvmAnnotationReference((JvmType)_annotation);
            AnnotationReferenceBuildContextImpl _annotationReferenceBuildContextImpl = new AnnotationReferenceBuildContextImpl();
            Procedures.Procedure1 _function = it -> {
                it.setDelegate(newJvmAnnotationReference);
                it.setCompilationUnit(this.compilationUnit);
            };
            AnnotationReferenceBuildContextImpl buildContext = (AnnotationReferenceBuildContextImpl)ObjectExtensions.operator_doubleArrow((Object)_annotationReferenceBuildContextImpl, (Procedures.Procedure1)_function);
            EList _explicitValues = baseJvmAnnotationReference.getExplicitValues();
            Functions.Function1 _function_1 = it -> {
                String _elvis = null;
                String _valueName = it.getValueName();
                _elvis = _valueName != null ? _valueName : "value";
                return _elvis;
            };
            List _map = ListExtensions.map((List)_explicitValues, (Functions.Function1)_function_1);
            for (String valueName : _map) {
                Object value = ((JvmAnnotationReferenceImpl)annotationReference).getValue(valueName);
                buildContext.set(valueName, value);
            }
            initializer.apply((Object)buildContext);
            return this.compilationUnit.toAnnotationReference(newJvmAnnotationReference);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected boolean isArrayOfAnnotations(JvmAnnotationValue annotationValue) {
        JvmOperation _operation = annotationValue.getOperation();
        JvmTypeReference returnType = _operation.getReturnType();
        if (returnType instanceof JvmGenericArrayTypeReference) {
            JvmTypeReference _componentType = ((JvmGenericArrayTypeReference)returnType).getComponentType();
            JvmType _type = _componentType.getType();
            return _type instanceof JvmAnnotationType;
        }
        return false;
    }

    protected JvmAnnotationReference createJvmAnnotationReference(JvmType type) {
        JvmAnnotationReference _switchResult = null;
        boolean _matched = false;
        if (type instanceof JvmAnnotationType) {
            _matched = true;
            JvmAnnotationReference _createJvmAnnotationReference = TypesFactory.eINSTANCE.createJvmAnnotationReference();
            Procedures.Procedure1 _function = it -> it.setAnnotation((JvmAnnotationType)type);
            _switchResult = (JvmAnnotationReference)ObjectExtensions.operator_doubleArrow((Object)_createJvmAnnotationReference, (Procedures.Procedure1)_function);
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }
}

