/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationReferenceImpl;
import org.eclipse.xtend.core.macro.declaration.JvmNamedElementImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class JvmAnnotationTargetImpl<T extends JvmAnnotationTarget>
extends JvmNamedElementImpl<T> {
    public Iterable<? extends AnnotationReference> getAnnotations() {
        JvmAnnotationTarget _delegate = (JvmAnnotationTarget)this.getDelegate();
        EList _annotations = _delegate.getAnnotations();
        Functions.Function1 _function = it -> {
            CompilationUnitImpl _compilationUnit = this.getCompilationUnit();
            return _compilationUnit.toAnnotationReference((JvmAnnotationReference)it);
        };
        List _map = ListExtensions.map((List)_annotations, (Functions.Function1)_function);
        return ImmutableList.copyOf((Collection)_map);
    }

    public AnnotationReference addAnnotation(AnnotationReference annotationReference) {
        AnnotationReference _xblockexpression = null;
        this.checkMutable();
        Preconditions.checkArgument((annotationReference != null ? 1 : 0) != 0, (Object)"annotationReference cannot be null");
        AnnotationReference _xifexpression = null;
        if (!(annotationReference instanceof JvmAnnotationReferenceImpl)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)annotationReference, "");
            _builder.append(" is not annotation reference");
            throw new IllegalArgumentException(_builder.toString());
        }
        AnnotationReference _xblockexpression_1 = null;
        JvmAnnotationReference _delegate = (JvmAnnotationReference)((JvmAnnotationReferenceImpl)annotationReference).getDelegate();
        JvmAnnotationReference jvmAnnotationReference = (JvmAnnotationReference)EcoreUtil2.cloneWithProxies((EObject)_delegate);
        JvmAnnotationTarget _delegate_1 = (JvmAnnotationTarget)this.getDelegate();
        EList _annotations = _delegate_1.getAnnotations();
        _annotations.add((Object)jvmAnnotationReference);
        CompilationUnitImpl _compilationUnit = this.getCompilationUnit();
        _xifexpression = _xblockexpression_1 = _compilationUnit.toAnnotationReference(jvmAnnotationReference);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean removeAnnotation(AnnotationReference annotationReference) {
        this.checkMutable();
        if (annotationReference instanceof JvmAnnotationReferenceImpl) {
            JvmAnnotationTarget _delegate = (JvmAnnotationTarget)this.getDelegate();
            EList _annotations = _delegate.getAnnotations();
            JvmAnnotationReference _delegate_1 = (JvmAnnotationReference)((JvmAnnotationReferenceImpl)annotationReference).getDelegate();
            return _annotations.remove((Object)_delegate_1);
        }
        return false;
    }

    public AnnotationReference findAnnotation(Type annotationType) {
        Iterable<AnnotationReference> _annotations = this.getAnnotations();
        Functions.Function1 _function = it -> {
            AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
            return Objects.equal((Object)_annotationTypeDeclaration, (Object)annotationType);
        };
        return (AnnotationReference)IterableExtensions.findFirst(_annotations, (Functions.Function1)_function);
    }
}

