/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmClassDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.validation.ReadAndWriteTracking;

public class MutableJvmClassDeclarationImpl
extends JvmClassDeclarationImpl
implements MutableClassDeclaration {
    public void markAsRead() {
        this.checkMutable();
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        ReadAndWriteTracking _readAndWriteTracking = _compilationUnit.getReadAndWriteTracking();
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _readAndWriteTracking.markReadAccess((EObject)_delegate);
    }

    public MutableMethodDeclaration findDeclaredMethod(String name, TypeReference ... parameterTypes) {
        MethodDeclaration _findDeclaredMethod = super.findDeclaredMethod(name, parameterTypes);
        return (MutableMethodDeclaration)_findDeclaredMethod;
    }

    public MutableFieldDeclaration findDeclaredField(String name) {
        FieldDeclaration _findDeclaredField = super.findDeclaredField(name);
        return (MutableFieldDeclaration)_findDeclaredField;
    }

    public MutableTypeDeclaration findDeclaredType(String name) {
        TypeDeclaration _findDeclaredType = super.findDeclaredType(name);
        return (MutableTypeDeclaration)_findDeclaredType;
    }

    public MutableConstructorDeclaration findDeclaredConstructor(TypeReference ... parameterTypes) {
        ConstructorDeclaration _findDeclaredConstructor = super.findDeclaredConstructor(parameterTypes);
        return (MutableConstructorDeclaration)_findDeclaredConstructor;
    }

    @Override
    public Iterable<? extends MutableMethodDeclaration> getDeclaredMethods() {
        Iterable<MethodDeclaration> _declaredMethods = super.getDeclaredMethods();
        return _declaredMethods;
    }

    @Override
    public Iterable<? extends MutableFieldDeclaration> getDeclaredFields() {
        Iterable<FieldDeclaration> _declaredFields = super.getDeclaredFields();
        return _declaredFields;
    }

    @Override
    public Iterable<? extends MutableClassDeclaration> getDeclaredClasses() {
        Iterable<ClassDeclaration> _declaredClasses = super.getDeclaredClasses();
        return _declaredClasses;
    }

    @Override
    public Iterable<? extends MutableConstructorDeclaration> getDeclaredConstructors() {
        Iterable<ConstructorDeclaration> _declaredConstructors = super.getDeclaredConstructors();
        return _declaredConstructors;
    }

    @Override
    public Iterable<? extends MutableInterfaceDeclaration> getDeclaredInterfaces() {
        Iterable<InterfaceDeclaration> _declaredInterfaces = super.getDeclaredInterfaces();
        return _declaredInterfaces;
    }

    @Override
    public Iterable<? extends MutableAnnotationTypeDeclaration> getDeclaredAnnotationTypes() {
        Iterable<AnnotationTypeDeclaration> _declaredAnnotationTypes = super.getDeclaredAnnotationTypes();
        return _declaredAnnotationTypes;
    }

    @Override
    public Iterable<? extends MutableEnumerationTypeDeclaration> getDeclaredEnumerationTypes() {
        Iterable<EnumerationTypeDeclaration> _declaredEnumerationTypes = super.getDeclaredEnumerationTypes();
        return _declaredEnumerationTypes;
    }

    @Override
    public Iterable<? extends MutableTypeDeclaration> getDeclaredTypes() {
        Iterable<TypeDeclaration> _declaredTypes = super.getDeclaredTypes();
        return _declaredTypes;
    }

    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    @Override
    public Iterable<? extends MutableMemberDeclaration> getDeclaredMembers() {
        Iterable<MemberDeclaration> _declaredMembers = super.getDeclaredMembers();
        return _declaredMembers;
    }

    public Iterable<? extends MutableTypeParameterDeclaration> getTypeParameters() {
        Iterable<? extends TypeParameterDeclaration> _typeParameters = super.getTypeParameters();
        return _typeParameters;
    }

    public void setStrictFloatingPoint(boolean isStrictFloatingPoint) {
        this.checkMutable();
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _delegate.setStrictFloatingPoint(isStrictFloatingPoint);
    }

    public void setAbstract(boolean isAbstract) {
        this.checkMutable();
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _delegate.setAbstract(isAbstract);
    }

    public void setFinal(boolean isFinal) {
        this.checkMutable();
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _delegate.setFinal(isFinal);
    }

    public void setStatic(boolean isStatic) {
        this.checkMutable();
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        _delegate.setStatic(isStatic);
    }

    public void setExtendedClass(TypeReference superclass) {
        this.checkMutable();
        ConditionUtils.checkInferredTypeReferences("extended class", superclass);
        JvmTypeReference _xifexpression = null;
        if (superclass != null) {
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            _xifexpression = _compilationUnit.toJvmTypeReference(superclass);
        } else {
            CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
            TypeReferences _typeReferences = _compilationUnit_1.getTypeReferences();
            CompilationUnit _compilationUnit_2 = this.getCompilationUnit();
            XtendFile _xtendFile = _compilationUnit_2.getXtendFile();
            _xifexpression = _typeReferences.getTypeForName(Object.class, (Notifier)_xtendFile, new JvmTypeReference[0]);
        }
        JvmTypeReference newTypeRef = _xifexpression;
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        EList _superTypes = _delegate.getSuperTypes();
        Functions.Function1 _function = it -> it.getType() instanceof JvmGenericType && !((JvmGenericType)it.getType()).isInterface();
        JvmTypeReference oldType = (JvmTypeReference)IterableExtensions.findFirst((Iterable)_superTypes, (Functions.Function1)_function);
        if (oldType != null) {
            JvmGenericType _delegate_1 = (JvmGenericType)this.getDelegate();
            EList _superTypes_1 = _delegate_1.getSuperTypes();
            _superTypes_1.remove((Object)oldType);
        }
        JvmGenericType _delegate_2 = (JvmGenericType)this.getDelegate();
        EList _superTypes_2 = _delegate_2.getSuperTypes();
        _superTypes_2.add((Object)newTypeRef);
    }

    public void setImplementedInterfaces(Iterable<? extends TypeReference> superInterfaces) {
        this.checkMutable();
        ConditionUtils.checkIterable(superInterfaces, "superIntefaces");
        ConditionUtils.checkInferredTypeReferences("implemented interface", (TypeReference[])Conversions.unwrapArray(superInterfaces, TypeReference.class));
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        EList _superTypes = _delegate.getSuperTypes();
        Functions.Function1 _function = it -> it.getType() instanceof JvmGenericType && ((JvmGenericType)it.getType()).isInterface();
        Iterable oldInterfaces = IterableExtensions.filter((Iterable)_superTypes, (Functions.Function1)_function);
        JvmGenericType _delegate_1 = (JvmGenericType)this.getDelegate();
        EList _superTypes_1 = _delegate_1.getSuperTypes();
        CollectionExtensions.removeAll((Collection)_superTypes_1, (Iterable)oldInterfaces);
        JvmGenericType _delegate_2 = (JvmGenericType)this.getDelegate();
        EList _superTypes_2 = _delegate_2.getSuperTypes();
        Functions.Function1 _function_1 = it -> {
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            return _compilationUnit.toJvmTypeReference((TypeReference)it);
        };
        Iterable _map = IterableExtensions.map(superInterfaces, (Functions.Function1)_function_1);
        Iterables.addAll((Collection)_superTypes_2, (Iterable)_map);
    }

    public MutableTypeParameterDeclaration addTypeParameter(String name, TypeReference ... upperBounds) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)upperBounds), "upperBounds");
        ConditionUtils.checkInferredTypeReferences("parameter type", upperBounds);
        JvmTypeParameter param = TypesFactory.eINSTANCE.createJvmTypeParameter();
        param.setName(name);
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        EList _typeParameters = _delegate.getTypeParameters();
        _typeParameters.add((Object)param);
        for (TypeReference upper : upperBounds) {
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            JvmTypeReference typeRef = _compilationUnit.toJvmTypeReference(upper);
            JvmUpperBound jvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            jvmUpperBound.setTypeReference(typeRef);
            EList _constraints = param.getConstraints();
            _constraints.add((Object)jvmUpperBound);
        }
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        TypeParameterDeclaration _typeParameterDeclaration = _compilationUnit.toTypeParameterDeclaration(param);
        return (MutableTypeParameterDeclaration)_typeParameterDeclaration;
    }
}

