/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.declaration.XtendMemberDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.services.TypeReferenceProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class XtendTypeDeclarationImpl<T extends XtendTypeDeclaration>
extends XtendMemberDeclarationImpl<T>
implements TypeDeclaration {
    public String getPackageName() {
        XtendTypeDeclaration _delegate = (XtendTypeDeclaration)this.getDelegate();
        XtendFile _containerOfType = (XtendFile)EcoreUtil2.getContainerOfType((EObject)_delegate, XtendFile.class);
        return _containerOfType.getPackage();
    }

    public String getSimpleName() {
        XtendTypeDeclaration _delegate = (XtendTypeDeclaration)this.getDelegate();
        return _delegate.getName();
    }

    public String getQualifiedName() {
        XtendTypeDeclaration _delegate = (XtendTypeDeclaration)this.getDelegate();
        return this.getQualifiedName(_delegate);
    }

    private String getQualifiedName(XtendTypeDeclaration decl) {
        boolean _isAnonymous = decl.isAnonymous();
        if (_isAnonymous) {
            return null;
        }
        EObject container = decl.eContainer();
        if (container instanceof XtendFile) {
            String package_ = ((XtendFile)container).getPackage();
            if (package_ == null) {
                return decl.getName();
            }
            String _name = decl.getName();
            return package_ + "." + _name;
        }
        if (container instanceof XtendTypeDeclaration) {
            String containerName = this.getQualifiedName((XtendTypeDeclaration)container);
            if (containerName == null) {
                return null;
            }
            String _name_1 = decl.getName();
            return containerName + "." + _name_1;
        }
        return null;
    }

    @Override
    public Visibility getVisibility() {
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        XtendTypeDeclaration _delegate = (XtendTypeDeclaration)this.getDelegate();
        JvmVisibility _visibility = _delegate.getVisibility();
        return _compilationUnit.toVisibility(_visibility);
    }

    public Iterable<? extends MemberDeclaration> getDeclaredMembers() {
        XtendTypeDeclaration _delegate = (XtendTypeDeclaration)this.getDelegate();
        EList<XtendMember> _members = _delegate.getMembers();
        Functions.Function1 _function = it -> {
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            return _compilationUnit.toXtendMemberDeclaration((XtendMember)it);
        };
        return ListExtensions.map(_members, (Functions.Function1)_function);
    }

    public boolean isAssignableFrom(Type otherType) {
        if (otherType == null) {
            return false;
        }
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        TypeReferenceProvider _typeReferenceProvider = _compilationUnit.getTypeReferenceProvider();
        TypeReference thisTypeRef = _typeReferenceProvider.newTypeReference((Type)this, new TypeReference[0]);
        CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
        TypeReferenceProvider _typeReferenceProvider_1 = _compilationUnit_1.getTypeReferenceProvider();
        TypeReference thatTypeRef = _typeReferenceProvider_1.newTypeReference(otherType, new TypeReference[0]);
        return thisTypeRef.isAssignableFrom(thatTypeRef);
    }

    public ConstructorDeclaration findDeclaredConstructor(TypeReference ... parameterTypes) {
        Iterable<ConstructorDeclaration> _declaredConstructors = this.getDeclaredConstructors();
        Functions.Function1 _function = constructor -> {
            Iterable _parameters = constructor.getParameters();
            Functions.Function1 _function_1 = it -> it.getType();
            Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function_1);
            List _list = IterableExtensions.toList((Iterable)_map);
            List _list_1 = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)parameterTypes)));
            return Objects.equal((Object)_list, (Object)_list_1);
        };
        return (ConstructorDeclaration)IterableExtensions.findFirst(_declaredConstructors, (Functions.Function1)_function);
    }

    public FieldDeclaration findDeclaredField(String name) {
        Iterable<FieldDeclaration> _declaredFields = this.getDeclaredFields();
        Functions.Function1 _function = field -> {
            String _simpleName = field.getSimpleName();
            return Objects.equal((Object)_simpleName, (Object)name);
        };
        return (FieldDeclaration)IterableExtensions.findFirst(_declaredFields, (Functions.Function1)_function);
    }

    public TypeDeclaration findDeclaredType(String name) {
        Iterable<TypeDeclaration> _declaredTypes = this.getDeclaredTypes();
        Functions.Function1 _function = type -> {
            String _simpleName = type.getSimpleName();
            return Objects.equal((Object)_simpleName, (Object)name);
        };
        return (TypeDeclaration)IterableExtensions.findFirst(_declaredTypes, (Functions.Function1)_function);
    }

    public MethodDeclaration findDeclaredMethod(String name, TypeReference ... parameterTypes) {
        Iterable<MethodDeclaration> _declaredMethods = this.getDeclaredMethods();
        Functions.Function1 _function = method -> Objects.equal((Object)method.getSimpleName(), (Object)name) && Objects.equal((Object)IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)method.getParameters(), it -> it.getType())), (Object)IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)parameterTypes))));
        return (MethodDeclaration)IterableExtensions.findFirst(_declaredMethods, (Functions.Function1)_function);
    }

    public Iterable<? extends MethodDeclaration> getDeclaredMethods() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, MethodDeclaration.class);
    }

    public Iterable<? extends FieldDeclaration> getDeclaredFields() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, FieldDeclaration.class);
    }

    public Iterable<? extends ClassDeclaration> getDeclaredClasses() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, ClassDeclaration.class);
    }

    public Iterable<? extends ConstructorDeclaration> getDeclaredConstructors() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, ConstructorDeclaration.class);
    }

    public Iterable<? extends InterfaceDeclaration> getDeclaredInterfaces() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, InterfaceDeclaration.class);
    }

    public Iterable<? extends AnnotationTypeDeclaration> getDeclaredAnnotationTypes() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, AnnotationTypeDeclaration.class);
    }

    public Iterable<? extends EnumerationTypeDeclaration> getDeclaredEnumerationTypes() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, EnumerationTypeDeclaration.class);
    }

    public Iterable<? extends TypeDeclaration> getDeclaredTypes() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, TypeDeclaration.class);
    }
}

