/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.richstring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend.core.richstring.TextLine;

public class TextLines {
    public static List<TextLine> splitString(String text) {
        ArrayList result = Lists.newArrayList();
        TextLines.appendLines(text, result);
        return Collections.unmodifiableList(result);
    }

    public static void appendLines(String text, List<TextLine> result) {
        if (text == null) {
            return;
        }
        int length = text.length();
        int nextLineOffset = 0;
        for (int idx = 0; idx < length; ++idx) {
            char currentChar = text.charAt(idx);
            if (currentChar == '\r') {
                int delimiterLength = 1;
                if (idx + 1 < length && text.charAt(idx + 1) == '\n') {
                    ++delimiterLength;
                    ++idx;
                }
                int lineLength = idx - delimiterLength - nextLineOffset + 1;
                TextLine line = new TextLine(text, nextLineOffset, lineLength, delimiterLength);
                result.add(line);
                nextLineOffset = idx + 1;
                continue;
            }
            if (currentChar != '\n') continue;
            int lineLength = idx - nextLineOffset;
            TextLine line = new TextLine(text, nextLineOffset, lineLength, 1);
            result.add(line);
            nextLineOffset = idx + 1;
        }
        if (nextLineOffset != length) {
            int lineLength = length - nextLineOffset;
            TextLine line = new TextLine(text, nextLineOffset, lineLength, 0);
            result.add(line);
        }
    }
}

