/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.richstring.RichStringProcessor;
import org.eclipse.xtend.core.typesystem.LocalClassAwareTypeNames;
import org.eclipse.xtend.core.validation.AnnotationValidation;
import org.eclipse.xtend.core.validation.ModifierValidator;
import org.eclipse.xtend.core.validation.ValidatingRichStringAcceptor;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringElseIf;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFormalParameter;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.core.xtend.XtendVariableDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.typing.XAnnotationUtil;
import org.eclipse.xtext.xbase.annotations.validation.XbaseWithAnnotationsValidator;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.ConflictingDefaultOperation;
import org.eclipse.xtext.xbase.typesystem.override.IOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.RecursionGuard;
import org.eclipse.xtext.xbase.validation.ImplicitReturnFinder;
import org.eclipse.xtext.xbase.validation.ProxyAwareUIStrings;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XComputedTypeReference;

@ComposedChecks(validators={AnnotationValidation.class})
public class XtendValidator
extends XbaseWithAnnotationsValidator {
    @Inject
    private RichStringProcessor richStringProcessor;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private DispatchHelper dispatchHelper;
    @Inject
    private XAnnotationUtil annotationUtil;
    @Inject
    private JavaKeywords javaUtils;
    @Inject
    private UIStrings uiStrings;
    @Inject
    private ILogicalContainerProvider containerProvider;
    @Inject
    private JvmTypeExtensions typeExtensions;
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private IVisibilityHelper visibilityHelper;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private OperatorMapping operatorMapping;
    @Inject
    private ImplicitReturnFinder implicitReturnFinder;
    @Inject
    private LocalClassAwareTypeNames localClassAwareTypeNames;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    @Inject
    private ProxyAwareUIStrings proxyAwareUIStrings;
    @Inject
    private AnnotationLookup annotationLookup;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    protected final Set<String> visibilityModifers = ImmutableSet.of((Object)"public", (Object)"private", (Object)"protected", (Object)"package");
    protected final Multimap<Class<?>, ElementType> targetInfos;
    private final ModifierValidator classModifierValidator;
    private final ModifierValidator interfaceModifierValidator;
    private final ModifierValidator enumModifierValidator;
    private final ModifierValidator annotationTypeModifierValidator;
    private final ModifierValidator nestedClassModifierValidator;
    private final ModifierValidator nestedInterfaceModifierValidator;
    private final ModifierValidator nestedEnumModifierValidator;
    private final ModifierValidator nestedAnnotationTypeModifierValidator;
    private final ModifierValidator fieldModifierValidator;
    private final ModifierValidator fieldInInterfaceModifierValidator;
    private final ModifierValidator constructorModifierValidator;
    private final ModifierValidator methodModifierValidator;
    private ModifierValidator methodInInterfaceModifierValidator;

    public XtendValidator() {
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        result.put(XtendClass.class, (Object)ElementType.TYPE);
        result.put(XtendInterface.class, (Object)ElementType.TYPE);
        result.put(XtendEnum.class, (Object)ElementType.TYPE);
        result.putAll(XtendAnnotationType.class, (Object[])new ElementType[]{ElementType.ANNOTATION_TYPE, ElementType.TYPE});
        result.put(XtendField.class, (Object)ElementType.FIELD);
        result.put(XtendFunction.class, (Object)ElementType.METHOD);
        result.put(XtendParameter.class, (Object)ElementType.PARAMETER);
        this.targetInfos = result.build();
        this.classModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "final", "abstract", "strictfp"}), (AbstractDeclarativeValidator)this);
        this.interfaceModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "abstract", "strictfp"}), (AbstractDeclarativeValidator)this);
        this.enumModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package"}), (AbstractDeclarativeValidator)this);
        this.annotationTypeModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "abstract"}), (AbstractDeclarativeValidator)this);
        this.nestedClassModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "protected", "private", "static", "final", "abstract", "strictfp"}), (AbstractDeclarativeValidator)this);
        this.nestedInterfaceModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "protected", "private", "static", "abstract", "strictfp"}), (AbstractDeclarativeValidator)this);
        this.nestedEnumModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "protected", "private", "static"}), (AbstractDeclarativeValidator)this);
        this.nestedAnnotationTypeModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "protected", "private", "static", "abstract"}), (AbstractDeclarativeValidator)this);
        this.fieldModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "protected", "package", "private", "static", "final", "val", "var", "extension", "volatile", "transient"}), (AbstractDeclarativeValidator)this);
        this.fieldInInterfaceModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "static", "final", "val"}), (AbstractDeclarativeValidator)this);
        this.constructorModifierValidator = new ModifierValidator(Lists.newArrayList(this.visibilityModifers), (AbstractDeclarativeValidator)this);
        this.methodModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "protected", "package", "private", "static", "abstract", "dispatch", "final", "def", "override", "strictfp", "native", "synchronized"}), (AbstractDeclarativeValidator)this);
    }

    protected List<EPackage> getEPackages() {
        ArrayList ePackages = Lists.newArrayList((Iterable)super.getEPackages());
        ePackages.add(XtendPackage.eINSTANCE);
        return ePackages;
    }

    protected GeneratorConfig getGeneratorConfig(EObject element) {
        GeneratorConfig result = (GeneratorConfig)this.getContext().get(GeneratorConfig.class);
        if (result == null) {
            result = this.generatorConfigProvider.get(element);
            this.getContext().put(GeneratorConfig.class, result);
            this.methodInInterfaceModifierValidator = result.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8) ? new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "abstract", "static", "def", "override"}), (AbstractDeclarativeValidator)this) : new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "abstract", "def", "override"}), (AbstractDeclarativeValidator)this);
        }
        return result;
    }

    protected boolean hasAnnotation(XtendAnnotationTarget source, Class<?> class1) {
        for (XAnnotation anno : source.getAnnotations()) {
            if (anno == null || anno.getAnnotationType() == null || !class1.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkValidExtension(XtendField field) {
        JvmField jvmField;
        if (field.isExtension() && (jvmField = this.associations.getJvmField(field)) != null) {
            this.checkValidExtensionType((JvmIdentifiableElement)jvmField, field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__TYPE);
        }
    }

    @Check
    public void checkNonRawTypeInferred(XtendField field) {
        JvmField jvmField;
        if (field.getType() == null && (jvmField = this.associations.getJvmField(field)) != null && jvmField.eResource() != null) {
            JvmTypeReference fieldType = jvmField.getType();
            this.validateInferredType(fieldType, field, "The inferred field type ", XtendPackage.Literals.XTEND_FIELD__NAME);
        }
    }

    @Check
    public void checkNonRawTypeInferred(XtendFunction function) {
        JvmOperation operation;
        if (function.getReturnType() == null && (operation = this.associations.getDirectlyInferredOperation(function)) != null && operation.eResource() != null) {
            JvmTypeReference returnType = operation.getReturnType();
            this.validateInferredType(returnType, function, "The inferred return type ", XtendPackage.Literals.XTEND_FUNCTION__NAME);
        }
    }

    protected void validateInferredType(JvmTypeReference inferredType, XtendMember member, String messagePrefix, EAttribute location) {
        if (inferredType != null) {
            TreeIterator iterator = EcoreUtil2.eAll((EObject)inferredType);
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                if (next instanceof JvmParameterizedTypeReference) {
                    JvmParameterizedTypeReference candidate = (JvmParameterizedTypeReference)next;
                    JvmType type = candidate.getType();
                    if (!(type instanceof JvmGenericType) || ((JvmGenericType)type).getTypeParameters().isEmpty() || !candidate.getArguments().isEmpty()) continue;
                    StringBuilder message = new StringBuilder(messagePrefix);
                    if ((message = this.proxyAwareUIStrings.visit(inferredType, message)) != null) {
                        message.append(" uses the raw type ");
                        message.append(type.getSimpleName());
                        message.append(". References to generic type ");
                        message = this.proxyAwareUIStrings.appendTypeSignature(type, message);
                        message.append(" should be parameterized");
                        this.warning(message.toString(), member, (EStructuralFeature)location, "org.eclipse.xtext.xbase.validation.IssueCodes.raw_type", new String[0]);
                    }
                    return;
                }
                if (!(next instanceof XComputedTypeReference)) continue;
                this.validateInferredType(((XComputedTypeReference)next).getEquivalent(), member, messagePrefix, location);
                iterator.prune();
            }
        }
    }

    @Check
    public void checkValidExtension(XtendFormalParameter parameter) {
        if (parameter.isExtension() && !(parameter.eContainer() instanceof XCatchClause)) {
            this.checkValidExtensionType((JvmIdentifiableElement)parameter, (EObject)parameter, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__PARAMETER_TYPE);
        }
    }

    @Check
    public void checkValidExtension(XtendVariableDeclaration variableDeclaration) {
        if (variableDeclaration.isExtension()) {
            this.checkValidExtensionType((JvmIdentifiableElement)variableDeclaration, (EObject)variableDeclaration, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME);
        }
    }

    @Check
    public void checkValidExtension(XtendParameter parameter) {
        JvmFormalParameter jvmParameter;
        if (parameter.isExtension() && (jvmParameter = this.associations.getJvmParameter(parameter)) != null) {
            this.checkValidExtensionType((JvmIdentifiableElement)jvmParameter, parameter, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__PARAMETER_TYPE);
        }
    }

    protected void checkValidExtensionType(JvmIdentifiableElement identifiable, EObject source, EStructuralFeature feature) {
        LightweightTypeReference type = this.getActualType(identifiable);
        if (type != null && type.isPrimitive()) {
            this.error(String.format("The primitive type %s is not a valid extension", type.getHumanReadableName()), source, feature, "org.eclipse.xtend.core.validation.IssueCodes.invalid_extension_type", new String[0]);
        }
    }

    @Check
    public void checkAnnotationTarget(XAnnotation annotation) {
        JvmType annotationType = annotation.getAnnotationType();
        if (annotationType == null || annotationType.eIsProxy() || !(annotationType instanceof JvmAnnotationType)) {
            return;
        }
        Set targets = this.annotationUtil.getAnnotationTargets((JvmAnnotationType)annotationType);
        if (targets.isEmpty()) {
            return;
        }
        EObject eContainer = this.getContainingAnnotationTarget(annotation);
        for (Map.Entry mapping : this.targetInfos.asMap().entrySet()) {
            if (!((Class)mapping.getKey()).isInstance(eContainer)) continue;
            targets.retainAll((Collection)mapping.getValue());
            if (!targets.isEmpty()) continue;
            this.error("The annotation @" + annotation.getAnnotationType().getSimpleName() + " is disallowed for this location.", (EObject)annotation, null, -1, "org.eclipse.xtend.core.validation.IssueCodes.wrong_annotation_target", new String[0]);
        }
    }

    @Check
    public void checkMultipleAnnotations(XtendAnnotationTarget annotationTarget) {
        if (annotationTarget.getAnnotations().size() <= 1 || !this.isRelevantAnnotationTarget(annotationTarget)) {
            return;
        }
        ImmutableListMultimap groupByIdentifier = Multimaps.index(annotationTarget.getAnnotations(), (Function)new Function<XAnnotation, String>(){

            public String apply(XAnnotation input) {
                return input.getAnnotationType().getIdentifier();
            }
        });
        for (String qName : groupByIdentifier.keySet()) {
            JvmType type;
            ImmutableList sameType = groupByIdentifier.get((Object)qName);
            if (sameType.size() <= 1 || !((type = ((XAnnotation)sameType.get(0)).getAnnotationType()) instanceof JvmAnnotationType) || type.eIsProxy() || this.annotationLookup.isRepeatable((JvmAnnotationType)type)) continue;
            for (XAnnotation xAnnotation : sameType) {
                this.error("Multiple annotations of non-repeatable type @" + xAnnotation.getAnnotationType().getSimpleName() + ". Only annotation types marked @Repeatable can be used multiple times at one target.", (EObject)xAnnotation, (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, -1, "org.eclipse.xtend.core.validation.IssueCodes.multiple_annotations_used", new String[0]);
            }
        }
    }

    private boolean isRelevantAnnotationTarget(final XtendAnnotationTarget annotationTarget) {
        return Iterables.any((Iterable)this.targetInfos.keySet(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isInstance(annotationTarget);
            }
        });
    }

    protected EObject getContainingAnnotationTarget(XAnnotation annotation) {
        EObject eContainer = annotation.eContainer();
        if (eContainer.eClass() == XtendPackage.Literals.XTEND_MEMBER || eContainer.eClass() == XtendPackage.Literals.XTEND_TYPE_DECLARATION) {
            return eContainer.eContainer();
        }
        return eContainer;
    }

    @Check
    public void checkNoVoidInDependencyDeclaration(XtendField dep) {
        JvmTypeReference declaredFieldType = dep.getType();
        if (this.isPrimitiveVoid(declaredFieldType)) {
            this.error("Primitive void cannot be a dependency.", (EObject)dep.getType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkNoTypeNameShadowing(XtendTypeDeclaration type) {
        String name = type.getName();
        if (name != null && name.length() > 0) {
            XtendTypeDeclaration outer = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)type.eContainer(), XtendTypeDeclaration.class);
            while (outer != null) {
                if (name.equals(outer.getName())) {
                    this.acceptError("The nested type " + name + " cannot hide an enclosing type", type, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name", new String[0]);
                    return;
                }
                outer = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)outer.eContainer(), XtendTypeDeclaration.class);
            }
        }
    }

    @Check
    public void checkMemberNamesAreUnique(XtendTypeDeclaration xtendType) {
        Collection fields;
        HashMultimap name2field = HashMultimap.create();
        HashMultimap name2type = HashMultimap.create();
        HashMultimap type2extension = HashMultimap.create();
        for (XtendMember member : xtendType.getMembers()) {
            String name;
            if (member instanceof XtendField) {
                XtendField field = (XtendField)member;
                if (Strings.isEmpty((String)field.getName())) {
                    Object type;
                    JvmTypeReference typeReference;
                    if (!field.isExtension() || (typeReference = field.getType()) == null || (type = typeReference.getType()) == null) continue;
                    type2extension.put(type, (Object)field);
                    continue;
                }
                name2field.put((Object)field.getName(), (Object)field);
                continue;
            }
            if (!(member instanceof XtendTypeDeclaration) || (name = ((XtendTypeDeclaration)member).getName()) == null || name.length() <= 0) continue;
            name2type.put((Object)name, (Object)((XtendTypeDeclaration)member));
        }
        for (String name : name2field.keySet()) {
            fields = name2field.get((Object)name);
            if (fields.size() <= 1) continue;
            for (XtendField field : fields) {
                this.error("Duplicate field " + name, field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_field", new String[0]);
            }
        }
        for (String name : name2type.keySet()) {
            Collection types = name2type.get((Object)name);
            if (types.size() <= 1) continue;
            for (Object type : types) {
                this.error("Duplicate nested type " + name, (EObject)type, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type", new String[0]);
            }
        }
        for (JvmType type : type2extension.keySet()) {
            fields = type2extension.get((Object)type);
            if (fields.size() <= 1) continue;
            for (XtendField field : fields) {
                this.error("Duplicate extension with same type", field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__TYPE, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_field", new String[0]);
            }
        }
    }

    @Check
    public void checkXtendParameterNotPrimitiveVoid(XtendParameter param) {
        if (this.isPrimitiveVoid(param.getParameterType())) {
            XtendFunction function = (XtendFunction)(param.eContainer() instanceof XtendFunction ? param.eContainer() : null);
            if (function != null) {
                this.error("void is an invalid type for the parameter " + param.getName() + " of the method " + function.getName(), (EObject)param.getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            } else {
                this.error("void is an invalid type for the parameter " + param.getName(), (EObject)param.getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        }
    }

    @Check
    public void checkVarArgIsNotExtension(XtendParameter param) {
        if (param.isVarArg() && param.isExtension()) {
            this.error("A vararg may not be an extension.", param, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__EXTENSION, "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_varArg", new String[0]);
        }
    }

    @Check
    public void checkVarArgComesLast(XtendParameter param) {
        List params;
        if (param.isVarArg() && param != Iterables.getLast((Iterable)(params = (List)param.eContainer().eGet(param.eContainingFeature())))) {
            this.error("A vararg must be the last parameter.", param, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__VAR_ARG, "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_varArg", new String[0]);
        }
    }

    @Check
    public void checkClassPath(XtendFile xtendFile) {
        TypeReferences typeReferences = this.getServices().getTypeReferences();
        JvmGenericType listType = (JvmGenericType)typeReferences.findDeclaredType(List.class, (Notifier)xtendFile);
        if (listType == null || listType.getTypeParameters().isEmpty()) {
            this.error("Couldn't find a JDK 1.5 or higher on the project's classpath.", xtendFile, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, "org.eclipse.xtend.core.validation.IssueCodes.jdk_not_on_classpath", new String[0]);
        } else if (typeReferences.findDeclaredType(ToStringBuilder.class, (Notifier)xtendFile) == null) {
            this.error("Couldn't find the mandatory library 'org.eclipse.xtext.xbase.lib' 2.8.0 or higher on the project's classpath.", xtendFile, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, "org.eclipse.xtend.core.validation.IssueCodes.xbase_lib_not_on_classpath", new String[0]);
        }
    }

    @Check
    public void checkWhitespaceInRichStrings(RichString richString) {
        Object container;
        if (richString.eContainer() instanceof RichStringIf && ((container = (RichStringIf)richString.eContainer()).getThen() == richString || container.getElse() == richString)) {
            return;
        }
        if (richString.eContainer() instanceof RichStringElseIf && (container = (RichStringElseIf)richString.eContainer()).getThen() == richString) {
            return;
        }
        if (richString.eContainer() instanceof RichStringForLoop && (container = (RichStringForLoop)richString.eContainer()).getEachExpression() == richString) {
            return;
        }
        this.doCheckWhitespaceIn(richString);
    }

    protected void doCheckWhitespaceIn(RichString richString) {
        ValidatingRichStringAcceptor helper = new ValidatingRichStringAcceptor((ValidationMessageAcceptor)this);
        this.richStringProcessor.process(richString, helper, helper);
    }

    @Check
    public void checkSuperTypes(XtendClass xtendClass) {
        JvmTypeReference superClass = xtendClass.getExtends();
        if (superClass != null && superClass.getType() != null) {
            if (!(superClass.getType() instanceof JvmGenericType) || ((JvmGenericType)superClass.getType()).isInterface()) {
                this.error("Superclass must be a class", (EStructuralFeature)XtendPackage.Literals.XTEND_CLASS__EXTENDS, "org.eclipse.xtend.core.validation.IssueCodes.class_expected", new String[0]);
            } else {
                if (((JvmGenericType)superClass.getType()).isFinal()) {
                    this.error("Attempt to override final class", (EStructuralFeature)XtendPackage.Literals.XTEND_CLASS__EXTENDS, "org.eclipse.xtend.core.validation.IssueCodes.overridden_final", new String[0]);
                }
                this.checkWildcardSupertype(xtendClass, superClass, (EStructuralFeature)XtendPackage.Literals.XTEND_CLASS__EXTENDS, -1);
            }
        }
        for (int i = 0; i < xtendClass.getImplements().size(); ++i) {
            JvmTypeReference implementedType = (JvmTypeReference)xtendClass.getImplements().get(i);
            if (!this.isInterface(implementedType.getType())) {
                this.error("Implemented interface must be an interface", (EStructuralFeature)XtendPackage.Literals.XTEND_CLASS__IMPLEMENTS, i, "org.eclipse.xtend.core.validation.IssueCodes.interface_expected", new String[0]);
            }
            this.checkWildcardSupertype(xtendClass, implementedType, (EStructuralFeature)XtendPackage.Literals.XTEND_CLASS__IMPLEMENTS, i);
        }
        JvmGenericType inferredType = this.associations.getInferredType(xtendClass);
        if (inferredType != null && this.hasCycleInHierarchy(inferredType, Sets.newHashSet())) {
            this.error("The inheritance hierarchy of " + Strings.notNull((Object)xtendClass.getName()) + " contains cycles", (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.cyclic_inheritance", new String[0]);
        }
    }

    @Check
    public void checkSuperTypes(XtendInterface xtendInterface) {
        for (int i = 0; i < xtendInterface.getExtends().size(); ++i) {
            JvmTypeReference extendedType = (JvmTypeReference)xtendInterface.getExtends().get(i);
            if (!this.isInterface(extendedType.getType())) {
                this.error("Extended interface must be an interface", (EStructuralFeature)XtendPackage.Literals.XTEND_INTERFACE__EXTENDS, i, "org.eclipse.xtend.core.validation.IssueCodes.interface_expected", new String[0]);
            }
            this.checkWildcardSupertype(xtendInterface, extendedType, (EStructuralFeature)XtendPackage.Literals.XTEND_INTERFACE__EXTENDS, i);
        }
        JvmGenericType inferredType = this.associations.getInferredType(xtendInterface);
        if (inferredType != null && this.hasCycleInHierarchy(inferredType, Sets.newHashSet())) {
            this.error("The inheritance hierarchy of " + Strings.notNull((Object)xtendInterface.getName()) + " contains cycles", (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.cyclic_inheritance", new String[0]);
        }
    }

    @Check
    public void checkSuperTypes(AnonymousClass anonymousClass) {
        JvmTypeReference superTypeRef;
        JvmType superType;
        JvmGenericType inferredType = this.associations.getInferredType(anonymousClass);
        if (inferredType != null && (superType = (superTypeRef = (JvmTypeReference)Iterables.getLast((Iterable)inferredType.getSuperTypes())).getType()) instanceof JvmGenericType && ((JvmGenericType)superType).isFinal()) {
            this.error("Attempt to override final class", (EObject)anonymousClass.getConstructorCall(), (EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, -1, "org.eclipse.xtend.core.validation.IssueCodes.overridden_final", new String[0]);
        }
    }

    @Check
    public void checkStaticMembers(AnonymousClass anonymousClass) {
        for (XtendMember member : anonymousClass.getMembers()) {
            if (!member.isStatic()) continue;
            if (member instanceof XtendExecutable) {
                this.error("A method of an anonymous class cannot be static.", member, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, -1, "org.eclipse.xtend.core.validation.IssueCodes.anonymous_class_static_method", new String[0]);
                continue;
            }
            if (!(member instanceof XtendField)) continue;
            JvmField field = (JvmField)this.jvmModelAssociations.getPrimaryJvmElement((EObject)member);
            if (!member.isFinal()) {
                this.error("A static field of an anonymous class must be final.", member, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, -1, "org.eclipse.xtend.core.validation.IssueCodes.anonymous_class_static_field", new String[0]);
                continue;
            }
            if (field.isConstant()) continue;
            this.error("A static field of an anonymous class must be initialized with a constant expression.", member, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__INITIAL_VALUE, -1, "org.eclipse.xtend.core.validation.IssueCodes.anonymous_class_static_field", new String[0]);
        }
    }

    protected void checkWildcardSupertype(XtendTypeDeclaration xtendType, JvmTypeReference superTypeReference, EStructuralFeature feature, int index) {
        if (this.isInvalidWildcard(superTypeReference)) {
            this.error("The type " + Strings.notNull((Object)xtendType.getName()) + " cannot extend or implement " + superTypeReference.getIdentifier() + ". A supertype may not specify any wildcard", feature, index, "org.eclipse.xtend.core.validation.IssueCodes.wildcard_in_supertype", new String[0]);
        }
    }

    protected boolean isInvalidWildcard(JvmTypeReference typeRef) {
        if (typeRef instanceof JvmWildcardTypeReference) {
            return true;
        }
        if (typeRef instanceof JvmParameterizedTypeReference) {
            for (JvmTypeReference typeArgument : ((JvmParameterizedTypeReference)typeRef).getArguments()) {
                if (!(typeArgument instanceof JvmWildcardTypeReference)) continue;
                return true;
            }
        } else if (typeRef instanceof JvmSpecializedTypeReference) {
            return this.isInvalidWildcard(((JvmSpecializedTypeReference)typeRef).getEquivalent());
        }
        return false;
    }

    protected boolean hasCycleInHierarchy(JvmGenericType type, Set<JvmGenericType> processedSuperTypes) {
        JvmGenericType container = type;
        do {
            if (!processedSuperTypes.contains(container)) continue;
            return true;
        } while ((container = container.getDeclaringType()) != null);
        processedSuperTypes.add(type);
        for (JvmTypeReference superTypeRef : type.getSuperTypes()) {
            if (!(superTypeRef.getType() instanceof JvmGenericType) || !this.hasCycleInHierarchy((JvmGenericType)superTypeRef.getType(), processedSuperTypes)) continue;
            return true;
        }
        processedSuperTypes.remove(type);
        return false;
    }

    @Check
    public void checkDuplicateAndOverriddenFunctions(XtendTypeDeclaration xtendType) {
        JvmDeclaredType inferredType = this.associations.getInferredType(xtendType);
        if (inferredType instanceof JvmGenericType) {
            JavaVersion targetVersion = this.getGeneratorConfig(xtendType).getJavaSourceVersion();
            ResolvedFeatures resolvedFeatures = this.overrideHelper.getResolvedFeatures(inferredType, targetVersion);
            HashSet flaggedOperations = Sets.newHashSet();
            this.doCheckDuplicateExecutables((JvmGenericType)inferredType, resolvedFeatures, flaggedOperations);
            this.doCheckOverriddenMethods(xtendType, (JvmGenericType)inferredType, resolvedFeatures, flaggedOperations);
            this.doCheckFunctionOverrides(resolvedFeatures, (Set<EObject>)flaggedOperations);
        }
    }

    protected void doCheckDuplicateExecutables(JvmGenericType inferredType, final ResolvedFeatures resolvedFeatures, Set<EObject> flaggedOperations) {
        List declaredOperations = resolvedFeatures.getDeclaredOperations();
        this.doCheckDuplicateExecutables(inferredType, declaredOperations, new Function<String, List<IResolvedOperation>>(){

            public List<IResolvedOperation> apply(String erasedSignature) {
                return resolvedFeatures.getDeclaredOperations(erasedSignature);
            }
        }, flaggedOperations);
        final List declaredConstructors = resolvedFeatures.getDeclaredConstructors();
        this.doCheckDuplicateExecutables(inferredType, declaredConstructors, new Function<String, List<IResolvedConstructor>>(){

            public List<IResolvedConstructor> apply(String erasedSignature) {
                if (declaredConstructors.size() == 1) {
                    if (erasedSignature.equals(((IResolvedConstructor)declaredConstructors.get(0)).getResolvedErasureSignature())) {
                        return declaredConstructors;
                    }
                    return Collections.emptyList();
                }
                ArrayList result = Lists.newArrayListWithCapacity((int)declaredConstructors.size());
                for (IResolvedConstructor constructor : declaredConstructors) {
                    if (!erasedSignature.equals(constructor.getResolvedErasureSignature())) continue;
                    result.add(constructor);
                }
                return result;
            }
        }, flaggedOperations);
    }

    protected <Executable extends IResolvedExecutable> void doCheckDuplicateExecutables(JvmGenericType inferredType, List<Executable> declaredOperations, Function<String, List<Executable>> bySignature, Set<EObject> flaggedOperations) {
        HashSet processed = Sets.newHashSet();
        for (IResolvedExecutable declaredExecutable : declaredOperations) {
            List sameErasure;
            if (processed.contains(declaredExecutable) || (sameErasure = (List)bySignature.apply((Object)declaredExecutable.getResolvedErasureSignature())).size() <= 1) continue;
            HashMultimap perSignature = HashMultimap.create((int)sameErasure.size(), (int)2);
            block1: for (IResolvedExecutable executable : sameErasure) {
                for (LightweightTypeReference parameterType : executable.getResolvedParameterTypes()) {
                    if (!parameterType.isUnknown()) continue;
                    continue block1;
                }
                perSignature.put((Object)executable.getResolvedSignature(), (Object)executable);
            }
            if (perSignature.size() <= 1) continue;
            for (Collection sameSignature : perSignature.asMap().values()) {
                for (IResolvedExecutable operationWithSameSignature : sameSignature) {
                    JvmExecutable executable = operationWithSameSignature.getDeclaration();
                    EObject otherSource = this.associations.getPrimarySourceElement((EObject)executable);
                    if (!flaggedOperations.add(otherSource)) continue;
                    if (sameSignature.size() > 1) {
                        this.error("Duplicate " + this.typeLabel(executable) + " " + operationWithSameSignature.getSimpleSignature() + " in type " + inferredType.getSimpleName(), otherSource, this.nameFeature(otherSource), "org.eclipse.xtend.core.validation.IssueCodes.duplicate_method", new String[0]);
                        continue;
                    }
                    this.error("The " + this.typeLabel(executable) + " " + operationWithSameSignature.getSimpleSignature() + " has the same erasure " + operationWithSameSignature.getResolvedErasureSignature() + " as another " + this.typeLabel(executable) + " in type " + inferredType.getSimpleName(), otherSource, this.nameFeature(otherSource), "org.eclipse.xtend.core.validation.IssueCodes.duplicate_method", new String[0]);
                }
            }
        }
    }

    protected String typeLabel(JvmExecutable executable) {
        if (executable instanceof JvmOperation) {
            return "method";
        }
        if (executable instanceof JvmConstructor) {
            return "constructor";
        }
        return "?";
    }

    protected EStructuralFeature nameFeature(EObject member) {
        if (member instanceof XtendFunction) {
            return XtendPackage.Literals.XTEND_FUNCTION__NAME;
        }
        if (member instanceof XtendConstructor) {
            return null;
        }
        if (member instanceof XtendField) {
            return XtendPackage.Literals.XTEND_FIELD__NAME;
        }
        return null;
    }

    protected EStructuralFeature exceptionsFeature(EObject member) {
        if (member instanceof XtendExecutable) {
            return XtendPackage.Literals.XTEND_EXECUTABLE__EXCEPTIONS;
        }
        return null;
    }

    protected EStructuralFeature returnTypeFeature(EObject member) {
        if (member instanceof XtendFunction) {
            return XtendPackage.Literals.XTEND_FUNCTION__RETURN_TYPE;
        }
        return null;
    }

    protected void doCheckOverriddenMethods(XtendTypeDeclaration xtendType, JvmGenericType inferredType, ResolvedFeatures resolvedFeatures, Set<EObject> flaggedOperations) {
        boolean doCheckAbstract;
        ArrayList operationsMissingImplementation = null;
        boolean bl = doCheckAbstract = !inferredType.isAbstract();
        if (doCheckAbstract) {
            operationsMissingImplementation = Lists.newArrayList();
        }
        ContextualVisibilityHelper visibilityHelper = new ContextualVisibilityHelper(this.visibilityHelper, resolvedFeatures.getType());
        boolean flaggedType = false;
        for (IResolvedOperation operation : resolvedFeatures.getAllOperations()) {
            JvmDeclaredType operationDeclaringType = operation.getDeclaration().getDeclaringType();
            if (operationDeclaringType == inferredType) continue;
            if (operationsMissingImplementation != null && operation.getDeclaration().isAbstract()) {
                operationsMissingImplementation.add(operation);
            }
            if (!visibilityHelper.isVisible((JvmMember)operation.getDeclaration())) continue;
            String erasureSignature = operation.getResolvedErasureSignature();
            List declaredOperationsWithSameErasure = resolvedFeatures.getDeclaredOperations(erasureSignature);
            for (IResolvedOperation localOperation : declaredOperationsWithSameErasure) {
                EObject source;
                if (localOperation.isOverridingOrImplementing(operation.getDeclaration()).isOverridingOrImplementing() || !flaggedOperations.add(source = this.findPrimarySourceElement(localOperation))) continue;
                if (operation.getDeclaration().isStatic() && !localOperation.getDeclaration().isStatic()) {
                    this.error("The instance method " + localOperation.getSimpleSignature() + " cannot override the static method " + operation.getSimpleSignature() + " of type " + this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + ".", source, this.nameFeature(source), "org.eclipse.xtend.core.validation.IssueCodes.duplicate_method", new String[0]);
                    continue;
                }
                this.error("Name clash: The method " + localOperation.getSimpleSignature() + " of type " + inferredType.getSimpleName() + " has the same erasure as " + operation.getSimpleSignature() + " of type " + this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + " but does not override it.", source, this.nameFeature(source), "org.eclipse.xtend.core.validation.IssueCodes.duplicate_method", new String[0]);
            }
            if (!(operation instanceof ConflictingDefaultOperation) || !this.contributesToConflict(inferredType, (ConflictingDefaultOperation)operation) || flaggedType) continue;
            IResolvedOperation conflictingOperation = (IResolvedOperation)((ConflictingDefaultOperation)operation).getConflictingOperations().get(0);
            String[] uris = new String[]{this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + "|" + EcoreUtil.getURI((EObject)operation.getDeclaration()).toString(), this.getDeclaratorName((JvmFeature)conflictingOperation.getDeclaration()) + "|" + EcoreUtil.getURI((EObject)conflictingOperation.getDeclaration()).toString()};
            if (!operation.getDeclaration().isAbstract() && !conflictingOperation.getDeclaration().isAbstract()) {
                this.error("The type " + inferredType.getSimpleName() + " inherits multiple implementations of the method " + conflictingOperation.getSimpleSignature() + " from " + this.getDeclaratorName((JvmFeature)conflictingOperation.getDeclaration()) + " and " + this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + ".", xtendType, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.conflicting_default_methods", uris);
            } else {
                IResolvedOperation nonabstractOp;
                IResolvedOperation abstractOp;
                if (operation.getDeclaration().isAbstract()) {
                    abstractOp = operation;
                    nonabstractOp = conflictingOperation;
                } else {
                    abstractOp = conflictingOperation;
                    nonabstractOp = operation;
                }
                this.error("The non-abstract method " + nonabstractOp.getSimpleSignature() + " inherited from " + this.getDeclaratorName((JvmFeature)nonabstractOp.getDeclaration()) + " conflicts with the method " + abstractOp.getSimpleSignature() + " inherited from " + this.getDeclaratorName((JvmFeature)abstractOp.getDeclaration()) + ".", xtendType, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.conflicting_default_methods", uris);
            }
            flaggedType = true;
        }
        if (operationsMissingImplementation != null && !operationsMissingImplementation.isEmpty() && !flaggedType) {
            this.reportMissingImplementations(xtendType, inferredType, operationsMissingImplementation);
        }
    }

    private boolean contributesToConflict(JvmGenericType rootType, ConflictingDefaultOperation conflictingDefaultOperation) {
        HashSet involvedInterfaces = Sets.newHashSet();
        involvedInterfaces.add(((JvmOperation)conflictingDefaultOperation.getDeclaration()).getDeclaringType());
        for (IResolvedOperation conflictingOperation : conflictingDefaultOperation.getConflictingOperations()) {
            involvedInterfaces.add(conflictingOperation.getDeclaration().getDeclaringType());
        }
        RecursionGuard recursionGuard = new RecursionGuard();
        if (rootType.isInterface()) {
            int contributingCount = 0;
            for (JvmTypeReference typeRef : rootType.getExtendedInterfaces()) {
                JvmType rawType = typeRef.getType();
                if (!(rawType instanceof JvmDeclaredType) || !this.contributesToConflict((JvmDeclaredType)rawType, involvedInterfaces, (RecursionGuard<JvmDeclaredType>)recursionGuard)) continue;
                ++contributingCount;
            }
            return contributingCount >= 2;
        }
        return this.contributesToConflict((JvmDeclaredType)rootType, involvedInterfaces, (RecursionGuard<JvmDeclaredType>)recursionGuard);
    }

    private boolean contributesToConflict(JvmDeclaredType type, Set<JvmDeclaredType> involvedInterfaces, RecursionGuard<JvmDeclaredType> guard) {
        if (!guard.tryNext((Object)type)) {
            return false;
        }
        if (involvedInterfaces.contains(type)) {
            return true;
        }
        for (JvmTypeReference typeRef : type.getExtendedInterfaces()) {
            JvmType rawType = typeRef.getType();
            if (!(rawType instanceof JvmDeclaredType) || !this.contributesToConflict((JvmDeclaredType)rawType, involvedInterfaces, guard)) continue;
            return true;
        }
        return false;
    }

    protected void reportMissingImplementations(XtendTypeDeclaration xtendClass, JvmGenericType inferredType, List<IResolvedOperation> operationsMissingImplementation) {
        boolean needsNewLine;
        StringBuilder errorMsg = new StringBuilder();
        String name = xtendClass.getName();
        boolean bl = needsNewLine = operationsMissingImplementation.size() > 1;
        if (xtendClass.isAnonymous()) {
            JvmTypeReference superType = (JvmTypeReference)Iterables.getLast((Iterable)inferredType.getSuperTypes());
            errorMsg.append("The anonymous subclass of ").append(superType.getSimpleName());
            errorMsg.append(" does not implement ");
        } else {
            errorMsg.append("The class ").append(name);
            errorMsg.append(" must be defined abstract because it does not implement ");
        }
        if (needsNewLine) {
            errorMsg.append("its inherited abstract methods ");
        }
        for (int i = 0; i < operationsMissingImplementation.size() && i < 3; ++i) {
            IResolvedOperation operation = operationsMissingImplementation.get(i);
            if (needsNewLine) {
                errorMsg.append("\n- ");
            }
            errorMsg.append(operation.getSimpleSignature());
        }
        int numUnshownOperations = operationsMissingImplementation.size() - 3;
        if (numUnshownOperations > 0) {
            errorMsg.append("\nand " + numUnshownOperations + " more.");
        }
        List uris = Lists.transform(operationsMissingImplementation, (Function)new Function<IResolvedOperation, String>(){

            public String apply(IResolvedOperation from) {
                return EcoreUtil.getURI((EObject)from.getDeclaration()).toString();
            }
        });
        if (xtendClass.isAnonymous()) {
            this.error(errorMsg.toString(), xtendClass, (EStructuralFeature)XtendPackage.Literals.ANONYMOUS_CLASS__CONSTRUCTOR_CALL, "org.eclipse.xtend.core.validation.IssueCodes.anonymous_class_missing_members", (String[])Iterables.toArray((Iterable)uris, String.class));
        } else {
            this.error(errorMsg.toString(), xtendClass, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.class_must_be_defined_abstract", (String[])Iterables.toArray((Iterable)uris, String.class));
        }
    }

    protected void doCheckFunctionOverrides(ResolvedFeatures resolvedFeatures, Set<EObject> flaggedOperations) {
        for (IResolvedOperation operation : resolvedFeatures.getDeclaredOperations()) {
            this.doCheckFunctionOverrides(operation, flaggedOperations);
        }
    }

    protected void doCheckFunctionOverrides(IResolvedOperation operation, Set<EObject> flaggedOperations) {
        EObject sourceElement = this.findPrimarySourceElement(operation);
        if (sourceElement != null) {
            List allInherited = operation.getOverriddenAndImplementedMethods();
            if (allInherited.isEmpty()) {
                XtendFunction function;
                if (sourceElement instanceof XtendFunction && flaggedOperations.add(sourceElement) && (function = (XtendFunction)sourceElement).isOverride()) {
                    this.error("The method " + operation.getSimpleSignature() + " of type " + this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + " must override a superclass method.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)"override"), "org.eclipse.xtend.core.validation.IssueCodes.obsolete_override", new String[0]);
                }
            } else if (flaggedOperations.add(sourceElement)) {
                this.doCheckFunctionOverrides(sourceElement, operation, allInherited);
            }
        }
    }

    protected void doCheckFunctionOverrides(EObject sourceElement, IResolvedOperation resolved, List<IResolvedOperation> allInherited) {
        boolean overrideProblems = false;
        List exceptionMismatch = null;
        for (IResolvedOperation inherited : allInherited) {
            if (!inherited.getOverrideCheckResult().hasProblems()) continue;
            overrideProblems = true;
            EnumSet details = inherited.getOverrideCheckResult().getDetails();
            if (details.contains(IOverrideCheckResult.OverrideCheckDetails.IS_FINAL)) {
                this.error("Attempt to override final method " + inherited.getSimpleSignature(), sourceElement, this.nameFeature(sourceElement), "org.eclipse.xtend.core.validation.IssueCodes.overridden_final", new String[0]);
                continue;
            }
            if (details.contains(IOverrideCheckResult.OverrideCheckDetails.REDUCED_VISIBILITY)) {
                this.error("Cannot reduce the visibility of the overridden method " + inherited.getSimpleSignature(), sourceElement, this.nameFeature(sourceElement), "org.eclipse.xtend.core.validation.IssueCodes.override_reduces_visibility", new String[0]);
                continue;
            }
            if (details.contains(IOverrideCheckResult.OverrideCheckDetails.EXCEPTION_MISMATCH)) {
                if (exceptionMismatch == null) {
                    exceptionMismatch = Lists.newArrayListWithCapacity((int)allInherited.size());
                }
                exceptionMismatch.add(inherited);
                continue;
            }
            if (!details.contains(IOverrideCheckResult.OverrideCheckDetails.RETURN_MISMATCH)) continue;
            this.error("The return type is incompatible with " + inherited.getSimpleSignature(), sourceElement, this.returnTypeFeature(sourceElement), "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
        }
        if (exceptionMismatch != null) {
            this.createExceptionMismatchError(resolved, sourceElement, exceptionMismatch);
        }
        if (sourceElement instanceof XtendFunction) {
            XtendFunction function = (XtendFunction)sourceElement;
            if (!(overrideProblems || function.isOverride() || function.isStatic())) {
                this.error("The method " + resolved.getSimpleSignature() + " of type " + this.getDeclaratorName(resolved) + " must use override keyword since it actually overrides a supertype method.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.missing_override", new String[0]);
            }
            if (!overrideProblems && function.isOverride() && function.isStatic()) {
                for (IResolvedOperation inherited : allInherited) {
                    this.error("The method " + resolved.getSimpleSignature() + " of type " + this.getDeclaratorName(resolved) + " shadows the method " + resolved.getSimpleSignature() + " of type " + this.getDeclaratorName(inherited) + ", but does not override it.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, function.getModifiers().indexOf((Object)"override"), "org.eclipse.xtend.core.validation.IssueCodes.obsolete_override", new String[0]);
                }
            }
        }
    }

    protected String getDeclaratorName(IResolvedOperation resolved) {
        return this.getDeclaratorName((JvmFeature)resolved.getDeclaration());
    }

    protected void createExceptionMismatchError(IResolvedOperation operation, EObject sourceElement, List<IResolvedOperation> exceptionMismatch) {
        int i;
        List exceptions = operation.getIllegallyDeclaredExceptions();
        StringBuilder message = new StringBuilder(100);
        message.append("The declared exception");
        if (exceptions.size() > 1) {
            message.append('s');
        }
        message.append(' ');
        for (i = 0; i < exceptions.size(); ++i) {
            if (i != 0) {
                if (i != exceptions.size() - 1) {
                    message.append(", ");
                } else {
                    message.append(" and ");
                }
            }
            message.append(((LightweightTypeReference)exceptions.get(i)).getHumanReadableName());
        }
        if (exceptions.size() > 1) {
            message.append(" are");
        } else {
            message.append(" is");
        }
        message.append(" not compatible with throws clause in ");
        for (i = 0; i < exceptionMismatch.size(); ++i) {
            if (i != 0) {
                if (i != exceptionMismatch.size() - 1) {
                    message.append(", ");
                } else {
                    message.append(" and ");
                }
            }
            IResolvedOperation resolvedOperation = exceptionMismatch.get(i);
            message.append(this.getDeclaratorName(resolvedOperation));
            message.append('.');
            message.append(exceptionMismatch.get(i).getSimpleSignature());
        }
        this.error(message.toString(), sourceElement, this.exceptionsFeature(sourceElement), "org.eclipse.xtend.core.validation.IssueCodes.incompatible_throws_clause", new String[0]);
    }

    protected EObject findPrimarySourceElement(IResolvedOperation operation) {
        return this.associations.getPrimarySourceElement((EObject)operation.getDeclaration());
    }

    protected boolean isMorePrivateThan(JvmVisibility o1, JvmVisibility o2) {
        if (o1 == o2) {
            return false;
        }
        switch (o1) {
            case DEFAULT: {
                return o2 != JvmVisibility.PRIVATE;
            }
            case PRIVATE: {
                return true;
            }
            case PROTECTED: {
                return o2 == JvmVisibility.PUBLIC;
            }
            case PUBLIC: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown JvmVisibility " + o1);
    }

    @Check
    public void checkDefaultSuperConstructor(XtendClass xtendClass) {
        JvmType superType;
        JvmGenericType inferredType = this.associations.getInferredType(xtendClass);
        if (inferredType == null) {
            return;
        }
        Iterable constructors = Iterables.filter((Iterable)inferredType.getMembers(), JvmConstructor.class);
        if (inferredType.getExtendedClass() != null && (superType = inferredType.getExtendedClass().getType()) instanceof JvmGenericType) {
            Iterable superConstructors = ((JvmGenericType)superType).getDeclaredConstructors();
            for (Object superConstructor : superConstructors) {
                if (!superConstructor.getParameters().isEmpty()) continue;
                return;
            }
            if (Iterables.size((Iterable)constructors) == 1 && this.typeExtensions.isSingleSyntheticDefaultConstructor((JvmConstructor)constructors.iterator().next())) {
                ArrayList issueData = Lists.newArrayList();
                for (JvmConstructor superConstructor : superConstructors) {
                    issueData.add(EcoreUtil.getURI((EObject)superConstructor).toString());
                    issueData.add(this.doGetReadableSignature(xtendClass.getName(), (List<JvmFormalParameter>)superConstructor.getParameters()));
                }
                this.error("No default constructor in super type " + superType.getSimpleName() + "." + xtendClass.getName() + " must define an explicit constructor.", xtendClass, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.missing_constructor", (String[])Iterables.toArray((Iterable)issueData, String.class));
            } else {
                for (JvmConstructor constructor : constructors) {
                    EList expressions;
                    XExpression expression = this.containerProvider.getAssociatedExpression((JvmIdentifiableElement)constructor);
                    if (!(expression instanceof XBlockExpression) || !(expressions = ((XBlockExpression)expression).getExpressions()).isEmpty() && this.isDelegateConstructorCall((XExpression)expressions.get(0))) continue;
                    EObject source = this.associations.getPrimarySourceElement((EObject)constructor);
                    this.error("No default constructor in super type " + superType.getSimpleName() + ". Another constructor must be invoked explicitly.", source, null, "org.eclipse.xtend.core.validation.IssueCodes.must_invoke_super_constructor", new String[0]);
                }
            }
        }
    }

    protected boolean isDelegateConstructorCall(XExpression expression) {
        if (expression instanceof XFeatureCall) {
            JvmIdentifiableElement feature = ((XFeatureCall)expression).getFeature();
            return feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor;
        }
        return false;
    }

    protected boolean isInterface(JvmDeclaredType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isInterface();
    }

    protected String canonicalName(JvmIdentifiableElement element) {
        return element != null ? Strings.notNull((Object)element.getIdentifier()) : null;
    }

    protected String getReadableSignature(JvmExecutable executable) {
        if (executable == null) {
            return "null";
        }
        return this.doGetReadableSignature(executable.getSimpleName(), (List<JvmFormalParameter>)executable.getParameters());
    }

    protected String doGetReadableSignature(String simpleName, List<JvmFormalParameter> parameters) {
        return this.getReadableSignature(simpleName, Lists.transform(parameters, (Function)new Function<JvmFormalParameter, JvmTypeReference>(){

            public JvmTypeReference apply(JvmFormalParameter from) {
                return from.getParameterType();
            }
        }));
    }

    protected String getReadableSignature(String elementName, List<JvmTypeReference> parameterTypes) {
        StringBuilder result = new StringBuilder(elementName);
        result.append('(');
        for (int i = 0; i < parameterTypes.size(); ++i) {
            JvmTypeReference parameterType;
            if (i != 0) {
                result.append(", ");
            }
            if ((parameterType = parameterTypes.get(i)) != null) {
                result.append(parameterType.getSimpleName());
                continue;
            }
            result.append("null");
        }
        result.append(')');
        return result.toString();
    }

    @Check
    public void checkParameterNames(XtendFunction function) {
        for (int i = 0; i < function.getParameters().size(); ++i) {
            String leftParameterName = ((XtendParameter)function.getParameters().get(i)).getName();
            for (int j = i + 1; j < function.getParameters().size(); ++j) {
                if (!Strings.equal((String)leftParameterName, (String)((XtendParameter)function.getParameters().get(j)).getName())) continue;
                this.error("Duplicate parameter " + leftParameterName, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                this.error("Duplicate parameter " + leftParameterName, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, j, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_parameter_name", new String[0]);
            }
            if (function.getCreateExtensionInfo() == null || !Strings.equal((String)leftParameterName, (String)function.getCreateExtensionInfo().getName())) continue;
            this.error("Duplicate parameter " + leftParameterName, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_parameter_name", new String[0]);
            if (function.getCreateExtensionInfo().eIsSet((EStructuralFeature)XtendPackage.Literals.CREATE_EXTENSION_INFO__NAME)) {
                this.error("Duplicate parameter " + leftParameterName, function.getCreateExtensionInfo(), (EStructuralFeature)XtendPackage.Literals.CREATE_EXTENSION_INFO__NAME, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                continue;
            }
            this.error("Duplicate implicit parameter 'it'", function.getCreateExtensionInfo(), (EStructuralFeature)XtendPackage.Literals.CREATE_EXTENSION_INFO__NAME, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_parameter_name", new String[0]);
        }
    }

    @Check
    public void checkAbstract(XtendFunction function) {
        XtendTypeDeclaration declarator = function.getDeclaringType();
        if (function.getExpression() == null) {
            if (declarator instanceof XtendClass || declarator.isAnonymous()) {
                if (function.isDispatch()) {
                    this.error("The dispatch method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " must not be abstract", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "dispatch_functions_must_not_be_abstract", new String[0]);
                    return;
                }
                if (function.getCreateExtensionInfo() != null) {
                    this.error("The 'create'-method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " must not be abstract", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "create_functions_must_not_be_abstract", new String[0]);
                    return;
                }
                if (declarator.isAnonymous()) {
                    this.error("The abstract method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " can only be defined by an abstract class.", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract_in_anonymous", new String[0]);
                } else if (!((XtendClass)declarator).isAbstract() && !function.isNative()) {
                    this.error("The abstract method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " can only be defined by an abstract class.", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract", new String[0]);
                }
                if (function.getReturnType() == null && !function.isOverride()) {
                    this.error("The " + (function.isNative() ? "native" : "abstract") + " method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " must declare a return type", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.abstract_method_missing_return_type", new String[0]);
                }
            } else if (declarator instanceof XtendInterface) {
                if (function.getCreateExtensionInfo() != null) {
                    this.error("'Create'-method " + function.getName() + " is not permitted in an interface", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "create_functions_must_not_be_abstract", new String[0]);
                    return;
                }
                if (function.getReturnType() == null && !function.isOverride()) {
                    this.error("The abstract method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " must declare a return type", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.abstract_method_missing_return_type", new String[0]);
                }
            }
        } else if (declarator instanceof XtendInterface && !this.getGeneratorConfig(function).getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8)) {
            this.error("Abstract methods do not specify a body", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.abstract_method_with_body", new String[0]);
        }
    }

    @Check
    public void checkOperatorSignature(XtendFunction function) {
        JvmOperation operation;
        QualifiedName qualifiedName;
        QualifiedName operator;
        String functionName = function.getName();
        if (functionName != null && (operator = this.operatorMapping.getOperator(qualifiedName = QualifiedName.create((String)functionName))) != null && (operation = this.associations.getDirectlyInferredOperation(function)) != null) {
            int parameterSize = operation.getParameters().size();
            if (function.isStatic()) {
                if (this.operatorMapping.isUnaryOperator(operator) && this.operatorMapping.isBinaryOperator(operator)) {
                    if (parameterSize < 1) {
                        this.addIssue("The static operator '" + operator + "' requires at least one argument.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                    } else if (parameterSize > 2) {
                        this.addIssue("The static operator '" + operator + "' allows at most two arguments.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                    }
                } else if (this.operatorMapping.isUnaryOperator(operator)) {
                    if (parameterSize != 1) {
                        this.addIssue("The static unary operator '" + operator + "' requires exactly one argument.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                    }
                } else if (parameterSize != 2) {
                    this.addIssue("The static binary operator '" + operator + "' requires exactly two arguments.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                }
            } else if (this.operatorMapping.isUnaryOperator(operator) && this.operatorMapping.isBinaryOperator(operator)) {
                if (parameterSize > 2) {
                    this.addIssue("The operator '" + operator + "' allows at most two arguments.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                }
            } else if (this.operatorMapping.isUnaryOperator(operator)) {
                if (parameterSize > 1) {
                    this.addIssue("The unary operator '" + operator + "' allows at most one argument.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                }
            } else if (parameterSize == 0) {
                this.addIssue("The binary operator '" + operator + "' requires at least one argument.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
            } else if (parameterSize > 2) {
                this.addIssue("The binary operator '" + operator + "' allows at most two arguments.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
            }
        }
    }

    @Check
    public void checkParameterNames(XtendConstructor constructor) {
        for (int i = 0; i < constructor.getParameters().size(); ++i) {
            String leftParameterName = ((XtendParameter)constructor.getParameters().get(i)).getName();
            for (int j = i + 1; j < constructor.getParameters().size(); ++j) {
                if (!Strings.equal((String)leftParameterName, (String)((XtendParameter)constructor.getParameters().get(j)).getName())) continue;
                this.error("Duplicate parameter " + leftParameterName, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                this.error("Duplicate parameter " + leftParameterName, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, j, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_parameter_name", new String[0]);
            }
        }
    }

    @Check
    public void dispatchFuncWithTypeParams(XtendFunction func) {
        if (func.isDispatch()) {
            if (func.getParameters().isEmpty()) {
                this.error("A dispatch method must at least have one parameter declared.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, func.getModifiers().indexOf((Object)"dispatch"), "org.eclipse.xtend.core.validation.IssueCodes.case_function_without_params", new String[0]);
            }
            if (!func.getTypeParameters().isEmpty()) {
                this.error("A dispatch method must not declare any type parameters.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, func.getModifiers().indexOf((Object)"dispatch"), "org.eclipse.xtend.core.validation.IssueCodes.case_function_with_type_params", new String[0]);
            }
            if (func.getName().startsWith("_")) {
                this.error("A dispatch method's name must not start with an underscore.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.case_func_name_starts_with_underscore", new String[0]);
            }
        }
    }

    @Check
    public void checkDispatchFunctions(XtendClass clazz) {
        JvmGenericType type = this.associations.getInferredType(clazz);
        if (type != null) {
            ListMultimap<DispatchHelper.DispatchSignature, JvmOperation> dispatchMethods = this.dispatchHelper.getDeclaredOrEnhancedDispatchMethods((JvmDeclaredType)type);
            this.checkDispatchNonDispatchConflict(clazz, (Multimap<DispatchHelper.DispatchSignature, JvmOperation>)dispatchMethods);
            for (DispatchHelper.DispatchSignature signature : dispatchMethods.keySet()) {
                LightweightTypeReference operationType;
                Collection dispatchOperations = dispatchMethods.get((Object)signature);
                JvmOperation syntheticDispatchMethod = this.dispatchHelper.getDispatcherOperation((JvmDeclaredType)type, signature);
                if (syntheticDispatchMethod == null) continue;
                JvmOperation overriddenOperation = this.overrideHelper.findOverriddenOperation(syntheticDispatchMethod);
                Boolean expectStatic = null;
                if (overriddenOperation != null) {
                    if (this.isMorePrivateThan(syntheticDispatchMethod.getVisibility(), overriddenOperation.getVisibility())) {
                        String msg = "Synthetic dispatch method reduces visibility of overridden method " + overriddenOperation.getIdentifier();
                        this.addDispatchError(type, dispatchOperations, msg, null, "org.eclipse.xtend.core.validation.IssueCodes.override_reduces_visibility");
                    }
                    expectStatic = overriddenOperation.isStatic();
                }
                LightweightTypeReference dispatchMethodReturnType = this.getActualType(clazz, (JvmIdentifiableElement)syntheticDispatchMethod);
                if (dispatchOperations.size() == 1) {
                    JvmOperation singleOp = (JvmOperation)dispatchOperations.iterator().next();
                    XtendFunction function = this.associations.getXtendFunction(singleOp);
                    this.addIssue("Single dispatch method.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)"dispatch"), "org.eclipse.xtend.core.validation.IssueCodes.single_case_function", new String[0]);
                    continue;
                }
                HashMultimap signatures = HashMultimap.create();
                boolean[] allPrimitive = new boolean[signature.getArity()];
                Arrays.fill(allPrimitive, true);
                boolean isFirstLocalOperation = true;
                JvmVisibility commonVisibility = null;
                Boolean commonStatic = null;
                for (JvmOperation jvmOperation : dispatchOperations) {
                    XtendFunction function;
                    signatures.put(this.getParamTypes(jvmOperation, true), (Object)jvmOperation);
                    for (int i = 0; i < jvmOperation.getParameters().size(); ++i) {
                        JvmFormalParameter parameter = (JvmFormalParameter)jvmOperation.getParameters().get(i);
                        if (parameter.getParameterType().getType() instanceof JvmPrimitiveType) continue;
                        allPrimitive[i] = false;
                    }
                    if (jvmOperation.getDeclaringType() != type) continue;
                    if (expectStatic != null) {
                        if (expectStatic.booleanValue() && !jvmOperation.isStatic()) {
                            String msg = "The dispatch method must be static because the dispatch methods in the superclass are static.";
                            this.addDispatchError(jvmOperation, msg, "static", "dispatch_functions_static_expected");
                        }
                        if (!expectStatic.booleanValue() && jvmOperation.isStatic()) {
                            String msg = "The dispatch method must not be static because the dispatch methods in the superclass are not static.";
                            this.addDispatchError(jvmOperation, msg, "static", "dispatch_functions_non_static_expected");
                        }
                    }
                    if (isFirstLocalOperation) {
                        commonVisibility = jvmOperation.getVisibility();
                        commonStatic = jvmOperation.isStatic();
                        isFirstLocalOperation = false;
                    } else {
                        if (jvmOperation.getVisibility() != commonVisibility) {
                            commonVisibility = null;
                        }
                        if (commonStatic != null && commonStatic.booleanValue() != jvmOperation.isStatic()) {
                            commonStatic = null;
                        }
                    }
                    if (dispatchMethodReturnType == null || (function = this.associations.getXtendFunction(jvmOperation)) == null || dispatchMethodReturnType.isAssignableFrom(operationType = this.getActualType((EObject)function.getExpression(), (JvmIdentifiableElement)jvmOperation))) continue;
                    this.error("Incompatible return type of dispatch method. Expected " + dispatchMethodReturnType.getHumanReadableName() + " but was " + operationType.getHumanReadableName(), function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__RETURN_TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
                }
                if (commonVisibility == null) {
                    this.addDispatchError(type, dispatchOperations, "All local dispatch methods must have the same visibility.", null, "dispatch_functions_with_different_visibility");
                }
                if (expectStatic == null && commonStatic == null) {
                    this.addDispatchError(type, dispatchOperations, "Static and non-static dispatch methods can not be mixed.", "static", "dispatch_functions_mixed_static_and_non_static");
                }
                for (final List paramTypes : signatures.keySet()) {
                    Collection ops = signatures.get((Object)paramTypes);
                    if (ops.size() <= 1 || !Iterables.any((Iterable)ops, (Predicate)new Predicate<JvmOperation>(){

                        public boolean apply(JvmOperation input) {
                            return !XtendValidator.this.getParamTypes(input, false).equals(paramTypes);
                        }
                    })) continue;
                    operationType = ops.iterator();
                    while (operationType.hasNext()) {
                        JvmOperation jvmOperation = (JvmOperation)operationType.next();
                        XtendFunction function = this.associations.getXtendFunction(jvmOperation);
                        this.error("Duplicate dispatch methods. Primitives cannot overload their wrapper types in dispatch methods.", function, null, "org.eclipse.xtend.core.validation.IssueCodes.duplicate_method", new String[0]);
                    }
                }
                for (int i = 0; i < allPrimitive.length; ++i) {
                    if (!allPrimitive[i]) continue;
                    Iterator operationIter = dispatchOperations.iterator();
                    JvmType paramType1 = ((JvmFormalParameter)((JvmOperation)operationIter.next()).getParameters().get(i)).getParameterType().getType();
                    while (operationIter.hasNext()) {
                        JvmType paramType2 = ((JvmFormalParameter)((JvmOperation)operationIter.next()).getParameters().get(i)).getParameterType().getType();
                        if (paramType2.equals(paramType1)) continue;
                        for (JvmOperation jvmOperation : dispatchOperations) {
                            XtendFunction function = this.associations.getXtendFunction(jvmOperation);
                            this.addIssue("Dispatch methods have arguments with different primitive types.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "org.eclipse.xtend.core.validation.IssueCodes.dispatch_functions_different_primitive_args", new String[0]);
                        }
                    }
                }
            }
        }
    }

    protected void checkDispatchNonDispatchConflict(XtendClass clazz, Multimap<DispatchHelper.DispatchSignature, JvmOperation> dispatchMethods) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash")) {
            return;
        }
        HashMultimap nonDispatchMethods = HashMultimap.create();
        for (XtendFunction method : Iterables.filter(clazz.getMembers(), XtendFunction.class)) {
            if (method.isDispatch()) continue;
            nonDispatchMethods.put((Object)new DispatchHelper.DispatchSignature(method.getName(), method.getParameters().size()), (Object)method);
        }
        for (DispatchHelper.DispatchSignature dispatchSignature : dispatchMethods.keySet()) {
            if (!nonDispatchMethods.containsKey((Object)dispatchSignature)) continue;
            for (XtendFunction function : nonDispatchMethods.get((Object)dispatchSignature)) {
                this.addIssue("Non-dispatch method has same name and number of parameters as dispatch method", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash", new String[0]);
            }
            for (JvmOperation operation : dispatchMethods.get((Object)dispatchSignature)) {
                this.addIssue("Dispatch method has same name and number of parameters as non-dispatch method", this.associations.getXtendFunction(operation), (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash", new String[0]);
            }
        }
    }

    protected void addDispatchError(JvmGenericType type, Iterable<JvmOperation> operations, String message, String modifier, String ISSUE_ID) {
        for (JvmOperation jvmOperation : operations) {
            if (jvmOperation.getDeclaringType() != type) continue;
            this.addDispatchError(jvmOperation, message, modifier, ISSUE_ID);
        }
    }

    protected void addDispatchError(JvmOperation jvmOperation, String message, String modifier, String ISSUE_ID) {
        XtendFunction function = this.associations.getXtendFunction(jvmOperation);
        if (function != null) {
            int modifierIndex = -1;
            if (modifier != null) {
                modifierIndex = function.getModifiers().indexOf((Object)modifier);
            } else {
                for (int i = 0; i < function.getModifiers().size(); ++i) {
                    if (!this.visibilityModifers.contains(function.getModifiers().get(i))) continue;
                    modifierIndex = i;
                    break;
                }
            }
            if (modifierIndex == -1) {
                modifierIndex = function.getModifiers().indexOf((Object)"dispatch");
            }
            this.error(message, function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, modifierIndex, ISSUE_ID, new String[0]);
        }
    }

    protected List<JvmType> getParamTypes(JvmOperation jvmOperation, boolean wrapPrimitives) {
        ArrayList types = Lists.newArrayList();
        for (JvmFormalParameter p : jvmOperation.getParameters()) {
            LightweightTypeReference typeReference = this.toLightweightTypeReference(p.getParameterType());
            if (wrapPrimitives) {
                typeReference = typeReference.getWrapperTypeIfPrimitive();
            }
            types.add(typeReference.getType());
        }
        return types;
    }

    @Check
    public void checkNoReturnsInCreateExtensions(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        ArrayList found = Lists.newArrayList();
        this.collectReturnExpressions((EObject)func.getCreateExtensionInfo().getCreateExpression(), found);
        for (XReturnExpression xReturnExpression : found) {
            this.error("Return is not allowed in creation expression", (EObject)xReturnExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
        }
    }

    @Check
    public void checkCreateFunctionIsNotTypeVoid(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        if (func.getReturnType() == null) {
            JvmOperation operation = this.associations.getDirectlyInferredOperation(func);
            if (operation != null && this.isPrimitiveVoid(operation.getReturnType())) {
                this.error("void is an invalid type for the create method " + func.getName(), func, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        } else if (this.isPrimitiveVoid(func.getReturnType())) {
            if (func.getReturnType() != null) {
                this.error("Create method " + func.getName() + " may not declare return type void.", (EObject)func.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            } else {
                this.error("The inherited return type void of " + func.getName() + " is invalid for create method.", (EObject)func.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        }
    }

    @Check
    public void checkCreateFunctionIsNotGeneric(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        if (!func.getTypeParameters().isEmpty()) {
            this.error("Create methods can not have type parameters.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, func.getModifiers().indexOf((Object)"static"), "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_static", new String[0]);
        }
    }

    @Check
    public void checkCreateFunctionIsNotStatic(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        if (func.isStatic()) {
            this.error("Create methods can not be static.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, func.getModifiers().indexOf((Object)"static"), "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_static", new String[0]);
        }
    }

    protected boolean isValueExpectedRecursive(XExpression expr) {
        EObject container = expr.eContainer();
        if (container instanceof RichString || container instanceof RichStringForLoop || container instanceof XtendField) {
            return true;
        }
        return super.isValueExpectedRecursive(expr);
    }

    protected void collectReturnExpressions(EObject expr, List<XReturnExpression> found) {
        if (expr instanceof XReturnExpression) {
            found.add((XReturnExpression)expr);
        } else if (expr instanceof XClosure) {
            return;
        }
        for (EObject child : expr.eContents()) {
            this.collectReturnExpressions(child, found);
        }
    }

    @Check
    public void checkClasses(XtendFile file) {
        LinkedHashSet names = Sets.newLinkedHashSet();
        for (XtendTypeDeclaration clazz : file.getXtendTypes()) {
            if (clazz.getName() == null || names.add(clazz.getName())) continue;
            this.error("The type " + clazz.getName() + " is already defined.", clazz, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type", new String[0]);
        }
    }

    public boolean doCheckValidMemberName(XtendMember member) {
        String name;
        EStructuralFeature nameAttribute = member.eClass().getEStructuralFeature("name");
        if (nameAttribute != null && (name = (String)member.eGet(nameAttribute)) != null && (name.equals("this") || name.equals("it"))) {
            this.error("'it' and 'this' are not allowed as member names", nameAttribute, "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name", new String[0]);
            return false;
        }
        return true;
    }

    @Check
    public void checkLocalUsageOfDeclaredFields(XtendField field) {
        if (this.doCheckValidMemberName(field) && !this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member")) {
            JvmField jvmField = this.associations.getJvmField(field);
            if (jvmField == null || jvmField.getVisibility() != JvmVisibility.PRIVATE || jvmField.eContainer() == null) {
                return;
            }
            if (this.isLocallyUsed((EObject)jvmField, this.getOutermostType(field))) {
                return;
            }
            String message = field.isExtension() ? (field.getName() == null && jvmField.getType() != null ? "The extension " + jvmField.getType().getIdentifier() + " is not used in " + this.getDeclaratorName((JvmFeature)jvmField) : "The extension " + this.getDeclaratorName((JvmFeature)jvmField) + "." + jvmField.getSimpleName() + " is not used") : "The value of the field " + this.getDeclaratorName((JvmFeature)jvmField) + "." + jvmField.getSimpleName() + " is not used";
            this.addIssueToState("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member", message, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME);
        }
    }

    private EObject getOutermostType(XtendMember member) {
        XtendTypeDeclaration result = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)member, XtendTypeDeclaration.class);
        if (result == null) {
            return member.eContainer();
        }
        while (!(result.eContainer() instanceof XtendFile)) {
            XtendTypeDeclaration next = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)result.eContainer(), XtendTypeDeclaration.class);
            if (next == null) {
                return result;
            }
            result = next;
        }
        return result;
    }

    protected String getDeclaratorName(JvmFeature feature) {
        JvmDeclaredType declarator = feature.getDeclaringType();
        if (declarator.isLocal()) {
            return "new " + ((JvmTypeReference)Iterables.getLast((Iterable)declarator.getSuperTypes())).getType().getSimpleName() + "(){}";
        }
        return declarator.getSimpleName();
    }

    @Check
    public void checkLocalUsageOfDeclaredXtendFunction(XtendFunction function) {
        if (this.doCheckValidMemberName(function) && !this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member")) {
            JvmOperation jvmOperation;
            JvmOperation jvmOperation2 = jvmOperation = function.isDispatch() ? this.associations.getDispatchOperation(function) : this.associations.getDirectlyInferredOperation(function);
            if (jvmOperation != null && jvmOperation.getVisibility() == JvmVisibility.PRIVATE && !this.isLocallyUsed((EObject)jvmOperation, this.getOutermostType(function))) {
                String message = "The method " + jvmOperation.getSimpleName() + this.uiStrings.parameters((JvmIdentifiableElement)jvmOperation) + " from the type " + this.getDeclaratorName((JvmFeature)jvmOperation) + " is never used locally.";
                this.addIssueToState("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member", message, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME);
            }
        }
    }

    @Check
    public void checkDeclaredExceptions(XtendConstructor constructor) {
        JvmConstructor jvmConstructor = this.associations.getInferredConstructor(constructor);
        if (jvmConstructor != null) {
            this.checkExceptions(constructor, (List<JvmTypeReference>)jvmConstructor.getExceptions(), XtendPackage.Literals.XTEND_EXECUTABLE__EXCEPTIONS);
        }
    }

    @Check
    public void checkTypeParameterForwardReferences(XtendClass xtendClass) {
        this.doCheckTypeParameterForwardReference((List)xtendClass.getTypeParameters());
    }

    @Check
    public void checkTypeParameterForwardReferences(XtendInterface xtendInterface) {
        this.doCheckTypeParameterForwardReference((List)xtendInterface.getTypeParameters());
    }

    @Check
    public void checkTypeParameterForwardReferences(XtendFunction xtendFunction) {
        this.doCheckTypeParameterForwardReference((List)xtendFunction.getTypeParameters());
    }

    @Check
    public void checkTypeParametersAreUnsupported(XtendConstructor constructor) {
        if (!constructor.getTypeParameters().isEmpty()) {
            this.error("Type parameters are not supported for constructors", (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__TYPE_PARAMETERS, -1, "org.eclipse.xtend.core.validation.IssueCodes.constructor_type_params_not_supported", new String[0]);
        }
    }

    @Check
    public void checkDeclaredExceptions(XtendFunction function) {
        JvmOperation jvmOperation = this.associations.getDirectlyInferredOperation(function);
        if (jvmOperation != null) {
            this.checkExceptions(function, (List<JvmTypeReference>)jvmOperation.getExceptions(), XtendPackage.Literals.XTEND_EXECUTABLE__EXCEPTIONS);
        }
    }

    private void checkExceptions(EObject context, List<JvmTypeReference> exceptions, EReference reference) {
        HashSet declaredExceptionNames = Sets.newHashSet();
        JvmTypeReference throwableType = this.getServices().getTypeReferences().getTypeForName(Throwable.class, (Notifier)context, new JvmTypeReference[0]);
        if (throwableType == null) {
            return;
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.getServices(), context);
        LightweightTypeReference throwableReference = owner.toLightweightTypeReference(throwableType);
        for (int i = 0; i < exceptions.size(); ++i) {
            JvmTypeReference exception = exceptions.get(i);
            if (exception.getType() == null || exception.getType().eIsProxy()) continue;
            if (!throwableReference.isAssignableFrom(exception.getType())) {
                this.error("No exception of type " + exception.getSimpleName() + " can be thrown; an exception type must be a subclass of Throwable", (EStructuralFeature)reference, i, "org.eclipse.xtend.core.validation.IssueCodes.exception_not_throwable", new String[0]);
            }
            if (declaredExceptionNames.add(exception.getQualifiedName())) continue;
            this.error("Exception " + exception.getSimpleName() + " is declared twice", (EStructuralFeature)reference, i, "org.eclipse.xtend.core.validation.IssueCodes.exception_declared_twice", new String[0]);
        }
    }

    @Check
    public void checkLeftHandSideIsVariable(XAssignment assignment) {
        String concreteSyntaxFeatureName = assignment.getConcreteSyntaxFeatureName();
        if (concreteSyntaxFeatureName.equals(IFeatureNames.THIS.toString())) {
            this.error("Left-hand side of an assignment must be an variable", (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, "left_hand_side_must_be_variable", new String[0]);
        }
    }

    @Check
    public void checkJavaKeywordConflict(XtendField member) {
        this.checkNoJavaKeyword(member, XtendPackage.Literals.XTEND_FIELD__NAME);
    }

    @Check
    public void checkJavaKeywordConflict(XtendFunction member) {
        if (member.eContainer() instanceof XtendAnnotationType && "do".equals(member.getName())) {
            return;
        }
        this.checkNoJavaKeyword(member, XtendPackage.Literals.XTEND_FUNCTION__NAME);
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check
    public void checkJavaKeywordConflict(XtendConstructor member) {
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check
    public void checkJavaKeywordConflict(XtendTypeDeclaration member) {
        this.checkNoJavaKeyword(member, XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME);
    }

    @Check
    public void checkJavaKeywordConflict(XtendClass member) {
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check
    public void checkJavaKeywordConflict(XtendInterface member) {
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    protected void checkNoJavaKeyword(EObject obj, EAttribute attribute) {
        Object name = obj.eGet((EStructuralFeature)attribute);
        if (name != null && this.javaUtils.isJavaKeyword(name.toString())) {
            this.error("'" + name + "' is not a valid identifier.", obj, (EStructuralFeature)attribute, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_identifier", new String[0]);
        }
    }

    @Check
    public void checkNonInitializedFieldsHaveAType(XtendField field) {
        if (field.getType() == null && field.getInitialValue() == null) {
            this.error("The field " + field.getName() + " needs an explicit type since there is no initialization expression to infer the type from.", field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
        }
    }

    @Check
    public void checkFieldsAreCalledSelf(XtendField field) {
        if ("self".equals(field.getName())) {
            this.addIssue("'self' is a discouraged name", field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged", new String[0]);
        }
    }

    @Check
    public void checkFinalFieldInitialization(XtendClass clazz) {
        JvmGenericType inferredType = this.associations.getInferredType(clazz);
        if (inferredType == null) {
            return;
        }
        super.checkFinalFieldInitialization(inferredType);
    }

    @Check
    public void checkFinalFieldInitialization(XtendInterface xtendInterface) {
        JvmGenericType inferredType = this.associations.getInferredType(xtendInterface);
        if (inferredType == null) {
            return;
        }
        super.checkFinalFieldInitialization(inferredType);
    }

    @Check
    public void checkJavaDocRefs(XtendMember member) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking")) {
            return;
        }
        List documentationNodes = ((IEObjectDocumentationProviderExtension)this.documentationProvider).getDocumentationNodes((EObject)member);
        for (INode node : documentationNodes) {
            for (ReplaceRegion region : this.javaDocTypeReferenceProvider.computeTypeRefRegions(node)) {
                Severity severity;
                IScope scope;
                IEObjectDescription candidate;
                String typeRefString = region.getText();
                if (typeRefString == null || typeRefString.length() <= 0 || (candidate = (scope = this.scopeProvider.getScope((EObject)member, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)).getSingleElement(this.qualifiedNameConverter.toQualifiedName(typeRefString))) != null || (severity = this.getIssueSeverities(this.getContext(), this.getCurrentObject()).getSeverity("org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking")) == null) continue;
                this.getChain().add(this.createDiagnostic(severity, "javaDoc: " + typeRefString + " cannot be resolved to a type", member, region.getOffset(), region.getLength(), "org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking", new String[0]));
            }
        }
    }

    protected void reportUninitializedField(JvmField field) {
        EObject element = this.associations.getPrimarySourceElement((EObject)field);
        if (element instanceof XtendField) {
            this.error("The blank final field " + field.getSimpleName() + " may not have been initialized.", element, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
        } else {
            this.error("The blank final derived field " + field.getSimpleName() + " may not have been initialized.", element, null, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
        }
    }

    protected void reportUninitializedField(JvmField field, JvmConstructor constructor) {
        EObject sourceElement = this.associations.getPrimarySourceElement((EObject)constructor);
        if (sourceElement != null) {
            if (this.associations.getXtendField(field) != null) {
                this.error("The blank final field " + field.getSimpleName() + " may not have been initialized.", sourceElement, null, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
            } else {
                this.error("The blank final derived field " + field.getSimpleName() + " may not have been initialized.", sourceElement, null, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
            }
        }
    }

    protected boolean hasAnnotation(Iterable<? extends XAnnotation> annotations, Class<?> annotationType) {
        for (XAnnotation xAnnotation : annotations) {
            if (xAnnotation.getAnnotationType() == null || !annotationType.getName().equals(xAnnotation.getAnnotationType().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    @Check
    protected void checkModifiers(XtendClass xtendClass) {
        EObject eContainer = xtendClass.eContainer();
        if (eContainer instanceof XtendFile) {
            this.classModifierValidator.checkModifiers(xtendClass, "class " + xtendClass.getName());
        } else {
            this.nestedClassModifierValidator.checkModifiers(xtendClass, "class " + xtendClass.getName());
            if (!xtendClass.isStatic() && eContainer instanceof XtendClass) {
                this.error("Nested classes must be static", (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_static_modifier", new String[0]);
            }
        }
    }

    @Check
    protected void checkModifiers(XtendInterface xtendInterface) {
        EObject eContainer = xtendInterface.eContainer();
        if (eContainer instanceof XtendFile) {
            this.interfaceModifierValidator.checkModifiers(xtendInterface, "interface " + xtendInterface.getName());
        } else {
            this.nestedInterfaceModifierValidator.checkModifiers(xtendInterface, "interface " + xtendInterface.getName());
        }
    }

    @Check
    protected void checkModifiers(XtendEnum xtendEnum) {
        EObject eContainer = xtendEnum.eContainer();
        if (eContainer instanceof XtendFile) {
            this.enumModifierValidator.checkModifiers(xtendEnum, "enum " + xtendEnum.getName());
        } else {
            this.nestedEnumModifierValidator.checkModifiers(xtendEnum, "enum " + xtendEnum.getName());
        }
    }

    @Check
    protected void checkModifiers(XtendAnnotationType annotation) {
        EObject eContainer = annotation.eContainer();
        if (eContainer instanceof XtendFile) {
            this.annotationTypeModifierValidator.checkModifiers(annotation, "annotation type " + annotation.getName());
        } else {
            this.nestedAnnotationTypeModifierValidator.checkModifiers(annotation, "annotation type " + annotation.getName());
        }
    }

    @Check
    protected void checkModifiers(XtendField field) {
        if (field.getDeclaringType() instanceof XtendClass) {
            if (field.isFinal() && field.isVolatile()) {
                this.error("The field " + field.getName() + " can be either final or volatile, not both.", (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
            }
            this.fieldModifierValidator.checkModifiers(field, "field " + field.getName());
        } else if (field.getDeclaringType() instanceof XtendInterface || field.getDeclaringType() instanceof XtendAnnotationType) {
            this.fieldInInterfaceModifierValidator.checkModifiers(field, "field " + field.getName());
        }
    }

    @Check
    protected void checkModifiers(XtendConstructor constructor) {
        if (!(constructor.getDeclaringType() instanceof XtendClass)) {
            this.error("Contructors are only permitted within classes", null, "org.eclipse.xtend.core.validation.IssueCodes.constructor_not_permitted", new String[0]);
        } else {
            String typeName = ((XtendTypeDeclaration)constructor.eContainer()).getName();
            this.constructorModifierValidator.checkModifiers(constructor, "type " + typeName);
        }
    }

    @Check
    protected void checkModifiers(XtendFunction method) {
        if (method.getDeclaringType() instanceof XtendClass) {
            this.methodModifierValidator.checkModifiers(method, "method " + method.getName());
            int abstractIndex = method.getModifiers().indexOf((Object)"abstract");
            if (method.getExpression() != null) {
                if (abstractIndex != -1) {
                    this.error("Method " + method.getName() + " with a body cannot be abstract", (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, abstractIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                } else if (method.isNative()) {
                    this.error("Native methods do not specify a body", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                }
            } else {
                int finalIndex = method.getModifiers().indexOf((Object)"final");
                if (finalIndex != -1) {
                    this.error("Abstract method " + method.getName() + " cannot be final", (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, finalIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                }
            }
        } else if (method.getDeclaringType() instanceof XtendInterface) {
            GeneratorConfig config = this.getGeneratorConfig(method);
            this.methodInInterfaceModifierValidator.checkModifiers(method, "method " + method.getName());
            int abstractIndex = method.getModifiers().indexOf((Object)"abstract");
            if (config.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8) && method.getExpression() != null && abstractIndex != -1) {
                this.error("Method " + method.getName() + " with a body cannot be abstract", (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, abstractIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
            }
        }
    }

    @Check
    protected void checkInferedApi(XtendFunction method) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.api_type_inference")) {
            return;
        }
        if (this.isApi(method) && method.getReturnType() == null && !method.isOverride()) {
            this.addIssue("API method needs explicit return type", method, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.api_type_inference", new String[0]);
        }
    }

    @Check
    protected void checkInferedApi(XtendField field) {
        if (this.isApi(field) && field.getType() == null && field.getInitialValue() != null) {
            this.addIssue("API field needs explicit type", field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtend.core.validation.IssueCodes.api_type_inference", new String[0]);
        }
    }

    protected boolean isApi(XtendMember member) {
        if (!this.isApi(member.getDeclaringType())) {
            return false;
        }
        return member.getVisibility() == JvmVisibility.PUBLIC || member.getVisibility() == JvmVisibility.PROTECTED && !member.getDeclaringType().isFinal();
    }

    protected boolean isApi(XtendTypeDeclaration type) {
        boolean api;
        if (type.isAnonymous()) {
            return false;
        }
        boolean bl = api = type.getVisibility() == JvmVisibility.PUBLIC;
        if (type.getDeclaringType() != null) {
            api = api || type.getVisibility() == JvmVisibility.PROTECTED && !type.getDeclaringType().isFinal();
            api = api && this.isApi(type.getDeclaringType());
        }
        return api;
    }

    @Check
    protected void checkImplicitReturn(final XtendFunction method) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.implicit_return")) {
            return;
        }
        JvmOperation jvmOperation = this.associations.getDirectlyInferredOperation(method);
        IResolvedTypes types = this.batchTypeResolver.resolveTypes((EObject)method);
        if (jvmOperation != null && types.getActualType((JvmIdentifiableElement)jvmOperation).isPrimitiveVoid()) {
            return;
        }
        this.implicitReturnFinder.findImplicitReturns(method.getExpression(), new ImplicitReturnFinder.Acceptor(){

            public void accept(XExpression implicitReturn) {
                if (method.getExpression() == implicitReturn) {
                    return;
                }
                XtendValidator.this.addIssue("Implicit return", (EObject)implicitReturn, "org.eclipse.xtend.core.validation.IssueCodes.implicit_return");
            }
        });
    }

    protected boolean isLocalClassSemantics(EObject object) {
        return super.isLocalClassSemantics(object) || object instanceof XtendMember && !(object instanceof AnonymousClass);
    }
}

