/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.compiler.XtendGenerator;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtend.core.richstring.DefaultIndentationHandler;
import org.eclipse.xtend.core.richstring.IRichStringIndentationHandler;
import org.eclipse.xtend.core.richstring.RichStringProcessor;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.core.xtend.XtendFormalParameter;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.core.xtend.XtendVariableDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XtendCompiler
extends XbaseCompiler {
    @Inject
    private RichStringProcessor richStringProcessor;
    @Inject
    private Provider<DefaultIndentationHandler> indentationHandler;
    @Inject
    private XtendGenerator jvmModelGenerator;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private IXtendJvmAssociations associations;

    protected String getFavoriteVariableName(EObject ex) {
        if (ex instanceof RichStringForLoop) {
            return "hasAnyElements";
        }
        return super.getFavoriteVariableName(ex);
    }

    protected XExpression normalizeBlockExpression(XExpression expr) {
        if (expr instanceof RichString) {
            return expr;
        }
        return super.normalizeBlockExpression(expr);
    }

    public void doInternalToJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        this.prependLocalTypesIfFieldInitializer(obj, appendable, isReferenced);
        if (obj instanceof AnonymousClass) {
            this._toJavaStatement((AnonymousClass)obj, appendable, isReferenced);
        } else if (obj instanceof RichString) {
            this._toJavaStatement((RichString)obj, appendable, isReferenced);
        } else {
            super.doInternalToJavaStatement(obj, appendable, isReferenced);
        }
    }

    private void prependLocalTypesIfFieldInitializer(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        JvmIdentifiableElement container = this.getLogicalContainerProvider().getLogicalContainer(obj);
        if (container instanceof JvmField) {
            this.jvmModelGenerator.compileLocalTypeStubs((JvmFeature)container, appendable, null);
        }
    }

    public void _toJavaStatement(RichString richString, ITreeAppendable b, boolean isReferenced) {
        LightweightTypeReference actualType = this.getLightweightType((XExpression)richString);
        b = b.trace((EObject)richString);
        if (actualType.isType(StringConcatenationClient.class)) {
            String resultVariableName = b.declareSyntheticVariable((Object)richString, "_client");
            b.newLine();
            b.append(actualType);
            b.append((CharSequence)" ");
            b.append((CharSequence)resultVariableName);
            b.append((CharSequence)" = new ");
            b.append(actualType);
            b.append((CharSequence)"() {");
            b.openScope();
            this.reassignThisInClosure(b, actualType.getType());
            b.increaseIndentation().newLine();
            b.append((CharSequence)"@");
            b.append(Override.class);
            b.newLine().append((CharSequence)"protected void appendTo(");
            b.append(StringConcatenationClient.TargetStringConcatenation.class);
            String variableName = b.declareSyntheticVariable((Object)richString, "_builder");
            b.append((CharSequence)" ").append((CharSequence)variableName).append((CharSequence)") {");
            b.increaseIndentation();
            RichStringPrepareCompiler compiler = new RichStringPrepareCompiler(b, variableName, richString);
            this.richStringProcessor.process(richString, compiler, (IRichStringIndentationHandler)this.indentationHandler.get());
            b.closeScope();
            b.decreaseIndentation().newLine().append((CharSequence)"}").decreaseIndentation().newLine().append((CharSequence)"};");
        } else {
            String variableName = b.declareSyntheticVariable((Object)richString, "_builder");
            b.newLine();
            b.append(StringConcatenation.class);
            b.append((CharSequence)" ");
            b.append((CharSequence)variableName);
            b.append((CharSequence)" = new ");
            b.append(StringConcatenation.class);
            b.append((CharSequence)"();");
            RichStringPrepareCompiler compiler = new RichStringPrepareCompiler(b, variableName, richString);
            this.richStringProcessor.process(richString, compiler, (IRichStringIndentationHandler)this.indentationHandler.get());
        }
    }

    public void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        if (obj instanceof AnonymousClass) {
            this._toJavaExpression((AnonymousClass)obj, appendable);
        } else if (obj instanceof RichString) {
            this._toJavaExpression((RichString)obj, appendable);
        } else {
            super.internalToConvertedExpression(obj, appendable);
        }
    }

    protected void _toJavaExpression(AnonymousClass anonymousClass, ITreeAppendable b) {
        String varName = this.getReferenceName(anonymousClass, b);
        if (varName != null) {
            b.trace((EObject)anonymousClass, false).append((CharSequence)varName);
        } else {
            XConstructorCall constructorCall = anonymousClass.getConstructorCall();
            this.constructorCallToJavaExpression(constructorCall, b);
            JvmDeclaredType declaringType = constructorCall.getConstructor().getDeclaringType();
            this.compileAnonymousClassBody(anonymousClass, declaringType, b);
        }
    }

    protected void compileAnonymousClassBody(AnonymousClass anonymousClass, JvmDeclaredType type, ITreeAppendable b) {
        ITreeAppendable appendable = b.trace((EObject)anonymousClass, true);
        appendable.append((CharSequence)" ");
        appendable.openScope();
        GeneratorConfig config = this.generatorConfigProvider.get((EObject)anonymousClass);
        this.jvmModelGenerator.assignThisAndSuper(appendable, type, config);
        this.jvmModelGenerator.generateMembersInBody(type, appendable, config);
        appendable.closeScope();
    }

    public void _toJavaExpression(RichString richString, ITreeAppendable b) {
        b.append((CharSequence)this.getVarName(richString, b));
        if (this.getLightweightType((XExpression)richString).isType(String.class)) {
            b.append((CharSequence)".toString()");
        }
    }

    protected void appendCatchClauseParameter(XCatchClause catchClause, JvmTypeReference parameterType, String parameterName, ITreeAppendable appendable) {
        this.appendExtensionAnnotation(catchClause.getDeclaredParam(), (EObject)catchClause, appendable, false);
        super.appendCatchClauseParameter(catchClause, parameterType, parameterName, appendable);
    }

    protected void appendExtensionAnnotation(JvmFormalParameter parameter, EObject context, ITreeAppendable appendable, boolean newLine) {
        XtendFormalParameter castedParameter;
        if (parameter instanceof XtendFormalParameter && (castedParameter = (XtendFormalParameter)parameter).isExtension()) {
            this.appendExtensionAnnotation(context, appendable, newLine);
        }
    }

    protected void appendExtensionAnnotation(EObject context, ITreeAppendable appendable, boolean newLine) {
        JvmType extension = this.findKnownTopLevelType(Extension.class, (Notifier)context);
        if (extension != null) {
            appendable.append((CharSequence)"@");
            appendable.append(extension);
            if (!newLine) {
                appendable.append((CharSequence)" ");
            } else {
                appendable.newLine();
            }
        }
    }

    protected LightweightTypeReference appendVariableTypeAndName(XVariableDeclaration varDeclaration, ITreeAppendable appendable) {
        if (varDeclaration instanceof XtendVariableDeclaration && ((XtendVariableDeclaration)varDeclaration).isExtension()) {
            this.appendExtensionAnnotation((EObject)varDeclaration, appendable, true);
        }
        return super.appendVariableTypeAndName(varDeclaration, appendable);
    }

    protected void appendForLoopParameter(XForLoopExpression expr, ITreeAppendable appendable) {
        this.appendExtensionAnnotation(expr.getDeclaredParam(), (EObject)expr, appendable, false);
        super.appendForLoopParameter(expr, appendable);
    }

    protected void appendClosureParameter(JvmFormalParameter closureParam, LightweightTypeReference parameterType, ITreeAppendable appendable) {
        this.appendExtensionAnnotation(closureParam, (EObject)closureParam, appendable, false);
        super.appendClosureParameter(closureParam, parameterType, appendable);
    }

    protected boolean canUseArrayInitializer(XListLiteral literal, ITreeAppendable appendable) {
        EStructuralFeature feature = literal.eContainingFeature();
        if (feature == XtendPackage.Literals.XTEND_FIELD__INITIAL_VALUE) {
            return this.canUseArrayInitializerImpl(literal, appendable);
        }
        return super.canUseArrayInitializer(literal, appendable);
    }

    public void _toJavaExpression(XStringLiteral expr, ITreeAppendable b) {
        this.toJavaExpression(expr, b, false);
    }

    public void _toJavaStatement(XStringLiteral expr, ITreeAppendable b, boolean isReferenced) {
        this.toJavaStatement(expr, b, isReferenced, false);
    }

    protected void _toJavaStatement(AnonymousClass anonymousClass, ITreeAppendable b, boolean isReferenced) {
        this._toJavaStatement(anonymousClass.getConstructorCall(), b, isReferenced);
    }

    protected void _toJavaStatement(final XConstructorCall expr, ITreeAppendable b, boolean isReferenced) {
        for (XExpression arg : expr.getArguments()) {
            this.prepareExpression(arg, b);
        }
        if (!isReferenced) {
            b.newLine();
            this.constructorCallToJavaExpression(expr, b);
            if (expr.eContainer() instanceof AnonymousClass) {
                JvmConstructor constructor = expr.getConstructor();
                JvmDeclaredType declaringType = constructor.getDeclaringType();
                this.compileAnonymousClassBody((AnonymousClass)expr.eContainer(), declaringType, b);
            }
            b.append((CharSequence)";");
        } else if (this.isVariableDeclarationRequired((XExpression)expr, b)) {
            Later later = new Later(){

                public void exec(ITreeAppendable appendable) {
                    XtendCompiler.this.constructorCallToJavaExpression(expr, appendable);
                    if (expr.eContainer() instanceof AnonymousClass) {
                        JvmConstructor constructor = expr.getConstructor();
                        JvmDeclaredType declaringType = constructor.getDeclaringType();
                        XtendCompiler.this.compileAnonymousClassBody((AnonymousClass)expr.eContainer(), declaringType, appendable);
                    }
                }
            };
            this.declareFreshLocalVariable((XExpression)expr, b, later);
        }
    }

    protected boolean internalCanCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        if (expression instanceof AnonymousClass) {
            AnonymousClass anonymousClass = (AnonymousClass)expression;
            JvmGenericType inferredLocalClass = this.associations.getInferredType(anonymousClass);
            return inferredLocalClass.isAnonymous();
        }
        return super.internalCanCompileToJavaExpression(expression, appendable);
    }

    protected boolean isVariableDeclarationRequired(XExpression expr, ITreeAppendable b) {
        JvmConstructor constructor;
        JvmDeclaredType type;
        AnonymousClass anonymousClass;
        EObject container;
        boolean result = super.isVariableDeclarationRequired(expr, b);
        if (result && expr instanceof XConstructorCall && (container = expr.eContainer()) instanceof AnonymousClass && (result = this.isVariableDeclarationRequired(anonymousClass = (AnonymousClass)container, b)) && ((JvmGenericType)(type = (constructor = anonymousClass.getConstructorCall().getConstructor()).getDeclaringType())).isAnonymous()) {
            return false;
        }
        return result;
    }

    protected String getReferenceName(XExpression expr, ITreeAppendable b) {
        if (expr instanceof AnonymousClass) {
            return this.getReferenceName((XExpression)((AnonymousClass)expr).getConstructorCall(), b);
        }
        return super.getReferenceName(expr, b);
    }

    protected void doReassignThisInClosure(ITreeAppendable b, JvmType prevType) {
        if (prevType instanceof JvmDeclaredType && ((JvmDeclaredType)prevType).isLocal()) {
            String superVariable;
            Object superElement;
            if (b.hasName((Object)Pair.of((Object)"this", (Object)prevType))) {
                b.declareVariable((Object)prevType, b.getName((Object)Pair.of((Object)"this", (Object)prevType)));
            } else {
                b.declareSyntheticVariable((Object)prevType, "");
            }
            if (b.hasObject("super") && (superElement = b.getObject("super")) instanceof JvmType && "super".equals(superVariable = b.getName(superElement))) {
                b.declareSyntheticVariable(superElement, prevType.getSimpleName() + ".super");
            }
        } else {
            super.doReassignThisInClosure(b, prevType);
        }
    }

    protected boolean needSyntheticSelfVariable(XClosure closure, LightweightTypeReference typeRef) {
        JvmType jvmType = typeRef.getType();
        TreeIterator closureIterator = closure.eAllContents();
        while (closureIterator.hasNext()) {
            EObject obj1 = (EObject)closureIterator.next();
            if (obj1 instanceof XClosure) {
                closureIterator.prune();
                continue;
            }
            if (!(obj1 instanceof XtendTypeDeclaration)) continue;
            TreeIterator typeIterator = obj1.eAllContents();
            while (typeIterator.hasNext()) {
                EObject obj2 = (EObject)typeIterator.next();
                if (obj2 instanceof XClosure) {
                    typeIterator.prune();
                    continue;
                }
                if (!(obj2 instanceof XFeatureCall) || !this.isReferenceToSelf((XFeatureCall)obj2, jvmType)) continue;
                return true;
            }
            closureIterator.prune();
        }
        return false;
    }

    public class RichStringPrepareCompiler
    extends AbstractRichStringPartAcceptor.ForLoopOnce {
        private final LinkedList<ITreeAppendable> appendableStack;
        private final LinkedList<RichStringIf> ifStack = Lists.newLinkedList();
        private final LinkedList<RichStringForLoop> forStack = Lists.newLinkedList();
        private final String variableName;
        private ITreeAppendable appendable;
        private ITreeAppendable currentAppendable;

        public RichStringPrepareCompiler(ITreeAppendable appendable, String variableName, RichString richString) {
            this.appendableStack = Lists.newLinkedList();
            this.appendable = appendable;
            this.variableName = variableName;
            EList expressions = richString.getExpressions();
            if (!expressions.isEmpty() && expressions.get(0) instanceof RichStringLiteral) {
                this.setCurrentAppendable((RichStringLiteral)expressions.get(0));
            }
        }

        @Override
        public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
            this.setCurrentAppendable(origin);
            this.currentAppendable.newLine();
            this.currentAppendable.append((CharSequence)this.variableName);
            if (!controlStructureSeen) {
                this.currentAppendable.append((CharSequence)".newLine();");
            } else {
                this.currentAppendable.append((CharSequence)".newLineIfNotEmpty();");
            }
        }

        protected void setCurrentAppendable(RichStringLiteral origin) {
            if (this.currentAppendable == null && origin != null) {
                ITextRegionWithLineInformation region = (ITextRegionWithLineInformation)XtendCompiler.this.getLocationInFileProvider().getSignificantTextRegion((EObject)origin, (EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE, 0);
                this.currentAppendable = this.appendable.trace((ILocationData)new LocationData(region, null), true);
            }
        }

        @Override
        public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
            this.setCurrentAppendable(origin);
        }

        @Override
        public void acceptSemanticText(CharSequence text, RichStringLiteral origin) {
            this.setCurrentAppendable(origin);
            if (text.length() == 0) {
                return;
            }
            this.currentAppendable.newLine();
            this.currentAppendable.append((CharSequence)this.variableName);
            this.currentAppendable.append((CharSequence)".append(\"");
            this.currentAppendable.append((CharSequence)Strings.convertToJavaString((String)text.toString(), (boolean)false));
            this.currentAppendable.append((CharSequence)"\");");
        }

        @Override
        public void acceptIfCondition(XExpression condition) {
            this.currentAppendable = null;
            this.ifStack.add((RichStringIf)condition.eContainer());
            this.appendable.newLine();
            this.pushAppendable(condition.eContainer());
            this.appendable.append((CharSequence)"{").increaseIndentation();
            this.writeIf(condition);
        }

        protected void pushAppendable(EObject traceInfo) {
            this.appendableStack.add(this.appendable);
            this.appendable = this.appendable.trace(traceInfo);
        }

        protected void popAppendable() {
            this.appendable = this.appendableStack.removeLast();
        }

        @Override
        public void acceptElseIfCondition(XExpression condition) {
            this.currentAppendable = null;
            this.writeElse();
            this.writeIf(condition);
        }

        protected void writeIf(XExpression condition) {
            ITreeAppendable debugAppendable = this.appendable.trace(condition.eContainer(), true);
            XtendCompiler.this.internalToJavaStatement(condition, debugAppendable, true);
            debugAppendable.newLine();
            debugAppendable.append((CharSequence)"if (");
            XtendCompiler.this.internalToJavaExpression(condition, debugAppendable);
            debugAppendable.append((CharSequence)") {").increaseIndentation();
        }

        protected void writeElse() {
            this.currentAppendable = null;
            this.appendable.decreaseIndentation();
            this.appendable.newLine();
            this.appendable.append((CharSequence)"} else {");
            this.appendable.increaseIndentation();
        }

        @Override
        public void acceptElse() {
            this.currentAppendable = null;
            this.writeElse();
        }

        @Override
        public void acceptEndIf() {
            this.currentAppendable = null;
            RichStringIf richStringIf = this.ifStack.removeLast();
            for (int i = 0; i < richStringIf.getElseIfs().size() + 2; ++i) {
                this.appendable.decreaseIndentation();
                this.appendable.newLine();
                this.appendable.append((CharSequence)"}");
            }
            this.popAppendable();
        }

        @Override
        public void acceptForLoop(JvmFormalParameter parameter, XExpression expression) {
            this.currentAppendable = null;
            super.acceptForLoop(parameter, expression);
            if (expression == null) {
                throw new IllegalArgumentException("expression may not be null");
            }
            RichStringForLoop forLoop = (RichStringForLoop)expression.eContainer();
            this.forStack.add(forLoop);
            this.appendable.newLine();
            this.pushAppendable((EObject)forLoop);
            this.appendable.append((CharSequence)"{").increaseIndentation();
            ITreeAppendable debugAppendable = this.appendable.trace((EObject)forLoop, true);
            XtendCompiler.this.internalToJavaStatement(expression, debugAppendable, true);
            String variableName = null;
            if (forLoop.getBefore() != null || forLoop.getSeparator() != null || forLoop.getAfter() != null) {
                variableName = debugAppendable.declareSyntheticVariable((Object)forLoop, "_hasElements");
                debugAppendable.newLine();
                debugAppendable.append((CharSequence)"boolean ");
                debugAppendable.append((CharSequence)variableName);
                debugAppendable.append((CharSequence)" = false;");
            }
            debugAppendable.newLine();
            debugAppendable.append((CharSequence)"for(final ");
            LightweightTypeReference paramType = XtendCompiler.this.getLightweightType((JvmIdentifiableElement)parameter);
            if (paramType != null) {
                debugAppendable.append(paramType);
            } else {
                debugAppendable.append((CharSequence)"Object");
            }
            debugAppendable.append((CharSequence)" ");
            String loopParam = debugAppendable.declareVariable((Object)parameter, parameter.getName());
            debugAppendable.append((CharSequence)loopParam);
            debugAppendable.append((CharSequence)" : ");
            XtendCompiler.this.internalToJavaExpression(expression, debugAppendable);
            debugAppendable.append((CharSequence)") {").increaseIndentation();
        }

        @Override
        public boolean forLoopHasNext(XExpression before, XExpression separator, CharSequence indentation) {
            this.currentAppendable = null;
            if (!super.forLoopHasNext(before, separator, indentation)) {
                return false;
            }
            RichStringForLoop forLoop = this.forStack.getLast();
            if (this.appendable.hasName((Object)forLoop)) {
                String varName = XtendCompiler.this.getVarName(forLoop, this.appendable);
                this.appendable.newLine();
                this.appendable.append((CharSequence)"if (!");
                this.appendable.append((CharSequence)varName);
                this.appendable.append((CharSequence)") {");
                this.appendable.increaseIndentation();
                this.appendable.newLine();
                this.appendable.append((CharSequence)varName);
                this.appendable.append((CharSequence)" = true;");
                if (before != null) {
                    this.writeExpression(before, indentation, false);
                }
                this.appendable.decreaseIndentation();
                this.appendable.newLine();
                this.appendable.append((CharSequence)"}");
                if (separator != null) {
                    this.appendable.append((CharSequence)" else {");
                    this.appendable.increaseIndentation();
                    this.writeExpression(separator, indentation, true);
                    this.appendable.decreaseIndentation();
                    this.appendable.newLine();
                    this.appendable.append((CharSequence)"}");
                }
            }
            return true;
        }

        @Override
        public void acceptEndFor(XExpression after, CharSequence indentation) {
            this.currentAppendable = null;
            super.acceptEndFor(after, indentation);
            this.appendable.decreaseIndentation();
            this.appendable.newLine();
            this.appendable.append((CharSequence)"}");
            RichStringForLoop forLoop = this.forStack.removeLast();
            if (after != null) {
                String varName = XtendCompiler.this.getVarName(forLoop, this.appendable);
                this.appendable.newLine();
                this.appendable.append((CharSequence)"if (");
                this.appendable.append((CharSequence)varName);
                this.appendable.append((CharSequence)") {");
                this.appendable.increaseIndentation();
                this.writeExpression(after, indentation, false);
                this.appendable.decreaseIndentation();
                this.appendable.newLine();
                this.appendable.append((CharSequence)"}");
            }
            this.appendable.decreaseIndentation();
            this.appendable.newLine();
            this.appendable.append((CharSequence)"}");
            this.popAppendable();
        }

        @Override
        public void acceptExpression(XExpression expression, CharSequence indentation) {
            this.currentAppendable = null;
            if (!this.isEmptyEmission(expression)) {
                this.writeExpression(expression, indentation, false);
            }
        }

        private boolean isEmptyEmission(XExpression expression) {
            return expression instanceof XStringLiteral && StringExtensions.isNullOrEmpty((String)((XStringLiteral)expression).getValue()) || expression instanceof XNullLiteral;
        }

        protected void writeExpression(XExpression expression, CharSequence indentation, boolean immediate) {
            boolean referenced = !XtendCompiler.this.isPrimitiveVoid(expression);
            XtendCompiler.this.internalToJavaStatement(expression, this.appendable, referenced);
            if (referenced) {
                ITreeAppendable tracingAppendable = this.appendable.trace((EObject)expression, true);
                tracingAppendable.newLine();
                tracingAppendable.append((CharSequence)this.variableName);
                if (immediate) {
                    tracingAppendable.append((CharSequence)".appendImmediate(");
                } else {
                    tracingAppendable.append((CharSequence)".append(");
                }
                XtendCompiler.this.internalToJavaExpression(expression, tracingAppendable);
                String javaIndentation = Strings.convertToJavaString((String)indentation.toString(), (boolean)false);
                if (immediate || !javaIndentation.isEmpty()) {
                    tracingAppendable.append((CharSequence)", \"");
                    tracingAppendable.append((CharSequence)javaIndentation);
                    tracingAppendable.append((CharSequence)"\"");
                }
                tracingAppendable.append((CharSequence)");");
            }
        }
    }
}

