/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;

public class ModifierValidator {
    private static final Set<String> visibilityModifers = Sets.newHashSet((Object[])new String[]{"public", "protected", "package", "private"});
    private final Set<String> allowedModifiers;
    private final AbstractDeclarativeValidator validator;
    private final String allowedModifiersAsString;

    public ModifierValidator(List<String> allowedModifiers, AbstractDeclarativeValidator validator) {
        this.allowedModifiers = Sets.newHashSet(allowedModifiers);
        this.validator = validator;
        StringBuffer buffer = new StringBuffer(allowedModifiers.get(0));
        for (int i = 1; i < allowedModifiers.size() - 1; ++i) {
            buffer.append(", ").append(allowedModifiers.get(i));
        }
        if (allowedModifiers.size() > 1) {
            buffer.append(" & ").append(allowedModifiers.get(allowedModifiers.size() - 1));
        }
        this.allowedModifiersAsString = buffer.toString();
    }

    @Check
    protected void checkModifiers(XtendMember member, String memberName) {
        HashSet seenModifiers = Sets.newHashSet();
        boolean visibilitySeen = false;
        boolean abstractSeen = false;
        boolean staticSeen = false;
        boolean finalSeen = false;
        boolean varSeen = false;
        for (int i = 0; i < member.getModifiers().size(); ++i) {
            String modifier = (String)member.getModifiers().get(i);
            if (!this.allowedModifiers.contains(modifier)) {
                this.error("Illegal modifier for the " + memberName + "; only " + this.allowedModifiersAsString + " are permitted", member, i);
            }
            if (seenModifiers.contains(modifier)) {
                this.error("Duplicate modifier for the " + memberName, member, i);
            } else {
                seenModifiers.add(modifier);
                if (visibilityModifers.contains(modifier)) {
                    if (visibilitySeen) {
                        this.error("The " + memberName + " can only set one of public / package / protected / private", member, i);
                    }
                    visibilitySeen = true;
                }
            }
            if (Strings.equal((String)modifier, (String)"abstract")) {
                if (finalSeen) {
                    this.error("The " + memberName + " can either be abstract or final, not both", member, i);
                }
                if (staticSeen && !(member instanceof XtendTypeDeclaration)) {
                    this.error("The " + memberName + " can either be abstract or static, not both", member, i);
                }
                abstractSeen = true;
                continue;
            }
            if (Strings.equal((String)modifier, (String)"static")) {
                if (abstractSeen && !(member instanceof XtendTypeDeclaration)) {
                    this.error("The " + memberName + " can either be abstract or static, not both", member, i);
                }
                staticSeen = true;
                continue;
            }
            if (Strings.equal((String)modifier, (String)"final") || Strings.equal((String)modifier, (String)"val")) {
                if (abstractSeen) {
                    this.error("The " + memberName + " can either be abstract or final, not both", member, i);
                }
                if (varSeen) {
                    this.error("The " + memberName + " can either be var or val / final, not both", member, i);
                }
                finalSeen = true;
                continue;
            }
            if (!Strings.equal((String)modifier, (String)"var")) continue;
            if (finalSeen) {
                this.error("The " + memberName + " can either be var or val / final, not both", member, i);
            }
            varSeen = true;
        }
    }

    protected void error(String message, EObject source, int index) {
        this.validator.acceptError(message, source, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, index, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
    }
}

