/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.conversion;

import org.antlr.runtime.TokenSource;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;

public class JavaIDValueConverter
extends IDValueConverter {
    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            if (string.charAt(0) == '^') {
                string = string.substring(1);
            }
            String result = JavaIDValueConverter.convertFromJavaIdentifier(string, node);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    protected void assertValidValue(String value) {
        super.assertValidValue(value);
        if (!JavaIDValueConverter.isValidIdentifierStart(value.charAt(0))) {
            throw new ValueConverterException(value + " is not a valid identifier.", null, null);
        }
        int length = value.length();
        for (int i = 1; i < length; ++i) {
            if (JavaIDValueConverter.isValidIdentifierPart(value.charAt(i))) continue;
            throw new ValueConverterException(value + " is not a valid identifier.", null, null);
        }
    }

    protected void assertTokens(String value, String result) {
    }

    protected TokenSource getTokenSource(String escapedValue) {
        throw new UnsupportedOperationException();
    }

    public static boolean isValidIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isValidIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static String convertFromJavaIdentifier(String identifier, INode node) {
        int idx = identifier.indexOf(92);
        if (idx < 0) {
            return identifier;
        }
        return JavaIDValueConverter.doConvertFromJavaString(identifier, idx, node);
    }

    private static String doConvertFromJavaString(String identifier, int firstEscapeSequence, INode node) {
        char[] convtBuf;
        int off = firstEscapeSequence;
        int len = identifier.length();
        char[] out = convtBuf = new char[len];
        identifier.getChars(0, firstEscapeSequence, out, 0);
        int outLen = firstEscapeSequence;
        int end = len;
        boolean error = false;
        boolean badChar = false;
        block8: while (off < end) {
            char aChar;
            if ((aChar = identifier.charAt(off++)) == '\\') {
                if (off < end) {
                    aChar = identifier.charAt(off++);
                    switch (aChar) {
                        case 'u': {
                            int value = 0;
                            if (off + 4 > end || !JavaIDValueConverter.isHexSequence(identifier, off, 4)) {
                                error = true;
                                out[outLen++] = aChar;
                                continue block8;
                            }
                            block9: for (int i = 0; i < 4; ++i) {
                                aChar = identifier.charAt(off++);
                                switch (aChar) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        value = (value << 4) + aChar - 48;
                                        continue block9;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        value = (value << 4) + 10 + aChar - 97;
                                        continue block9;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        value = (value << 4) + 10 + aChar - 65;
                                        continue block9;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                }
                            }
                            if (JavaIDValueConverter.setChar(outLen, out, (char)value)) {
                                ++outLen;
                                continue block8;
                            }
                            badChar = true;
                            continue block8;
                        }
                    }
                    if (JavaIDValueConverter.setChar(outLen, out, aChar)) {
                        ++outLen;
                        continue;
                    }
                    badChar = true;
                    continue;
                }
                badChar = true;
                continue;
            }
            if (JavaIDValueConverter.setChar(outLen, out, aChar)) {
                ++outLen;
                continue;
            }
            badChar = true;
        }
        String result = new String(out, 0, outLen);
        if (error) {
            throw new ValueConverterWithValueException("Illegal escape sequence in identifier '" + identifier + "'", node, (Object)result, null);
        }
        if (badChar) {
            if (result.length() != 0) {
                throw new ValueConverterWithValueException("Illegal character in identifier '" + result + "' (" + identifier + ")", node, (Object)result, null);
            }
            throw new ValueConverterWithValueException("Illegal character in identifier '" + identifier + "'", node, null, null);
        }
        return result;
    }

    private static boolean setChar(int outLen, char[] out, char c) {
        if (outLen == 0 ? !JavaIDValueConverter.isValidIdentifierStart(c) : !JavaIDValueConverter.isValidIdentifierPart(c)) {
            return false;
        }
        out[outLen] = c;
        return true;
    }

    private static boolean isHexSequence(String in, int off, int chars) {
        block3: for (int i = off; i < in.length() && i < off + chars; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

