/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.macro.FilteringClassLoader;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.internal.AlternateJdkLoader;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Singleton
public class ProcessorInstanceForJvmTypeProvider {
    private static final Logger logger = Logger.getLogger(ProcessorInstanceForJvmTypeProvider.class);

    public Object getProcessorInstance(JvmType type) {
        try {
            ClassLoader _classLoader = this.getClassLoader((EObject)type);
            Class<?> _loadClass = null;
            if (_classLoader != null) {
                _loadClass = _classLoader.loadClass(type.getIdentifier());
            }
            Class<?> loadClass = _loadClass;
            Object _newInstance = null;
            if (loadClass != null) {
                _newInstance = loadClass.newInstance();
            }
            return _newInstance;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _identifier = type.getIdentifier();
                String _plus = "Problem during instantiation of " + _identifier;
                String _plus_1 = _plus + " : ";
                String _message = e.getMessage();
                String _plus_2 = _plus_1 + _message;
                throw new IllegalStateException(_plus_2, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected ClassLoader getClassLoader(EObject ctx) {
        ResourceSet resourceSet = ctx.eResource().getResourceSet();
        ProcessorClassloaderAdapter adapter = (ProcessorClassloaderAdapter)((Object)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resourceSet.eAdapters(), ProcessorClassloaderAdapter.class)));
        if (adapter != null) {
            return adapter.getClassLoader();
        }
        boolean _matched = false;
        if (resourceSet instanceof XtextResourceSet) {
            _matched = true;
            Object classLoaderCtx = ((XtextResourceSet)resourceSet).getClasspathURIContext();
            ClassLoader _switchResult_1 = null;
            boolean _matched_1 = false;
            if (classLoaderCtx instanceof ClassLoader) {
                _matched_1 = true;
                _switchResult_1 = (ClassLoader)classLoaderCtx;
            }
            if (!_matched_1 && classLoaderCtx instanceof Class) {
                _matched_1 = true;
                _switchResult_1 = ((Class)classLoaderCtx).getClassLoader();
            }
            ClassLoader jvmTypeLoader = _switchResult_1;
            ClassLoader _xifexpression = null;
            if (jvmTypeLoader instanceof URLClassLoader) {
                URLClassLoader _xblockexpression = null;
                ArrayList urls = CollectionLiterals.newArrayList();
                URL[] _uRLs = ((URLClassLoader)jvmTypeLoader).getURLs();
                Iterables.addAll((Collection)urls, (Iterable)((Iterable)Conversions.doWrapArray((Object)_uRLs)));
                ClassLoader bootClassloader = ((URLClassLoader)jvmTypeLoader).getParent();
                if (bootClassloader instanceof AlternateJdkLoader) {
                    URL[] _uRLs_1 = ((AlternateJdkLoader)bootClassloader).getURLs();
                    Iterables.addAll((Collection)urls, (Iterable)((Iterable)Conversions.doWrapArray((Object)_uRLs_1)));
                }
                ClassLoader _classLoader = TransformationContext.class.getClassLoader();
                FilteringClassLoader filtered = new FilteringClassLoader(_classLoader, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.xtext.xbase.lib", "org.eclipse.xtend.lib", "org.eclipse.xtend2.lib", "com.google.common"})));
                _xblockexpression = new URLClassLoader((URL[])Conversions.unwrapArray((Object)urls, URL.class), (ClassLoader)filtered);
                _xifexpression = _xblockexpression;
            } else {
                _xifexpression = jvmTypeLoader;
            }
            ClassLoader processorClassLoader = _xifexpression;
            if (processorClassLoader != null) {
                EList _eAdapters = ((XtextResourceSet)resourceSet).eAdapters();
                ProcessorClassloaderAdapter _processorClassloaderAdapter = new ProcessorClassloaderAdapter(processorClassLoader);
                _eAdapters.add((Object)_processorClassloaderAdapter);
                return processorClassLoader;
            }
        }
        logger.info((Object)"No class loader configured. Trying with this class classloader.");
        return this.getClass().getClassLoader();
    }

    @Accessors
    public static class ProcessorClassloaderAdapter
    extends AdapterImpl {
        private ClassLoader classLoader;

        public ProcessorClassloaderAdapter(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public boolean isAdapterForType(Object type) {
            return Objects.equal((Object)type, ProcessorClassloaderAdapter.class);
        }

        public void unsetTarget(Notifier oldTarget) {
            this.discard();
        }

        public void setTarget(Notifier newTarget) {
            if (newTarget == null) {
                this.discard();
            }
        }

        public ClassLoader discard() {
            Object _xifexpression = null;
            if (this.classLoader instanceof Closeable) {
                Object _xtrycatchfinallyexpression = null;
                try {
                    Object _xblockexpression = null;
                    ((Closeable)((Object)this.classLoader)).close();
                    this.classLoader = null;
                    _xtrycatchfinallyexpression = _xblockexpression = null;
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) {
                        IOException e = (IOException)_t;
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                _xifexpression = _xtrycatchfinallyexpression;
            }
            return _xifexpression;
        }

        @Pure
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }
}

