/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.validation.AnnotationValueValidator;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class AnnotationValidation
extends AbstractDeclarativeValidator {
    @Inject
    private AnnotationValueValidator annotationValueValidator;

    protected List<EPackage> getEPackages() {
        return CollectionLiterals.newArrayList((Object[])new EPackage[]{XtendPackage.eINSTANCE, XbasePackage.eINSTANCE, XAnnotationsPackage.eINSTANCE});
    }

    @Check
    public void checkAnnotation(XtendAnnotationType it) {
        Iterable _filter = Iterables.filter(it.getMembers(), XtendField.class);
        for (XtendField it_1 : _filter) {
            XExpression _initialValue;
            boolean _tripleNotEquals;
            boolean _not;
            boolean _isValidAnnotationValueType = this.isValidAnnotationValueType(it_1.getType());
            boolean bl = _not = !_isValidAnnotationValueType;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Invalid type ");
                String _simpleName = it_1.getType().getSimpleName();
                _builder.append(_simpleName);
                _builder.append(" for the annotation attribute ");
                String _name = it_1.getName();
                _builder.append(_name);
                _builder.append("; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof");
                this.error(_builder.toString(), it_1, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__TYPE, "org.eclipse.xtend.core.validation.IssueCodes.invalid_annotation_value_type", new String[0]);
            }
            if (!(_tripleNotEquals = (_initialValue = it_1.getInitialValue()) != null)) continue;
            this.annotationValueValidator.validateAnnotationValue(it_1.getInitialValue(), (ValidationMessageAcceptor)this);
        }
    }

    public boolean isValidAnnotationValueType(JvmTypeReference reference) {
        JvmTypeReference toCheck;
        JvmTypeReference _switchResult = null;
        boolean _matched = false;
        if (reference instanceof JvmGenericArrayTypeReference) {
            _matched = true;
            _switchResult = ((JvmGenericArrayTypeReference)reference).getComponentType();
        }
        if (!_matched) {
            _switchResult = reference;
        }
        if ((toCheck = _switchResult) == null) {
            return true;
        }
        JvmType _type = toCheck.getType();
        if (_type instanceof JvmPrimitiveType) {
            return true;
        }
        JvmType _type_1 = toCheck.getType();
        if (_type_1 instanceof JvmEnumerationType) {
            return true;
        }
        JvmType _type_2 = toCheck.getType();
        if (_type_2 instanceof JvmAnnotationType) {
            return true;
        }
        return Objects.equal((Object)toCheck.getType().getQualifiedName(), (Object)"java.lang.String") || Objects.equal((Object)toCheck.getType().getQualifiedName(), (Object)"java.lang.Class");
    }
}

