/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler;

import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFilePostProcessorExtension;
import org.eclipse.xtext.xbase.compiler.output.TraceAwarePostProcessor;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;

public class UnicodeAwarePostProcessor
extends TraceAwarePostProcessor
implements IFilePostProcessorExtension {
    public CharSequence postProcess(URI fileURI, CharSequence content, Charset targetCharset) {
        if (targetCharset != null && "java".equalsIgnoreCase(fileURI.fileExtension())) {
            final String lineSeparator = this.getWhitespaceInformationProvider().getLineSeparatorInformation(fileURI).getLineSeparator();
            final CharsetEncoder encoder = targetCharset.newEncoder();
            if (content instanceof TreeAppendable) {
                return ((TreeAppendable)content).acceptVisitor(new TreeAppendable.Visitor(){

                    protected String visit(String string) {
                        return UnicodeAwarePostProcessor.this.replaceLineSeparatorsAndEscapeChars(string, lineSeparator, encoder);
                    }
                });
            }
            String result = this.replaceLineSeparatorsAndEscapeChars(content, lineSeparator, encoder);
            return result;
        }
        return this.postProcess(fileURI, content);
    }

    protected String replaceLineSeparatorsAndEscapeChars(CharSequence content, String newLineSeparator, CharsetEncoder encoder) {
        CharArrayWriter writer = new CharArrayWriter(content.length());
        boolean isLookahead = false;
        boolean changed = false;
        int ignoreNext = 0;
        block4: for (int i = 0; i < content.length(); ++i) {
            int c = content.charAt(i);
            if (isLookahead) {
                isLookahead = false;
                if (c == ignoreNext) continue;
            }
            switch (c) {
                case 10: {
                    changed = true;
                    writer.append(newLineSeparator);
                    isLookahead = true;
                    ignoreNext = 13;
                    continue block4;
                }
                case 13: {
                    changed = true;
                    writer.append(newLineSeparator);
                    isLookahead = true;
                    ignoreNext = 10;
                    continue block4;
                }
                default: {
                    if (encoder.canEncode((char)c)) {
                        writer.append((char)c);
                        continue block4;
                    }
                    changed = true;
                    writer.append("\\u");
                    String hexString = Integer.toHexString(c);
                    for (int j = hexString.length(); j < 4; ++j) {
                        writer.append('0');
                    }
                    writer.append(hexString);
                }
            }
        }
        if (changed) {
            return writer.toString();
        }
        return content.toString();
    }
}

