/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.validation.XtendValidator;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;

public class ModifierValidator {
    private static final Set<String> visibilityModifers = Sets.newHashSet((Object[])new String[]{"public", "protected", "package", "private"});
    private final Set<String> allowedModifiers;
    private final XtendValidator validator;
    private final String allowedModifiersAsString;

    public ModifierValidator(List<String> allowedModifiers, XtendValidator validator) {
        this.allowedModifiers = Sets.newHashSet(allowedModifiers);
        this.validator = validator;
        StringBuffer buffer = new StringBuffer(allowedModifiers.get(0));
        for (int i = 1; i < allowedModifiers.size() - 1; ++i) {
            buffer.append(", ").append(allowedModifiers.get(i));
        }
        if (allowedModifiers.size() > 1) {
            buffer.append(" & ").append(allowedModifiers.get(allowedModifiers.size() - 1));
        }
        this.allowedModifiersAsString = buffer.toString();
    }

    @Check
    protected void checkModifiers(XtendMember member, String memberName) {
        HashSet seenModifiers = Sets.newHashSet();
        boolean visibilitySeen = false;
        boolean abstractSeen = false;
        boolean defSeen = false;
        boolean staticSeen = false;
        boolean finalSeen = false;
        boolean varSeen = false;
        int defKeywordIndex = -1;
        int finalKeywordIndex = -1;
        for (int i = 0; i < member.getModifiers().size(); ++i) {
            String modifier = (String)member.getModifiers().get(i);
            if (!this.allowedModifiers.contains(modifier)) {
                this.error("Illegal modifier for the " + memberName + "; only " + this.allowedModifiersAsString + " are permitted", member, i);
            }
            if (seenModifiers.contains(modifier)) {
                this.error("Duplicate modifier for the " + memberName, member, i);
            } else {
                seenModifiers.add(modifier);
                if (visibilityModifers.contains(modifier)) {
                    if (visibilitySeen) {
                        this.error("The " + memberName + " can only set one of public / package / protected / private", member, i);
                    }
                    visibilitySeen = true;
                    if ("private".equals(modifier) && this.isPrivateByDefault(member)) {
                        this.unnecessaryModifierIssue("private", memberName, member, i);
                    }
                    if ("protected".equals(modifier) && this.isProtectedByDefault(member)) {
                        this.unnecessaryModifierIssue("protected", memberName, member, i);
                    }
                    if ("package".equals(modifier) && this.isPackageByDefault(member)) {
                        this.unnecessaryModifierIssue("package", memberName, member, i);
                    }
                    if ("public".equals(modifier) && this.isPublicByDefault(member)) {
                        this.unnecessaryModifierIssue("public", memberName, member, i);
                    }
                }
            }
            if (Strings.equal((String)modifier, (String)"abstract")) {
                if (finalSeen) {
                    this.error("The " + memberName + " can either be abstract or final, not both", member, i);
                }
                if (staticSeen && !(member instanceof XtendTypeDeclaration)) {
                    this.error("The " + memberName + " can either be abstract or static, not both", member, i);
                }
                abstractSeen = true;
                continue;
            }
            if (Strings.equal((String)modifier, (String)"static")) {
                if (abstractSeen && !(member instanceof XtendTypeDeclaration)) {
                    this.error("The " + memberName + " can either be abstract or static, not both", member, i);
                }
                staticSeen = true;
                continue;
            }
            if (Strings.equal((String)modifier, (String)"final") || Strings.equal((String)modifier, (String)"val")) {
                if (abstractSeen) {
                    this.error("The " + memberName + " can either be abstract or final, not both", member, i);
                }
                if (varSeen) {
                    this.error("The " + memberName + " can either be var or val / final, not both", member, i);
                }
                if (Strings.equal((String)modifier, (String)"final")) {
                    finalKeywordIndex = i;
                }
                if (finalSeen) {
                    this.unnecessaryModifierIssue("final", memberName, member, finalKeywordIndex);
                }
                finalSeen = true;
                continue;
            }
            if (Strings.equal((String)modifier, (String)"var")) {
                if (finalSeen) {
                    this.error("The " + memberName + " can either be var or val / final, not both", member, i);
                }
                varSeen = true;
                continue;
            }
            if (!Strings.equal((String)modifier, (String)"def") && !Strings.equal((String)modifier, (String)"override") || !(member instanceof XtendFunction)) continue;
            if (Strings.equal((String)modifier, (String)"def")) {
                defKeywordIndex = i;
            }
            if (defSeen) {
                this.unnecessaryModifierIssue("def", memberName, member, defKeywordIndex);
            }
            defSeen = true;
        }
    }

    protected void unnecessaryModifierIssue(String modifier, String memberName, EObject source, int index) {
        this.issue("The " + modifier + " modifier is unnecessary on " + memberName, source, index, "org.eclipse.xtend.core.validation.IssueCodes.unnecessary_modifier", modifier);
    }

    protected void issue(String message, EObject source, int index, String code, String ... issueData) {
        this.validator.addIssue(message, source, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, index, code, issueData);
    }

    protected void error(String message, EObject source, int index) {
        this.validator.acceptError(message, source, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, index, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
    }

    protected boolean isPrivateByDefault(XtendMember member) {
        return member instanceof XtendField;
    }

    protected boolean isProtectedByDefault(XtendMember member) {
        return false;
    }

    protected boolean isPackageByDefault(XtendMember member) {
        return false;
    }

    protected boolean isPublicByDefault(XtendMember member) {
        return member instanceof XtendAnnotationType || member instanceof XtendClass || member instanceof XtendEnum || member instanceof XtendInterface || member instanceof XtendConstructor || member instanceof XtendFunction;
    }
}

