/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler.batch;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.eclipse.xtend.core.compiler.batch.Main;

public class XtendCompilerAntTask
extends Java {
    private File destdir;
    private File tempdir;
    private Path srcdir;
    private String encoding;

    public void execute() throws BuildException {
        this.createArgs();
        this.setClassname(Main.class.getName());
        this.createArg().setValue(this.getSrcdir().toString());
        try {
            super.execute();
        }
        catch (Exception ex) {
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace();
            }
            String message = "Compilation failed: " + String.valueOf(ex.getMessage());
            if (ex.getCause() != null) {
                message = message + " cause: " + String.valueOf(ex.getCause().getMessage());
            }
            throw new BuildException(message, (Throwable)ex);
        }
    }

    private void createArgs() {
        this.validateArgs();
        this.createArg().setValue("-d");
        this.createArg().setValue(this.getDestdir().getAbsolutePath());
        if (this.getTempdir() != null) {
            this.createArg().setValue("-tp");
            this.createArg().setValue(this.getTempdir().getAbsolutePath());
        }
        if (this.getCommandLine().getClasspath() != null) {
            this.createArg().setValue("-cp");
            this.createArg().setValue(this.getCommandLine().getClasspath().toString());
        }
        if (this.getEncoding() != null) {
            this.createArg().setValue("-encoding");
            this.createArg().setValue(this.getEncoding());
        }
    }

    private void validateArgs() {
        if (this.getDestdir() == null) {
            throw new BuildException("Destination directory 'destdir' is required.");
        }
        Path srcDirs = this.getSrcdir();
        if (srcDirs == null) {
            throw new BuildException("Sources directory 'srcdir' is required.");
        }
        for (Object next : srcDirs) {
            if (next instanceof Resource && ((Resource)next).isDirectory()) continue;
            throw new BuildException("Source directory must be a directory. Check 'srcdir' entry: " + next);
        }
    }

    public Path createSrcdir() {
        if (this.srcdir == null) {
            this.srcdir = new Path(this.getProject());
        }
        return this.srcdir;
    }

    public Path getSrcdir() {
        return this.srcdir;
    }

    public void setSrcdir(Path srcdir) {
        this.createSrcdir().add(srcdir);
    }

    public File getDestdir() {
        return this.destdir;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setTempdir(File tempdir) {
        this.tempdir = tempdir;
    }

    public File getTempdir() {
        return this.tempdir;
    }
}

