/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.TreeAppendableUtil;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class DispatchMethodCompileStrategy
implements Procedures.Procedure1<ITreeAppendable> {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TreeAppendableUtil treeAppendableUtil;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private DispatchHelper sorter;
    private JvmOperation dispatchOperation;

    protected void initialize(JvmOperation dispatchOperation) {
        this.dispatchOperation = dispatchOperation;
    }

    public void apply(ITreeAppendable a) {
        if (a == null) {
            throw new IllegalArgumentException("a is never null");
        }
        int parameterCount = this.dispatchOperation.getParameters().size();
        List<JvmOperation> sortedDispatchOperations = this.sorter.getAllDispatchCases(this.dispatchOperation);
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)this.dispatchOperation);
        boolean[] allCasesSameType = new boolean[parameterCount];
        boolean[] voidIncluded = new boolean[parameterCount];
        boolean[] notNullIncluded = new boolean[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            allCasesSameType[i] = true;
            voidIncluded[i] = false;
            notNullIncluded[i] = false;
            JvmFormalParameter dispatchParam = (JvmFormalParameter)this.dispatchOperation.getParameters().get(i);
            LightweightTypeReference dispatchParamType = owner.toLightweightTypeReference(dispatchParam.getParameterType());
            for (JvmOperation operation : sortedDispatchOperations) {
                JvmFormalParameter caseParam = (JvmFormalParameter)operation.getParameters().get(i);
                LightweightTypeReference caseParamType = owner.toLightweightTypeReference(caseParam.getParameterType());
                if (!Strings.equal((String)dispatchParamType.getIdentifier(), (String)caseParamType.getIdentifier())) {
                    allCasesSameType[i] = false;
                }
                if (caseParamType.isType(Void.class)) {
                    voidIncluded[i] = true;
                }
                if (!this.isSameType(dispatchParamType, caseParamType) || dispatchParamType.isPrimitive()) continue;
                notNullIncluded[i] = true;
            }
        }
        boolean needsElse = this.anyFalse(notNullIncluded) || this.anyFalse(voidIncluded) && (parameterCount != 1 || sortedDispatchOperations.size() != 1);
        for (JvmOperation operation : sortedDispatchOperations) {
            boolean isLast;
            ITreeAppendable operationAppendable = this.treeAppendableUtil.traceSignificant(a, (EObject)operation, true);
            ArrayList laters = Lists.newArrayList();
            for (int i = 0; i < parameterCount; ++i) {
                JvmFormalParameter dispatchParam = (JvmFormalParameter)this.dispatchOperation.getParameters().get(i);
                final LightweightTypeReference dispatchParamType = owner.toLightweightTypeReference(dispatchParam.getParameterType());
                JvmFormalParameter caseParam = (JvmFormalParameter)operation.getParameters().get(i);
                final LightweightTypeReference caseParamType = owner.toLightweightTypeReference(caseParam.getParameterType());
                final String name = this.getVarName((JvmIdentifiableElement)dispatchParam, (IAppendable)operationAppendable);
                if (caseParamType.isType(Void.class)) {
                    laters.add(new Later(){

                        public void exec(ITreeAppendable appendable) {
                            appendable.append((CharSequence)name).append((CharSequence)" == null");
                        }
                    });
                    continue;
                }
                if (allCasesSameType[i]) continue;
                laters.add(new Later(){

                    public void exec(ITreeAppendable appendable) {
                        if (DispatchMethodCompileStrategy.this.isSameType(dispatchParamType, caseParamType) && !dispatchParamType.isPrimitive()) {
                            appendable.append((CharSequence)name).append((CharSequence)" != null");
                        } else {
                            appendable.append((CharSequence)name).append((CharSequence)" instanceof ");
                            JvmType type = caseParamType.getWrapperTypeIfPrimitive().getType();
                            if (type == null) {
                                throw new IllegalStateException(String.valueOf(caseParamType));
                            }
                            appendable.append(type);
                        }
                    }
                });
            }
            boolean bl = isLast = sortedDispatchOperations.get(sortedDispatchOperations.size() - 1) == operation;
            if (sortedDispatchOperations.get(0) != operation) {
                operationAppendable.append((CharSequence)" else ");
            }
            if (laters.isEmpty()) {
                if (sortedDispatchOperations.size() != 1) {
                    operationAppendable.append((CharSequence)"{").increaseIndentation();
                    operationAppendable.newLine();
                }
            } else if (!isLast || needsElse) {
                operationAppendable.append((CharSequence)"if (");
                operationAppendable.increaseIndentation().increaseIndentation();
                Iterator iterator = laters.iterator();
                while (iterator.hasNext()) {
                    ((Later)iterator.next()).exec(operationAppendable);
                    if (!iterator.hasNext()) continue;
                    operationAppendable.newLine().append((CharSequence)" && ");
                }
                operationAppendable.decreaseIndentation().decreaseIndentation();
                operationAppendable.append((CharSequence)") {").increaseIndentation();
                operationAppendable.newLine();
            } else {
                operationAppendable.append((CharSequence)"{").increaseIndentation().newLine();
            }
            boolean isCurrentVoid = this.typeReferences.is(operation.getReturnType(), Void.TYPE);
            boolean isDispatchVoid = this.typeReferences.is(this.dispatchOperation.getReturnType(), Void.TYPE);
            if (isDispatchVoid) {
                this.generateActualDispatchCall(this.dispatchOperation, operation, operationAppendable, (ITypeReferenceOwner)owner);
                operationAppendable.append((CharSequence)";");
                operationAppendable.newLine().append((CharSequence)"return;");
            } else {
                if (isCurrentVoid) {
                    this.generateActualDispatchCall(this.dispatchOperation, operation, operationAppendable, (ITypeReferenceOwner)owner);
                    operationAppendable.append((CharSequence)";").newLine().append((CharSequence)"return null");
                } else {
                    operationAppendable.append((CharSequence)"return ");
                    this.generateActualDispatchCall(this.dispatchOperation, operation, operationAppendable, (ITypeReferenceOwner)owner);
                }
                operationAppendable.append((CharSequence)";");
            }
            if (sortedDispatchOperations.size() == 1) continue;
            operationAppendable.decreaseIndentation();
            a.newLine().append((CharSequence)"}");
        }
        if (needsElse) {
            a.append((CharSequence)" else {").increaseIndentation();
            a.newLine();
            a.increaseIndentation();
            a.append((CharSequence)"throw new IllegalArgumentException(\"Unhandled parameter types: \" +").newLine();
            JvmType jvmType = this.typeReferences.findDeclaredType("java.util.Arrays", (Notifier)this.dispatchOperation);
            if (jvmType != null) {
                a.append(jvmType);
            } else {
                a.append((CharSequence)Arrays.class.getSimpleName());
            }
            a.append((CharSequence)".<Object>asList(");
            Iterator iterator = this.dispatchOperation.getParameters().iterator();
            while (iterator.hasNext()) {
                JvmFormalParameter parameter = (JvmFormalParameter)iterator.next();
                String name = this.getVarName((JvmIdentifiableElement)parameter, (IAppendable)a);
                a.append((CharSequence)name);
                if (!iterator.hasNext()) continue;
                a.append((CharSequence)", ");
            }
            a.append((CharSequence)").toString());");
            a.decreaseIndentation();
            a.decreaseIndentation().newLine().append((CharSequence)"}");
        }
    }

    protected void generateActualDispatchCall(JvmOperation dispatchOperation, JvmOperation actualOperationToCall, ITreeAppendable a, ITypeReferenceOwner owner) {
        a.append((CharSequence)actualOperationToCall.getSimpleName()).append((CharSequence)"(");
        Iterator iter1 = dispatchOperation.getParameters().iterator();
        Iterator iter2 = actualOperationToCall.getParameters().iterator();
        while (iter2.hasNext()) {
            LightweightTypeReference type2;
            JvmFormalParameter p1 = (JvmFormalParameter)iter1.next();
            JvmFormalParameter p2 = (JvmFormalParameter)iter2.next();
            LightweightTypeReference type1 = owner.toLightweightTypeReference(p1.getParameterType());
            if (!this.isSameType(type1, type2 = owner.toLightweightTypeReference(p2.getParameterType()))) {
                a.append((CharSequence)"(").append(type2.getWrapperTypeIfPrimitive()).append((CharSequence)")");
            }
            if (this.typeReferences.is(p2.getParameterType(), Void.class)) {
                a.append((CharSequence)"null");
            } else {
                a.append((CharSequence)this.getVarName((JvmIdentifiableElement)p1, (IAppendable)a));
            }
            if (!iter2.hasNext()) continue;
            a.append((CharSequence)", ");
        }
        a.append((CharSequence)")");
    }

    protected String getVarName(JvmIdentifiableElement ex, IAppendable appendable) {
        return appendable.getName((Object)ex);
    }

    private boolean isSameType(LightweightTypeReference t0, LightweightTypeReference t1) {
        return t1.isAssignableFrom(t0, new TypeConformanceComputationArgument(true, false, true, true, false, false));
    }

    private boolean anyFalse(boolean[] list) {
        for (boolean v : list) {
            if (v) continue;
            return true;
        }
        return false;
    }
}

