/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmClassDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MutableJvmClassDeclarationImpl
extends JvmClassDeclarationImpl
implements MutableClassDeclaration {
    public void markAsRead() {
        this.checkMutable();
        this.getCompilationUnit().getReadAndWriteTracking().markReadAccess((EObject)this.getDelegate());
    }

    public MutableMethodDeclaration findDeclaredMethod(String name, TypeReference ... parameterTypes) {
        MethodDeclaration _findDeclaredMethod = super.findDeclaredMethod(name, parameterTypes);
        return (MutableMethodDeclaration)_findDeclaredMethod;
    }

    public MutableFieldDeclaration findDeclaredField(String name) {
        FieldDeclaration _findDeclaredField = super.findDeclaredField(name);
        return (MutableFieldDeclaration)_findDeclaredField;
    }

    public MutableTypeDeclaration findDeclaredType(String name) {
        TypeDeclaration _findDeclaredType = super.findDeclaredType(name);
        return (MutableTypeDeclaration)_findDeclaredType;
    }

    public MutableConstructorDeclaration findDeclaredConstructor(TypeReference ... parameterTypes) {
        ConstructorDeclaration _findDeclaredConstructor = super.findDeclaredConstructor(parameterTypes);
        return (MutableConstructorDeclaration)_findDeclaredConstructor;
    }

    @Override
    public Iterable<? extends MutableMethodDeclaration> getDeclaredMethods() {
        Iterable<MethodDeclaration> _declaredMethods = super.getDeclaredMethods();
        return _declaredMethods;
    }

    @Override
    public Iterable<? extends MutableFieldDeclaration> getDeclaredFields() {
        Iterable<FieldDeclaration> _declaredFields = super.getDeclaredFields();
        return _declaredFields;
    }

    @Override
    public Iterable<? extends MutableClassDeclaration> getDeclaredClasses() {
        Iterable<ClassDeclaration> _declaredClasses = super.getDeclaredClasses();
        return _declaredClasses;
    }

    @Override
    public Iterable<? extends MutableConstructorDeclaration> getDeclaredConstructors() {
        Iterable<ConstructorDeclaration> _declaredConstructors = super.getDeclaredConstructors();
        return _declaredConstructors;
    }

    @Override
    public Iterable<? extends MutableInterfaceDeclaration> getDeclaredInterfaces() {
        Iterable<InterfaceDeclaration> _declaredInterfaces = super.getDeclaredInterfaces();
        return _declaredInterfaces;
    }

    @Override
    public Iterable<? extends MutableAnnotationTypeDeclaration> getDeclaredAnnotationTypes() {
        Iterable<AnnotationTypeDeclaration> _declaredAnnotationTypes = super.getDeclaredAnnotationTypes();
        return _declaredAnnotationTypes;
    }

    @Override
    public Iterable<? extends MutableEnumerationTypeDeclaration> getDeclaredEnumerationTypes() {
        Iterable<EnumerationTypeDeclaration> _declaredEnumerationTypes = super.getDeclaredEnumerationTypes();
        return _declaredEnumerationTypes;
    }

    @Override
    public Iterable<? extends MutableTypeDeclaration> getDeclaredTypes() {
        Iterable<TypeDeclaration> _declaredTypes = super.getDeclaredTypes();
        return _declaredTypes;
    }

    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    @Override
    public Iterable<? extends MutableMemberDeclaration> getDeclaredMembers() {
        Iterable<MemberDeclaration> _declaredMembers = super.getDeclaredMembers();
        return _declaredMembers;
    }

    public Iterable<? extends MutableTypeParameterDeclaration> getTypeParameters() {
        Iterable<? extends TypeParameterDeclaration> _typeParameters = super.getTypeParameters();
        return _typeParameters;
    }

    public void setStrictFloatingPoint(boolean isStrictFloatingPoint) {
        this.checkMutable();
        ((JvmGenericType)this.getDelegate()).setStrictFloatingPoint(isStrictFloatingPoint);
    }

    public void setAbstract(boolean isAbstract) {
        this.checkMutable();
        ((JvmGenericType)this.getDelegate()).setAbstract(isAbstract);
    }

    public void setFinal(boolean isFinal) {
        this.checkMutable();
        ((JvmGenericType)this.getDelegate()).setFinal(isFinal);
    }

    public void setStatic(boolean isStatic) {
        this.checkMutable();
        ((JvmGenericType)this.getDelegate()).setStatic(isStatic);
    }

    public void setExtendedClass(TypeReference superclass) {
        this.checkMutable();
        ConditionUtils.checkInferredTypeReferences("extended class", superclass);
        JvmTypeReference _xifexpression = null;
        _xifexpression = superclass != null ? this.getCompilationUnit().toJvmTypeReference(superclass) : this.getCompilationUnit().getTypeReferences().getTypeForName(Object.class, (Notifier)this.getCompilationUnit().getXtendFile(), new JvmTypeReference[0]);
        JvmTypeReference newTypeRef = _xifexpression;
        Functions.Function1 _function = it -> it.getType() instanceof JvmGenericType && !((JvmGenericType)it.getType()).isInterface();
        JvmTypeReference oldType = (JvmTypeReference)IterableExtensions.findFirst((Iterable)((JvmGenericType)this.getDelegate()).getSuperTypes(), (Functions.Function1)_function);
        if (oldType != null) {
            ((JvmGenericType)this.getDelegate()).getSuperTypes().remove((Object)oldType);
        }
        ((JvmGenericType)this.getDelegate()).getSuperTypes().add((Object)newTypeRef);
    }

    public void setImplementedInterfaces(Iterable<? extends TypeReference> superInterfaces) {
        this.checkMutable();
        ConditionUtils.checkIterable(superInterfaces, "superIntefaces");
        ConditionUtils.checkInferredTypeReferences("implemented interface", (TypeReference[])Conversions.unwrapArray(superInterfaces, TypeReference.class));
        Functions.Function1 _function = it -> it.getType() instanceof JvmGenericType && ((JvmGenericType)it.getType()).isInterface();
        Iterable oldInterfaces = IterableExtensions.filter((Iterable)((JvmGenericType)this.getDelegate()).getSuperTypes(), (Functions.Function1)_function);
        CollectionExtensions.removeAll((Collection)((JvmGenericType)this.getDelegate()).getSuperTypes(), (Iterable)oldInterfaces);
        Functions.Function1 _function_1 = it -> this.getCompilationUnit().toJvmTypeReference((TypeReference)it);
        Iterables.addAll((Collection)((JvmGenericType)this.getDelegate()).getSuperTypes(), (Iterable)IterableExtensions.map(superInterfaces, (Functions.Function1)_function_1));
    }

    public MutableTypeParameterDeclaration addTypeParameter(String name, TypeReference ... upperBounds) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)upperBounds), "upperBounds");
        ConditionUtils.checkInferredTypeReferences("parameter type", upperBounds);
        JvmTypeParameter param = TypesFactory.eINSTANCE.createJvmTypeParameter();
        param.setName(name);
        ((JvmGenericType)this.getDelegate()).getTypeParameters().add((Object)param);
        for (TypeReference upper : upperBounds) {
            JvmTypeReference typeRef = this.getCompilationUnit().toJvmTypeReference(upper);
            JvmUpperBound jvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            jvmUpperBound.setTypeReference(typeRef);
            param.getConstraints().add((Object)jvmUpperBound);
        }
        TypeParameterDeclaration _typeParameterDeclaration = this.getCompilationUnit().toTypeParameterDeclaration(param);
        return (MutableTypeParameterDeclaration)_typeParameterDeclaration;
    }
}

