/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.xtend.core.javaconverter.ASTFlattenerUtils;
import org.eclipse.xtend.core.javaconverter.ASTParserFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaASTFlattener
extends ASTVisitor {
    @Inject
    private IValueConverterService converterService;
    @Inject
    @Extension
    private ASTFlattenerUtils _aSTFlattenerUtils;
    private List<String> problems = CollectionLiterals.newArrayList();
    private Set<Comment> assignedComments = CollectionLiterals.newHashSet();
    private StringBuffer fBuffer;
    private String javaSources;
    private int indentation = 0;
    private boolean fallBackStrategy = false;
    private String targetApiLevel;
    private boolean conditionalExpressionsAllowed;

    public JavaASTFlattener() {
        StringBuffer _stringBuffer;
        this.fBuffer = _stringBuffer = new StringBuffer();
    }

    public String getResult() {
        return this.fBuffer.toString();
    }

    public List<String> getProblems() {
        return this.problems;
    }

    public void acceptSyntaticBlock(Block node) {
        int childrenCount = node.statements().size();
        if (childrenCount > 0) {
            Procedures.Procedure2 _function = (child, counter) -> {
                child.accept((ASTVisitor)this);
                this.appendLineWrapToBuffer();
            };
            IterableExtensions.forEach((Iterable)node.statements(), (Procedures.Procedure2)_function);
        }
    }

    private int decreaseIndent() {
        int _xifexpression = 0;
        if (this.indentation > 0) {
            _xifexpression = this.indentation--;
        }
        return _xifexpression;
    }

    private int increaseIndent() {
        return this.indentation++;
    }

    private boolean notAssigned(Comment comment) {
        boolean _contains = this.assignedComments.contains(comment);
        return !_contains;
    }

    public boolean java8orHigher() {
        int _asJLS = ASTParserFactory.asJLS(this.targetApiLevel);
        return _asJLS >= 8;
    }

    public void appendModifiers(ASTNode node, Iterable<IExtendedModifier> ext) {
        this.appendModifiers(node, ext, null);
    }

    public void appendModifiers(ASTNode node, Iterable<IExtendedModifier> ext, Functions.Function1<? super ASTNode, ? extends StringBuffer> callBack) {
        Procedures.Procedure1 _function;
        Procedures.Procedure1 appender = _function = p -> ((ASTNode)p).accept((ASTVisitor)this);
        Functions.Function1 _function_1 = it -> it.isAnnotation() && !Objects.equal((Object)((Annotation)it).getTypeName().toString(), (Object)"Override");
        IterableExtensions.forEach((Iterable)IterableExtensions.filter(ext, (Functions.Function1)_function_1), (Procedures.Procedure1)appender);
        if (callBack != null) {
            callBack.apply((Object)node);
        }
        Functions.Function1 _function_2 = it -> it.isModifier() && !Objects.equal((Object)((Modifier)it).getKeyword().toString(), (Object)"default");
        IterableExtensions.forEach((Iterable)IterableExtensions.filter(ext, (Functions.Function1)_function_2), (Procedures.Procedure1)appender);
    }

    private StringBuffer appendSpaceToBuffer() {
        return this.appendToBuffer(" ");
    }

    private StringBuffer appendLineWrapToBuffer() {
        StringBuffer _xblockexpression = null;
        this.appendToBuffer(this.nl());
        String _multiply = this.operator_multiply("\t", this.indentation);
        _xblockexpression = this.appendToBuffer(_multiply);
        return _xblockexpression;
    }

    protected String nl() {
        return StringConcatenation.DEFAULT_LINE_DELIMITER;
    }

    public String operator_multiply(String string, int i) {
        String _xblockexpression = null;
        Object retVal = "";
        for (int counter = 0; counter < i; ++counter) {
            retVal = (String)retVal + string;
        }
        _xblockexpression = retVal;
        return _xblockexpression;
    }

    private StringBuffer appendToBuffer(String string) {
        return this.fBuffer.append(string);
    }

    protected boolean addProblem(ASTNode node, String string) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(string);
        _builder.append(" (start: ");
        int _startPosition = node.getStartPosition();
        _builder.append((Object)_startPosition);
        _builder.append(", length: ");
        int _length = node.getLength();
        _builder.append((Object)_length);
        _builder.append(")");
        return this.problems.add(_builder.toString());
    }

    public boolean visit(Assignment node) {
        Expression leftSide = node.getLeftHandSide();
        Type type = null;
        if (leftSide instanceof ArrayAccess) {
            Expression _array = ((ArrayAccess)leftSide).getArray();
            if (_array instanceof SimpleName) {
                Expression _array_1 = ((ArrayAccess)leftSide).getArray();
                type = this._aSTFlattenerUtils.findDeclaredType((SimpleName)_array_1);
            }
            this.handleAssignment(node, (ArrayAccess)leftSide, type);
        } else {
            if (leftSide instanceof SimpleName) {
                type = this._aSTFlattenerUtils.findDeclaredType((SimpleName)leftSide);
            }
            this.handleAssignment(node, (ASTNode)leftSide, type);
        }
        return false;
    }

    public void handleAssignment(Assignment node, ASTNode leftSide, Type type) {
        leftSide.accept((ASTVisitor)this);
        this.appendToBuffer(node.getOperator().toString());
        this.handleRightHandSide(node, type);
    }

    public void handleAssignment(Assignment node, ArrayAccess leftSide, Type type) {
        boolean _not;
        String arrayName = this.computeArrayName(leftSide);
        this.appendToBuffer("{ ");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("_wrVal_");
        _builder.append(arrayName);
        String valName = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("_wrIndx_");
        _builder_1.append(arrayName);
        String idxName = _builder_1.toString();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("val ");
        _builder_2.append(valName);
        _builder_2.append("=");
        this.appendToBuffer(_builder_2.toString());
        leftSide.getArray().accept((ASTVisitor)this);
        boolean _isConstantArrayIndex = this._aSTFlattenerUtils.isConstantArrayIndex(leftSide.getIndex());
        boolean bl = _not = !_isConstantArrayIndex;
        if (_not) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(" ");
            _builder_3.append("val ");
            _builder_3.append(idxName, " ");
            _builder_3.append("=");
            this.appendToBuffer(_builder_3.toString());
            leftSide.getIndex().accept((ASTVisitor)this);
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append(" ");
            _builder_4.append(valName, " ");
            _builder_4.append(".set(");
            _builder_4.append(idxName, " ");
            _builder_4.append(",");
            this.appendToBuffer(_builder_4.toString());
        } else {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append(" ");
            _builder_5.append(valName, " ");
            _builder_5.append(".set(");
            this.appendToBuffer(_builder_5.toString());
            leftSide.getIndex().accept((ASTVisitor)this);
            this.appendToBuffer(",");
        }
        this.handleRightHandSide(node, type);
        this.appendToBuffer(")");
        boolean _needsReturnValue = this._aSTFlattenerUtils.needsReturnValue((ASTNode)node);
        if (_needsReturnValue) {
            boolean _not_1;
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append(" ");
            _builder_6.append(valName, " ");
            _builder_6.append(".get(");
            this.appendToBuffer(_builder_6.toString());
            boolean _isConstantArrayIndex_1 = this._aSTFlattenerUtils.isConstantArrayIndex(leftSide.getIndex());
            boolean bl2 = _not_1 = !_isConstantArrayIndex_1;
            if (_not_1) {
                StringConcatenation _builder_7 = new StringConcatenation();
                _builder_7.append(idxName);
                this.appendToBuffer(_builder_7.toString());
            } else {
                leftSide.getIndex().accept((ASTVisitor)this);
            }
            this.appendToBuffer(")");
        }
        this.appendToBuffer("}");
    }

    public StringBuffer handleRightHandSide(Assignment a, Type type) {
        StringBuffer _xifexpression = null;
        if (this._aSTFlattenerUtils.needPrimitiveCast(type) && !(a.getRightHandSide() instanceof ArrayCreation)) {
            StringBuffer _xblockexpression = null;
            this.appendToBuffer("(");
            a.getRightHandSide().accept((ASTVisitor)this);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(") as ");
            _builder.append((Object)type);
            _xifexpression = _xblockexpression = this.appendToBuffer(_builder.toString());
        } else {
            a.getRightHandSide().accept((ASTVisitor)this);
        }
        return _xifexpression;
    }

    public boolean visit(MarkerAnnotation node) {
        this.appendToBuffer("@");
        node.getTypeName().accept((ASTVisitor)this);
        this.appendSpaceToBuffer();
        return false;
    }

    public boolean visit(CompilationUnit it) {
        boolean _not;
        boolean _isDummyType = this._aSTFlattenerUtils.isDummyType((AbstractTypeDeclaration)IterableExtensions.head((Iterable)it.types()));
        boolean bl = _not = !_isDummyType;
        if (_not) {
            PackageDeclaration _package = it.getPackage();
            if (_package != null) {
                _package.accept((ASTVisitor)this);
            }
            this.visitAll(it.imports());
        }
        this.visitAll(it.types());
        return false;
    }

    public boolean visit(PackageDeclaration it) {
        boolean _tripleNotEquals;
        Javadoc _javadoc = it.getJavadoc();
        boolean bl = _tripleNotEquals = _javadoc != null;
        if (_tripleNotEquals) {
            it.getJavadoc().accept((ASTVisitor)this);
        }
        this.visitAll(it.annotations(), " ");
        this.appendToBuffer("package ");
        it.getName().accept((ASTVisitor)this);
        this.appendLineWrapToBuffer();
        return false;
    }

    public boolean visit(ParameterizedType it) {
        it.getType().accept((ASTVisitor)this);
        this.appendTypeParameters(it.typeArguments());
        return false;
    }

    public boolean visit(PrimitiveType it) {
        this.appendToBuffer(it.getPrimitiveTypeCode().toString());
        return false;
    }

    public boolean visit(BooleanLiteral it) {
        this.appendToBuffer(String.valueOf(it.booleanValue()));
        return false;
    }

    public boolean visit(StringLiteral it) {
        String handleOctal = it.getEscapedValue().replaceAll("\\\\([01234567])", "\\u000$1");
        this.appendToBuffer(handleOctal);
        return false;
    }

    public boolean visit(ImportDeclaration it) {
        this.appendToBuffer("import ");
        boolean _isStatic = it.isStatic();
        if (_isStatic) {
            this.appendToBuffer("static ");
        }
        it.getName().accept((ASTVisitor)this);
        boolean _isOnDemand = it.isOnDemand();
        if (_isOnDemand) {
            this.appendToBuffer(".*");
        }
        this.appendLineWrapToBuffer();
        return false;
    }

    public boolean visit(Initializer it) {
        boolean _tripleNotEquals;
        Javadoc _javadoc = it.getJavadoc();
        boolean bl = _tripleNotEquals = _javadoc != null;
        if (_tripleNotEquals) {
            it.getJavadoc().accept((ASTVisitor)this);
        }
        this.appendModifiers((ASTNode)it, it.modifiers());
        boolean _isStatic = this._aSTFlattenerUtils.isStatic(it.modifiers());
        if (_isStatic) {
            if (it.getParent() instanceof TypeDeclaration && IterableExtensions.forall((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((TypeDeclaration)it.getParent()).getFields())), it_1 -> this._aSTFlattenerUtils.isStatic(it_1.modifiers()) && this._aSTFlattenerUtils.isFinal(it_1.modifiers())), f -> {
                Functions.Function1 _function = fragment -> {
                    Boolean _isAssignedInBody = this._aSTFlattenerUtils.isAssignedInBody(it.getBody(), (VariableDeclarationFragment)fragment);
                    return _isAssignedInBody == false;
                };
                return IterableExtensions.forall((Iterable)f.fragments(), (Functions.Function1)_function);
            })) {
                this.appendToBuffer(" final Void static_initializer = {");
                this.appendLineWrapToBuffer();
                it.getBody().accept((ASTVisitor)this);
                this.appendToBuffer("null }");
                this.appendLineWrapToBuffer();
            } else {
                this.addProblem((ASTNode)it, "Static initializer is not fully supported");
                this.appendToBuffer("{/*FIXME ");
                it.getBody().accept((ASTVisitor)this);
                this.appendToBuffer("*/}");
            }
        } else {
            ASTNode _parent = it.getParent();
            if (_parent instanceof AnonymousClassDeclaration) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Initializer is not supported in ");
                String _simpleName = ASTNode.nodeClassForType((int)it.getParent().getNodeType()).getSimpleName();
                _builder.append(_simpleName);
                this.addProblem((ASTNode)it, _builder.toString());
            }
            it.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration it) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _tripleNotEquals_1;
        boolean _not;
        Javadoc _javadoc;
        boolean _tripleNotEquals;
        boolean _isDummyType = this._aSTFlattenerUtils.isDummyType((AbstractTypeDeclaration)it);
        if (_isDummyType) {
            this.visitAll(it.bodyDeclarations(), this.nl());
            return false;
        }
        boolean _isNotSupportedInnerType = this._aSTFlattenerUtils.isNotSupportedInnerType(it);
        if (_isNotSupportedInnerType) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/* FIXME Non-static inner classes are not supported.*/");
            this.appendToBuffer(_builder.toString());
            this.addProblem((ASTNode)it, "Non-static inner classes are not supported.");
        }
        boolean bl = _tripleNotEquals = (_javadoc = it.getJavadoc()) != null;
        if (_tripleNotEquals) {
            it.getJavadoc().accept((ASTVisitor)this);
        }
        this.appendModifiers((ASTNode)it, it.modifiers());
        boolean _isInterface = it.isInterface();
        if (_isInterface) {
            this.appendToBuffer("interface ");
        } else {
            boolean _isPackageVisibility = this._aSTFlattenerUtils.isPackageVisibility(Iterables.filter((Iterable)it.modifiers(), Modifier.class));
            if (_isPackageVisibility) {
                this.appendToBuffer("package ");
            }
            this.appendToBuffer("class ");
        }
        it.getName().accept((ASTVisitor)this);
        boolean _isEmpty = it.typeParameters().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            this.appendTypeParameters(it.typeParameters());
        }
        this.appendSpaceToBuffer();
        Type _superclassType = it.getSuperclassType();
        boolean bl3 = _tripleNotEquals_1 = _superclassType != null;
        if (_tripleNotEquals_1) {
            this.appendToBuffer("extends ");
            it.getSuperclassType().accept((ASTVisitor)this);
            this.appendSpaceToBuffer();
        }
        boolean bl4 = _not_1 = !(_isEmpty_1 = it.superInterfaceTypes().isEmpty());
        if (_not_1) {
            boolean _isInterface_1 = it.isInterface();
            if (_isInterface_1) {
                this.appendToBuffer("extends ");
            } else {
                this.appendToBuffer("implements ");
            }
            this.visitAllSeparatedByComma(it.superInterfaceTypes());
        }
        this.appendToBuffer("{");
        this.increaseIndent();
        BodyDeclaration prev = null;
        List _bodyDeclarations = it.bodyDeclarations();
        for (BodyDeclaration body : _bodyDeclarations) {
            if (prev instanceof EnumConstantDeclaration) {
                if (body instanceof EnumConstantDeclaration) {
                    this.appendToBuffer(", ");
                } else {
                    this.appendToBuffer("; ");
                }
            }
            this.appendLineWrapToBuffer();
            body.accept((ASTVisitor)this);
            prev = body;
        }
        ASTNode _root = it.getRoot();
        if (_root instanceof CompilationUnit) {
            ASTNode _root_1 = it.getRoot();
            CompilationUnit cu = (CompilationUnit)_root_1;
            Consumer<Comment> _function = it_1 -> {
                it_1.accept((ASTVisitor)this);
                this.assignedComments.add((Comment)it_1);
            };
            this.unAssignedComments(cu).forEach(_function);
        }
        this.decreaseIndent();
        this.appendLineWrapToBuffer();
        this.appendToBuffer("}");
        return false;
    }

    private Iterable<Comment> unAssignedComments(CompilationUnit cu) {
        Functions.Function1 _function = c -> (!c.isDocComment() || c.getParent() == null) && this.notAssigned((Comment)c);
        return IterableExtensions.filter((Iterable)cu.getCommentList(), (Functions.Function1)_function);
    }

    public boolean visit(Javadoc it) {
        this.appendToBuffer("/** ");
        this.visitAll(it.tags());
        this.appendLineWrapToBuffer();
        this.appendToBuffer(" */");
        this.appendLineWrapToBuffer();
        return false;
    }

    public boolean visit(SimpleName it) {
        Object convertedName = this.converterService.toString((Object)it.getIdentifier(), "ValidID");
        if ("it".equals(convertedName) && this._aSTFlattenerUtils.shouldConvertName(it)) {
            convertedName = "renamed_" + (String)convertedName;
        }
        this.appendToBuffer((String)convertedName);
        return false;
    }

    public boolean visit(QualifiedName it) {
        it.getQualifier().accept((ASTVisitor)this);
        if (this.fallBackStrategy && this._aSTFlattenerUtils.isStaticMemberCall(it) && !(it.getParent() instanceof SimpleType) && !(it.getParent() instanceof ImportDeclaration)) {
            this.appendToBuffer("::");
        } else {
            this.appendToBuffer(".");
        }
        it.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SimpleType node) {
        return true;
    }

    public boolean visit(Modifier it) {
        boolean append = true;
        int _flagValue = it.getKeyword().toFlagValue();
        switch (_flagValue) {
            case 1: {
                if (!(it.getParent() instanceof TypeDeclaration) && !(it.getParent() instanceof MethodDeclaration)) break;
                append = false;
                break;
            }
            case 2: {
                ASTNode _parent = it.getParent();
                if (!(_parent instanceof FieldDeclaration)) break;
                append = false;
                break;
            }
            case 16: {
                if (!(it.getParent() instanceof VariableDeclarationExpression) && !(it.getParent() instanceof VariableDeclarationStatement)) break;
                append = false;
                break;
            }
            default: {
                append = true;
            }
        }
        if (append) {
            boolean _equals;
            String valueToAppend = it.getKeyword().toString();
            int _flagValue_1 = it.getKeyword().toFlagValue();
            boolean bl = _equals = _flagValue_1 == 0;
            if (_equals) {
                valueToAppend = "package";
            }
            this.appendToBuffer(valueToAppend);
            this.appendSpaceToBuffer();
        }
        return false;
    }

    public boolean visit(FieldDeclaration it) {
        boolean _tripleNotEquals;
        Javadoc _javadoc = it.getJavadoc();
        boolean bl = _tripleNotEquals = _javadoc != null;
        if (_tripleNotEquals) {
            it.getJavadoc().accept((ASTVisitor)this);
        }
        Consumer<VariableDeclarationFragment> _function = frag -> {
            ASTNode _parent;
            this.appendModifiers((ASTNode)it, it.modifiers());
            boolean _isPackageVisibility = this._aSTFlattenerUtils.isPackageVisibility(Iterables.filter((Iterable)it.modifiers(), Modifier.class));
            if (_isPackageVisibility && (_parent = it.getParent()) instanceof TypeDeclaration) {
                boolean _not;
                ASTNode _parent_1 = it.getParent();
                boolean _isInterface = ((TypeDeclaration)_parent_1).isInterface();
                boolean bl = _not = !_isInterface;
                if (_not) {
                    this.appendToBuffer("package ");
                }
            }
            it.getType().accept((ASTVisitor)this);
            this.appendExtraDimensions(frag.getExtraDimensions());
            this.appendSpaceToBuffer();
            frag.accept((ASTVisitor)this);
        };
        it.fragments().forEach(_function);
        return false;
    }

    public boolean visit(VariableDeclarationExpression it) {
        Procedures.Procedure2 _function = (frag, counter) -> {
            boolean _lessThan;
            this.appendModifiers((ASTNode)it, it.modifiers());
            this.appendToBuffer(this._aSTFlattenerUtils.handleVariableDeclaration(it.modifiers()));
            this.appendSpaceToBuffer();
            it.getType().accept((ASTVisitor)this);
            this.appendSpaceToBuffer();
            frag.accept((ASTVisitor)this);
            int _size = it.fragments().size();
            int _minus = _size - 1;
            boolean bl = _lessThan = counter < _minus;
            if (_lessThan) {
                this.appendToBuffer(",");
                this.appendSpaceToBuffer();
            }
        };
        IterableExtensions.forEach((Iterable)it.fragments(), (Procedures.Procedure2)_function);
        return false;
    }

    public boolean visit(VariableDeclarationFragment it) {
        boolean _tripleNotEquals;
        it.getName().accept((ASTVisitor)this);
        Expression _initializer = it.getInitializer();
        boolean bl = _tripleNotEquals = _initializer != null;
        if (_tripleNotEquals) {
            this.appendToBuffer("=");
            Type type = this._aSTFlattenerUtils.findDeclaredType(it.getName());
            if (this._aSTFlattenerUtils.needPrimitiveCast(type) && !this.hasDimensions(it)) {
                this.appendToBuffer("(");
                it.getInitializer().accept((ASTVisitor)this);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(") as ");
                _builder.append((Object)type);
                this.appendToBuffer(_builder.toString());
            } else {
                it.getInitializer().accept((ASTVisitor)this);
            }
        } else {
            ASTNode _parent_1;
            boolean _isFinal;
            ASTNode _parent = it.getParent();
            if (_parent instanceof VariableDeclarationStatement && (_isFinal = this._aSTFlattenerUtils.isFinal(((VariableDeclarationStatement)(_parent_1 = it.getParent())).modifiers()))) {
                this.appendToBuffer("/* FIXME empty initializer for final variable is not supported */");
                this.addProblem((ASTNode)it, "Empty initializer for final variables is not supported.");
            }
        }
        return false;
    }

    public boolean hasDimensions(VariableDeclarationFragment fragment) {
        boolean _java8orHigher = this.java8orHigher();
        if (_java8orHigher) {
            List<ASTNode> dimensions = this._aSTFlattenerUtils.genericChildListProperty((ASTNode)fragment, "extraDimensions2");
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(dimensions);
            return !_isNullOrEmpty;
        }
        int _extraDimensions = fragment.getExtraDimensions();
        return _extraDimensions > 0;
    }

    public boolean visit(ConditionalExpression node) {
        if (this.conditionalExpressionsAllowed) {
            String _string = null;
            if (node != null) {
                _string = node.toString();
            }
            this.appendToBuffer(_string);
        } else {
            this.appendToBuffer("if ");
            boolean _startsWith = node.getExpression().toString().startsWith("(");
            if (_startsWith) {
                node.getExpression().accept((ASTVisitor)this);
                this.appendToBuffer(" ");
            } else {
                this.appendToBuffer("(");
                node.getExpression().accept((ASTVisitor)this);
                this.appendToBuffer(") ");
            }
            node.getThenExpression().accept((ASTVisitor)this);
            this.appendToBuffer(" else ");
            node.getElseExpression().accept((ASTVisitor)this);
        }
        this.appendSpaceToBuffer();
        return false;
    }

    private StringBuffer appendExtraDimensions(int extraDimensions) {
        String _multiply = this.operator_multiply("[]", extraDimensions);
        return this.appendToBuffer(_multiply);
    }

    public boolean visit(VariableDeclarationStatement it) {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)it.modifiers(), Annotation.class));
        boolean hasAnnotations = !_isEmpty;
        Consumer<VariableDeclarationFragment> _function = frag -> {
            boolean _not;
            if (hasAnnotations) {
                this.appendToBuffer("/*FIXME Cannot add Annotation to Variable declaration. Java code: ");
            }
            Functions.Function1 _function_1 = it_1 -> {
                StringBuffer _xifexpression = null;
                if (hasAnnotations) {
                    StringBuffer _xblockexpression = null;
                    this.appendToBuffer("*/");
                    _xifexpression = _xblockexpression = this.appendLineWrapToBuffer();
                }
                return _xifexpression;
            };
            this.appendModifiers((ASTNode)it, it.modifiers(), (Functions.Function1<? super ASTNode, ? extends StringBuffer>)_function_1);
            this.appendToBuffer(this._aSTFlattenerUtils.handleVariableDeclaration(it.modifiers()));
            this.appendSpaceToBuffer();
            boolean _isMissingType = this.isMissingType(it.getType());
            boolean bl = _not = !_isMissingType;
            if (_not) {
                it.getType().accept((ASTVisitor)this);
            }
            this.appendExtraDimensions(frag.getExtraDimensions());
            this.appendSpaceToBuffer();
            frag.accept((ASTVisitor)this);
            this.appendSpaceToBuffer();
        };
        it.fragments().forEach(_function);
        return false;
    }

    public boolean isMissingType(Type type) {
        boolean _isSimpleName;
        if (type instanceof SimpleType && (_isSimpleName = ((SimpleType)type).getName().isSimpleName())) {
            Name _name = ((SimpleType)type).getName();
            return "MISSING".equals(((SimpleName)_name).getIdentifier());
        }
        return false;
    }

    public void visitAllSeparatedByComma(Iterable<? extends ASTNode> iterable) {
        this.visitAll(iterable, ", ");
    }

    public void visitAll(Iterable<? extends ASTNode> iterable) {
        boolean _isEmpty = IterableExtensions.isEmpty(iterable);
        if (_isEmpty) {
            return;
        }
        this.visitAll(iterable, null);
    }

    public void visitAll(Iterable<? extends ASTNode> iterable, String separator) {
        Procedures.Procedure2 _function = (node, counter) -> {
            node.accept((ASTVisitor)this);
            if (separator != null && counter < IterableExtensions.size((Iterable)iterable) - 1) {
                this.appendToBuffer(separator);
            }
        };
        IterableExtensions.forEach(iterable, (Procedures.Procedure2)_function);
    }

    public void appendTypeParameters(Iterable<TypeParameter> iterable) {
        boolean _isEmpty = IterableExtensions.isEmpty(iterable);
        if (_isEmpty) {
            return;
        }
        this.appendToBuffer("<");
        this.visitAllSeparatedByComma(iterable);
        this.appendToBuffer(">");
    }

    public boolean visit(MethodDeclaration it) {
        boolean _tripleNotEquals_2;
        boolean _not_4;
        boolean _isConstructor_2;
        boolean _not_2;
        boolean _isEmpty;
        boolean _not_1;
        boolean _isConstructor;
        ASTNode _parent;
        Functions.Function1 _function;
        boolean _tripleNotEquals;
        Javadoc _javadoc = it.getJavadoc();
        boolean bl = _tripleNotEquals = _javadoc != null;
        if (_tripleNotEquals) {
            it.getJavadoc().accept((ASTVisitor)this);
        }
        Functions.Function1 afterAnnotationProcessingCallback = _function = node -> {
            StringBuffer _xifexpression = null;
            if (node instanceof MethodDeclaration) {
                boolean _not;
                StringBuffer _xifexpression_1 = null;
                boolean _isConstructor = ((MethodDeclaration)node).isConstructor();
                boolean bl = _not = !_isConstructor;
                if (_not) {
                    StringBuffer _xifexpression_2 = null;
                    boolean _isOverrideMethod = this._aSTFlattenerUtils.isOverrideMethod((MethodDeclaration)node);
                    _xifexpression_2 = _isOverrideMethod ? this.appendToBuffer("override ") : this.appendToBuffer("def ");
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        };
        this.appendModifiers((ASTNode)it, it.modifiers(), (Functions.Function1<? super ASTNode, ? extends StringBuffer>)afterAnnotationProcessingCallback);
        boolean _isPackageVisibility = this._aSTFlattenerUtils.isPackageVisibility(Iterables.filter((Iterable)it.modifiers(), Modifier.class));
        if (_isPackageVisibility && (_parent = it.getParent()) instanceof TypeDeclaration) {
            boolean _not;
            ASTNode _parent_1 = it.getParent();
            boolean _isInterface = ((TypeDeclaration)_parent_1).isInterface();
            boolean bl2 = _not = !_isInterface;
            if (_not) {
                this.appendToBuffer("package ");
            }
        }
        if (_isConstructor = it.isConstructor()) {
            this.appendToBuffer(" new");
        }
        boolean bl3 = _not_1 = !(_isEmpty = it.typeParameters().isEmpty());
        if (_not_1) {
            boolean _isConstructor_1 = it.isConstructor();
            if (_isConstructor_1) {
                this.addProblem((ASTNode)it, "Type parameters for constructors are not supported");
            }
            this.appendTypeParameters(it.typeParameters());
        }
        boolean bl4 = _not_2 = !(_isConstructor_2 = it.isConstructor());
        if (_not_2) {
            boolean _tripleNotEquals_1;
            Type _returnType2 = it.getReturnType2();
            boolean bl5 = _tripleNotEquals_1 = _returnType2 != null;
            if (_tripleNotEquals_1) {
                it.getReturnType2().accept((ASTVisitor)this);
            } else {
                this.appendToBuffer("void");
            }
            this.appendSpaceToBuffer();
            it.getName().accept((ASTVisitor)this);
        }
        this.appendToBuffer("(");
        Consumer<SingleVariableDeclaration> _function_1 = p -> {
            Boolean _isAssignedInBody = this._aSTFlattenerUtils.isAssignedInBody(it.getBody(), p.getName());
            if (_isAssignedInBody.booleanValue()) {
                Expression firstInBody;
                if (it.isConstructor() && !it.getBody().statements().isEmpty() && (firstInBody = (Expression)IterableExtensions.head(this._aSTFlattenerUtils.findAssignmentsInBlock(it.getBody(), (VariableDeclaration)p))) != null) {
                    boolean _tripleNotEquals_2;
                    ConstructorInvocation _findParentOfType = this._aSTFlattenerUtils.findParentOfType((ASTNode)firstInBody, ConstructorInvocation.class);
                    boolean bl = _tripleNotEquals_2 = _findParentOfType != null;
                    if (_tripleNotEquals_2) {
                        this.addProblem((ASTNode)p, "Final parameter modified in constructor call");
                    } else {
                        boolean _tripleNotEquals_3;
                        SuperConstructorInvocation _findParentOfType_1 = this._aSTFlattenerUtils.findParentOfType((ASTNode)firstInBody, SuperConstructorInvocation.class);
                        boolean bl2 = _tripleNotEquals_3 = _findParentOfType_1 != null;
                        if (_tripleNotEquals_3) {
                            this.addProblem((ASTNode)p, "Final parameter modified in super constructor call");
                        }
                    }
                }
                VariableDeclarationFragment varFrag = p.getAST().newVariableDeclarationFragment();
                varFrag.setName(p.getAST().newSimpleName(p.getName().toString()));
                AST _aST = p.getAST();
                SimpleName _name = p.getName();
                String _plus = _name + "_finalParam_";
                p.setName(_aST.newSimpleName(_plus));
                varFrag.setInitializer((Expression)p.getAST().newSimpleName(p.getName().toString()));
                VariableDeclarationStatement varDecl = p.getAST().newVariableDeclarationStatement(varFrag);
                ASTNode _createInstance = p.getAST().createInstance(SimpleType.class);
                Type typeCopy = (Type)_createInstance;
                varDecl.setType(typeCopy);
                it.getBody().statements().add(0, varDecl);
            }
        };
        ListExtensions.reverseView((List)it.parameters()).forEach(_function_1);
        this.visitAllSeparatedByComma(it.parameters());
        this.appendToBuffer(")");
        this.appendExtraDimensions(it.getExtraDimensions());
        List<Object> throwsTypes = CollectionLiterals.newArrayList();
        boolean _java8orHigher = this.java8orHigher();
        boolean _not_3 = !_java8orHigher;
        throwsTypes = _not_3 ? it.thrownExceptions() : this._aSTFlattenerUtils.genericChildListProperty((ASTNode)it, "thrownExceptionTypes");
        boolean _isEmpty_1 = throwsTypes.isEmpty();
        boolean bl6 = _not_4 = !_isEmpty_1;
        if (_not_4) {
            this.appendToBuffer(" throws ");
            this.visitAllSeparatedByComma(throwsTypes);
        }
        this.appendSpaceToBuffer();
        Block _body = it.getBody();
        boolean bl7 = _tripleNotEquals_2 = _body != null;
        if (_tripleNotEquals_2) {
            it.getBody().accept((ASTVisitor)this);
        } else {
            this.appendLineWrapToBuffer();
        }
        return false;
    }

    public boolean visit(SingleVariableDeclaration it) {
        boolean _tripleNotEquals;
        if (it.getParent() instanceof MethodDeclaration || it.getParent() instanceof CatchClause || it.getParent() instanceof EnhancedForStatement) {
            Functions.Function1 _function = it_1 -> it_1.isAnnotation();
            this.appendModifiers((ASTNode)it, IterableExtensions.filter((Iterable)Iterables.filter((Iterable)it.modifiers(), IExtendedModifier.class), (Functions.Function1)_function));
        } else {
            this.appendModifiers((ASTNode)it, it.modifiers());
        }
        it.getType().accept((ASTVisitor)this);
        this.appendExtraDimensions(it.getExtraDimensions());
        boolean _isVarargs = it.isVarargs();
        if (_isVarargs) {
            this.appendToBuffer("...");
        }
        this.appendSpaceToBuffer();
        it.getName().accept((ASTVisitor)this);
        Expression _initializer = it.getInitializer();
        boolean bl = _tripleNotEquals = _initializer != null;
        if (_tripleNotEquals) {
            this.appendToBuffer("=");
            it.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        boolean _isLambdaCase;
        boolean _tripleNotEquals;
        Expression _expression = node.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            node.getExpression().accept((ASTVisitor)this);
            this.appendToBuffer(".");
        }
        if (_isLambdaCase = this._aSTFlattenerUtils.isLambdaCase(node)) {
            boolean _not;
            if (this.fallBackStrategy) {
                this.appendToBuffer("(");
            }
            this.appendToBuffer("[");
            Object _get = node.getAnonymousClassDeclaration().bodyDeclarations().get(0);
            MethodDeclaration method = (MethodDeclaration)_get;
            boolean _isEmpty = method.parameters().isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                this.visitAllSeparatedByComma(method.parameters());
                this.appendToBuffer("|");
            } else if (this.fallBackStrategy) {
                this.appendToBuffer("|");
            }
            this.visitAll(method.getBody().statements());
            this.appendToBuffer("]");
            if (this.fallBackStrategy) {
                boolean _not_1;
                this.appendToBuffer(" as ");
                boolean _isEmpty_1 = node.typeArguments().isEmpty();
                boolean bl3 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    this.appendTypeParameters(node.typeArguments());
                }
                node.getType().accept((ASTVisitor)this);
                this.appendToBuffer(")");
            }
        } else {
            boolean _tripleNotEquals_1;
            boolean _not_2;
            this.appendToBuffer("new ");
            boolean _isEmpty_2 = node.typeArguments().isEmpty();
            boolean bl4 = _not_2 = !_isEmpty_2;
            if (_not_2) {
                this.appendTypeParameters(node.typeArguments());
            }
            node.getType().accept((ASTVisitor)this);
            this.appendToBuffer("(");
            Iterator it = node.arguments().iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                boolean _hasNext = it.hasNext();
                if (!_hasNext) continue;
                this.appendToBuffer(",");
            }
            this.appendToBuffer(")");
            AnonymousClassDeclaration _anonymousClassDeclaration = node.getAnonymousClassDeclaration();
            boolean bl5 = _tripleNotEquals_1 = _anonymousClassDeclaration != null;
            if (_tripleNotEquals_1) {
                node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(Block node) {
        ASTNode _root;
        boolean _not;
        this.appendToBuffer("{");
        this.increaseIndent();
        boolean _isEmpty = node.statements().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure2 _function = (child, counter) -> {
                this.appendLineWrapToBuffer();
                child.accept((ASTVisitor)this);
            };
            IterableExtensions.forEach((Iterable)node.statements(), (Procedures.Procedure2)_function);
        }
        if ((_root = node.getRoot()) instanceof CompilationUnit) {
            ASTNode _root_1 = node.getRoot();
            CompilationUnit cu = (CompilationUnit)_root_1;
            Functions.Function1 _function_1 = it -> {
                int _length;
                int _startPosition_1;
                int _plus;
                int _startPosition = it.getStartPosition();
                return _startPosition < (_plus = (_startPosition_1 = node.getStartPosition()) + (_length = node.getLength()));
            };
            Consumer<Comment> _function_2 = it -> {
                if (!(it instanceof LineComment)) {
                    this.appendLineWrapToBuffer();
                }
                it.accept((ASTVisitor)this);
                this.assignedComments.add((Comment)it);
            };
            IterableExtensions.filter(this.unAssignedComments(cu), (Functions.Function1)_function_1).forEach(_function_2);
        }
        this.decreaseIndent();
        this.appendLineWrapToBuffer();
        this.appendToBuffer("}");
        return false;
    }

    public boolean visit(CastExpression node) {
        boolean parantesis;
        ASTNode _parent = node.getParent();
        boolean bl = parantesis = !(_parent instanceof Assignment);
        if (parantesis) {
            this.appendToBuffer("(");
        }
        node.getExpression().accept((ASTVisitor)this);
        this.appendToBuffer(" as ");
        node.getType().accept((ASTVisitor)this);
        if (parantesis) {
            this.appendToBuffer(")");
        }
        return false;
    }

    public boolean visit(ExpressionStatement it) {
        it.getExpression().accept((ASTVisitor)this);
        this.appendSpaceToBuffer();
        return false;
    }

    public boolean visit(MethodInvocation it) {
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        Expression _expression = it.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            it.getExpression().accept((ASTVisitor)this);
            if (this.fallBackStrategy && this._aSTFlattenerUtils.isStaticMemberCall(it)) {
                this.appendToBuffer("::");
            } else {
                this.appendToBuffer(".");
            }
        }
        boolean bl2 = _not = !(_isEmpty = it.typeArguments().isEmpty());
        if (_not) {
            this.appendTypeParameters(it.typeArguments());
        }
        it.getName().accept((ASTVisitor)this);
        this.appendToBuffer("(");
        this.visitAllSeparatedByComma(it.arguments());
        this.appendToBuffer(")");
        return false;
    }

    public boolean visit(ForStatement it) {
        boolean _tripleNotEquals;
        this.appendToBuffer("for (");
        this.visitAll(it.initializers());
        this.appendToBuffer("; ");
        Expression _expression = it.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            it.getExpression().accept((ASTVisitor)this);
        }
        this.appendToBuffer("; ");
        this.visitAll(it.updaters());
        this.appendToBuffer(") ");
        it.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(NullLiteral it) {
        this.appendToBuffer("null");
        return false;
    }

    public boolean visit(ThisExpression it) {
        boolean _tripleNotEquals;
        Name _qualifier = it.getQualifier();
        boolean bl = _tripleNotEquals = _qualifier != null;
        if (_tripleNotEquals) {
            it.getQualifier().accept((ASTVisitor)this);
            this.appendToBuffer(".");
        }
        this.appendToBuffer("this");
        return false;
    }

    public boolean visit(IfStatement node) {
        boolean _tripleNotEquals;
        this.appendToBuffer("if (");
        node.getExpression().accept((ASTVisitor)this);
        this.appendToBuffer(") ");
        node.getThenStatement().accept((ASTVisitor)this);
        Statement _elseStatement = node.getElseStatement();
        boolean bl = _tripleNotEquals = _elseStatement != null;
        if (_tripleNotEquals) {
            this.appendToBuffer(" else ");
            node.getElseStatement().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(FieldAccess it) {
        it.getExpression().accept((ASTVisitor)this);
        if (this.fallBackStrategy && this._aSTFlattenerUtils.isStaticMemberCall(it)) {
            this.appendToBuffer("::");
        } else {
            this.appendToBuffer(".");
        }
        it.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(InfixExpression node) {
        boolean useRichString = this._aSTFlattenerUtils.canConvertToRichText(node);
        if (useRichString) {
            boolean firstEntrance;
            ASTNode _parent = node.getParent();
            boolean bl = firstEntrance = !(_parent instanceof InfixExpression);
            if (firstEntrance) {
                this.appendToBuffer("'''");
            }
            this.appendAsRichString(node.getLeftOperand());
            this.appendAsRichString(node.getRightOperand());
            Functions.Function2 _function = (prevExpr, currExpr) -> {
                this.appendAsRichString((Expression)currExpr);
                return currExpr;
            };
            IterableExtensions.fold((Iterable)node.extendedOperands(), (Object)node.getRightOperand(), (Functions.Function2)_function);
            if (firstEntrance) {
                this.appendToBuffer("'''");
                if (this.fallBackStrategy) {
                    this.appendToBuffer(".toString");
                }
            }
        } else {
            boolean _notEquals;
            node.getLeftOperand().accept((ASTVisitor)this);
            InfixExpression.Operator operator = node.getOperator();
            this.handleInfixRightSide(node, operator, node.getRightOperand());
            List extendedOperands = node.extendedOperands();
            int _size = extendedOperands.size();
            boolean bl = _notEquals = _size != 0;
            if (_notEquals) {
                Consumer<Expression> _function_1 = e -> this.handleInfixRightSide(node, operator, (Expression)e);
                extendedOperands.forEach(_function_1);
            }
        }
        return false;
    }

    public StringBuffer handleInfixRightSide(InfixExpression infixParent, InfixExpression.Operator operator, Expression rightSide) {
        StringBuffer _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)operator, (Object)InfixExpression.Operator.XOR)) {
            _matched = true;
            StringBuffer _xifexpression = null;
            boolean _isBooleanInvolved = this.isBooleanInvolved(infixParent);
            if (_isBooleanInvolved) {
                StringBuffer _xblockexpression = null;
                this.appendToBuffer(".xor(");
                rightSide.accept((ASTVisitor)this);
                _xifexpression = _xblockexpression = this.appendToBuffer(")");
            } else {
                StringBuffer _xblockexpression_1 = null;
                this.appendToBuffer(".bitwiseXor(");
                rightSide.accept((ASTVisitor)this);
                _xifexpression = _xblockexpression_1 = this.appendToBuffer(")");
            }
            _switchResult = _xifexpression;
        }
        if (!_matched) {
            if (Objects.equal((Object)operator, (Object)InfixExpression.Operator.AND)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)operator, (Object)InfixExpression.Operator.OR)) {
                _matched = true;
            }
            if (_matched) {
                boolean _not;
                StringBuffer _xifexpression_1 = null;
                boolean _isBooleanInvolved_1 = this.isBooleanInvolved(infixParent);
                boolean bl = _not = !_isBooleanInvolved_1;
                if (_not) {
                    StringBuffer _xblockexpression_2 = null;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(".bitwise");
                    String _xifexpression_2 = null;
                    boolean _equals = Objects.equal((Object)operator, (Object)InfixExpression.Operator.AND);
                    _xifexpression_2 = _equals ? "And" : "Or";
                    _builder.append(_xifexpression_2);
                    _builder.append("(");
                    this.appendToBuffer(_builder.toString());
                    rightSide.accept((ASTVisitor)this);
                    _xifexpression_1 = _xblockexpression_2 = this.appendToBuffer(")");
                } else {
                    this.appendSpaceToBuffer();
                    String _string = operator.toString();
                    String _multiply = this.operator_multiply(_string, 2);
                    this.appendToBuffer(_multiply);
                    this.appendSpaceToBuffer();
                    rightSide.accept((ASTVisitor)this);
                }
                _switchResult = _xifexpression_1;
            }
        }
        if (!_matched && Objects.equal((Object)operator, (Object)InfixExpression.Operator.EQUALS)) {
            _matched = true;
            this.appendToBuffer(" === ");
            rightSide.accept((ASTVisitor)this);
        }
        if (!_matched && Objects.equal((Object)operator, (Object)InfixExpression.Operator.NOT_EQUALS)) {
            _matched = true;
            this.appendToBuffer(" !== ");
            rightSide.accept((ASTVisitor)this);
        }
        if (!_matched) {
            this.appendSpaceToBuffer();
            this.appendToBuffer(operator.toString());
            this.appendSpaceToBuffer();
            rightSide.accept((ASTVisitor)this);
        }
        return _switchResult;
    }

    public boolean isBooleanInvolved(InfixExpression it) {
        return this.isBooleanType(it.getLeftOperand()) || this.isBooleanType(it.getRightOperand());
    }

    public boolean isBooleanType(Expression expression) {
        Type declType;
        if (expression instanceof BooleanLiteral) {
            return true;
        }
        if (expression instanceof SimpleName && (declType = this._aSTFlattenerUtils.findDeclaredType((SimpleName)expression)) != null) {
            boolean _matched = false;
            boolean _isPrimitiveType = declType.isPrimitiveType();
            if (_isPrimitiveType) {
                _matched = true;
                PrimitiveType.Code _primitiveTypeCode = ((PrimitiveType)declType).getPrimitiveTypeCode();
                return Objects.equal((Object)_primitiveTypeCode, (Object)PrimitiveType.BOOLEAN);
            }
        }
        return false;
    }

    public void appendAsRichString(Expression expression) {
        if (expression instanceof StringLiteral) {
            this.appendToBuffer(this.richTextValue((StringLiteral)expression));
        } else {
            boolean stringConcat;
            boolean bl = stringConcat = expression instanceof InfixExpression && this._aSTFlattenerUtils.canConvertToRichText((InfixExpression)expression);
            if (!stringConcat) {
                this.appendToBuffer("\u00ab");
            }
            expression.accept((ASTVisitor)this);
            if (!stringConcat) {
                this.appendToBuffer("\u00bb");
            }
        }
    }

    public String richTextValue(StringLiteral literal) {
        String value = literal.getLiteralValue();
        boolean _endsWith = value.endsWith("'");
        if (_endsWith) {
            value = value.concat("\u00ab\u00bb");
        }
        return value;
    }

    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.appendToBuffer(" instanceof ");
        node.getRightOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        boolean _tripleNotEquals;
        this.appendToBuffer("return");
        Expression _expression = node.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            this.appendSpaceToBuffer();
            node.getExpression().accept((ASTVisitor)this);
            this.appendSpaceToBuffer();
        } else {
            boolean isIfElse;
            ASTNode parent = node.getParent();
            boolean bl2 = isIfElse = parent instanceof IfStatement && ((IfStatement)parent).getElseStatement() != null;
            if (!isIfElse && !(parent instanceof SwitchStatement)) {
                this.appendToBuffer(";");
            }
        }
        return false;
    }

    public boolean visit(BlockComment node) {
        if (this.javaSources != null) {
            this.appendToBuffer(this.commentContent((Comment)node));
            boolean _shouldWrap = this.shouldWrap(node);
            if (_shouldWrap) {
                this.appendLineWrapToBuffer();
            }
        }
        return false;
    }

    private boolean shouldWrap(BlockComment comment) {
        char charAfterComment;
        int _length_1;
        boolean _lessThan;
        int _length;
        int _startPosition = comment.getStartPosition();
        int index = _startPosition + (_length = comment.getLength());
        boolean bl = _lessThan = index < (_length_1 = this.javaSources.length());
        return _lessThan && ((charAfterComment = this.javaSources.charAt(index)) == Character.valueOf('\n').charValue() || charAfterComment == Character.valueOf('\r').charValue());
    }

    private String commentContent(Comment comment) {
        int _startPosition = comment.getStartPosition();
        int _startPosition_1 = comment.getStartPosition();
        int _length = comment.getLength();
        int _plus = _startPosition_1 + _length;
        return this.javaSources.substring(_startPosition, _plus);
    }

    public boolean visit(LineComment node) {
        if (this.javaSources != null) {
            this.appendToBuffer(this.commentContent((Comment)node));
        }
        this.appendLineWrapToBuffer();
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        this.appendToBuffer("(");
        node.getExpression().accept((ASTVisitor)this);
        this.appendToBuffer(")");
        return false;
    }

    public boolean visit(PostfixExpression node) {
        AST dummyAST = AST.newAST((int)node.getAST().apiLevel());
        PostfixExpression.Operator pfOperator = node.getOperator();
        Expression _operand = node.getOperand();
        if (_operand instanceof ArrayAccess) {
            Expression _operand_1 = node.getOperand();
            ArrayAccess pfOperand = (ArrayAccess)_operand_1;
            if (Objects.equal((Object)pfOperator, (Object)PostfixExpression.Operator.INCREMENT) || Objects.equal((Object)pfOperator, (Object)PostfixExpression.Operator.DECREMENT)) {
                String arrayName = this.computeArrayName(pfOperand);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("_postIndx_");
                _builder.append(arrayName);
                String idxName = _builder.toString();
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("_postVal_");
                _builder_1.append(arrayName);
                String tempVarName = _builder_1.toString();
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("{ var ");
                _builder_2.append(idxName);
                _builder_2.append("=");
                this.appendToBuffer(_builder_2.toString());
                pfOperand.getIndex().accept((ASTVisitor)this);
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append(" ");
                _builder_3.append("var  ");
                this.appendToBuffer(_builder_3.toString());
                VariableDeclarationFragment varDeclaration = dummyAST.newVariableDeclarationFragment();
                varDeclaration.setName(dummyAST.newSimpleName(tempVarName));
                ASTNode _copySubtree = ASTNode.copySubtree((AST)dummyAST, (ASTNode)pfOperand);
                ArrayAccess arrayAccess = (ArrayAccess)_copySubtree;
                arrayAccess.setIndex((Expression)dummyAST.newSimpleName(idxName));
                varDeclaration.setInitializer((Expression)arrayAccess);
                varDeclaration.accept((ASTVisitor)this);
                InfixExpression infixOp = dummyAST.newInfixExpression();
                infixOp.setLeftOperand((Expression)dummyAST.newSimpleName(tempVarName));
                PostfixExpression.Operator _operator = node.getOperator();
                boolean _equals = Objects.equal((Object)_operator, (Object)PostfixExpression.Operator.DECREMENT);
                if (_equals) {
                    infixOp.setOperator(InfixExpression.Operator.MINUS);
                } else {
                    infixOp.setOperator(InfixExpression.Operator.PLUS);
                }
                infixOp.setRightOperand((Expression)dummyAST.newNumberLiteral("1"));
                Assignment assigment = dummyAST.newAssignment();
                ASTNode _copySubtree_1 = ASTNode.copySubtree((AST)dummyAST, (ASTNode)pfOperand);
                ArrayAccess writeArray = (ArrayAccess)_copySubtree_1;
                writeArray.setIndex((Expression)dummyAST.newSimpleName(idxName));
                assigment.setLeftHandSide((Expression)writeArray);
                ASTNode _copySubtree_2 = ASTNode.copySubtree((AST)dummyAST, (ASTNode)infixOp);
                assigment.setRightHandSide((Expression)_copySubtree_2);
                assigment.accept((ASTVisitor)this);
                StringConcatenation _builder_4 = new StringConcatenation();
                String _xifexpression = null;
                boolean _needsReturnValue = this._aSTFlattenerUtils.needsReturnValue((ASTNode)node);
                if (_needsReturnValue) {
                    _xifexpression = tempVarName;
                }
                _builder_4.append(_xifexpression);
                _builder_4.append(" }");
                this.appendToBuffer(_builder_4.toString());
                return false;
            }
        }
        node.getOperand().accept((ASTVisitor)this);
        this.appendToBuffer(pfOperator.toString());
        return false;
    }

    public boolean visit(PrefixExpression node) {
        Expression operand = node.getOperand();
        PrefixExpression.Operator _operator = node.getOperator();
        boolean _matched = false;
        if (Objects.equal((Object)_operator, (Object)PrefixExpression.Operator.DECREMENT)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_operator, (Object)PrefixExpression.Operator.INCREMENT)) {
            _matched = true;
        }
        if (_matched) {
            if (operand instanceof ArrayAccess) {
                String arrayName = this.computeArrayName((ArrayAccess)operand);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("_tPreInx_");
                _builder.append(arrayName);
                String idxName = _builder.toString();
                String op = "-";
                PrefixExpression.Operator _operator_1 = node.getOperator();
                boolean _equals = Objects.equal((Object)_operator_1, (Object)PrefixExpression.Operator.INCREMENT);
                if (_equals) {
                    op = "+";
                }
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("{val ");
                _builder_1.append(idxName);
                _builder_1.append("=");
                this.appendToBuffer(_builder_1.toString());
                ((ArrayAccess)operand).getIndex().accept((ASTVisitor)this);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(" ");
                _builder_2.append("val ");
                _builder_2.append(idxName, " ");
                _builder_2.append("_res=");
                _builder_2.append(arrayName, " ");
                _builder_2.append(".get(");
                _builder_2.append(idxName, " ");
                _builder_2.append(")");
                _builder_2.append(op, " ");
                _builder_2.append("1");
                this.appendToBuffer(_builder_2.toString());
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append(" ");
                _builder_3.append(arrayName, " ");
                _builder_3.append(".set(");
                _builder_3.append(idxName, " ");
                _builder_3.append(", ");
                _builder_3.append(idxName, " ");
                _builder_3.append("_res)  ");
                _builder_3.append(idxName, " ");
                _builder_3.append("_res}");
                this.appendToBuffer(_builder_3.toString());
                return false;
            }
            AST dummyAST = AST.newAST((int)node.getAST().apiLevel());
            Assignment assigment = dummyAST.newAssignment();
            InfixExpression infixOp = dummyAST.newInfixExpression();
            ASTNode _copySubtree = ASTNode.copySubtree((AST)dummyAST, (ASTNode)operand);
            infixOp.setLeftOperand((Expression)_copySubtree);
            PrefixExpression.Operator _operator_2 = node.getOperator();
            boolean _equals_1 = Objects.equal((Object)_operator_2, (Object)PrefixExpression.Operator.DECREMENT);
            if (_equals_1) {
                infixOp.setOperator(InfixExpression.Operator.MINUS);
            } else {
                infixOp.setOperator(InfixExpression.Operator.PLUS);
            }
            infixOp.setRightOperand((Expression)dummyAST.newNumberLiteral("1"));
            ASTNode _copySubtree_1 = ASTNode.copySubtree((AST)dummyAST, (ASTNode)operand);
            Expression leftSide = (Expression)_copySubtree_1;
            assigment.setLeftHandSide(leftSide);
            assigment.setRightHandSide((Expression)infixOp);
            this.appendToBuffer("{");
            Type type = null;
            if (operand instanceof SimpleName) {
                type = this._aSTFlattenerUtils.findDeclaredType((SimpleName)operand);
            }
            this.handleAssignment(assigment, (ASTNode)leftSide, type);
            this.appendToBuffer("}");
            return false;
        }
        if (!_matched && Objects.equal((Object)_operator, (Object)PrefixExpression.Operator.COMPLEMENT)) {
            _matched = true;
            node.getOperand().accept((ASTVisitor)this);
            this.appendToBuffer(".bitwiseNot");
        }
        if (!_matched) {
            this.appendToBuffer(node.getOperator().toString());
            node.getOperand().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.appendToBuffer("@");
        node.getTypeName().accept((ASTVisitor)this);
        this.appendToBuffer("(");
        node.getValue().accept((ASTVisitor)this);
        this.appendToBuffer(")");
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        Expression _expression = node.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            node.getExpression().accept((ASTVisitor)this);
            this.appendToBuffer(".");
        }
        boolean bl2 = _not = !(_isEmpty = node.typeArguments().isEmpty());
        if (_not) {
            this.appendTypeParameters(node.typeArguments());
        }
        this.appendToBuffer("super(");
        this.visitAllSeparatedByComma(node.arguments());
        this.appendToBuffer(")");
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        boolean _tripleNotEquals;
        Name _qualifier = node.getQualifier();
        boolean bl = _tripleNotEquals = _qualifier != null;
        if (_tripleNotEquals) {
            node.getQualifier().accept((ASTVisitor)this);
            this.appendToBuffer(".");
        }
        this.appendToBuffer("super.");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        boolean _not;
        boolean _tripleNotEquals;
        Name _qualifier = node.getQualifier();
        boolean bl = _tripleNotEquals = _qualifier != null;
        if (_tripleNotEquals) {
            node.getQualifier().accept((ASTVisitor)this);
            this.appendToBuffer(".");
        }
        this.appendToBuffer("super.");
        boolean _isEmpty = node.typeArguments().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            this.appendTypeParameters(node.typeArguments());
        }
        node.getName().accept((ASTVisitor)this);
        this.appendToBuffer("(");
        this.visitAllSeparatedByComma(node.arguments());
        this.appendToBuffer(")");
        return false;
    }

    public boolean visit(TagElement node) {
        boolean _tripleNotEquals;
        boolean _isNested = node.isNested();
        if (_isNested) {
            this.appendToBuffer("{");
        } else {
            this.appendLineWrapToBuffer();
            this.appendToBuffer(" * ");
        }
        boolean previousRequiresWhiteSpace = false;
        String _tagName = node.getTagName();
        boolean bl = _tripleNotEquals = _tagName != null;
        if (_tripleNotEquals) {
            this.appendToBuffer(node.getTagName());
            previousRequiresWhiteSpace = true;
        }
        boolean previousRequiresNewLine = false;
        for (ASTNode e : node.fragments()) {
            boolean currentIncludesWhiteSpace = e instanceof TextElement;
            if (previousRequiresNewLine && currentIncludesWhiteSpace) {
                this.appendLineWrapToBuffer();
                this.appendToBuffer(" * ");
            }
            previousRequiresNewLine = currentIncludesWhiteSpace;
            if (previousRequiresWhiteSpace && !currentIncludesWhiteSpace) {
                this.appendSpaceToBuffer();
            }
            e.accept((ASTVisitor)this);
            previousRequiresWhiteSpace = !currentIncludesWhiteSpace && !(e instanceof TagElement);
        }
        boolean _isNested_1 = node.isNested();
        if (_isNested_1) {
            this.appendToBuffer("}");
        }
        return false;
    }

    public boolean visit(TextElement node) {
        this.appendToBuffer(node.getText());
        return false;
    }

    public boolean visit(TypeLiteral node) {
        if (this.fallBackStrategy) {
            this.appendToBuffer("typeof(");
        }
        node.getType().accept((ASTVisitor)this);
        if (this.fallBackStrategy) {
            this.appendToBuffer(")");
        }
        return false;
    }

    public boolean visit(ThrowStatement node) {
        boolean _not;
        this.appendToBuffer("throw ");
        node.getExpression().accept((ASTVisitor)this);
        ASTNode _parent = node.getParent();
        boolean bl = _not = !(_parent instanceof Block);
        if (_not) {
            this.appendToBuffer(";");
        }
        return false;
    }

    public boolean visit(TryStatement node) {
        boolean _tripleNotEquals;
        boolean _not;
        this.appendToBuffer("try ");
        List<ASTNode> resources = this._aSTFlattenerUtils.genericChildListProperty((ASTNode)node, "resources");
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(resources);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this.appendToBuffer("(");
            for (ASTNode child : resources) {
                child.accept((ASTVisitor)this);
            }
            this.appendToBuffer(")");
            this.addProblem((ASTNode)node, "Try with resource is not yet supported.");
        }
        node.getBody().accept((ASTVisitor)this);
        Consumer<Object> _function = it -> ((ASTNode)it).accept((ASTVisitor)this);
        node.catchClauses().forEach(_function);
        Block _finally = node.getFinally();
        boolean bl2 = _tripleNotEquals = _finally != null;
        if (_tripleNotEquals) {
            this.appendToBuffer(" finally ");
            node.getFinally().accept((ASTVisitor)this);
        } else {
            this.appendLineWrapToBuffer();
        }
        return false;
    }

    public boolean visit(TypeParameter node) {
        boolean _not;
        node.getName().accept((ASTVisitor)this);
        boolean _isEmpty = node.typeBounds().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.appendToBuffer(" extends ");
            Iterator _it = node.typeBounds().iterator();
            while (_it.hasNext()) {
                Type t = (Type)_it.next();
                t.accept((ASTVisitor)this);
                boolean _hasNext = _it.hasNext();
                if (!_hasNext) continue;
                this.appendToBuffer(" & ");
            }
        }
        return false;
    }

    public boolean visit(NumberLiteral node) {
        Object value = node.getToken();
        if (((String)value).startsWith("0x") || ((String)value).startsWith("0X")) {
            int binExponent;
            int _length = ((String)value).length();
            int _minus = _length - 1;
            char lastChar = ((String)value).charAt(_minus);
            String _lowerCase = Character.valueOf(lastChar).toString().toLowerCase();
            boolean _equals = Objects.equal((Object)"l", (Object)_lowerCase);
            if (_equals) {
                int _length_1 = ((String)value).length();
                int _minus_1 = _length_1 - 1;
                String _substring = ((String)value).substring(0, _minus_1);
                String _plus = _substring + "#";
                String _plus_1 = _plus + Character.valueOf(lastChar);
                value = _plus_1;
            }
            if ((binExponent = ((String)value).indexOf("p")) >= 2) {
                boolean _endsWith = ((String)value).endsWith("f");
                if (_endsWith) {
                    String _string = Float.valueOf((String)value).toString();
                    String _plus_2 = _string + "f";
                    value = _plus_2;
                } else {
                    value = Double.valueOf((String)value).toString();
                }
            }
        }
        this.appendToBuffer((String)value);
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        this.appendToBuffer("@");
        node.getTypeName().accept((ASTVisitor)this);
        this.appendToBuffer("(");
        this.visitAllSeparatedByComma(node.values());
        this.appendToBuffer(")");
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Character.valueOf(");
        String _escapedValue = node.getEscapedValue();
        _builder.append(_escapedValue);
        _builder.append(").charValue");
        this.appendToBuffer(_builder.toString());
        return false;
    }

    public boolean visit(WildcardType node) {
        this.appendToBuffer("?");
        Type bound = node.getBound();
        if (bound != null) {
            boolean _isUpperBound = node.isUpperBound();
            if (_isUpperBound) {
                this.appendToBuffer(" extends ");
            } else {
                this.appendToBuffer(" super ");
            }
            bound.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(MemberValuePair node) {
        node.getName().accept((ASTVisitor)this);
        this.appendToBuffer("=");
        node.getValue().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(WhileStatement node) {
        this.appendToBuffer("while (");
        node.getExpression().accept((ASTVisitor)this);
        this.appendToBuffer(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        boolean _tripleNotEquals;
        Javadoc _javadoc = node.getJavadoc();
        boolean bl = _tripleNotEquals = _javadoc != null;
        if (_tripleNotEquals) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.appendModifiers((ASTNode)node, node.modifiers());
        this.appendToBuffer("annotation ");
        node.getName().accept((ASTVisitor)this);
        this.appendToBuffer(" {");
        this.appendLineWrapToBuffer();
        this.visitAll(node.bodyDeclarations());
        this.appendToBuffer("}");
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Javadoc _javadoc = node.getJavadoc();
        boolean bl = _tripleNotEquals = _javadoc != null;
        if (_tripleNotEquals) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.appendModifiers((ASTNode)node, node.modifiers());
        node.getType().accept((ASTVisitor)this);
        this.appendSpaceToBuffer();
        node.getName().accept((ASTVisitor)this);
        Expression _default = node.getDefault();
        boolean bl2 = _tripleNotEquals_1 = _default != null;
        if (_tripleNotEquals_1) {
            this.appendToBuffer(" = ");
            node.getDefault().accept((ASTVisitor)this);
        }
        this.appendLineWrapToBuffer();
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.appendToBuffer("{");
        this.increaseIndent();
        this.appendLineWrapToBuffer();
        this.visitAll(node.bodyDeclarations());
        this.decreaseIndent();
        this.appendToBuffer("}");
        return false;
    }

    public boolean visit(ArrayAccess node) {
        Expression _index = node.getIndex();
        if (_index instanceof NumberLiteral) {
            node.getArray().accept((ASTVisitor)this);
            this.appendToBuffer(".get(");
            node.getIndex().accept((ASTVisitor)this);
            this.appendToBuffer(")");
        } else {
            String arrayname = this.computeArrayName(node);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{val _rdIndx_");
            _builder.append(arrayname);
            _builder.append("=");
            this.appendToBuffer(_builder.toString());
            node.getIndex().accept((ASTVisitor)this);
            this.appendSpaceToBuffer();
            node.getArray().accept((ASTVisitor)this);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".get(_rdIndx_");
            _builder_1.append(arrayname);
            _builder_1.append(")}");
            this.appendToBuffer(_builder_1.toString());
        }
        return false;
    }

    public String computeArrayName(ArrayAccess node) {
        Expression _array;
        Object _switchResult = null;
        Expression array = _array = node.getArray();
        boolean _matched = false;
        if (array instanceof SimpleName) {
            _matched = true;
            _switchResult = ((SimpleName)array).getIdentifier();
        }
        if (!_matched && array instanceof MethodInvocation) {
            _matched = true;
            _switchResult = ((MethodInvocation)array).getName().getIdentifier();
        }
        if (!_matched && array instanceof ArrayAccess) {
            _matched = true;
            String _computeArrayName = this.computeArrayName((ArrayAccess)array);
            _switchResult = "_" + _computeArrayName;
        }
        if (!_matched) {
            _switchResult = "tmpNode";
        }
        return _switchResult;
    }

    public boolean visit(ArrayCreation node) {
        boolean _tripleNotEquals;
        ArrayType at = node.getType();
        int dims = at.getDimensions();
        if (dims > 1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/* FIXME Only one dimensional arrays are supported. ");
            _builder.append((Object)node);
            _builder.append("*/");
            this.appendToBuffer(_builder.toString());
            this.addProblem((ASTNode)node, "Only one dimension arrays are supported.");
            return false;
        }
        ArrayInitializer _initializer = node.getInitializer();
        boolean bl = _tripleNotEquals = _initializer != null;
        if (_tripleNotEquals) {
            if (this.fallBackStrategy) {
                this.appendToBuffer("(");
            }
            node.getInitializer().accept((ASTVisitor)this);
            if (this.fallBackStrategy) {
                this.appendToBuffer(" as ");
                at.accept((ASTVisitor)this);
                this.appendToBuffer(")");
            }
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("new");
            String _xifexpression = null;
            boolean _isPrimitiveType = node.getType().getElementType().isPrimitiveType();
            if (_isPrimitiveType) {
                Type _elementType = node.getType().getElementType();
                _xifexpression = StringExtensions.toFirstUpper((String)((PrimitiveType)_elementType).getPrimitiveTypeCode().toString());
            }
            _builder_1.append(_xifexpression);
            _builder_1.append("ArrayOfSize(");
            this.appendToBuffer(_builder_1.toString());
            List _dimensions = node.dimensions();
            ((Expression[])Conversions.unwrapArray((Object)_dimensions, Expression.class))[0].accept((ASTVisitor)this);
            this.appendToBuffer(")");
        }
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        this.appendToBuffer("#[");
        this.visitAllSeparatedByComma(node.expressions());
        this.appendToBuffer("]");
        return false;
    }

    public boolean visit(ArrayType node) {
        boolean _not;
        boolean _java8orHigher = this.java8orHigher();
        boolean bl = _not = !_java8orHigher;
        if (_not) {
            node.getComponentType().accept((ASTVisitor)this);
            this.appendToBuffer("[]");
        } else {
            List<ASTNode> dimensions;
            boolean _isNullOrEmpty;
            boolean _not_1;
            ASTNode _genericChildProperty = this._aSTFlattenerUtils.genericChildProperty((ASTNode)node, "elementType");
            if (_genericChildProperty != null) {
                _genericChildProperty.accept((ASTVisitor)this);
            }
            boolean bl2 = _not_1 = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty(dimensions = this._aSTFlattenerUtils.genericChildListProperty((ASTNode)node, "dimensions")));
            if (_not_1) {
                Consumer<ASTNode> _function = dim -> {
                    List<ASTNode> _genericChildListProperty = this._aSTFlattenerUtils.genericChildListProperty((ASTNode)dim, "annotations");
                    if (_genericChildListProperty != null) {
                        this.visitAll(_genericChildListProperty);
                    }
                    this.appendToBuffer("[]");
                };
                dimensions.forEach(_function);
            }
        }
        return false;
    }

    public boolean visit(AssertStatement node) {
        boolean _tripleNotEquals;
        this.appendToBuffer("if(!(");
        node.getExpression().accept((ASTVisitor)this);
        this.appendToBuffer(")) {");
        this.appendToBuffer("throw new AssertionError(");
        Expression _message = node.getMessage();
        boolean bl = _tripleNotEquals = _message != null;
        if (_tripleNotEquals) {
            node.getMessage().accept((ASTVisitor)this);
        }
        this.appendToBuffer(")}");
        return false;
    }

    public boolean visit(BreakStatement node) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* FIXME Unsupported BreakStatement */ break");
        this.appendToBuffer(_builder.toString());
        this.addProblem((ASTNode)node, "Break statement is not supported");
        SimpleName _label = node.getLabel();
        boolean bl = _tripleNotEquals = _label != null;
        if (_tripleNotEquals) {
            this.appendSpaceToBuffer();
            node.getLabel().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(CatchClause node) {
        boolean _tripleEquals;
        int _nodeType = node.getException().getType().getNodeType();
        boolean bl = _tripleEquals = _nodeType == 84;
        if (_tripleEquals) {
            this.appendToBuffer(" catch (");
            List<ASTNode> types = this._aSTFlattenerUtils.genericChildListProperty((ASTNode)node.getException().getType(), "types");
            if (types != null) {
                Procedures.Procedure2 _function = (child, index) -> {
                    boolean _lessThan;
                    child.accept((ASTVisitor)this);
                    int _size = types.size();
                    int _minus = _size - 1;
                    boolean bl = _lessThan = index < _minus;
                    if (_lessThan) {
                        this.appendSpaceToBuffer();
                        this.appendToBuffer("|");
                        this.appendSpaceToBuffer();
                    }
                };
                IterableExtensions.forEach(types, (Procedures.Procedure2)_function);
            }
            this.appendSpaceToBuffer();
            this.appendToBuffer(this._aSTFlattenerUtils.toSimpleName((Name)node.getException().getName()));
            this.appendToBuffer(") ");
            node.getBody().accept((ASTVisitor)this);
        } else {
            this.appendToBuffer(" catch (");
            node.getException().accept((ASTVisitor)this);
            this.appendToBuffer(") ");
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        boolean _not;
        boolean _isEmpty = node.typeArguments().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.appendTypeParameters(node.typeArguments());
        }
        this.appendToBuffer("this(");
        this.visitAllSeparatedByComma(node.arguments());
        this.appendToBuffer(")");
        return false;
    }

    public boolean visit(ContinueStatement node) {
        boolean _tripleNotEquals;
        this.appendToBuffer("/* FIXME Unsupported continue statement */ continue");
        this.addProblem((ASTNode)node, "Continue statement is not supported");
        SimpleName _label = node.getLabel();
        boolean bl = _tripleNotEquals = _label != null;
        if (_tripleNotEquals) {
            this.appendSpaceToBuffer();
            node.getLabel().accept((ASTVisitor)this);
        }
        this.appendToBuffer(";");
        this.appendLineWrapToBuffer();
        return false;
    }

    public boolean visit(DoStatement node) {
        this.appendToBuffer("do ");
        node.getBody().accept((ASTVisitor)this);
        this.appendToBuffer(" while (");
        node.getExpression().accept((ASTVisitor)this);
        this.appendToBuffer(")");
        return false;
    }

    public boolean visit(EmptyStatement node) {
        this.appendToBuffer(";");
        return false;
    }

    public boolean visit(EnhancedForStatement node) {
        this.appendToBuffer("for (");
        node.getParameter().accept((ASTVisitor)this);
        this.appendToBuffer(" : ");
        node.getExpression().accept((ASTVisitor)this);
        this.appendToBuffer(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(EnumConstantDeclaration node) {
        AnonymousClassDeclaration _anonymousClassDeclaration;
        boolean _tripleNotEquals_1;
        boolean _not;
        boolean _tripleNotEquals;
        Javadoc _javadoc = node.getJavadoc();
        boolean bl = _tripleNotEquals = _javadoc != null;
        if (_tripleNotEquals) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.appendModifiers((ASTNode)node, node.modifiers());
        node.getName().accept((ASTVisitor)this);
        boolean _isEmpty = node.arguments().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            this.addProblem((ASTNode)node, "Enum constant cannot have any arguments");
            this.appendToBuffer("(");
            this.visitAllSeparatedByComma(node.arguments());
            this.appendToBuffer(")");
        }
        boolean bl3 = _tripleNotEquals_1 = (_anonymousClassDeclaration = node.getAnonymousClassDeclaration()) != null;
        if (_tripleNotEquals_1) {
            this.addProblem((ASTNode)node, "Enum constant cannot have any anonymous class declarations");
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        boolean _not_1;
        boolean _not;
        boolean _tripleNotEquals;
        Javadoc _javadoc = node.getJavadoc();
        boolean bl = _tripleNotEquals = _javadoc != null;
        if (_tripleNotEquals) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.appendModifiers((ASTNode)node, node.modifiers());
        boolean _isPackageVisibility = this._aSTFlattenerUtils.isPackageVisibility(Iterables.filter((Iterable)node.modifiers(), Modifier.class));
        if (_isPackageVisibility) {
            this.appendToBuffer("package ");
        }
        this.appendToBuffer("enum ");
        node.getName().accept((ASTVisitor)this);
        this.appendSpaceToBuffer();
        boolean _isEmpty = node.superInterfaceTypes().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            this.addProblem((ASTNode)node, "Enum cannot have a supertype");
            this.appendToBuffer("implements ");
            this.visitAllSeparatedByComma(node.superInterfaceTypes());
            this.appendSpaceToBuffer();
        }
        this.appendToBuffer("{");
        this.increaseIndent();
        this.appendLineWrapToBuffer();
        this.visitAllSeparatedByComma(node.enumConstants());
        boolean _isEmpty_1 = node.bodyDeclarations().isEmpty();
        boolean bl3 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            this.addProblem((ASTNode)node, "Enum cannot have any body declaration statements");
            this.appendToBuffer(";");
            this.appendLineWrapToBuffer();
            this.visitAll(node.bodyDeclarations());
        }
        this.decreaseIndent();
        this.appendToBuffer("}");
        return false;
    }

    public boolean visit(LabeledStatement node) {
        this.addProblem((ASTNode)node, "LabeledStatements are not supported");
        this.appendToBuffer("/*");
        node.getLabel().accept((ASTVisitor)this);
        this.appendToBuffer(": */");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MemberRef node) {
        boolean _tripleNotEquals;
        Name _qualifier = node.getQualifier();
        boolean bl = _tripleNotEquals = _qualifier != null;
        if (_tripleNotEquals) {
            node.getQualifier().accept((ASTVisitor)this);
        }
        this.appendToBuffer("#");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MethodRef node) {
        boolean _tripleNotEquals;
        Name _qualifier = node.getQualifier();
        boolean bl = _tripleNotEquals = _qualifier != null;
        if (_tripleNotEquals) {
            node.getQualifier().accept((ASTVisitor)this);
        }
        this.appendToBuffer("#");
        node.getName().accept((ASTVisitor)this);
        this.appendToBuffer("(");
        this.visitAllSeparatedByComma(node.parameters());
        this.appendToBuffer(")");
        return false;
    }

    public boolean visit(MethodRefParameter node) {
        SimpleName _name;
        boolean _tripleNotEquals;
        node.getType().accept((ASTVisitor)this);
        boolean _isVarargs = node.isVarargs();
        if (_isVarargs) {
            this.appendToBuffer("...");
        }
        boolean bl = _tripleNotEquals = (_name = node.getName()) != null;
        if (_tripleNotEquals) {
            this.appendSpaceToBuffer();
            node.getName().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(QualifiedType node) {
        node.getQualifier().accept((ASTVisitor)this);
        this.appendToBuffer(".");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SwitchCase node) {
        this.appendLineWrapToBuffer();
        boolean _isDefault = node.isDefault();
        if (_isDefault) {
            this.appendToBuffer("default ");
        } else {
            boolean _greaterEqualsThan;
            this.appendToBuffer("case ");
            int _asJLS = ASTParserFactory.asJLS(this.targetApiLevel);
            boolean bl = _greaterEqualsThan = _asJLS >= 14;
            if (_greaterEqualsThan) {
                Object _get = node.expressions().get(0);
                Expression expression = (Expression)_get;
                expression.accept((ASTVisitor)this);
            } else {
                node.getExpression().accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(SwitchStatement node) {
        this.appendLineWrapToBuffer();
        this.appendToBuffer("switch (");
        node.getExpression().accept((ASTVisitor)this);
        this.appendToBuffer(") ");
        this.appendToBuffer("{");
        this.increaseIndent();
        Functions.Function2 _function = (map, currStatement) -> {
            if (currStatement instanceof SwitchCase) {
                map.put((SwitchCase)currStatement, CollectionLiterals.newArrayList());
            } else {
                ((ArrayList)map.get(IterableExtensions.last(map.keySet()))).add(currStatement);
            }
            return map;
        };
        Map foldedCases = (Map)IterableExtensions.fold((Iterable)node.statements(), (Object)CollectionLiterals.newLinkedHashMap(), (Functions.Function2)_function);
        BiConsumer<SwitchCase, ArrayList> _function_1 = (switchCase, statements) -> {
            boolean surround;
            switchCase.accept((ASTVisitor)this);
            boolean isLastCase = switchCase.equals(IterableExtensions.last(foldedCases.keySet()));
            if (statements.isEmpty() && !isLastCase) {
                this.appendToBuffer(",");
            } else {
                boolean probablyReturns;
                this.appendToBuffer(":");
                boolean bl = probablyReturns = IterableExtensions.last((Iterable)statements) instanceof ReturnStatement || IterableExtensions.last((Iterable)statements) instanceof Block && IterableExtensions.last((Iterable)((Block)IterableExtensions.last((Iterable)statements)).statements()) instanceof ReturnStatement;
                if (!isLastCase && !probablyReturns) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("/* FIXME unsupported fall-through */");
                    this.appendToBuffer(_builder.toString());
                    this.addProblem((ASTNode)node, "Unsupported fall-through case in switch expression");
                }
            }
            boolean bl = surround = isLastCase && statements.isEmpty() || !statements.isEmpty() && !(statements.get(0) instanceof Block);
            if (surround) {
                this.appendToBuffer("{");
                this.increaseIndent();
                this.appendLineWrapToBuffer();
            }
            this.visitAll((Iterable<? extends ASTNode>)statements);
            if (surround) {
                this.decreaseIndent();
                this.appendLineWrapToBuffer();
                this.appendToBuffer("}");
            }
        };
        foldedCases.forEach(_function_1);
        this.decreaseIndent();
        this.appendLineWrapToBuffer();
        this.appendToBuffer("}");
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        this.appendToBuffer("synchronized (");
        node.getExpression().accept((ASTVisitor)this);
        this.appendToBuffer(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        boolean _isNotSupportedInnerType = this._aSTFlattenerUtils.isNotSupportedInnerType(node);
        if (_isNotSupportedInnerType) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/*FIXME Non-static inner classes are not supported. */");
            this.appendToBuffer(_builder.toString());
            this.addProblem((ASTNode)node, "Non-static inner classes are not supported.");
        }
        node.getDeclaration().accept((ASTVisitor)this);
        return false;
    }

    public void preVisit(ASTNode node) {
        if (node instanceof Comment || node instanceof TagElement || node instanceof TextElement) {
            return;
        }
        ASTNode _root = node.getRoot();
        if (_root instanceof CompilationUnit) {
            ASTNode _root_1 = node.getRoot();
            CompilationUnit cu = (CompilationUnit)_root_1;
            Functions.Function1 _function = it -> {
                int _startPosition_1;
                int _startPosition = it.getStartPosition();
                return _startPosition < (_startPosition_1 = node.getStartPosition());
            };
            Consumer<Comment> _function_1 = it -> {
                it.accept((ASTVisitor)this);
                this.assignedComments.add((Comment)it);
            };
            IterableExtensions.filter(this.unAssignedComments(cu), (Functions.Function1)_function).forEach(_function_1);
        }
    }

    public boolean preVisit2(ASTNode node) {
        boolean _tripleEquals;
        int _nodeType = node.getNodeType();
        boolean bl = _tripleEquals = _nodeType == 86;
        if (_tripleEquals) {
            this.preVisit(node);
            this.handleLambdaExpression(node);
            return false;
        }
        return super.preVisit2(node);
    }

    public boolean handleLambdaExpression(ASTNode node) {
        ASTNode _genericChildProperty;
        boolean _not;
        this.appendToBuffer("[");
        List<ASTNode> params = this._aSTFlattenerUtils.genericChildListProperty(node, "parameters");
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(params);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this.visitAllSeparatedByComma(params);
            this.appendToBuffer(" | ");
        }
        if ((_genericChildProperty = this._aSTFlattenerUtils.genericChildProperty(node, "body")) != null) {
            _genericChildProperty.accept((ASTVisitor)this);
        }
        this.appendToBuffer("]");
        return false;
    }

    public String setJavaSources(String javaSources) {
        this.javaSources = javaSources;
        return this.javaSources;
    }

    public boolean useFallBackStrategy(boolean fallBackStrategy) {
        this.fallBackStrategy = fallBackStrategy;
        return this.fallBackStrategy;
    }

    public String setTargetlevel(String targetApiLevel) {
        this.targetApiLevel = targetApiLevel;
        return this.targetApiLevel;
    }

    public boolean allowConditionalExpressions(boolean allow) {
        this.conditionalExpressionsAllowed = allow;
        return this.conditionalExpressionsAllowed;
    }
}

