/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.richstring;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.richstring.ElseIfCondition;
import org.eclipse.xtend.core.richstring.ElseStart;
import org.eclipse.xtend.core.richstring.EndIf;
import org.eclipse.xtend.core.richstring.ForLoopEnd;
import org.eclipse.xtend.core.richstring.ForLoopStart;
import org.eclipse.xtend.core.richstring.IRichStringIndentationHandler;
import org.eclipse.xtend.core.richstring.IRichStringPartAcceptor;
import org.eclipse.xtend.core.richstring.IfConditionStart;
import org.eclipse.xtend.core.richstring.InitialTemplateIndentationComputer;
import org.eclipse.xtend.core.richstring.Line;
import org.eclipse.xtend.core.richstring.LineBreak;
import org.eclipse.xtend.core.richstring.LinePart;
import org.eclipse.xtend.core.richstring.Literal;
import org.eclipse.xtend.core.richstring.PrintedExpression;
import org.eclipse.xtend.core.richstring.ProcessedRichString;
import org.eclipse.xtend.core.richstring.ProcessedRichStringFactory;
import org.eclipse.xtend.core.richstring.TextLine;
import org.eclipse.xtend.core.richstring.TextLines;
import org.eclipse.xtend.core.richstring.util.ProcessedRichStringSwitch;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringElseIf;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.core.xtend.util.XtendSwitch;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;

public class RichStringProcessor {
    public void process(RichString richString, IRichStringPartAcceptor acceptor, IRichStringIndentationHandler indentationHandler) {
        ProcessedRichString processedRichString = new ProcessedRichStringBuilder().processRichString(richString);
        Implementation implementation = new Implementation(acceptor, indentationHandler);
        implementation.doSwitch(processedRichString);
    }

    public static class Implementation
    extends ProcessedRichStringSwitch<Boolean> {
        private final IRichStringPartAcceptor acceptor;
        private final IRichStringIndentationHandler indentationHandler;
        private LinePart nextPart;
        private RichStringLiteral announced;
        private int skipCount = 0;

        public Implementation(IRichStringPartAcceptor acceptor, IRichStringIndentationHandler indentationHandler) {
            this.acceptor = acceptor;
            this.indentationHandler = indentationHandler;
        }

        public Boolean doSwitch(EObject theEObject) {
            if (theEObject == null) {
                return Boolean.TRUE;
            }
            return (Boolean)super.doSwitch(theEObject);
        }

        @Override
        public Boolean caseProcessedRichString(ProcessedRichString object) {
            String indentation = this.computeInitialIndentation(object.getRichString());
            this.pushTemplateIndentation(indentation);
            EList<Line> lines = object.getLines();
            if (!lines.isEmpty()) {
                int i = 0;
                this.nextPart = null;
                Line currentLine = (Line)lines.get(i);
                while (currentLine.getParts().isEmpty() && i < lines.size()) {
                    currentLine = (Line)lines.get(i);
                }
                if (!currentLine.getParts().isEmpty()) {
                    this.nextPart = (LinePart)currentLine.getParts().get(0);
                }
                while (this.nextPart != null) {
                    this.doSwitch(this.nextPart);
                }
            }
            this.popIndentation();
            return Boolean.TRUE;
        }

        protected void computeNextPart(LinePart part) {
            Line line = part.getLine();
            int index = line.getParts().indexOf((Object)part);
            if (index == line.getParts().size() - 1) {
                ProcessedRichString richString = line.getRichString();
                index = richString.getLines().indexOf((Object)line);
                if (index == richString.getLines().size() - 1) {
                    this.nextPart = null;
                } else {
                    int i = index + 1;
                    this.nextPart = null;
                    line = (Line)richString.getLines().get(i);
                    while (line.getParts().isEmpty() && i < richString.getLines().size()) {
                        line = (Line)richString.getLines().get(i);
                    }
                    if (!line.getParts().isEmpty()) {
                        this.nextPart = (LinePart)line.getParts().get(0);
                    }
                }
            } else {
                this.nextPart = (LinePart)line.getParts().get(index + 1);
            }
        }

        @Override
        public Boolean caseForLoopStart(ForLoopStart object) {
            RichStringForLoop loop = object.getLoop();
            this.acceptor.acceptForLoop(loop.getDeclaredParam(), loop.getForExpression());
            this.pushTemplateIndentationTwice(this.computeInitialIndentation((RichString)loop.getEachExpression()));
            boolean hasNext = this.acceptor.forLoopHasNext(loop.getBefore(), loop.getSeparator(), this.indentationHandler.getTotalSemanticIndentation());
            if (hasNext) {
                while (hasNext) {
                    this.computeNextPart(object);
                    while (this.nextPart != object.getEnd()) {
                        this.doSwitch(this.nextPart);
                    }
                    hasNext = this.acceptor.forLoopHasNext(loop.getBefore(), loop.getSeparator(), this.indentationHandler.getTotalSemanticIndentation());
                }
            } else {
                this.nextPart = object.getEnd();
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseForLoopEnd(ForLoopEnd object) {
            this.popIndentationTwice();
            this.acceptor.acceptEndFor(object.getStart().getLoop().getAfter(), this.indentationHandler.getTotalSemanticIndentation());
            this.computeNextPart(object);
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseIfConditionStart(IfConditionStart object) {
            RichStringIf richStringIf = object.getRichStringIf();
            this.acceptor.acceptIfCondition(richStringIf.getIf());
            this.computeNextPart(object);
            this.pushTemplateIndentationTwice(this.computeInitialIndentation((RichString)richStringIf.getThen()));
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseElseIfCondition(ElseIfCondition object) {
            this.popIndentationTwice();
            RichStringElseIf elseIf = object.getRichStringElseIf();
            this.acceptor.acceptElseIfCondition(elseIf.getIf());
            this.computeNextPart(object);
            this.pushTemplateIndentationTwice(this.computeInitialIndentation((RichString)elseIf.getThen()));
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseElseStart(ElseStart object) {
            this.popIndentationTwice();
            this.acceptor.acceptElse();
            this.computeNextPart(object);
            this.pushTemplateIndentationTwice(this.computeInitialIndentation((RichString)object.getIfConditionStart().getRichStringIf().getElse()));
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseEndIf(EndIf object) {
            this.popIndentationTwice();
            this.acceptor.acceptEndIf();
            this.computeNextPart(object);
            return Boolean.TRUE;
        }

        @Override
        public Boolean casePrintedExpression(PrintedExpression object) {
            this.acceptor.acceptExpression(object.getExpression(), this.indentationHandler.getTotalSemanticIndentation());
            this.computeNextPart(object);
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseLineBreak(LineBreak object) {
            Line line = object.getLine();
            if (this.isTemplateLine(line)) {
                boolean firstOrLast;
                this.announceTemplateLinebreak(object);
                ProcessedRichString string = line.getRichString();
                boolean bl = firstOrLast = string.getLines().get(0) == line || string.getLines().get(string.getLines().size() - 1) == line;
                if (!firstOrLast) {
                    this.popIndentation();
                }
            } else {
                this.announceSemanticLinebreak(object);
                this.popIndentation();
            }
            this.computeNextPart(object);
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseLiteral(Literal object) {
            boolean firstOrLast;
            if (this.announced == null || this.announced != object.getLiteral()) {
                this.acceptor.announceNextLiteral(object.getLiteral());
                this.announced = object.getLiteral();
            }
            Line line = object.getLine();
            TextLine textLine = new TextLine(Strings.emptyIfNull((String)object.getLiteral().getValue()), object.getOffset(), object.getLength(), 0);
            Object ws = textLine.getLeadingWhiteSpace();
            ProcessedRichString string = line.getRichString();
            boolean bl = firstOrLast = string.getLines().get(0) == line || string.getLines().get(string.getLines().size() - 1) == line;
            if (this.isTemplateLine(line)) {
                if (line.getParts().get(0) == object && !firstOrLast) {
                    LinePart next;
                    boolean followedByOpening = false;
                    if (line.getParts().size() >= 2 && ((next = (LinePart)line.getParts().get(1)) instanceof ForLoopStart || next instanceof IfConditionStart)) {
                        followedByOpening = true;
                    }
                    if (!followedByOpening) {
                        this.pushSemanticIndentation(this.indentationHandler.getTotalIndentation());
                    } else {
                        this.pushSemanticIndentation((CharSequence)ws);
                    }
                }
                this.announceTemplateText(textLine, object.getLiteral());
            } else if (this.skipCount <= 1) {
                firstOrLast = false;
                if (this.skipCount == 0 && line.getParts().get(0) == object) {
                    if (textLine.length() == ws.length()) {
                        for (int i = 1; i < line.getParts().size() && line.getParts().get(i) instanceof Literal && !(line.getParts().get(i) instanceof LineBreak); ++i) {
                            Literal nextLiteralInSameLine = (Literal)line.getParts().get(i);
                            TextLine nextLiteralLine = new TextLine(nextLiteralInSameLine.getLiteral().getValue(), nextLiteralInSameLine.getOffset(), nextLiteralInSameLine.getLength(), 0);
                            CharSequence nextLeading = nextLiteralLine.getLeadingWhiteSpace();
                            if (nextLeading.length() > 0) {
                                ws = ws.toString() + nextLeading;
                            }
                            ++this.skipCount;
                            if (nextLeading.length() != nextLiteralLine.length()) break;
                        }
                        if (this.skipCount != 0) {
                            this.pushSemanticIndentation((CharSequence)ws);
                        } else {
                            this.pushSemanticIndentation((CharSequence)ws);
                            this.announceIndentation();
                            this.announceSemanticText(textLine.subSequence(ws.length(), textLine.length()), object.getLiteral());
                        }
                    } else {
                        this.pushSemanticIndentation((CharSequence)ws);
                        this.announceIndentation();
                        this.announceSemanticText(textLine.subSequence(ws.length(), textLine.length()), object.getLiteral());
                    }
                } else if (this.skipCount == 1) {
                    --this.skipCount;
                    this.announceIndentation();
                    this.announceSemanticText(textLine.subSequence(ws.length(), textLine.length()), object.getLiteral());
                } else {
                    this.announceSemanticText(textLine, object.getLiteral());
                }
            } else {
                --this.skipCount;
            }
            if (!firstOrLast && line.getParts().get(line.getParts().size() - 1) == object) {
                this.popIndentation();
            }
            this.computeNextPart(object);
            return Boolean.TRUE;
        }

        protected boolean isTemplateLine(Line line) {
            boolean firstOrLast;
            ProcessedRichString string = line.getRichString();
            if (string.getLines().size() == 1) {
                return false;
            }
            boolean bl = firstOrLast = string.getLines().get(0) == line;
            if (!firstOrLast && string.getLines().get(string.getLines().size() - 1) == line && !(line.getParts().get(line.getParts().size() - 1) instanceof LineBreak)) {
                firstOrLast = true;
            }
            boolean onlyLiterals = true;
            for (LinePart part : line.getParts()) {
                if (part instanceof PrintedExpression) {
                    return false;
                }
                if (part instanceof Literal) {
                    Literal literal = (Literal)part;
                    if (literal instanceof LineBreak) {
                        if (firstOrLast) {
                            return onlyLiterals;
                        }
                        return !onlyLiterals;
                    }
                    if (new TextLine(literal.getLiteral().getValue(), literal.getOffset(), literal.getLength(), 0).containsOnlyWhitespace()) continue;
                    return false;
                }
                if (firstOrLast) {
                    return false;
                }
                onlyLiterals = false;
            }
            if (firstOrLast) {
                return onlyLiterals;
            }
            return !onlyLiterals;
        }

        protected void pushSemanticIndentation(CharSequence line) {
            this.indentationHandler.pushSemanticIndentation(line);
        }

        protected void popIndentation() {
            this.indentationHandler.popIndentation();
        }

        protected void popIndentationTwice() {
            this.popIndentation();
            this.popIndentation();
        }

        protected void pushTemplateIndentationTwice(CharSequence indentation) {
            this.pushTemplateIndentation(indentation);
            this.pushTemplateIndentation(indentation);
        }

        protected void pushTemplateIndentation(CharSequence indentation) {
            this.indentationHandler.pushTemplateIndentation(indentation);
        }

        protected void announceSemanticText(CharSequence text, RichStringLiteral origin) {
            this.acceptor.acceptSemanticText(text, origin);
        }

        public void announceTemplateText(CharSequence text, RichStringLiteral origin) {
            this.acceptor.acceptTemplateText(text, origin);
        }

        public void announceIndentation() {
            this.indentationHandler.accept(this.acceptor);
        }

        protected void announceTemplateLinebreak(LineBreak lineBreak) {
            this.acceptor.acceptTemplateLineBreak(lineBreak.getLength(), lineBreak.getLiteral());
        }

        public void announceSemanticLinebreak(LineBreak lineBreak) {
            boolean controlStructureSeen = false;
            for (LinePart part : lineBreak.getLine().getParts()) {
                if (part instanceof Literal) continue;
                controlStructureSeen = true;
                break;
            }
            this.acceptor.acceptSemanticLineBreak(lineBreak.getLength(), lineBreak.getLiteral(), controlStructureSeen);
        }

        public String computeInitialIndentation(RichString object) {
            if (object == null) {
                return this.indentationHandler.getTotalIndentation().toString();
            }
            InitialTemplateIndentationComputer computer = new InitialTemplateIndentationComputer(this.indentationHandler.getTotalIndentation());
            String result = (String)computer.doSwitch((EObject)object);
            return result;
        }
    }

    public static class ProcessedRichStringBuilder
    extends XtendSwitch<Boolean> {
        @Inject
        private ProcessedRichStringFactory factory = ProcessedRichStringFactory.eINSTANCE;
        private ProcessedRichString result = null;
        private Line currentLine = null;

        public ProcessedRichString processRichString(RichString richString) {
            if (this.result != null || this.currentLine != null) {
                throw new IllegalStateException("result is already set");
            }
            this.doSwitch((EObject)richString);
            return this.result;
        }

        public Boolean doSwitch(EObject theEObject) {
            if (theEObject == null) {
                return Boolean.TRUE;
            }
            return (Boolean)super.doSwitch(theEObject);
        }

        protected void addToCurrentLine(LinePart part) {
            if (this.currentLine == null) {
                this.currentLine = this.factory.createLine();
                if (!(part instanceof Literal) && !this.result.getLines().isEmpty()) {
                    Line prevLine = (Line)this.result.getLines().get(this.result.getLines().size() - 1);
                    LineBreak lineBreak = (LineBreak)prevLine.getParts().get(prevLine.getParts().size() - 1);
                    Literal literal = this.factory.createLiteral();
                    literal.setLength(0);
                    literal.setOffset(lineBreak.getLiteral().getValue().length());
                    literal.setLiteral(lineBreak.getLiteral());
                    this.currentLine.getParts().add((Object)literal);
                }
                this.result.getLines().add((Object)this.currentLine);
            }
            if (part != null) {
                this.currentLine.getParts().add((Object)part);
            }
        }

        @Override
        public Boolean caseRichString(RichString object) {
            if (this.result == null) {
                this.result = this.factory.createProcessedRichString();
                this.result.setRichString(object);
            }
            EList elements = object.getExpressions();
            for (XExpression element : elements) {
                this.doSwitch((EObject)element);
            }
            if (this.currentLine == null && !this.result.getLines().isEmpty()) {
                this.addToCurrentLine(null);
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseRichStringForLoop(RichStringForLoop object) {
            ForLoopStart start = this.factory.createForLoopStart();
            start.setLoop(object);
            this.addToCurrentLine(start);
            this.doSwitch((EObject)object.getEachExpression());
            ForLoopEnd end = this.factory.createForLoopEnd();
            end.setStart(start);
            this.addToCurrentLine(end);
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseRichStringIf(RichStringIf object) {
            IfConditionStart start = this.factory.createIfConditionStart();
            start.setRichStringIf(object);
            this.addToCurrentLine(start);
            this.doSwitch((EObject)object.getThen());
            for (RichStringElseIf elseIf : object.getElseIfs()) {
                ElseIfCondition elseIfStart = this.factory.createElseIfCondition();
                elseIfStart.setIfConditionStart(start);
                elseIfStart.setRichStringElseIf(elseIf);
                this.addToCurrentLine(elseIfStart);
                this.doSwitch((EObject)elseIf.getThen());
            }
            if (object.getElse() != null) {
                ElseStart elseStart = this.factory.createElseStart();
                elseStart.setIfConditionStart(start);
                this.addToCurrentLine(elseStart);
                this.doSwitch((EObject)object.getElse());
            }
            EndIf end = this.factory.createEndIf();
            end.setIfConditionStart(start);
            this.addToCurrentLine(end);
            return Boolean.TRUE;
        }

        @Override
        public Boolean defaultCase(EObject object) {
            if (object instanceof XExpression) {
                PrintedExpression printedExpression = this.factory.createPrintedExpression();
                printedExpression.setExpression((XExpression)object);
                this.addToCurrentLine(printedExpression);
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseRichStringLiteral(RichStringLiteral object) {
            String value = object.getValue();
            List<TextLine> lines = TextLines.splitString(value);
            if (lines.isEmpty()) {
                Literal literal = this.factory.createLiteral();
                literal.setLength(0);
                literal.setOffset(0);
                literal.setLiteral(object);
                this.addToCurrentLine(literal);
            } else {
                for (TextLine textLine : lines) {
                    Literal literal = this.factory.createLiteral();
                    literal.setLength(textLine.length());
                    literal.setOffset(textLine.getRelativeOffset());
                    literal.setLiteral(object);
                    this.addToCurrentLine(literal);
                    if (!textLine.hasTrailingLineBreak()) continue;
                    LineBreak lineBreak = this.factory.createLineBreak();
                    lineBreak.setLength(textLine.getDelimiterLength());
                    lineBreak.setOffset(textLine.getRelativeOffset() + textLine.length());
                    lineBreak.setLiteral(object);
                    this.addToCurrentLine(lineBreak);
                    this.currentLine = null;
                }
            }
            return Boolean.TRUE;
        }
    }
}

