/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmTypeDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeElementDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmAnnotationTypeDeclarationImpl
extends JvmTypeDeclarationImpl<JvmAnnotationType>
implements MutableAnnotationTypeDeclaration {
    @Override
    public MutableConstructorDeclaration addConstructor(Procedures.Procedure1<MutableConstructorDeclaration> initializer) {
        String _simpleName = this.getSimpleName();
        String _plus = "The annotation '" + _simpleName;
        String _plus_1 = String.valueOf(_plus) + "' cannot declare any constructors.";
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException(_plus_1);
        throw _unsupportedOperationException;
    }

    @Override
    public MutableFieldDeclaration addField(String name, Procedures.Procedure1<MutableFieldDeclaration> initializer) {
        String _simpleName = this.getSimpleName();
        String _plus = "The annotation '" + _simpleName;
        String _plus_1 = String.valueOf(_plus) + "' cannot declare any fields.";
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException(_plus_1);
        throw _unsupportedOperationException;
    }

    @Override
    public MutableMethodDeclaration addMethod(String name, Procedures.Procedure1<MutableMethodDeclaration> initializer) {
        String _simpleName = this.getSimpleName();
        String _plus = "The annotation '" + _simpleName;
        String _plus_1 = String.valueOf(_plus) + "' cannot declare any methods.";
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException(_plus_1);
        throw _unsupportedOperationException;
    }

    public MutableAnnotationTypeElementDeclaration addAnnotationTypeElement(String name, Procedures.Procedure1<MutableAnnotationTypeElementDeclaration> initializer) {
        ConditionUtils.checkJavaIdentifier(name, "name");
        boolean _notEquals = !Objects.equal(initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        JvmOperation newAnnotationElement = TypesFactory.eINSTANCE.createJvmOperation();
        newAnnotationElement.setSimpleName(name);
        newAnnotationElement.setVisibility(JvmVisibility.PUBLIC);
        JvmAnnotationType _delegate = (JvmAnnotationType)this.getDelegate();
        EList _members = _delegate.getMembers();
        _members.add((Object)newAnnotationElement);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        MutableMemberDeclaration _memberDeclaration = _compilationUnit.toMemberDeclaration((JvmMember)newAnnotationElement);
        MutableAnnotationTypeElementDeclaration mutableAnnotationTypeElementDeclaration = (MutableAnnotationTypeElementDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableAnnotationTypeElementDeclaration);
        return mutableAnnotationTypeElementDeclaration;
    }

    public MutableAnnotationTypeElementDeclaration findDeclaredAnnotationTypeElement(final String name) {
        Iterable<? extends MutableAnnotationTypeElementDeclaration> _declaredAnnotationTypeElements = this.getDeclaredAnnotationTypeElements();
        Functions.Function1<MutableAnnotationTypeElementDeclaration, Boolean> _function = new Functions.Function1<MutableAnnotationTypeElementDeclaration, Boolean>(){

            public Boolean apply(MutableAnnotationTypeElementDeclaration it) {
                String _simpleName = it.getSimpleName();
                boolean _equals = Objects.equal((Object)_simpleName, (Object)name);
                return _equals;
            }
        };
        MutableAnnotationTypeElementDeclaration _findFirst = (MutableAnnotationTypeElementDeclaration)IterableExtensions.findFirst(_declaredAnnotationTypeElements, (Functions.Function1)_function);
        return _findFirst;
    }

    public Iterable<? extends MutableAnnotationTypeElementDeclaration> getDeclaredAnnotationTypeElements() {
        JvmAnnotationType _delegate = (JvmAnnotationType)this.getDelegate();
        EList _members = _delegate.getMembers();
        Functions.Function1<JvmMember, MutableMemberDeclaration> _function = new Functions.Function1<JvmMember, MutableMemberDeclaration>(){

            public MutableMemberDeclaration apply(JvmMember it) {
                CompilationUnit _compilationUnit = JvmAnnotationTypeDeclarationImpl.this.getCompilationUnit();
                MutableMemberDeclaration _memberDeclaration = _compilationUnit.toMemberDeclaration(it);
                return _memberDeclaration;
            }
        };
        List _map = ListExtensions.map((List)_members, (Functions.Function1)_function);
        Iterable _filter = Iterables.filter((Iterable)_map, MutableAnnotationTypeElementDeclaration.class);
        return _filter;
    }
}

