/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmMemberDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.services.TypeReferenceProvider;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JvmTypeDeclarationImpl<T extends JvmDeclaredType>
extends JvmMemberDeclarationImpl<T>
implements MutableTypeDeclaration {
    public Iterable<? extends MutableMemberDeclaration> getDeclaredMembers() {
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        EList _members = _delegate.getMembers();
        Functions.Function1<JvmMember, MutableMemberDeclaration> _function = new Functions.Function1<JvmMember, MutableMemberDeclaration>(){

            public MutableMemberDeclaration apply(JvmMember it) {
                CompilationUnit _compilationUnit = JvmTypeDeclarationImpl.this.getCompilationUnit();
                MutableMemberDeclaration _memberDeclaration = _compilationUnit.toMemberDeclaration(it);
                return _memberDeclaration;
            }
        };
        List _map = ListExtensions.map((List)_members, (Functions.Function1)_function);
        ImmutableList _copyOf = ImmutableList.copyOf((Collection)_map);
        return _copyOf;
    }

    @Override
    public String getSimpleName() {
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        String _simpleName = _delegate.getSimpleName();
        return _simpleName;
    }

    public String getQualifiedName() {
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        String _identifier = _delegate.getIdentifier();
        return _identifier;
    }

    public boolean isAssignableFrom(Type otherType) {
        boolean _equals = Objects.equal((Object)otherType, null);
        if (_equals) {
            return false;
        }
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        TypeReferenceProvider _typeReferenceProvider = _compilationUnit.getTypeReferenceProvider();
        TypeReference thisTypeRef = _typeReferenceProvider.newTypeReference((Type)this, new TypeReference[0]);
        CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
        TypeReferenceProvider _typeReferenceProvider_1 = _compilationUnit_1.getTypeReferenceProvider();
        TypeReference thatTypeRef = _typeReferenceProvider_1.newTypeReference(otherType, new TypeReference[0]);
        return thisTypeRef.isAssignableFrom(thatTypeRef);
    }

    public MutableConstructorDeclaration addConstructor(Procedures.Procedure1<MutableConstructorDeclaration> initializer) {
        boolean _notEquals_1;
        boolean _notEquals = !Objects.equal(initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        EList _members = _delegate.getMembers();
        Iterable _filter = Iterables.filter((Iterable)_members, JvmConstructor.class);
        Functions.Function1<JvmConstructor, Boolean> _function = new Functions.Function1<JvmConstructor, Boolean>(){

            public Boolean apply(JvmConstructor it) {
                CompilationUnit _compilationUnit = JvmTypeDeclarationImpl.this.getCompilationUnit();
                JvmTypeExtensions _typeExtensions = _compilationUnit.getTypeExtensions();
                boolean _isSingleSyntheticDefaultConstructor = _typeExtensions.isSingleSyntheticDefaultConstructor(it);
                return _isSingleSyntheticDefaultConstructor;
            }
        };
        JvmConstructor constructor = (JvmConstructor)IterableExtensions.findFirst((Iterable)_filter, (Functions.Function1)_function);
        boolean bl = _notEquals_1 = !Objects.equal((Object)constructor, null);
        if (_notEquals_1) {
            EcoreUtil.remove((EObject)constructor);
        }
        JvmConstructor newConstructor = TypesFactory.eINSTANCE.createJvmConstructor();
        newConstructor.setVisibility(JvmVisibility.PUBLIC);
        String _simpleName = this.getSimpleName();
        newConstructor.setSimpleName(_simpleName);
        JvmDeclaredType _delegate_1 = (JvmDeclaredType)this.getDelegate();
        EList _members_1 = _delegate_1.getMembers();
        _members_1.add((Object)newConstructor);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        MutableMemberDeclaration _memberDeclaration = _compilationUnit.toMemberDeclaration((JvmMember)newConstructor);
        MutableConstructorDeclaration mutableConstructorDeclaration = (MutableConstructorDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableConstructorDeclaration);
        return mutableConstructorDeclaration;
    }

    public MutableFieldDeclaration addField(String name, Procedures.Procedure1<MutableFieldDeclaration> initializer) {
        ConditionUtils.checkJavaIdentifier(name, "name");
        boolean _notEquals = !Objects.equal(initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        JvmField newField = TypesFactory.eINSTANCE.createJvmField();
        newField.setSimpleName(name);
        newField.setVisibility(JvmVisibility.PRIVATE);
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        EList _members = _delegate.getMembers();
        _members.add((Object)newField);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        MutableMemberDeclaration _memberDeclaration = _compilationUnit.toMemberDeclaration((JvmMember)newField);
        MutableFieldDeclaration mutableFieldDeclaration = (MutableFieldDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableFieldDeclaration);
        return mutableFieldDeclaration;
    }

    public MutableMethodDeclaration addMethod(String name, Procedures.Procedure1<MutableMethodDeclaration> initializer) {
        ConditionUtils.checkJavaIdentifier(name, "name");
        boolean _notEquals = !Objects.equal(initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        JvmOperation newMethod = TypesFactory.eINSTANCE.createJvmOperation();
        newMethod.setVisibility(JvmVisibility.PUBLIC);
        newMethod.setSimpleName(name);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
        TypeReferenceProvider _typeReferenceProvider = _compilationUnit_1.getTypeReferenceProvider();
        TypeReference _primitiveVoid = _typeReferenceProvider.getPrimitiveVoid();
        JvmTypeReference _jvmTypeReference = _compilationUnit.toJvmTypeReference(_primitiveVoid);
        newMethod.setReturnType(_jvmTypeReference);
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        EList _members = _delegate.getMembers();
        _members.add((Object)newMethod);
        CompilationUnit _compilationUnit_2 = this.getCompilationUnit();
        MutableMemberDeclaration _memberDeclaration = _compilationUnit_2.toMemberDeclaration((JvmMember)newMethod);
        MutableMethodDeclaration mutableMethodDeclaration = (MutableMethodDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableMethodDeclaration);
        return mutableMethodDeclaration;
    }

    public MutableConstructorDeclaration findDeclaredConstructor(final TypeReference ... parameterTypes) {
        MutableConstructorDeclaration _findFirst;
        MutableConstructorDeclaration _xblockexpression = null;
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)parameterTypes), "parameterTypes");
        Iterable<MutableConstructorDeclaration> _declaredConstructors = this.getDeclaredConstructors();
        Functions.Function1<MutableConstructorDeclaration, Boolean> _function = new Functions.Function1<MutableConstructorDeclaration, Boolean>(){

            public Boolean apply(MutableConstructorDeclaration constructor) {
                Iterable _parameters = constructor.getParameters();
                Functions.Function1<MutableParameterDeclaration, TypeReference> _function = new Functions.Function1<MutableParameterDeclaration, TypeReference>(){

                    public TypeReference apply(MutableParameterDeclaration it) {
                        TypeReference _type = it.getType();
                        return _type;
                    }
                };
                Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
                List _list = IterableExtensions.toList((Iterable)_map);
                List _list_1 = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)parameterTypes)));
                boolean _equals = Objects.equal((Object)_list, (Object)_list_1);
                return _equals;
            }
        };
        _xblockexpression = _findFirst = (MutableConstructorDeclaration)IterableExtensions.findFirst(_declaredConstructors, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public MutableFieldDeclaration findDeclaredField(final String name) {
        Iterable<MutableFieldDeclaration> _declaredFields = this.getDeclaredFields();
        Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

            public Boolean apply(MutableFieldDeclaration field) {
                String _simpleName = field.getSimpleName();
                boolean _equals = Objects.equal((Object)_simpleName, (Object)name);
                return _equals;
            }
        };
        MutableFieldDeclaration _findFirst = (MutableFieldDeclaration)IterableExtensions.findFirst(_declaredFields, (Functions.Function1)_function);
        return _findFirst;
    }

    public MutableMethodDeclaration findDeclaredMethod(final String name, final TypeReference ... parameterTypes) {
        MutableMethodDeclaration _findFirst;
        MutableMethodDeclaration _xblockexpression = null;
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)parameterTypes), "parameterTypes");
        Iterable<MutableMethodDeclaration> _declaredMethods = this.getDeclaredMethods();
        Functions.Function1<MutableMethodDeclaration, Boolean> _function = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

            public Boolean apply(MutableMethodDeclaration method) {
                boolean _and = false;
                String _simpleName = method.getSimpleName();
                boolean _equals = Objects.equal((Object)_simpleName, (Object)name);
                if (!_equals) {
                    _and = false;
                } else {
                    Iterable _parameters = method.getParameters();
                    Functions.Function1<MutableParameterDeclaration, TypeReference> _function = new Functions.Function1<MutableParameterDeclaration, TypeReference>(){

                        public TypeReference apply(MutableParameterDeclaration it) {
                            TypeReference _type = it.getType();
                            return _type;
                        }
                    };
                    Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
                    List _list = IterableExtensions.toList((Iterable)_map);
                    List _list_1 = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)parameterTypes)));
                    boolean _equals_1 = Objects.equal((Object)_list, (Object)_list_1);
                    _and = _equals && _equals_1;
                }
                return _and;
            }
        };
        _xblockexpression = _findFirst = (MutableMethodDeclaration)IterableExtensions.findFirst(_declaredMethods, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public Iterable<? extends MutableMethodDeclaration> getDeclaredMethods() {
        Iterable<MutableMemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        Iterable _filter = Iterables.filter(_declaredMembers, MutableMethodDeclaration.class);
        return _filter;
    }

    public Iterable<? extends MutableFieldDeclaration> getDeclaredFields() {
        Iterable<MutableMemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        Iterable _filter = Iterables.filter(_declaredMembers, MutableFieldDeclaration.class);
        return _filter;
    }

    public Iterable<? extends MutableClassDeclaration> getDeclaredClasses() {
        Iterable<MutableMemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        Iterable _filter = Iterables.filter(_declaredMembers, MutableClassDeclaration.class);
        return _filter;
    }

    public Iterable<? extends MutableConstructorDeclaration> getDeclaredConstructors() {
        Iterable<MutableMemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        Iterable _filter = Iterables.filter(_declaredMembers, MutableConstructorDeclaration.class);
        return _filter;
    }

    public Iterable<? extends MutableInterfaceDeclaration> getDeclaredInterfaces() {
        Iterable<MutableMemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        Iterable _filter = Iterables.filter(_declaredMembers, MutableInterfaceDeclaration.class);
        return _filter;
    }

    @Override
    public void setSimpleName(String name) {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("The type cannot be renamed.");
        throw _unsupportedOperationException;
    }
}

