/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.resource;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendResourceDescription
extends DefaultResourceDescription {
    private static final Set<String> primitivesFilter = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"boolean", "int", "char", "byte", "short", "long", "double", "float", "void"}));
    private IBatchTypeResolver typeResolver;
    private IQualifiedNameConverter nameConverter;

    public XtendResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        super(resource, strategy);
    }

    public XtendResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy, IResourceScopeCache cache, IBatchTypeResolver typeResolver, IQualifiedNameConverter nameConverter) {
        super(resource, strategy, cache);
        this.typeResolver = typeResolver;
        this.nameConverter = nameConverter;
    }

    protected EObjectDescriptionLookUp getLookUp() {
        boolean _equals = Objects.equal((Object)this.lookup, null);
        if (_equals) {
            EObjectDescriptionLookUp _eObjectDescriptionLookUp;
            List _computeExportedObjects = this.computeExportedObjects();
            this.lookup = _eObjectDescriptionLookUp = new EObjectDescriptionLookUp(_computeExportedObjects);
        }
        return this.lookup;
    }

    public Iterable<QualifiedName> getImportedNames() {
        final HashSet result = CollectionLiterals.newHashSet((Object[])new QualifiedName[0]);
        Iterable _importedNames = super.getImportedNames();
        Iterables.addAll((Collection)result, (Iterable)_importedNames);
        Resource _resource = this.getResource();
        EList _contents = _resource.getContents();
        for (EObject eobject : _contents) {
            final IResolvedTypes types = this.typeResolver.resolveTypes(eobject);
            TreeIterator _allContents = EcoreUtil.getAllContents((EObject)eobject, (boolean)true);
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, XExpression.class);
            Functions.Function1<XExpression, LightweightTypeReference> _function = new Functions.Function1<XExpression, LightweightTypeReference>(){

                public LightweightTypeReference apply(XExpression it) {
                    LightweightTypeReference _actualType = types.getActualType(it);
                    return _actualType;
                }
            };
            Iterator _map = IteratorExtensions.map((Iterator)_filter, (Functions.Function1)_function);
            Iterable actualTypes = IteratorExtensions.toIterable((Iterator)_map);
            for (LightweightTypeReference typeRef : actualTypes) {
                boolean _notEquals;
                boolean bl = _notEquals = !Objects.equal((Object)typeRef, null);
                if (!_notEquals) continue;
                JvmType _type = typeRef.getType();
                Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                    public Boolean apply(String it) {
                        QualifiedName _qualifiedName = XtendResourceDescription.this.nameConverter.toQualifiedName(it);
                        QualifiedName _lowerCase = _qualifiedName.toLowerCase();
                        boolean _add = result.add(_lowerCase);
                        return _add;
                    }
                };
                this.registerAllTypes(_type, (Functions.Function1<? super String, ? extends Boolean>)_function_1);
            }
            TreeIterator _allContents_1 = EcoreUtil.getAllContents((EObject)eobject, (boolean)true);
            UnmodifiableIterator _filter_1 = Iterators.filter((Iterator)_allContents_1, JvmIdentifiableElement.class);
            Functions.Function1<JvmIdentifiableElement, LightweightTypeReference> _function_2 = new Functions.Function1<JvmIdentifiableElement, LightweightTypeReference>(){

                public LightweightTypeReference apply(JvmIdentifiableElement it) {
                    LightweightTypeReference _xifexpression = null;
                    boolean _or = false;
                    if (!(it instanceof JvmType)) {
                        _or = true;
                    } else {
                        boolean bl = _or = !(it instanceof JvmType) || it instanceof JvmDeclaredType;
                    }
                    if (_or) {
                        LightweightTypeReference _actualType;
                        _xifexpression = _actualType = types.getActualType(it);
                    }
                    return _xifexpression;
                }
            };
            Iterator _map_1 = IteratorExtensions.map((Iterator)_filter_1, (Functions.Function1)_function_2);
            Iterable typesOfIdentifiables = IteratorExtensions.toIterable((Iterator)_map_1);
            for (LightweightTypeReference typeRef_1 : typesOfIdentifiables) {
                boolean _notEquals_1;
                boolean bl = _notEquals_1 = !Objects.equal((Object)typeRef_1, null);
                if (!_notEquals_1) continue;
                JvmType _type_1 = typeRef_1.getType();
                Functions.Function1<String, Boolean> _function_3 = new Functions.Function1<String, Boolean>(){

                    public Boolean apply(String it) {
                        QualifiedName _qualifiedName = XtendResourceDescription.this.nameConverter.toQualifiedName(it);
                        QualifiedName _lowerCase = _qualifiedName.toLowerCase();
                        boolean _add = result.add(_lowerCase);
                        return _add;
                    }
                };
                this.registerAllTypes(_type_1, (Functions.Function1<? super String, ? extends Boolean>)_function_3);
            }
        }
        Functions.Function1<QualifiedName, Boolean> _function = new Functions.Function1<QualifiedName, Boolean>(){

            public Boolean apply(QualifiedName it) {
                String _lastSegment = it.getLastSegment();
                boolean _contains = primitivesFilter.contains(_lastSegment);
                boolean _not = !_contains;
                return _not;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)result, (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)_filter);
    }

    public void registerAllTypes(JvmType type, final Functions.Function1<? super String, ? extends Boolean> acceptor) {
        boolean _matched;
        boolean _equals = Objects.equal((Object)type, null);
        if (_equals) {
            return;
        }
        String _identifier = type.getIdentifier();
        Boolean _apply = (Boolean)acceptor.apply((Object)_identifier);
        if (_apply.booleanValue() && !(_matched = false) && type instanceof JvmGenericType) {
            _matched = true;
            JvmDeclaredType _declaringType = ((JvmGenericType)type).getDeclaringType();
            this.registerAllTypes((JvmType)_declaringType, acceptor);
            JvmTypeReference _extendedClass = null;
            if ((JvmGenericType)type != null) {
                _extendedClass = ((JvmGenericType)type).getExtendedClass();
            }
            JvmType _type = null;
            if (_extendedClass != null) {
                _type = _extendedClass.getType();
            }
            this.registerAllTypes(_type, acceptor);
            Iterable _extendedInterfaces = ((JvmGenericType)type).getExtendedInterfaces();
            Procedures.Procedure1<JvmTypeReference> _function = new Procedures.Procedure1<JvmTypeReference>(){

                public void apply(JvmTypeReference it) {
                    JvmType _type = null;
                    if (it != null) {
                        _type = it.getType();
                    }
                    XtendResourceDescription.this.registerAllTypes(_type, (Functions.Function1<? super String, ? extends Boolean>)acceptor);
                }
            };
            IterableExtensions.forEach((Iterable)_extendedInterfaces, (Procedures.Procedure1)_function);
        }
    }
}

