/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionUtils {
    public static void checkInferredTypeReferences(String typeName, TypeReference ... types) {
        TypeReference[] typeReferenceArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _isInferred;
            TypeReference type = typeReferenceArray[n2];
            boolean _and = false;
            boolean _notEquals = !Objects.equal((Object)type, null);
            _and = !_notEquals ? false : (_isInferred = type.isInferred());
            if (_and) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Cannot use inferred type as ");
                _builder.append((Object)typeName, "");
                _builder.append((Object)".");
                throw new IllegalArgumentException(_builder.toString());
            }
            ++n2;
        }
    }

    public static void checkIterable(Iterable<? extends Object> values, String name) {
        boolean _notEquals = !Objects.equal(values, null);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)name, "");
        _builder.append((Object)" cannot be null");
        Preconditions.checkArgument((boolean)_notEquals, (Object)_builder);
        for (Object object : values) {
            boolean _notEquals_1 = !Objects.equal((Object)object, null);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)name, "");
            _builder_1.append((Object)" cannot contain null");
            Preconditions.checkArgument((boolean)_notEquals_1, (Object)_builder_1);
        }
    }

    public static void checkQualifiedName(String qualifiedName, String name) {
        boolean _isValidQualifiedName = ConditionUtils.isValidQualifiedName(qualifiedName);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)name, "");
        _builder.append((Object)" has to be a valid qualified name");
        Preconditions.checkArgument((boolean)_isValidQualifiedName, (Object)_builder);
    }

    public static void checkJavaIdentifier(String string, String name) {
        boolean _isValidJavaIdentifier = ConditionUtils.isValidJavaIdentifier(string);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)name, "");
        _builder.append((Object)" has to be a valid java identifier");
        Preconditions.checkArgument((boolean)_isValidJavaIdentifier, (Object)_builder);
    }

    public static void checkTypeName(String typeName, String valueType) {
        boolean _equals = Objects.equal((Object)typeName, (Object)valueType);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)valueType, "");
        _builder.append((Object)" is not applicable at this location. Expected ");
        _builder.append((Object)typeName, "");
        Preconditions.checkArgument((boolean)_equals, (Object)_builder);
    }

    public static boolean isValidQualifiedName(String string) {
        String[] _split;
        int _length;
        boolean _equals_1;
        boolean _xblockexpression = false;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)string, null);
        _or = _equals ? true : (_equals_1 = (_length = string.length()) == 0);
        if (_or) {
            return false;
        }
        String[] stringArray = _split = string.split("\\.");
        int n = _split.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _not;
            String identifier = stringArray[n2];
            boolean _isValidJavaIdentifier = ConditionUtils.isValidJavaIdentifier(identifier);
            boolean bl = _not = !_isValidJavaIdentifier;
            if (_not) {
                return false;
            }
            ++n2;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    public static boolean isValidJavaIdentifier(String string) {
        boolean _not;
        int _length;
        boolean _equals_1;
        boolean _xblockexpression = false;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)string, null);
        _or = _equals ? true : (_equals_1 = (_length = string.length()) == 0);
        if (_or) {
            return false;
        }
        char[] charArray = string.toCharArray();
        Character _head = (Character)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)charArray)));
        boolean _isJavaIdentifierStart = Character.isJavaIdentifierStart(_head.charValue());
        boolean bl = _not = !_isJavaIdentifierStart;
        if (_not) {
            return false;
        }
        Iterable _tail = IterableExtensions.tail((Iterable)((Iterable)Conversions.doWrapArray((Object)charArray)));
        for (Character ch : _tail) {
            boolean _not_1;
            boolean _isJavaIdentifierPart = Character.isJavaIdentifierPart(ch.charValue());
            boolean bl2 = _not_1 = !_isJavaIdentifierPart;
            if (!_not_1) continue;
            return false;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }
}

