/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.JvmNamedElementImpl;
import org.eclipse.xtend.core.macro.declaration.TypeLookupImpl;
import org.eclipse.xtend.core.macro.declaration.XtendNamedElementImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableNamedElement;
import org.eclipse.xtend.lib.macro.declaration.NamedElement;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.MutableFileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend.lib.macro.services.Problem;
import org.eclipse.xtend.lib.macro.services.ProblemSupport;
import org.eclipse.xtend.lib.macro.services.TypeReferenceProvider;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationContextImpl
implements TransformationContext {
    @Inject
    private IXtendJvmAssociations associations;
    private CompilationUnitImpl _unit;

    public CompilationUnitImpl getUnit() {
        return this._unit;
    }

    public void setUnit(CompilationUnitImpl unit) {
        this._unit = unit;
    }

    public boolean isExternal(NamedElement element) {
        boolean _isGenerated;
        boolean _not_1;
        boolean _not;
        boolean _and = false;
        boolean _isSource = this.isSource(element);
        boolean bl = _not = !_isSource;
        _and = !_not ? false : (_not_1 = !(_isGenerated = this.isGenerated(element)));
        return _and;
    }

    public boolean isGenerated(NamedElement element) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (!_matched && element instanceof JvmNamedElementImpl) {
            _matched = true;
            JvmIdentifiableElement _delegate = (JvmIdentifiableElement)((JvmNamedElementImpl)element).getDelegate();
            Resource _eResource = _delegate.eResource();
            CompilationUnitImpl _unit = this.getUnit();
            XtendFile _xtendFile = _unit.getXtendFile();
            Resource _eResource_1 = _xtendFile.eResource();
            return Objects.equal((Object)_eResource, (Object)_eResource_1);
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean isSource(NamedElement element) {
        return element instanceof XtendNamedElementImpl;
    }

    public MutableNamedElement getPrimaryGeneratedJavaElement(NamedElement source) {
        boolean _isSource = this.isSource(source);
        if (_isSource) {
            boolean _notEquals;
            EObject _delegate = (EObject)((XtendNamedElementImpl)source).getDelegate();
            Set _jvmElements = this.associations.getJvmElements(_delegate);
            Iterable _filter = Iterables.filter((Iterable)_jvmElements, JvmIdentifiableElement.class);
            JvmIdentifiableElement derivedElement = (JvmIdentifiableElement)IterableExtensions.head((Iterable)_filter);
            boolean bl = _notEquals = !Objects.equal((Object)derivedElement, null);
            if (_notEquals) {
                CompilationUnitImpl _unit = this.getUnit();
                NamedElement _namedElement = _unit.toNamedElement(derivedElement);
                return (MutableNamedElement)_namedElement;
            }
        }
        return null;
    }

    public void addError(Element element, String message) {
        CompilationUnitImpl _unit = this.getUnit();
        ProblemSupport _problemSupport = _unit.getProblemSupport();
        _problemSupport.addError(element, message);
    }

    public void addWarning(Element element, String message) {
        CompilationUnitImpl _unit = this.getUnit();
        ProblemSupport _problemSupport = _unit.getProblemSupport();
        _problemSupport.addWarning(element, message);
    }

    public List<Problem> getProblems(Element element) {
        CompilationUnitImpl _unit = this.getUnit();
        ProblemSupport _problemSupport = _unit.getProblemSupport();
        return _problemSupport.getProblems(element);
    }

    public TypeReference getAnyType() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getAnyType();
    }

    public TypeReference getList(TypeReference param) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getList(param);
    }

    public TypeReference getObject() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getObject();
    }

    public TypeReference getPrimitiveBoolean() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getPrimitiveBoolean();
    }

    public TypeReference getPrimitiveByte() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getPrimitiveByte();
    }

    public TypeReference getPrimitiveChar() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getPrimitiveChar();
    }

    public TypeReference getPrimitiveDouble() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getPrimitiveDouble();
    }

    public TypeReference getPrimitiveFloat() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getPrimitiveFloat();
    }

    public TypeReference getPrimitiveInt() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getPrimitiveInt();
    }

    public TypeReference getPrimitiveLong() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getPrimitiveLong();
    }

    public TypeReference getPrimitiveShort() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getPrimitiveShort();
    }

    public TypeReference getPrimitiveVoid() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getPrimitiveVoid();
    }

    public TypeReference getSet(TypeReference param) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getSet(param);
    }

    public TypeReference getString() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.getString();
    }

    public TypeReference newArrayTypeReference(TypeReference componentType) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.newArrayTypeReference(componentType);
    }

    public TypeReference newTypeReference(String typeName, TypeReference ... typeArguments) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.newTypeReference(typeName, typeArguments);
    }

    public TypeReference newTypeReference(Type typeDeclaration, TypeReference ... typeArguments) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.newTypeReference(typeDeclaration, typeArguments);
    }

    public TypeReference newTypeReference(Class<? extends Object> clazz, TypeReference ... typeArguments) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.newTypeReference(clazz, typeArguments);
    }

    public TypeReference newWildcardTypeReference() {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.newWildcardTypeReference();
    }

    public TypeReference newWildcardTypeReference(TypeReference upperBound) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.newWildcardTypeReference(upperBound);
    }

    public TypeReference newWildcardTypeReferenceWithLowerBound(TypeReference upperBound) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeReferenceProvider _typeReferenceProvider = _unit.getTypeReferenceProvider();
        return _typeReferenceProvider.newWildcardTypeReferenceWithLowerBound(upperBound);
    }

    public MutableInterfaceDeclaration findInterface(String qualifiedName) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeLookupImpl _typeLookup = _unit.getTypeLookup();
        return _typeLookup.findInterface(qualifiedName);
    }

    public MutableClassDeclaration findClass(String qualifiedName) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeLookupImpl _typeLookup = _unit.getTypeLookup();
        return _typeLookup.findClass(qualifiedName);
    }

    public MutableAnnotationTypeDeclaration findAnnotationType(String qualifiedName) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeLookupImpl _typeLookup = _unit.getTypeLookup();
        return _typeLookup.findAnnotationType(qualifiedName);
    }

    public MutableEnumerationTypeDeclaration findEnumerationType(String qualifiedName) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeLookupImpl _typeLookup = _unit.getTypeLookup();
        return _typeLookup.findEnumerationType(qualifiedName);
    }

    public Type findTypeGlobally(Class<? extends Object> clazz) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeLookupImpl _typeLookup = _unit.getTypeLookup();
        return _typeLookup.findTypeGlobally(clazz);
    }

    public Type findTypeGlobally(String typeName) {
        CompilationUnitImpl _unit = this.getUnit();
        TypeLookupImpl _typeLookup = _unit.getTypeLookup();
        return _typeLookup.findTypeGlobally(typeName);
    }

    public boolean exists(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        MutableFileSystemSupport _fileSystemSupport = _unit.getFileSystemSupport();
        return _fileSystemSupport.exists(path);
    }

    public String getCharset(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        MutableFileSystemSupport _fileSystemSupport = _unit.getFileSystemSupport();
        return _fileSystemSupport.getCharset(path);
    }

    public Iterable<? extends Path> getChildren(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        MutableFileSystemSupport _fileSystemSupport = _unit.getFileSystemSupport();
        return _fileSystemSupport.getChildren(path);
    }

    public CharSequence getContents(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        MutableFileSystemSupport _fileSystemSupport = _unit.getFileSystemSupport();
        return _fileSystemSupport.getContents(path);
    }

    public InputStream getContentsAsStream(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        MutableFileSystemSupport _fileSystemSupport = _unit.getFileSystemSupport();
        return _fileSystemSupport.getContentsAsStream(path);
    }

    public long getLastModification(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        MutableFileSystemSupport _fileSystemSupport = _unit.getFileSystemSupport();
        return _fileSystemSupport.getLastModification(path);
    }

    public Path getProjectFolder(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        FileLocations _fileLocations = _unit.getFileLocations();
        return _fileLocations.getProjectFolder(path);
    }

    public Path getSourceFolder(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        FileLocations _fileLocations = _unit.getFileLocations();
        return _fileLocations.getSourceFolder(path);
    }

    public Path getTargetFolder(Path sourceFolder) {
        CompilationUnitImpl _unit = this.getUnit();
        FileLocations _fileLocations = _unit.getFileLocations();
        return _fileLocations.getTargetFolder(sourceFolder);
    }

    public boolean isFile(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        MutableFileSystemSupport _fileSystemSupport = _unit.getFileSystemSupport();
        return _fileSystemSupport.isFile(path);
    }

    public boolean isFolder(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        MutableFileSystemSupport _fileSystemSupport = _unit.getFileSystemSupport();
        return _fileSystemSupport.isFolder(path);
    }

    public URI toURI(Path path) {
        CompilationUnitImpl _unit = this.getUnit();
        MutableFileSystemSupport _fileSystemSupport = _unit.getFileSystemSupport();
        return _fileSystemSupport.toURI(path);
    }
}

