/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.parser;

import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.xtend.core.parser.JFlexMain;

public class JFlexLoader
implements IWorkflowComponent,
JFlexMain {
    private static final Logger log = Logger.getLogger(JFlexLoader.class);
    private static final String DOWNLOAD_URL = "http://jflex.de/jflex-1.4.3.zip";
    private static final String MAIN_CLASS = "JFlex.Main";
    private ClassLoader loader = JFlexLoader.class.getClassLoader();
    private String downloadTo = "./.jflex.jar";
    private boolean askBeforeDownload = true;

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void runJFlex(String ... args) {
        try {
            Class<?> main = this.loader.loadClass(MAIN_CLASS);
            Method mainMethod = main.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setDownloadPath(String downloadTo) {
        this.downloadTo = downloadTo;
    }

    public void setAskBeforeDownload(boolean askBeforeDownload) {
        this.askBeforeDownload = askBeforeDownload;
    }

    public String getDownloadTo() {
        return this.downloadTo;
    }

    public File getJarFile() {
        return new File(this.downloadTo);
    }

    public void preInvoke() {
        block11: {
            try {
                this.loader.loadClass(MAIN_CLASS);
            }
            catch (ClassNotFoundException e) {
                File jarFile = this.getJarFile();
                if (!jarFile.exists()) {
                    try {
                        if (!this.download(jarFile)) {
                            return;
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                if (!jarFile.exists()) break block11;
                try {
                    URL url = jarFile.toURI().toURL();
                    this.loader = new URLClassLoader(new URL[]{url}, this.loader);
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this.loader);
                        this.loader.loadClass(MAIN_CLASS);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(contextClassLoader);
                    }
                }
                catch (Exception e1) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean download(final File jarFile) throws IOException {
        final File tempFile = File.createTempFile("JFlex", "zip");
        if (this.askBeforeDownload) {
            boolean ok = false;
            while (!ok) {
                System.err.print("Download JFlex 1.4.3? (type 'y' or 'n' and hit enter)");
                int read = System.in.read();
                if (read == 110) {
                    return false;
                }
                if (read != 121) continue;
                ok = true;
            }
        }
        log.info((Object)"downloading JFlex 1.4.3 from 'http://jflex.de/jflex-1.4.3.zip' ...");
        ByteStreams.copy((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return new BufferedInputStream(new URL(JFlexLoader.DOWNLOAD_URL).openStream());
            }
        }, (OutputSupplier)new OutputSupplier<OutputStream>(){

            public OutputStream getOutput() throws IOException {
                return new BufferedOutputStream(new FileOutputStream(tempFile));
            }
        });
        log.info((Object)("finished downloading. Now extracting to " + this.downloadTo));
        final ZipFile zipFile = new ZipFile(tempFile);
        try {
            final ZipEntry entry = zipFile.getEntry("jflex/lib/JFlex.jar");
            ByteStreams.copy((InputSupplier)new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return zipFile.getInputStream(entry);
                }
            }, (OutputSupplier)new OutputSupplier<OutputStream>(){

                public OutputStream getOutput() throws IOException {
                    return new BufferedOutputStream(new FileOutputStream(jarFile));
                }
            });
        }
        finally {
            zipFile.close();
        }
        return true;
    }

    public void invoke(IWorkflowContext ctx) {
    }

    public void postInvoke() {
    }
}

