/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.parser;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.parser.antlr.internal.FlexerFactory;
import org.eclipse.xtend.core.parser.antlr.internal.InternalXtendFlexer;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.NodeModelBuilder;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.parser.ParseException;
import org.eclipse.xtext.parser.ParseResult;
import org.eclipse.xtext.parser.antlr.IPartialParsingHelper;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.parser.impl.PartialParsingPointers;
import org.eclipse.xtext.parser.impl.Range;
import org.eclipse.xtext.util.ReplaceRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendPartialParsingHelper
implements IPartialParsingHelper {
    @Inject
    private IReferableElementsUnloader unloader;
    @Inject
    private NodeModelBuilder nodeModelBuilder;
    @Inject
    private FlexerFactory flexerFactory;

    public IParseResult reparse(IParser parser, IParseResult previousParseResult, ReplaceRegion changedRegion) {
        ICompositeNode oldRootNode = previousParseResult.getRootNode();
        Iterator<ILeafNode> leafNodes = oldRootNode.getLeafNodes().iterator();
        ILeafNode leftNode = this.getLeftNode(leafNodes, changedRegion.getOffset());
        if (leftNode == null) {
            return this.fullyReparse(parser, previousParseResult, changedRegion);
        }
        ILeafNode rightNode = this.getRightNode(leafNodes, changedRegion.getEndOffset());
        if (rightNode == null) {
            return this.fullyReparse(parser, previousParseResult, changedRegion);
        }
        String originalText = oldRootNode.getText().substring(leftNode.getTotalOffset(), rightNode.getTotalEndOffset());
        StringBuilder newTextBuilder = new StringBuilder(originalText);
        changedRegion.shiftBy(-leftNode.getTotalOffset()).applyTo(newTextBuilder);
        String newText = newTextBuilder.toString();
        if (originalText.equals(newText)) {
            return previousParseResult;
        }
        if (!this.isSameTokenSequence(originalText, newText)) {
            return this.fullyReparse(parser, previousParseResult, changedRegion);
        }
        PartialParsingPointers parsingPointers = this.calculatePartialParsingPointers(oldRootNode, leftNode, rightNode);
        ICompositeNode replaceMe = this.getReplacedNode(parsingPointers);
        if (replaceMe == null || replaceMe == oldRootNode) {
            return this.fullyReparse(parser, previousParseResult, changedRegion);
        }
        String reparseRegion = this.insertChangeIntoReplaceRegion(replaceMe, changedRegion);
        EObject oldSemanticElement = this.getOldSemanticElement(replaceMe, parsingPointers);
        if (oldSemanticElement == null) {
            return this.fullyReparse(parser, previousParseResult, changedRegion);
        }
        if (oldSemanticElement == replaceMe.getParent().getSemanticElement()) {
            throw new IllegalStateException("oldParent == oldElement");
        }
        IParseResult newParseResult = this.doParseRegion(parser, parsingPointers, replaceMe, reparseRegion);
        if (newParseResult == null) {
            throw new IllegalStateException("Could not perform a partial parse operation");
        }
        this.replaceOldSemanticElement(oldSemanticElement, previousParseResult, newParseResult);
        this.nodeModelBuilder.replaceAndTransferLookAhead((INode)replaceMe, (INode)newParseResult.getRootNode());
        ((ParseResult)newParseResult).setRootNode(oldRootNode);
        StringBuilder builder = new StringBuilder(oldRootNode.getText());
        changedRegion.applyTo(builder);
        this.nodeModelBuilder.setCompleteContent(oldRootNode, builder.toString());
        return newParseResult;
    }

    private void replaceOldSemanticElement(EObject oldElement, IParseResult previousParseResult, IParseResult newParseResult) {
        EObject oldSemanticParentElement = oldElement.eContainer();
        if (oldSemanticParentElement != null) {
            EStructuralFeature feature = oldElement.eContainingFeature();
            if (feature.isMany()) {
                List featureValueList = (List)oldSemanticParentElement.eGet(feature);
                int index = featureValueList.indexOf(oldElement);
                this.unloadSemanticObject(oldElement);
                featureValueList.set(index, newParseResult.getRootASTElement());
            } else {
                this.unloadSemanticObject(oldElement);
                oldSemanticParentElement.eSet(feature, (Object)newParseResult.getRootASTElement());
            }
            ((ParseResult)newParseResult).setRootASTElement(previousParseResult.getRootASTElement());
        } else {
            this.unloadSemanticObject(oldElement);
        }
    }

    private EObject getOldSemanticElement(ICompositeNode replaceMe, PartialParsingPointers parsingPointers) {
        EObject oldSemanticElement = null;
        if (replaceMe.hasDirectSemanticElement()) {
            oldSemanticElement = replaceMe.getSemanticElement();
        } else {
            List nodesEnclosingRegion = parsingPointers.getNodesEnclosingRegion();
            int i = nodesEnclosingRegion.size() - 1;
            while (i >= 0) {
                ICompositeNode enclosingNode = (ICompositeNode)nodesEnclosingRegion.get(i);
                if (enclosingNode == replaceMe) break;
                if (enclosingNode.hasDirectSemanticElement()) {
                    oldSemanticElement = enclosingNode.getSemanticElement();
                }
                --i;
            }
        }
        return oldSemanticElement;
    }

    private ICompositeNode getReplacedNode(PartialParsingPointers parsingPointers) {
        List validReplaceRootNodes = parsingPointers.getValidReplaceRootNodes();
        ICompositeNode replaceMe = null;
        int i = validReplaceRootNodes.size() - 1;
        while (i >= 0) {
            replaceMe = (ICompositeNode)validReplaceRootNodes.get(i);
            if (!(replaceMe instanceof SyntheticCompositeNode)) break;
            --i;
        }
        return replaceMe;
    }

    private IParseResult doParseRegion(IParser parser, PartialParsingPointers parsingPointers, ICompositeNode replaceMe, String reparseRegion) {
        EObject entryRuleOrRuleCall = parsingPointers.findEntryRuleOrRuleCall(replaceMe);
        IParseResult newParseResult = null;
        try {
            newParseResult = entryRuleOrRuleCall instanceof RuleCall ? parser.parse((RuleCall)entryRuleOrRuleCall, (Reader)new StringReader(reparseRegion), replaceMe.getLookAhead()) : parser.parse((ParserRule)entryRuleOrRuleCall, (Reader)new StringReader(reparseRegion));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return newParseResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSameTokenSequence(String originalText, String newText) {
        try {
            InternalXtendFlexer originalSequence = this.flexerFactory.createFlexer(new StringReader(originalText));
            InternalXtendFlexer newSequence = this.flexerFactory.createFlexer(new StringReader(newText));
            int token = originalSequence.advance();
            while (true) {
                if (token == -1) {
                    return newSequence.advance() == -1;
                }
                if (token != newSequence.advance()) {
                    return false;
                }
                token = originalSequence.advance();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ILeafNode getLeftNode(Iterator<ILeafNode> leafNodes, int offset) {
        while (leafNodes.hasNext()) {
            ILeafNode leaf = leafNodes.next();
            if (leaf.getTotalEndOffset() < offset) continue;
            if (leaf.getSyntaxErrorMessage() != null) {
                return null;
            }
            return leaf;
        }
        return null;
    }

    private ILeafNode getRightNode(Iterator<ILeafNode> leafNodes, int offset) {
        while (leafNodes.hasNext()) {
            ILeafNode leaf = leafNodes.next();
            if (leaf.getSyntaxErrorMessage() != null) {
                return null;
            }
            if (leaf.getTotalEndOffset() <= offset) continue;
            return leaf;
        }
        return null;
    }

    protected IParseResult fullyReparse(IParser parser, IParseResult previousParseResult, ReplaceRegion replaceRegion) {
        this.unloadSemanticObject(previousParseResult.getRootASTElement());
        String reparseRegion = this.insertChangeIntoReplaceRegion(previousParseResult.getRootNode(), replaceRegion);
        return parser.parse((Reader)new StringReader(reparseRegion));
    }

    private void unloadSemanticObject(EObject object) {
        if (this.unloader != null && object != null) {
            this.unloader.unloadRoot(object);
        }
    }

    private String insertChangeIntoReplaceRegion(ICompositeNode rootNode, ReplaceRegion region) {
        StringBuilder builder = new StringBuilder(rootNode.getText());
        region.shiftBy(0 - rootNode.getTotalOffset()).applyTo(builder);
        return builder.toString();
    }

    private PartialParsingPointers calculatePartialParsingPointers(ICompositeNode oldRoot, ILeafNode left, ILeafNode right) {
        ICompositeNode result = right.getParent();
        while (result.getTotalOffset() > left.getTotalOffset()) {
            result = result.getParent();
        }
        List<ICompositeNode> nodesEnclosingRegion = this.getAllParents(result);
        Range range = new Range(left.getTotalOffset(), right.getTotalEndOffset());
        List<ICompositeNode> validReplaceRootNodes = this.internalFindValidReplaceRootNodeForChangeRegion(nodesEnclosingRegion, range);
        this.filterInvalidRootNodes(result, validReplaceRootNodes);
        if (validReplaceRootNodes.isEmpty()) {
            validReplaceRootNodes = Collections.singletonList(oldRoot);
        }
        return new PartialParsingPointers(oldRoot, range.getOffset(), range.getLength(), validReplaceRootNodes, nodesEnclosingRegion);
    }

    private List<ICompositeNode> getAllParents(ICompositeNode node) {
        ArrayList list = Lists.newArrayList((Object[])new ICompositeNode[]{node});
        node = node.getParent();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        return Lists.reverse((List)list);
    }

    private void filterInvalidRootNodes(ICompositeNode oldRootNode, List<ICompositeNode> validReplaceRootNodes) {
        ListIterator<ICompositeNode> iter = validReplaceRootNodes.listIterator(validReplaceRootNodes.size());
        while (iter.hasPrevious()) {
            ICompositeNode candidate = iter.previous();
            if (this.isInvalidRootNode(oldRootNode, candidate)) {
                iter.remove();
                continue;
            }
            return;
        }
    }

    private boolean isInvalidRootNode(ICompositeNode rootNode, ICompositeNode candidate) {
        AbstractRule rule;
        if (candidate instanceof SyntheticCompositeNode) {
            return true;
        }
        if (candidate.getGrammarElement() instanceof RuleCall && (!((rule = ((RuleCall)candidate.getGrammarElement()).getRule()) instanceof ParserRule) || GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)rule)))) {
            return true;
        }
        return candidate.getGrammarElement() instanceof Action;
    }

    private List<ICompositeNode> internalFindValidReplaceRootNodeForChangeRegion(List<ICompositeNode> nodesEnclosingRegion, Range range) {
        ArrayList<ICompositeNode> result = new ArrayList<ICompositeNode>();
        boolean mustSkipNext = false;
        int i = 0;
        while (i < nodesEnclosingRegion.size()) {
            ICompositeNode node = nodesEnclosingRegion.get(i);
            if (node.getGrammarElement() != null) {
                if (!mustSkipNext) {
                    result.add(node);
                    if (this.isActionNode(node)) {
                        mustSkipNext = true;
                    }
                } else {
                    mustSkipNext = this.isActionNode(node);
                }
            }
            ++i;
        }
        return result;
    }

    private boolean isActionNode(ICompositeNode node) {
        return node.getGrammarElement() != null && node.getGrammarElement().eClass() == XtextPackage.Literals.ACTION;
    }
}

