/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationTypeDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeElementDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableJvmAnnotationTypeDeclarationImpl
extends JvmAnnotationTypeDeclarationImpl
implements MutableAnnotationTypeDeclaration {
    public MutableMethodDeclaration findDeclaredMethod(String name, TypeReference ... parameterTypes) {
        MethodDeclaration _findDeclaredMethod = super.findDeclaredMethod(name, parameterTypes);
        return (MutableMethodDeclaration)_findDeclaredMethod;
    }

    public MutableFieldDeclaration findDeclaredField(String name) {
        FieldDeclaration _findDeclaredField = super.findDeclaredField(name);
        return (MutableFieldDeclaration)_findDeclaredField;
    }

    public MutableConstructorDeclaration findDeclaredConstructor(TypeReference ... parameterTypes) {
        ConstructorDeclaration _findDeclaredConstructor = super.findDeclaredConstructor(parameterTypes);
        return (MutableConstructorDeclaration)_findDeclaredConstructor;
    }

    @Override
    public Iterable<? extends MutableMethodDeclaration> getDeclaredMethods() {
        Iterable<MethodDeclaration> _declaredMethods = super.getDeclaredMethods();
        return _declaredMethods;
    }

    @Override
    public Iterable<? extends MutableFieldDeclaration> getDeclaredFields() {
        Iterable<FieldDeclaration> _declaredFields = super.getDeclaredFields();
        return _declaredFields;
    }

    @Override
    public Iterable<? extends MutableClassDeclaration> getDeclaredClasses() {
        Iterable<ClassDeclaration> _declaredClasses = super.getDeclaredClasses();
        return _declaredClasses;
    }

    @Override
    public Iterable<? extends MutableConstructorDeclaration> getDeclaredConstructors() {
        Iterable<ConstructorDeclaration> _declaredConstructors = super.getDeclaredConstructors();
        return _declaredConstructors;
    }

    @Override
    public Iterable<? extends MutableInterfaceDeclaration> getDeclaredInterfaces() {
        Iterable<InterfaceDeclaration> _declaredInterfaces = super.getDeclaredInterfaces();
        return _declaredInterfaces;
    }

    public MutableAnnotationReference findAnnotation(Type annotationType) {
        AnnotationReference _findAnnotation = super.findAnnotation(annotationType);
        return (MutableAnnotationReference)_findAnnotation;
    }

    @Override
    public Iterable<? extends MutableAnnotationReference> getAnnotations() {
        Iterable<AnnotationReference> _annotations = super.getAnnotations();
        return _annotations;
    }

    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    @Override
    public Iterable<? extends MutableMemberDeclaration> getDeclaredMembers() {
        Iterable<MemberDeclaration> _declaredMembers = super.getDeclaredMembers();
        return _declaredMembers;
    }

    public MutableAnnotationTypeElementDeclaration addAnnotationTypeElement(String name, Procedures.Procedure1<MutableAnnotationTypeElementDeclaration> initializer) {
        ConditionUtils.checkJavaIdentifier(name, "name");
        boolean _notEquals = !Objects.equal(initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        JvmOperation newAnnotationElement = TypesFactory.eINSTANCE.createJvmOperation();
        newAnnotationElement.setSimpleName(name);
        newAnnotationElement.setVisibility(JvmVisibility.PUBLIC);
        JvmAnnotationType _delegate = (JvmAnnotationType)this.getDelegate();
        EList _members = _delegate.getMembers();
        _members.add((Object)newAnnotationElement);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        MemberDeclaration _memberDeclaration = _compilationUnit.toMemberDeclaration((JvmMember)newAnnotationElement);
        MutableAnnotationTypeElementDeclaration mutableAnnotationTypeElementDeclaration = (MutableAnnotationTypeElementDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableAnnotationTypeElementDeclaration);
        return mutableAnnotationTypeElementDeclaration;
    }

    public MutableAnnotationTypeElementDeclaration findDeclaredAnnotationTypeElement(final String name) {
        Iterable<? extends MutableAnnotationTypeElementDeclaration> _declaredAnnotationTypeElements = this.getDeclaredAnnotationTypeElements();
        Functions.Function1<MutableAnnotationTypeElementDeclaration, Boolean> _function = new Functions.Function1<MutableAnnotationTypeElementDeclaration, Boolean>(){

            public Boolean apply(MutableAnnotationTypeElementDeclaration it) {
                String _simpleName = it.getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)name);
            }
        };
        return (MutableAnnotationTypeElementDeclaration)IterableExtensions.findFirst(_declaredAnnotationTypeElements, (Functions.Function1)_function);
    }

    public Iterable<? extends MutableAnnotationTypeElementDeclaration> getDeclaredAnnotationTypeElements() {
        JvmAnnotationType _delegate = (JvmAnnotationType)this.getDelegate();
        EList _members = _delegate.getMembers();
        Functions.Function1<JvmMember, MemberDeclaration> _function = new Functions.Function1<JvmMember, MemberDeclaration>(){

            public MemberDeclaration apply(JvmMember it) {
                CompilationUnit _compilationUnit = MutableJvmAnnotationTypeDeclarationImpl.this.getCompilationUnit();
                return _compilationUnit.toMemberDeclaration(it);
            }
        };
        List _map = ListExtensions.map((List)_members, (Functions.Function1)_function);
        return Iterables.filter((Iterable)_map, MutableAnnotationTypeElementDeclaration.class);
    }
}

