/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.compiler.MacroAwareStringConcatenation;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.CodeGenerationContextImpl;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.CodeGenerationParticipant;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.MutableFileSystemSupport;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.JvmModelGenerator;
import org.eclipse.xtext.xbase.compiler.LoopParams;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ImportingStringConcatenation;
import org.eclipse.xtext.xbase.compiler.output.SharedAppendableState;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendGenerator
extends JvmModelGenerator {
    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        super.doGenerate(input, fsa);
        this.callMacroProcessors(input);
    }

    public void callMacroProcessors(Resource input) {
        ActiveAnnotationContexts ctxs = ActiveAnnotationContexts.find(input);
        boolean _equals = Objects.equal((Object)((Object)ctxs), null);
        if (_equals) {
            return;
        }
        Map<JvmAnnotationType, ActiveAnnotationContext> _contexts = ctxs.getContexts();
        Collection<ActiveAnnotationContext> _values = _contexts.values();
        for (final ActiveAnnotationContext context : _values) {
            try {
                Object _processorInstance;
                Object processor = _processorInstance = context.getProcessorInstance();
                boolean _matched = false;
                if (_matched || !(processor instanceof CodeGenerationParticipant)) continue;
                _matched = true;
                CodeGenerationContextImpl _codeGenerationContextImpl = new CodeGenerationContextImpl();
                Procedures.Procedure1<CodeGenerationContextImpl> _function = new Procedures.Procedure1<CodeGenerationContextImpl>(){

                    public void apply(CodeGenerationContextImpl it) {
                        CompilationUnitImpl _compilationUnit = context.getCompilationUnit();
                        MutableFileSystemSupport _fileSystemSupport = _compilationUnit.getFileSystemSupport();
                        it.setFileSystemSupport(_fileSystemSupport);
                        CompilationUnitImpl _compilationUnit_1 = context.getCompilationUnit();
                        FileLocations _fileLocations = _compilationUnit_1.getFileLocations();
                        it.setFileLocations(_fileLocations);
                    }
                };
                CodeGenerationContextImpl codeGenServices = (CodeGenerationContextImpl)ObjectExtensions.operator_doubleArrow((Object)_codeGenerationContextImpl, (Procedures.Procedure1)_function);
                List<XtendAnnotationTarget> _annotatedSourceElements = context.getAnnotatedSourceElements();
                Functions.Function1<XtendAnnotationTarget, MemberDeclaration> _function_1 = new Functions.Function1<XtendAnnotationTarget, MemberDeclaration>(){

                    public MemberDeclaration apply(XtendAnnotationTarget it) {
                        CompilationUnitImpl _compilationUnit = context.getCompilationUnit();
                        return _compilationUnit.toXtendMemberDeclaration((XtendMember)it);
                    }
                };
                List elements = ListExtensions.map(_annotatedSourceElements, (Functions.Function1)_function_1);
                ((CodeGenerationParticipant)processor).doGenerateCode(elements, (CodeGenerationContext)codeGenServices);
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable t = _t;
                    context.handleProcessingError(input, t);
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    protected ImportingStringConcatenation createImportingStringConcatenation(SharedAppendableState state, ITypeReferenceOwner owner) {
        return new MacroAwareStringConcatenation(state, owner);
    }

    public String doConvertToJavaString(String input) {
        return Strings.convertToJavaString((String)input, (boolean)false);
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmGenericType it) {
        Iterable _xifexpression = null;
        boolean _isLocal = it.isLocal();
        if (_isLocal) {
            EList _members = it.getMembers();
            Functions.Function1<JvmMember, Boolean> _function = new Functions.Function1<JvmMember, Boolean>(){

                public Boolean apply(JvmMember it) {
                    return it instanceof JvmOperation;
                }
            };
            _xifexpression = IterableExtensions.filter((Iterable)_members, (Functions.Function1)_function);
        } else {
            _xifexpression = this._getMembersToBeCompiled((JvmDeclaredType)it);
        }
        return _xifexpression;
    }

    protected ArrayList<JvmMember> getAddedDeclarations(JvmGenericType it, AnonymousClass anonymousClass) {
        boolean _greaterEqualsThan;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new JvmMember[0]);
        XConstructorCall _constructorCall = anonymousClass.getConstructorCall();
        JvmConstructor constructor = _constructorCall.getConstructor();
        EList _parameters = constructor.getParameters();
        int _size = _parameters.size();
        boolean bl = _greaterEqualsThan = _size >= 1;
        if (_greaterEqualsThan) {
            result.add(0, constructor);
        }
        Iterable _declaredFields = it.getDeclaredFields();
        Iterables.addAll((Collection)result, (Iterable)_declaredFields);
        Iterable _declaredOperations = it.getDeclaredOperations();
        Functions.Function1<JvmOperation, Boolean> _function = new Functions.Function1<JvmOperation, Boolean>(){

            public Boolean apply(JvmOperation it) {
                Set _sourceElements = XtendGenerator.this.getSourceElements((EObject)it);
                EObject _head = (EObject)IterableExtensions.head((Iterable)_sourceElements);
                XtendFunction function = (XtendFunction)_head;
                boolean _isOverride = function.isOverride();
                return !_isOverride;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_declaredOperations, (Functions.Function1)_function);
        Iterables.addAll((Collection)result, (Iterable)_filter);
        EList _members = it.getMembers();
        Iterable _filter_1 = Iterables.filter((Iterable)_members, JvmDeclaredType.class);
        Iterables.addAll((Collection)result, (Iterable)_filter_1);
        return result;
    }

    public ITreeAppendable compile(JvmExecutable executable, XExpression expression, JvmTypeReference returnType, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        this.compileLocalTypeStubs((JvmFeature)executable, appendable, config);
        _xblockexpression = super.compile(executable, expression, returnType, appendable, config);
        return _xblockexpression;
    }

    public void compileLocalTypeStubs(JvmFeature feature, final ITreeAppendable appendable, final GeneratorConfig config) {
        EList _localClasses = feature.getLocalClasses();
        Functions.Function1<JvmGenericType, Boolean> _function = new Functions.Function1<JvmGenericType, Boolean>(){

            public Boolean apply(JvmGenericType it) {
                boolean _isAnonymous = it.isAnonymous();
                return !_isAnonymous;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_localClasses, (Functions.Function1)_function);
        Procedures.Procedure1<JvmGenericType> _function_1 = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(JvmGenericType it) {
                appendable.newLine();
                Set _sourceElements = XtendGenerator.this.getSourceElements((EObject)it);
                EObject _head = (EObject)IterableExtensions.head((Iterable)_sourceElements);
                AnonymousClass anonymousClass = (AnonymousClass)_head;
                final ITreeAppendable childAppendable = appendable.trace((EObject)anonymousClass);
                childAppendable.append((CharSequence)"abstract class ");
                ITreeAppendable _traceSignificant = XtendGenerator.this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)anonymousClass);
                String _simpleName = it.getSimpleName();
                _traceSignificant.append((CharSequence)_simpleName);
                EList _typeParameters = it.getTypeParameters();
                boolean _isEmpty = _typeParameters.isEmpty();
                if (_isEmpty) {
                    childAppendable.append((CharSequence)" ");
                }
                XtendGenerator.this.generateExtendsClause((JvmDeclaredType)it, childAppendable, null);
                ITreeAppendable _append = childAppendable.append((CharSequence)"{");
                _append.increaseIndentation();
                ArrayList<JvmMember> _addedDeclarations = XtendGenerator.this.getAddedDeclarations(it, anonymousClass);
                Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

                    public void apply(LoopParams it) {
                        Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                            public ITreeAppendable apply(ITreeAppendable it) {
                                return it.newLine();
                            }
                        };
                        it.setSeparator((Functions.Function1)_function);
                    }
                };
                Procedures.Procedure1<JvmMember> _function_1 = new Procedures.Procedure1<JvmMember>(){

                    public void apply(JvmMember it) {
                        ITreeAppendable memberAppendable = XtendGenerator.this._treeAppendableUtil.traceWithComments(childAppendable, (EObject)it);
                        memberAppendable.openScope();
                        if (it instanceof JvmOperation) {
                            ITreeAppendable tracedAppendable = childAppendable.trace((EObject)it);
                            tracedAppendable.newLine();
                            XtendGenerator.this.generateJavaDoc((EObject)it, tracedAppendable, config);
                            XtendGenerator.this.generateVisibilityModifier(it, tracedAppendable);
                            tracedAppendable.append((CharSequence)"abstract ");
                            XtendGenerator.this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable, null);
                            JvmTypeReference _returnType = ((JvmOperation)it).getReturnType();
                            boolean _equals = Objects.equal((Object)_returnType, null);
                            if (_equals) {
                                tracedAppendable.append((CharSequence)"void");
                            } else {
                                JvmTypeReference _returnType_1 = ((JvmOperation)it).getReturnType();
                                XtendGenerator.this._errorSafeExtensions.serializeSafely(_returnType_1, "Object", tracedAppendable);
                            }
                            tracedAppendable.append((CharSequence)" ");
                            ITreeAppendable _traceSignificant = XtendGenerator.this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
                            String _simpleName = ((JvmOperation)it).getSimpleName();
                            _traceSignificant.append((CharSequence)_simpleName);
                            tracedAppendable.append((CharSequence)"(");
                            XtendGenerator.this.generateParameters((JvmExecutable)it, tracedAppendable, null);
                            tracedAppendable.append((CharSequence)")");
                            XtendGenerator.this.generateThrowsClause((JvmExecutable)it, tracedAppendable, null);
                            tracedAppendable.append((CharSequence)";");
                        } else if (it instanceof JvmField) {
                            ITreeAppendable tracedAppendable_1 = childAppendable.trace((EObject)it);
                            tracedAppendable_1.newLine();
                            XtendGenerator.this.generateJavaDoc((EObject)it, tracedAppendable_1, config);
                            EList _annotations = ((JvmField)it).getAnnotations();
                            XtendGenerator.this.generateAnnotations((Iterable)_annotations, tracedAppendable_1, true, config);
                            JvmTypeReference _type = ((JvmField)it).getType();
                            XtendGenerator.this._errorSafeExtensions.serializeSafely(_type, "Object", tracedAppendable_1);
                            tracedAppendable_1.append((CharSequence)" ");
                            ITreeAppendable _traceSignificant_1 = XtendGenerator.this._treeAppendableUtil.traceSignificant(tracedAppendable_1, (EObject)it);
                            String _simpleName_1 = ((JvmField)it).getSimpleName();
                            _traceSignificant_1.append((CharSequence)_simpleName_1);
                            tracedAppendable_1.append((CharSequence)";");
                        } else {
                            XtendGenerator.this.generateMember(it, memberAppendable, config);
                        }
                        memberAppendable.closeScope();
                    }
                };
                XtendGenerator.this._loopExtensions.forEach(childAppendable, _addedDeclarations, (Procedures.Procedure1)_function, (Procedures.Procedure1)_function_1);
                ITreeAppendable _decreaseIndentation = childAppendable.decreaseIndentation();
                ITreeAppendable _newLine = _decreaseIndentation.newLine();
                _newLine.append((CharSequence)"}");
                appendable.newLine();
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
    }

    public ITreeAppendable generateVisibilityModifier(JvmMember it, ITreeAppendable result) {
        ITreeAppendable _xblockexpression = null;
        boolean _and = false;
        JvmVisibility _visibility = it.getVisibility();
        boolean _equals = Objects.equal((Object)_visibility, (Object)JvmVisibility.PRIVATE);
        if (!_equals) {
            _and = false;
        } else {
            boolean _isLocal;
            JvmDeclaredType _declaringType = it.getDeclaringType();
            _and = _isLocal = _declaringType.isLocal();
        }
        if (_and && it instanceof JvmOperation) {
            boolean _not;
            JvmDeclaredType _declaringType_1 = ((JvmOperation)it).getDeclaringType();
            JvmGenericType declarator = (JvmGenericType)_declaringType_1;
            boolean _isAnonymous = declarator.isAnonymous();
            boolean bl = _not = !_isAnonymous;
            if (_not) {
                return result;
            }
        }
        _xblockexpression = super.generateVisibilityModifier(it, result);
        return _xblockexpression;
    }

    public ITreeAppendable generateMembersInBody(JvmDeclaredType it, final ITreeAppendable appendable, final GeneratorConfig config) {
        ITreeAppendable _xifexpression = null;
        boolean _isLocal = it.isLocal();
        if (_isLocal) {
            boolean _not;
            ITreeAppendable _xblockexpression = null;
            ITreeAppendable _append = appendable.append((CharSequence)"{");
            _append.increaseIndentation();
            Iterable _declaredFields = it.getDeclaredFields();
            Functions.Function1<JvmField, Boolean> _function = new Functions.Function1<JvmField, Boolean>(){

                public Boolean apply(JvmField it) {
                    boolean _isGenerateExpressions;
                    boolean _notEquals_1;
                    boolean _notEquals;
                    boolean _xblockexpression = false;
                    Procedures.Procedure1 _compilationStrategy = XtendGenerator.this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
                    boolean bl = _notEquals = !Objects.equal((Object)_compilationStrategy, null);
                    if (_notEquals) {
                        return true;
                    }
                    StringConcatenationClient _compilationTemplate = XtendGenerator.this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)it);
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)_compilationTemplate, null);
                    if (_notEquals_1) {
                        return true;
                    }
                    XExpression expression = XtendGenerator.this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
                    boolean _and = false;
                    boolean _notEquals_2 = !Objects.equal((Object)expression, null);
                    _and = !_notEquals_2 ? false : (_isGenerateExpressions = config.isGenerateExpressions());
                    if (_and) {
                        return true;
                    }
                    _xblockexpression = false;
                    return _xblockexpression;
                }
            };
            Iterable fieldsWithInitializer = IterableExtensions.filter((Iterable)_declaredFields, (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)fieldsWithInitializer);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                ITreeAppendable _newLine = appendable.newLine();
                ITreeAppendable _append_1 = _newLine.append((CharSequence)"{");
                _append_1.increaseIndentation();
                Procedures.Procedure1<LoopParams> _function_1 = new Procedures.Procedure1<LoopParams>(){

                    public void apply(LoopParams it) {
                        Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                            public ITreeAppendable apply(ITreeAppendable it) {
                                return it.newLine();
                            }
                        };
                        it.setSeparator((Functions.Function1)_function);
                    }
                };
                Procedures.Procedure1<JvmField> _function_2 = new Procedures.Procedure1<JvmField>(){

                    public void apply(JvmField it) {
                        ITreeAppendable memberAppendable = XtendGenerator.this._treeAppendableUtil.traceWithComments(appendable, (EObject)it);
                        memberAppendable.openScope();
                        appendable.newLine();
                        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
                        ITreeAppendable _traceSignificant = XtendGenerator.this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
                        String _simpleName = it.getSimpleName();
                        _traceSignificant.append((CharSequence)_simpleName);
                        XtendGenerator.this.generateInitialization(it, tracedAppendable, config);
                        tracedAppendable.append((CharSequence)";");
                        memberAppendable.closeScope();
                    }
                };
                this._loopExtensions.forEach(appendable, fieldsWithInitializer, (Procedures.Procedure1)_function_1, (Procedures.Procedure1)_function_2);
                ITreeAppendable _decreaseIndentation = appendable.decreaseIndentation();
                ITreeAppendable _newLine_1 = _decreaseIndentation.newLine();
                _newLine_1.append((CharSequence)"}");
            }
            Iterable _membersToBeCompiled = this.getMembersToBeCompiled(it);
            Procedures.Procedure1<LoopParams> _function_3 = new Procedures.Procedure1<LoopParams>(){

                public void apply(LoopParams it) {
                    Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                        public ITreeAppendable apply(ITreeAppendable it) {
                            return it.newLine();
                        }
                    };
                    it.setSeparator((Functions.Function1)_function);
                }
            };
            Procedures.Procedure1<JvmMember> _function_4 = new Procedures.Procedure1<JvmMember>(){

                public void apply(JvmMember it) {
                    ITreeAppendable memberAppendable = XtendGenerator.this._treeAppendableUtil.traceWithComments(appendable, (EObject)it);
                    memberAppendable.openScope();
                    XtendGenerator.this.generateMember(it, memberAppendable, config);
                    memberAppendable.closeScope();
                }
            };
            this._loopExtensions.forEach(appendable, _membersToBeCompiled, (Procedures.Procedure1)_function_3, (Procedures.Procedure1)_function_4);
            ITreeAppendable _decreaseIndentation_1 = appendable.decreaseIndentation();
            ITreeAppendable _newLine_2 = _decreaseIndentation_1.newLine();
            _xifexpression = _xblockexpression = _newLine_2.append((CharSequence)"}");
        } else {
            _xifexpression = super.generateMembersInBody(it, appendable, config);
        }
        return _xifexpression;
    }
}

