/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.CreateExtensionInfo;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMethodCompileStrategy
implements Procedures.Procedure1<ITreeAppendable> {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private XbaseCompiler compiler;
    @Inject
    private CommonTypeComputationServices services;
    private CreateExtensionInfo createExtensionInfo;
    private JvmOperation initializerMethod;
    private JvmField cacheField;

    protected void init(CreateExtensionInfo createExtensionInfo, JvmField cacheField, JvmOperation initializerMethod) {
        this.createExtensionInfo = createExtensionInfo;
        this.initializerMethod = initializerMethod;
        this.cacheField = cacheField;
    }

    public void apply(ITreeAppendable appendable) {
        JvmOperation cacheMethod = (JvmOperation)this.logicalContainerProvider.getLogicalContainer((EObject)this.createExtensionInfo.getCreateExpression());
        JvmDeclaredType containerType = cacheMethod.getDeclaringType();
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)containerType);
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)containerType);
        ParameterizedTypeReference listType = new ParameterizedTypeReference((ITypeReferenceOwner)owner, this.typeReferences.findDeclaredType(ArrayList.class, (Notifier)containerType));
        listType.addTypeArgument((LightweightTypeReference)new WildcardTypeReference((ITypeReferenceOwner)owner));
        JvmType collectonLiterals = this.typeReferences.findDeclaredType(CollectionLiterals.class, (Notifier)containerType);
        String cacheVarName = this.cacheField.getSimpleName();
        String cacheKeyVarName = appendable.declareSyntheticVariable((Object)"CacheKey", "_cacheKey");
        appendable.append((CharSequence)"final ").append((LightweightTypeReference)listType).append((CharSequence)" ").append((CharSequence)cacheKeyVarName).append((CharSequence)" = ").append(collectonLiterals).append((CharSequence)".newArrayList(");
        EList list = cacheMethod.getParameters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JvmFormalParameter jvmFormalParameter = (JvmFormalParameter)iterator.next();
            appendable.append((CharSequence)this.getVarName((JvmIdentifiableElement)jvmFormalParameter));
            if (!iterator.hasNext()) continue;
            appendable.append((CharSequence)", ");
        }
        appendable.append((CharSequence)");");
        LightweightTypeReference returnType = resolvedTypes.getActualType(this.createExtensionInfo.getCreateExpression());
        if (returnType != null) {
            appendable.newLine().append((CharSequence)"final ").append(returnType);
        } else {
            appendable.newLine().append((CharSequence)"final Object");
        }
        String resultVarName = "_result";
        appendable.append((CharSequence)" ").append((CharSequence)resultVarName).append((CharSequence)";");
        appendable.newLine().append((CharSequence)"synchronized (").append((CharSequence)cacheVarName).append((CharSequence)") {");
        appendable.increaseIndentation();
        appendable.newLine().append((CharSequence)"if (").append((CharSequence)cacheVarName).append((CharSequence)".containsKey(").append((CharSequence)cacheKeyVarName).append((CharSequence)")) {");
        appendable.increaseIndentation();
        appendable.newLine().append((CharSequence)"return ").append((CharSequence)cacheVarName).append((CharSequence)".get(").append((CharSequence)cacheKeyVarName).append((CharSequence)");");
        appendable.decreaseIndentation().newLine().append((CharSequence)"}");
        this.compiler.toJavaStatement(this.createExtensionInfo.getCreateExpression(), appendable, true);
        appendable.newLine();
        appendable.append((CharSequence)resultVarName).append((CharSequence)" = ");
        this.compiler.toJavaExpression(this.createExtensionInfo.getCreateExpression(), appendable);
        appendable.append((CharSequence)";");
        appendable.newLine().append((CharSequence)cacheVarName).append((CharSequence)".put(").append((CharSequence)cacheKeyVarName).append((CharSequence)", ").append((CharSequence)resultVarName).append((CharSequence)");");
        appendable.decreaseIndentation();
        appendable.newLine().append((CharSequence)"}");
        appendable.newLine().append((CharSequence)this.initializerMethod.getSimpleName()).append((CharSequence)"(").append((CharSequence)resultVarName);
        for (JvmFormalParameter parameter : cacheMethod.getParameters()) {
            appendable.append((CharSequence)", ").append((CharSequence)parameter.getName());
        }
        appendable.append((CharSequence)");");
        appendable.newLine().append((CharSequence)"return ");
        appendable.append((CharSequence)resultVarName).append((CharSequence)";");
    }

    protected String getVarName(JvmIdentifiableElement ex) {
        return ex.getSimpleName();
    }
}

