/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.declaration.ExpressionImpl;
import org.eclipse.xtend.core.macro.declaration.JvmFieldDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.validation.ReadAndWriteTracking;

public class MutableJvmFieldDeclarationImpl
extends JvmFieldDeclarationImpl
implements MutableFieldDeclaration {
    public void markAsRead() {
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        ReadAndWriteTracking _readAndWriteTracking = _compilationUnit.getReadAndWriteTracking();
        JvmField _delegate = (JvmField)this.getDelegate();
        _readAndWriteTracking.markReadAccess((EObject)_delegate);
    }

    public void markAsInitialized() {
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        ReadAndWriteTracking _readAndWriteTracking = _compilationUnit.getReadAndWriteTracking();
        JvmField _delegate = (JvmField)this.getDelegate();
        _readAndWriteTracking.markInitialized((EObject)_delegate);
    }

    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    public void setInitializer(Expression initializer) {
        boolean _equals = Objects.equal((Object)initializer, null);
        if (_equals) {
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            JvmTypesBuilder _jvmTypesBuilder = _compilationUnit.getJvmTypesBuilder();
            JvmField _delegate = (JvmField)this.getDelegate();
            _jvmTypesBuilder.removeExistingBody((JvmMember)_delegate);
        } else {
            CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
            JvmTypesBuilder _jvmTypesBuilder_1 = _compilationUnit_1.getJvmTypesBuilder();
            JvmField _delegate_1 = (JvmField)this.getDelegate();
            XExpression _delegate_2 = (XExpression)((ExpressionImpl)initializer).getDelegate();
            _jvmTypesBuilder_1.setInitializer(_delegate_1, _delegate_2);
        }
    }

    public void setInitializer(CompilationStrategy initializer) {
        boolean _notEquals = !Objects.equal((Object)initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        _compilationUnit.setCompilationStrategy(_delegate, initializer);
    }

    public void setInitializer(StringConcatenationClient template) {
        boolean _notEquals = !Objects.equal((Object)template, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"template cannot be null");
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        _compilationUnit.setCompilationTemplate(_delegate, template);
    }

    public void setFinal(boolean isFinal) {
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setFinal(isFinal);
    }

    public void setStatic(boolean isStatic) {
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setStatic(isStatic);
    }

    public void setTransient(boolean isTransient) {
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setTransient(isTransient);
    }

    public void setVolatile(boolean isVolatile) {
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setVolatile(isVolatile);
    }

    public void setType(TypeReference type) {
        boolean _notEquals = !Objects.equal((Object)type, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"type cannot be null");
        JvmField _delegate = (JvmField)this.getDelegate();
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmTypeReference _jvmTypeReference = _compilationUnit.toJvmTypeReference(type);
        _delegate.setType(_jvmTypeReference);
    }
}

