/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.parser;

import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.emf.mwe2.runtime.Mandatory;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandFacade;
import org.eclipse.xtend.core.parser.JFlexMain;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.NewlineNormalizer;
import org.eclipse.xtext.generator.parser.antlr.XtextAntlrGeneratorFragment;
import org.eclipse.xtext.generator.parser.antlr.XtextAntlrUiGeneratorFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFlexGeneratorFragment
extends AbstractGeneratorFragment {
    private JFlexMain main;
    private String patternPath;
    private String additionalRulePath;
    private boolean ui = false;

    @Mandatory
    public void setJFlexMain(JFlexMain main) {
        this.main = main;
    }

    public void setUi(boolean ui) {
        this.ui = ui;
    }

    protected String getEncoding(XpandExecutionContext xpt, String outlet) {
        return xpt.getOutput().getOutlet(outlet).getFileEncoding();
    }

    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        String encoding;
        String template;
        String directory;
        if (!this.ui) {
            String srcGenPath = ctx.getOutput().getOutlet("SRC_GEN").getPath();
            directory = String.valueOf(srcGenPath) + '/' + this.getNaming().asPath(String.valueOf(this.getNaming().basePackageRuntime(grammar)) + ".parser.antlr.internal");
            template = String.valueOf(this.getTemplate()) + "::generate";
            encoding = this.getEncoding(ctx, "SRC_GEN");
        } else {
            String srcGenPath = ctx.getOutput().getOutlet("SRC_GEN_UI").getPath();
            directory = String.valueOf(srcGenPath) + '/' + this.getNaming().asPath(String.valueOf(this.getNaming().basePackageUi(grammar)) + ".contentassist.antlr.internal");
            template = String.valueOf(this.getTemplate()) + "::generateUI";
            encoding = this.getEncoding(ctx, "SRC_GEN_UI");
        }
        XpandFacade.create((XpandExecutionContext)ctx).evaluate2(template, (Object)grammar, this.getParameters(grammar));
        String fileName = "Internal" + GrammarUtil.getName((Grammar)grammar) + "Flexer.flex";
        String javaFileName = String.valueOf(directory) + "/" + "Internal" + GrammarUtil.getName((Grammar)grammar) + "Flexer.java";
        this.main.runJFlex("-d", directory, String.valueOf(directory) + "/" + fileName);
        Charset charset = Charset.forName(encoding);
        String javaCode = this.readFileIntoString(javaFileName, charset);
        javaCode = new NewlineNormalizer(this.getNaming().getLineDelimiter()).normalizeLineDelimiters((CharSequence)javaCode);
        javaCode = this.removeTimestamps(javaCode);
        this.writeStringIntoFile(javaFileName, javaCode, charset);
    }

    private String removeTimestamps(String javaCode) {
        int timestampEnd = javaCode.indexOf("*/");
        int commentStart = javaCode.indexOf("/*", timestampEnd);
        String result = javaCode.substring(commentStart);
        int timestampStart = result.indexOf("* on");
        timestampEnd = result.indexOf("from the specification file", timestampStart);
        result = String.valueOf(result.substring(0, timestampStart + 2)) + result.substring(timestampEnd);
        return result;
    }

    public void setPatternPath(String patternPath) {
        this.patternPath = patternPath;
    }

    public void setAdditionalRulePath(String rulePath) {
        this.additionalRulePath = rulePath;
    }

    protected List<Object> getParameters(Grammar grammar) {
        String parserName = this.ui ? XtextAntlrUiGeneratorFragment.getGrammarFileName((Grammar)grammar, (Naming)this.getNaming()) : XtextAntlrGeneratorFragment.getGrammarFileName((Grammar)grammar, (Naming)this.getNaming());
        return Lists.newArrayList((Object[])new Object[]{this.read(this.patternPath), this.read(this.additionalRulePath), parserName});
    }

    private String read(String path) {
        if (path != null) {
            String string;
            InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(path), "ISO-8859-1");
            try {
                String patterns;
                string = patterns = CharStreams.toString((Readable)reader);
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
            return string;
        }
        return null;
    }
}

