/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler.batch;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.xtend.core.compiler.batch.BootClassLoader;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.file.ProjectConfig;
import org.eclipse.xtext.xbase.file.RuntimeWorkspaceConfigProvider;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendBatchCompiler {
    private static final Logger log = Logger.getLogger((String)XtendBatchCompiler.class.getName());
    protected static final FileFilter ACCEPT_ALL_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return true;
        }
    };
    protected Provider<ResourceSet> resourceSetProvider;
    @Inject
    protected Provider<JavaIoFileSystemAccess> javaIoFileSystemAccessProvider;
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    @Inject
    protected Provider<ResourceSetBasedResourceDescriptions> resourceSetDescriptionsProvider;
    @Inject
    private IGenerator generator;
    @Inject
    private IndexedJvmTypeAccess indexedJvmTypeAccess;
    @Inject
    private ProcessorInstanceForJvmTypeProvider annotationProcessorFactory;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private RuntimeWorkspaceConfigProvider workspaceConfigProvider;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private IStubGenerator stubGenerator;
    protected Writer outputWriter;
    protected Writer errorWriter;
    protected String sourcePath;
    protected String classPath;
    protected String bootClassPath;
    protected boolean useCurrentClassLoaderAsParent;
    protected String outputPath;
    protected String fileEncoding;
    protected String complianceLevel = "1.5";
    protected boolean verbose = false;
    protected String tempDirectory = System.getProperty("java.io.tmpdir");
    protected boolean deleteTempDirectory = true;
    protected List<File> tempFolders = Lists.newArrayList();
    protected boolean writeTraceFiles = true;
    protected ClassLoader currentClassLoader = this.getClass().getClassLoader();

    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
        this.currentClassLoader = currentClassLoader;
    }

    public void setUseCurrentClassLoaderAsParent(boolean useCurrentClassLoaderAsParent) {
        this.useCurrentClassLoaderAsParent = useCurrentClassLoaderAsParent;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public boolean isWriteTraceFiles() {
        return this.writeTraceFiles;
    }

    public void setWriteTraceFiles(boolean writeTraceFiles) {
        this.writeTraceFiles = writeTraceFiles;
    }

    @Inject
    public void setResourceSetProvider(Provider<ResourceSet> resourceSetProvider) {
        this.resourceSetProvider = resourceSetProvider;
    }

    public boolean isDeleteTempDirectory() {
        return this.deleteTempDirectory;
    }

    public void setDeleteTempDirectory(boolean deletetempDirectory) {
        this.deleteTempDirectory = deletetempDirectory;
    }

    public Writer getOutputWriter() {
        if (this.outputWriter == null) {
            this.outputWriter = new Writer(){

                public void write(char[] data, int offset, int count) throws IOException {
                    String message = String.copyValueOf(data, offset, count);
                    if (!Strings.isEmpty((String)message.trim())) {
                        log.debug((Object)message);
                    }
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            };
        }
        return this.outputWriter;
    }

    public void setOutputWriter(Writer ouputWriter) {
        this.outputWriter = ouputWriter;
    }

    public Writer getErrorWriter() {
        if (this.errorWriter == null) {
            this.errorWriter = new Writer(){

                public void write(char[] data, int offset, int count) throws IOException {
                    String message = String.copyValueOf(data, offset, count);
                    if (!Strings.isEmpty((String)message.trim())) {
                        log.debug((Object)message);
                    }
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            };
        }
        return this.errorWriter;
    }

    public void setErrorWriter(Writer errorWriter) {
        this.errorWriter = errorWriter;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public void setBootClassPath(String bootClassPath) {
        this.bootClassPath = bootClassPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    protected String getComplianceLevel() {
        return this.complianceLevel;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public boolean configureWorkspace() {
        List<File> sourceFileList = this.getSourcePathFileList();
        File outputFile = this.getOutputPathFile();
        if (sourceFileList == null || outputFile == null) {
            return false;
        }
        File commonRoot = this.determineCommonRoot(outputFile, sourceFileList);
        if (commonRoot == null || commonRoot.getParent() == null || commonRoot.getParentFile().getParent() == null) {
            log.error((Object)"All source folders and the output folder should have a common parent non-top level folder (like project folder)");
            for (File sourceFile : sourceFileList) {
                log.error((Object)("(Source folder: '" + sourceFile + "')"));
            }
            log.error((Object)("(Output folder: '" + outputFile + "')"));
            return false;
        }
        WorkspaceConfig workspaceConfig = new WorkspaceConfig(commonRoot.getParent().toString());
        ProjectConfig projectConfig = new ProjectConfig(commonRoot.getName());
        java.net.URI commonURI = commonRoot.toURI();
        java.net.URI relativizedTarget = commonURI.relativize(outputFile.toURI());
        if (relativizedTarget.isAbsolute()) {
            log.error((Object)("Target folder '" + outputFile + "' must be a child of the project folder '" + commonRoot + "'"));
            return false;
        }
        for (File source : sourceFileList) {
            java.net.URI relativizedSrc = commonURI.relativize(source.toURI());
            if (relativizedSrc.isAbsolute()) {
                log.error((Object)("Source folder '" + source + "' must be a child of the project folder '" + commonRoot + "'"));
                return false;
            }
            projectConfig.addSourceFolderMapping(relativizedSrc.getPath(), relativizedTarget.getPath());
        }
        workspaceConfig.addProjectConfig(projectConfig);
        this.workspaceConfigProvider.setWorkspaceConfig(workspaceConfig);
        return true;
    }

    private File getOutputPathFile() {
        try {
            return new File(this.outputPath).getCanonicalFile();
        }
        catch (IOException e) {
            log.error((Object)("Invalid target folder '" + this.outputPath + "' (" + e.getMessage() + ")"));
            return null;
        }
    }

    private List<File> getSourcePathFileList() {
        ArrayList<File> sourceFileList = new ArrayList<File>();
        for (String path : this.getSourcePathDirectories()) {
            try {
                sourceFileList.add(new File(path).getCanonicalFile());
            }
            catch (IOException e) {
                log.error((Object)("Invalid source folder '" + path + "' (" + e.getMessage() + ")"));
                return null;
            }
        }
        return sourceFileList;
    }

    /*
     * WARNING - void declaration
     */
    private File determineCommonRoot(File outputFile, List<File> sourceFileList) {
        ArrayList<File> pathList = new ArrayList<File>(sourceFileList);
        pathList.add(outputFile);
        ArrayList pathParts = new ArrayList();
        for (File path : pathList) {
            void var8_9;
            ArrayList<void> partsList = new ArrayList<void>();
            File file = path;
            while (var8_9 != null) {
                partsList.add(var8_9);
                File file2 = var8_9.getParentFile();
            }
            pathParts.add(partsList);
        }
        int i = 1;
        File result = null;
        while (true) {
            File compareWith = null;
            for (List list : pathParts) {
                if (list.size() < i) {
                    return result;
                }
                File part = (File)list.get(list.size() - i);
                if (compareWith == null) {
                    compareWith = part;
                    continue;
                }
                if (compareWith.equals(part)) continue;
                return result;
            }
            result = compareWith;
            ++i;
        }
    }

    public boolean compile() {
        try {
            if (this.workspaceConfigProvider.getWorkspaceConfig() == null && !this.configureWorkspace()) {
                return false;
            }
            ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
            File classDirectory = this.createTempDir("classes");
            try {
                this.compilerPhases.setIndexing((Notifier)resourceSet, true);
                this.installJvmTypeProvider(resourceSet, classDirectory, true);
                this.loadXtendFiles(resourceSet);
                File sourceDirectory = this.createStubs(resourceSet);
                if (!this.preCompileStubs(sourceDirectory, classDirectory)) {
                    log.debug((Object)"Compilation of stubs and existing Java code had errors. This is expected and usually is not a probblem.");
                }
            }
            finally {
                this.compilerPhases.setIndexing((Notifier)resourceSet, false);
            }
            this.installJvmTypeProvider(resourceSet, classDirectory, false);
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            List<Issue> issues = this.validate(resourceSet);
            Iterable errors = Iterables.filter(issues, (Predicate)SeverityFilter.ERROR);
            Iterable warnings = Iterables.filter(issues, (Predicate)SeverityFilter.WARNING);
            this.reportIssues(Iterables.concat((Iterable)errors, (Iterable)warnings));
            if (!Iterables.isEmpty((Iterable)errors)) {
                return false;
            }
            this.generateJavaFiles(resourceSet);
        }
        finally {
            if (this.isDeleteTempDirectory()) {
                this.deleteTmpFolders();
            }
        }
        return true;
    }

    protected ResourceSet loadXtendFiles(ResourceSet resourceSet) {
        this.encodingProvider.setDefaultEncoding(this.getFileEncoding());
        final NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setExtension(this.fileExtensionProvider.getPrimaryFileExtension());
        PathTraverser pathTraverser = new PathTraverser();
        List<String> sourcePathDirectories = this.getSourcePathDirectories();
        Multimap pathes = pathTraverser.resolvePathes(sourcePathDirectories, (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                boolean matches = nameBasedFilter.matches(input);
                return matches;
            }
        });
        for (String src : pathes.keySet()) {
            URI baseDir = URI.createFileURI((String)(String.valueOf(src) + "/"));
            String identifier = Joiner.on((String)"_").join((Object[])baseDir.segments());
            URI platformResourceURI = URI.createPlatformResourceURI((String)(String.valueOf(identifier) + "/"), (boolean)true);
            resourceSet.getURIConverter().getURIMap().put(platformResourceURI, baseDir);
            for (URI uri : pathes.get((Object)src)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("load xtend file '" + uri + "'"));
                }
                URI uriToUse = uri.replacePrefix(baseDir, platformResourceURI);
                resourceSet.getResource(uriToUse, true);
            }
        }
        return resourceSet;
    }

    @Deprecated
    protected ResourceSet loadXtendFiles() {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        return this.loadXtendFiles(resourceSet);
    }

    protected File createStubs(ResourceSet resourceSet) {
        File outputDirectory = this.createTempDir("stubs");
        JavaIoFileSystemAccess fileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        fileSystemAccess.setOutputPath(outputDirectory.toString());
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            IResourceDescription description = this.resourceDescriptionManager.getResourceDescription(resource);
            this.stubGenerator.doGenerateStubs((IFileSystemAccess)fileSystemAccess, description);
        }
        return outputDirectory;
    }

    protected boolean preCompileStubs(File tmpSourceDirectory, File classDirectory) {
        ArrayList commandLine = Lists.newArrayList();
        if (this.isVerbose()) {
            commandLine.add("-verbose");
        }
        if (!Strings.isEmpty((String)this.bootClassPath)) {
            commandLine.add("-bootclasspath \"" + Strings.concat((String)File.pathSeparator, this.getBootClassPathEntries()) + "\"");
        }
        if (!Strings.isEmpty((String)this.classPath)) {
            commandLine.add("-cp \"" + Strings.concat((String)File.pathSeparator, this.getClassPathEntries()) + "\"");
        }
        commandLine.add("-d \"" + classDirectory.toString() + "\"");
        commandLine.add("-" + this.getComplianceLevel());
        commandLine.add("-proceedOnError");
        ArrayList sourceDirectories = Lists.newArrayList(this.getSourcePathDirectories());
        sourceDirectories.add(tmpSourceDirectory.toString());
        commandLine.add(Strings.concat((String)" ", (List)Lists.transform((List)sourceDirectories, (Function)new Function<String, String>(){

            public String apply(String path) {
                return "\"" + path + "\"";
            }
        })));
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke batch compiler with '" + Strings.concat((String)" ", (List)commandLine) + "'"));
        }
        return BatchCompiler.compile((String)Strings.concat((String)" ", (List)commandLine), (PrintWriter)new PrintWriter(this.getOutputWriter()), (PrintWriter)new PrintWriter(this.getErrorWriter()), null);
    }

    protected List<Issue> validate(ResourceSet resourceSet) {
        ArrayList issues = Lists.newArrayList();
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(resource.getURI());
            if (resourceServiceProvider == null) continue;
            IResourceValidator resourceValidator = resourceServiceProvider.getResourceValidator();
            List result = resourceValidator.validate(resource, CheckMode.ALL, null);
            Iterables.addAll((Collection)issues, (Iterable)result);
        }
        return issues;
    }

    @Deprecated
    protected void installJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory) {
        this.internalInstallJvmTypeProvider(resourceSet, tmpClassDirectory, false);
    }

    protected void installJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory, boolean skipIndexLookup) {
        if (skipIndexLookup) {
            this.internalInstallJvmTypeProvider(resourceSet, tmpClassDirectory, skipIndexLookup);
        } else {
            this.installJvmTypeProvider(resourceSet, tmpClassDirectory);
        }
    }

    private void internalInstallJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory, boolean skipIndexLookup) {
        ClassLoader parentClassLoader;
        Iterable classPathEntries = Iterables.concat(this.getClassPathEntries(), this.getSourcePathDirectories(), Arrays.asList(tmpClassDirectory.toString()));
        classPathEntries = Iterables.filter((Iterable)classPathEntries, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isEmpty((String)input.trim());
            }
        });
        Function<String, URL> toUrl = new Function<String, URL>(){

            public URL apply(String from) {
                try {
                    return new File(from).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Iterable classPathUrls = Iterables.transform((Iterable)classPathEntries, (Function)toUrl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("classpath used for Xtend compilation : " + classPathUrls));
        }
        if (this.useCurrentClassLoaderAsParent) {
            parentClassLoader = this.currentClassLoader;
        } else if (Strings.isEmpty((String)this.bootClassPath)) {
            parentClassLoader = ClassLoader.getSystemClassLoader().getParent();
        } else {
            Iterable bootClassPathUrls = Iterables.transform(this.getBootClassPathEntries(), (Function)toUrl);
            parentClassLoader = new BootClassLoader((URL[])Iterables.toArray((Iterable)bootClassPathUrls, URL.class));
        }
        URLClassLoader urlClassLoader = new URLClassLoader((URL[])Iterables.toArray((Iterable)classPathUrls, URL.class), parentClassLoader);
        new ClasspathTypeProvider((ClassLoader)urlClassLoader, resourceSet, skipIndexLookup ? null : this.indexedJvmTypeAccess);
        ((XtextResourceSet)resourceSet).setClasspathURIContext((Object)urlClassLoader);
        URLClassLoader urlClassLoaderForAnnotationProcessing = new URLClassLoader((URL[])Iterables.toArray((Iterable)classPathUrls, URL.class), this.currentClassLoader);
        this.annotationProcessorFactory.setClassLoader(urlClassLoaderForAnnotationProcessing);
    }

    protected void reportIssues(Iterable<Issue> issues) {
        for (Issue issue : issues) {
            StringBuilder issueBuilder = this.createIssueMessage(issue);
            if (Severity.ERROR == issue.getSeverity()) {
                log.error((Object)issueBuilder.toString());
                continue;
            }
            if (Severity.WARNING != issue.getSeverity()) continue;
            log.warn((Object)issueBuilder.toString());
        }
    }

    private StringBuilder createIssueMessage(Issue issue) {
        StringBuilder issueBuilder = new StringBuilder("\n");
        issueBuilder.append(issue.getSeverity()).append(": \t");
        URI uriToProblem = issue.getUriToProblem();
        if (uriToProblem != null) {
            URI resourceUri = uriToProblem.trimFragment();
            issueBuilder.append(resourceUri.lastSegment()).append(" - ");
            if (resourceUri.isFile()) {
                issueBuilder.append(resourceUri.toFileString());
            }
        }
        issueBuilder.append("\n").append(issue.getLineNumber()).append(": ").append(issue.getMessage());
        return issueBuilder;
    }

    protected void generateJavaFiles(ResourceSet resourceSet) {
        JavaIoFileSystemAccess javaIoFileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        javaIoFileSystemAccess.setOutputPath(this.outputPath);
        javaIoFileSystemAccess.setWriteTrace(this.writeTraceFiles);
        for (Resource resource : resourceSet.getResources()) {
            if (!(resource instanceof BatchLinkableResource)) continue;
            this.generator.doGenerate(resource, (IFileSystemAccess)javaIoFileSystemAccess);
        }
    }

    protected ResourceSetBasedResourceDescriptions getResourceDescriptions(ResourceSet resourceSet) {
        ResourceSetBasedResourceDescriptions resourceDescriptions = (ResourceSetBasedResourceDescriptions)this.resourceSetDescriptionsProvider.get();
        resourceDescriptions.setContext((Notifier)resourceSet);
        resourceDescriptions.setRegistry(IResourceServiceProvider.Registry.INSTANCE);
        return resourceDescriptions;
    }

    protected XtendFile getXtendFile(Resource resource) {
        EObject model;
        XtextResource xtextResource = (XtextResource)resource;
        IParseResult parseResult = xtextResource.getParseResult();
        if (parseResult != null && (model = parseResult.getRootASTElement()) instanceof XtendFile) {
            XtendFile xtendFile = (XtendFile)model;
            return xtendFile;
        }
        return null;
    }

    protected List<String> getClassPathEntries() {
        return this.getDirectories(this.classPath);
    }

    protected List<String> getBootClassPathEntries() {
        return this.getDirectories(this.bootClassPath);
    }

    protected List<String> getSourcePathDirectories() {
        return this.getDirectories(this.sourcePath);
    }

    protected List<String> getDirectories(String path) {
        if (Strings.isEmpty((String)path)) {
            return Lists.newArrayList();
        }
        List split = Strings.split((String)Strings.emptyIfNull((String)path), (String)File.pathSeparator);
        return Lists.transform((List)split, (Function)new Function<String, String>(){

            public String apply(String from) {
                try {
                    return new File(from).getCanonicalPath();
                }
                catch (IOException e) {
                    throw new WrappedException("Invalid source path: '" + from + "'", (Exception)e);
                }
            }
        });
    }

    protected File createTempDir(String prefix) {
        File tempDir = new File(this.getTempDirectory(), String.valueOf(prefix) + System.nanoTime());
        XtendBatchCompiler.cleanFolder(tempDir, ACCEPT_ALL_FILTER, true, true);
        if (!tempDir.mkdirs()) {
            throw new RuntimeException("Error creating temp directory '" + tempDir.getAbsolutePath() + "'");
        }
        this.tempFolders.add(tempDir);
        return tempDir;
    }

    protected void deleteTmpFolders() {
        for (File file : this.tempFolders) {
            XtendBatchCompiler.cleanFolder(file, ACCEPT_ALL_FILTER, true, true);
        }
    }

    protected static boolean cleanFolder(File parentFolder, FileFilter filter, boolean continueOnError, boolean deleteParentFolder) {
        if (!parentFolder.exists()) {
            return true;
        }
        if (filter == null) {
            filter = ACCEPT_ALL_FILTER;
        }
        log.debug((Object)("Cleaning folder " + parentFolder.toString()));
        File[] contents = parentFolder.listFiles(filter);
        int j = 0;
        while (j < contents.length) {
            File file = contents[j];
            if (file.isDirectory()) {
                if (!XtendBatchCompiler.cleanFolder(file, filter, continueOnError, true) && !continueOnError) {
                    return false;
                }
            } else if (!file.delete()) {
                log.error((Object)("Couldn't delete " + file.getAbsolutePath()));
                if (!continueOnError) {
                    return false;
                }
            }
            ++j;
        }
        if (deleteParentFolder && parentFolder.list().length == 0 && !parentFolder.delete()) {
            log.error((Object)("Couldn't delete " + parentFolder.getAbsolutePath()));
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SeverityFilter
    implements Predicate<Issue> {
        private static final SeverityFilter WARNING = new SeverityFilter(Severity.WARNING);
        private static final SeverityFilter ERROR = new SeverityFilter(Severity.ERROR);
        private Severity severity;

        private SeverityFilter(Severity severity) {
            this.severity = severity;
        }

        public boolean apply(Issue issue) {
            return this.severity == issue.getSeverity();
        }
    }
}

