/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.AnnotationProcessor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.IssueSeveritiesProvider;
import org.eclipse.xtext.xbase.annotations.validation.DerivedStateAwareResourceValidator;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.typesystem.computation.DiagnosticOnFirstKeyword;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingResourceValidatorImpl
extends DerivedStateAwareResourceValidator {
    @Inject
    private OnChangeEvictingCache cache;
    @Inject
    private AnnotationProcessor annotationProcessor;
    @Inject
    private IssueSeveritiesProvider issueSeveritiesProvider;
    @Inject
    @Extension
    private IJvmModelAssociations _iJvmModelAssociations;
    @Inject
    @Extension
    private JvmTypeExtensions _jvmTypeExtensions;

    public List<Issue> validate(final Resource resource, final CheckMode mode, final CancelIndicator mon) {
        try {
            Provider<List<Issue>> _function = new Provider<List<Issue>>(){

                public List<Issue> get() {
                    boolean _isCanceled;
                    List _xblockexpression = null;
                    List result = CachingResourceValidatorImpl.super.validate(resource, mode, mon);
                    List _xifexpression = null;
                    boolean _and = false;
                    boolean _notEquals = !Objects.equal((Object)mon, null);
                    _and = !_notEquals ? false : (_isCanceled = mon.isCanceled());
                    if (_and) {
                        throw new OperationCanceledException();
                    }
                    _xblockexpression = _xifexpression = result;
                    return _xblockexpression;
                }
            };
            return (List)this.cache.get((Object)mode, resource, (Provider)_function);
        }
        catch (Throwable _t) {
            if (_t instanceof OperationCanceledException) {
                OperationCanceledException exc = (OperationCanceledException)_t;
                return CollectionLiterals.emptyList();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void collectResourceDiagnostics(Resource resource, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        this.runActiveAnnotationValidation(resource, monitor);
        this.addWarningsForOrphanedJvmElements(resource, monitor, acceptor);
        super.collectResourceDiagnostics(resource, monitor, acceptor);
    }

    private void runActiveAnnotationValidation(Resource resource, CancelIndicator monitor) {
        boolean _tripleEquals;
        ActiveAnnotationContexts contexts = ActiveAnnotationContexts.find(resource);
        boolean bl = _tripleEquals = contexts == null;
        if (_tripleEquals) {
            return;
        }
        try {
            contexts.before(ActiveAnnotationContexts.AnnotationCallback.VALIDATION);
            Map<JvmAnnotationType, ActiveAnnotationContext> _contexts = contexts.getContexts();
            Collection<ActiveAnnotationContext> _values = _contexts.values();
            for (ActiveAnnotationContext ctx : _values) {
                boolean _isCanceled = monitor.isCanceled();
                if (_isCanceled) {
                    return;
                }
                try {
                    this.annotationProcessor.validationPhase(ctx, monitor);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable t = _t;
                        ctx.handleProcessingError(resource, t);
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        finally {
            contexts.after(ActiveAnnotationContexts.AnnotationCallback.VALIDATION);
        }
    }

    private void addWarningsForOrphanedJvmElements(Resource resource, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        IssueSeverities issueSeverities = this.issueSeveritiesProvider.getIssueSeverities(resource);
        Severity severity = issueSeverities.getSeverity("org.eclipse.xtend.core.validation.IssueCodes.orphan_element");
        boolean _equals = Objects.equal((Object)severity, (Object)Severity.IGNORE);
        if (_equals) {
            return;
        }
        EList _contents = resource.getContents();
        Iterable _tail = IterableExtensions.tail((Iterable)_contents);
        Iterable _filter = Iterables.filter((Iterable)_tail, JvmDeclaredType.class);
        for (JvmDeclaredType jvmType : _filter) {
            TreeIterator _eAllContents = jvmType.eAllContents();
            UnmodifiableIterator _filter_1 = Iterators.filter((Iterator)_eAllContents, JvmMember.class);
            Functions.Function1<JvmMember, Boolean> _function = new Functions.Function1<JvmMember, Boolean>(){

                public Boolean apply(JvmMember it) {
                    boolean _isSynthetic = CachingResourceValidatorImpl.this._jvmTypeExtensions.isSynthetic((JvmIdentifiableElement)it);
                    return !_isSynthetic;
                }
            };
            Iterator _filter_2 = IteratorExtensions.filter((Iterator)_filter_1, (Functions.Function1)_function);
            Iterable _iterable = IteratorExtensions.toIterable((Iterator)_filter_2);
            for (JvmMember jvmMember : _iterable) {
                boolean _tripleEquals;
                boolean _isCanceled = monitor.isCanceled();
                if (_isCanceled) {
                    return;
                }
                EObject sourceElement = this._iJvmModelAssociations.getPrimarySourceElement((EObject)jvmMember);
                boolean bl = _tripleEquals = sourceElement == null;
                if (!_tripleEquals) continue;
                this.addWarningForOrphanedJvmElement(resource, jvmMember, severity, acceptor);
            }
        }
    }

    private void addWarningForOrphanedJvmElement(Resource resource, JvmMember jvmElement, Severity severity, IAcceptor<Issue> acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"The generated ");
        String _uiString = this.getUiString(jvmElement);
        _builder.append((Object)_uiString, "");
        _builder.append((Object)" is not associated with a source element. The producing active annotation should use 'setPrimarySourceElement'.");
        EList _contents = resource.getContents();
        EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
        DiagnosticOnFirstKeyword _diagnosticOnFirstKeyword = new DiagnosticOnFirstKeyword(severity, "org.eclipse.xtend.core.validation.IssueCodes.orphan_element", _builder.toString(), _head, null);
        this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)_diagnosticOnFirstKeyword, severity, acceptor);
    }

    private String getUiString(JvmMember member) {
        String _xblockexpression = null;
        StringBuilder uiString = new StringBuilder();
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && member instanceof JvmConstructor) {
            _matched = true;
            _switchResult = "constructor";
        }
        if (!_matched && member instanceof JvmField) {
            _matched = true;
            _switchResult = "field";
        }
        if (!_matched && member instanceof JvmOperation) {
            _matched = true;
            _switchResult = "method";
        }
        if (!_matched && member instanceof JvmDeclaredType) {
            _matched = true;
            _switchResult = "type";
        }
        String type = _switchResult;
        StringBuilder _append = uiString.append(type);
        StringBuilder _append_1 = _append.append(" '");
        String _qualifiedName = member.getQualifiedName('.');
        _append_1.append(_qualifiedName);
        if (member instanceof JvmExecutable) {
            EList _parameters = ((JvmExecutable)member).getParameters();
            Functions.Function1<JvmFormalParameter, String> _function = new Functions.Function1<JvmFormalParameter, String>(){

                public String apply(JvmFormalParameter it) {
                    JvmTypeReference _parameterType = it.getParameterType();
                    return _parameterType.getSimpleName();
                }
            };
            String parameterTypes = IterableExtensions.join((Iterable)_parameters, (CharSequence)", ", (Functions.Function1)_function);
            StringBuilder _append_2 = uiString.append("(");
            StringBuilder _append_3 = _append_2.append(parameterTypes);
            _append_3.append(")");
        }
        uiString.append("'");
        _xblockexpression = uiString.toString();
        return _xblockexpression;
    }
}

