/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.resource;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.resource.XtendResourceDescription;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.DerivedStateAwareResourceDescriptionManager;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XtendResourceDescriptionManager
extends DerivedStateAwareResourceDescriptionManager
implements IResourceDescription.Manager.AllChangeAware {
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private IQualifiedNameConverter nameConverter;

    public IResourceDescription createResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        IResourceScopeCache _cache = this.getCache();
        return new XtendResourceDescription(resource, strategy, _cache, this.typeResolver, this.nameConverter);
    }

    public boolean hasChanges(IResourceDescription.Delta delta, IResourceDescription candidate) {
        boolean _containsActiveAnnotation;
        boolean _or = false;
        boolean _hasChanges = super.hasChanges(delta, candidate);
        _or = _hasChanges ? true : (_containsActiveAnnotation = this.containsActiveAnnotation(candidate));
        return _or;
    }

    private boolean containsActiveAnnotation(IResourceDescription description) {
        Iterable _exportedObjects = description.getExportedObjects();
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                String[] _userDataKeys = it.getUserDataKeys();
                return ((List)Conversions.doWrapArray((Object)_userDataKeys)).contains("ACTIVE_ANNOTATION_TIMESTAMP");
            }
        };
        return IterableExtensions.exists((Iterable)_exportedObjects, (Functions.Function1)_function);
    }

    public boolean isAffectedByAny(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) throws IllegalArgumentException {
        return this.isAffected(deltas, candidate, context);
    }
}

