/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler.batch;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.xtend.core.compiler.batch.internal.AlternateJdkLoader;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.GeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.JavaVersion;
import org.eclipse.xtext.xbase.file.ProjectConfig;
import org.eclipse.xtext.xbase.file.RuntimeWorkspaceConfigProvider;
import org.eclipse.xtext.xbase.file.SimpleWorkspaceConfig;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;

public class XtendBatchCompiler {
    private static Logger log = Logger.getLogger((String)XtendBatchCompiler.class.getName());
    protected static final FileFilter ACCEPT_ALL_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    };
    protected Provider<ResourceSet> resourceSetProvider;
    @Inject
    protected Provider<JavaIoFileSystemAccess> javaIoFileSystemAccessProvider;
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    @Inject
    protected Provider<ResourceSetBasedResourceDescriptions> resourceSetDescriptionsProvider;
    @Inject
    private IGenerator generator;
    @Inject
    private IndexedJvmTypeAccess indexedJvmTypeAccess;
    @Inject
    private ProcessorInstanceForJvmTypeProvider annotationProcessorFactory;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private RuntimeWorkspaceConfigProvider workspaceConfigProvider;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private IStubGenerator stubGenerator;
    protected String sourcePath;
    protected String classPath;
    protected String bootClassPath;
    protected boolean useCurrentClassLoaderAsParent;
    protected String outputPath;
    protected String fileEncoding;
    protected boolean verbose = false;
    protected String tempDirectory = System.getProperty("java.io.tmpdir");
    protected boolean deleteTempDirectory = true;
    protected List<File> tempFolders = Lists.newArrayList();
    protected boolean writeTraceFiles = true;
    protected boolean writeStorageFiles = false;
    private GeneratorConfig generatorConfig = new GeneratorConfig();
    protected ClassLoader currentClassLoader = this.getClass().getClassLoader();
    private URI baseURI;
    private ClassLoader jvmTypesClassLoader;
    private ClassLoader annotationProcessingClassLoader;
    private static final Function<String, File> TO_FILE = new Function<String, File>(){

        public File apply(String from) {
            return new File(from);
        }
    };
    private static final Function<File, URL> TO_URL = new Function<File, URL>(){

        public URL apply(File from) {
            try {
                return from.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    @Deprecated
    protected Writer outputWriter = new CharArrayWriter();
    @Deprecated
    protected Writer errorWriter = new CharArrayWriter();

    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
        this.currentClassLoader = currentClassLoader;
    }

    public void setUseCurrentClassLoaderAsParent(boolean useCurrentClassLoaderAsParent) {
        this.useCurrentClassLoaderAsParent = useCurrentClassLoaderAsParent;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public boolean isWriteTraceFiles() {
        return this.writeTraceFiles;
    }

    public void setWriteTraceFiles(boolean writeTraceFiles) {
        this.writeTraceFiles = writeTraceFiles;
    }

    public boolean isWriteStorageFiles() {
        return this.writeStorageFiles;
    }

    public void setWriteStorageFiles(boolean writeStorageFiles) {
        this.writeStorageFiles = writeStorageFiles;
    }

    @Inject
    public void setResourceSetProvider(Provider<ResourceSet> resourceSetProvider) {
        this.resourceSetProvider = resourceSetProvider;
    }

    public boolean isDeleteTempDirectory() {
        return this.deleteTempDirectory;
    }

    public void setDeleteTempDirectory(boolean deletetempDirectory) {
        this.deleteTempDirectory = deletetempDirectory;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public void setBootClassPath(String bootClassPath) {
        this.bootClassPath = bootClassPath;
    }

    public void setBasePath(String basePath) {
        this.baseURI = URI.createFileURI((String)new File(basePath).getAbsolutePath());
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Deprecated
    protected String getComplianceLevel() {
        return this.getJavaSourceVersion();
    }

    public boolean isGenerateSyntheticSuppressWarnings() {
        return this.generatorConfig.isGenerateSyntheticSuppressWarnings();
    }

    public void setGenerateSyntheticSuppressWarnings(boolean generateSyntheticSuppressWarnings) {
        this.generatorConfig.setGenerateSyntheticSuppressWarnings(generateSyntheticSuppressWarnings);
    }

    public boolean isGenerateGeneratedAnnotation() {
        return this.generatorConfig.isGenerateGeneratedAnnotation();
    }

    public void setGenerateGeneratedAnnotation(boolean generateGeneratedAnnotation) {
        this.generatorConfig.setGenerateGeneratedAnnotation(generateGeneratedAnnotation);
    }

    public boolean isIncludeDateInGeneratedAnnotation() {
        return this.generatorConfig.isIncludeDateInGeneratedAnnotation();
    }

    public void setIncludeDateInGeneratedAnnotation(boolean includeDateInGeneratedAnnotation) {
        this.generatorConfig.setIncludeDateInGeneratedAnnotation(includeDateInGeneratedAnnotation);
    }

    public String getGeneratedAnnotationComment() {
        return this.generatorConfig.getGeneratedAnnotationComment();
    }

    public void setGeneratedAnnotationComment(String generatedAnnotationComment) {
        this.generatorConfig.setGeneratedAnnotationComment(generatedAnnotationComment);
    }

    public String getJavaSourceVersion() {
        return this.generatorConfig.getJavaSourceVersion().getQualifier();
    }

    public void setJavaSourceVersion(String javaSourceVersion) {
        this.generatorConfig.setJavaSourceVersion(JavaVersion.fromQualifier((String)javaSourceVersion));
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public boolean configureWorkspace() {
        List<File> sourceFileList = this.getSourcePathFileList();
        File outputFile = this.getOutputPathFile();
        if (sourceFileList == null || outputFile == null) {
            return false;
        }
        File commonRoot = this.determineCommonRoot(outputFile, sourceFileList);
        if (commonRoot == null || commonRoot.getParent() == null || commonRoot.getParentFile().getParent() == null) {
            log.error((Object)"All source folders and the output folder should have a common parent non-top level folder (like project folder)");
            for (File sourceFile : sourceFileList) {
                log.error((Object)("(Source folder: '" + sourceFile + "')"));
            }
            log.error((Object)("(Output folder: '" + outputFile + "')"));
            return false;
        }
        SimpleWorkspaceConfig workspaceConfig = new SimpleWorkspaceConfig(commonRoot.getParent().toString());
        ProjectConfig projectConfig = new ProjectConfig(commonRoot.getName());
        java.net.URI commonURI = commonRoot.toURI();
        java.net.URI relativizedTarget = commonURI.relativize(outputFile.toURI());
        if (relativizedTarget.isAbsolute()) {
            log.error((Object)("Target folder '" + outputFile + "' must be a child of the project folder '" + commonRoot + "'"));
            return false;
        }
        for (File source : sourceFileList) {
            java.net.URI relativizedSrc = commonURI.relativize(source.toURI());
            if (relativizedSrc.isAbsolute()) {
                log.error((Object)("Source folder '" + source + "' must be a child of the project folder '" + commonRoot + "'"));
                return false;
            }
            projectConfig.addSourceFolderMapping(relativizedSrc.getPath(), relativizedTarget.getPath());
        }
        workspaceConfig.addProjectConfig(projectConfig);
        this.workspaceConfigProvider.setWorkspaceConfig((WorkspaceConfig)workspaceConfig);
        return true;
    }

    private File getOutputPathFile() {
        try {
            return new File(this.outputPath).getCanonicalFile();
        }
        catch (IOException e) {
            log.error((Object)("Invalid target folder '" + this.outputPath + "' (" + e.getMessage() + ")"));
            return null;
        }
    }

    private List<File> getSourcePathFileList() {
        ArrayList<File> sourceFileList = new ArrayList<File>();
        for (String path : this.getSourcePathDirectories()) {
            try {
                sourceFileList.add(new File(path).getCanonicalFile());
            }
            catch (IOException e) {
                log.error((Object)("Invalid source folder '" + path + "' (" + e.getMessage() + ")"));
                return null;
            }
        }
        return sourceFileList;
    }

    /*
     * WARNING - void declaration
     */
    private File determineCommonRoot(File outputFile, List<File> sourceFileList) {
        ArrayList<File> pathList = new ArrayList<File>(sourceFileList);
        pathList.add(outputFile);
        ArrayList pathParts = new ArrayList();
        for (File path : pathList) {
            void var8_9;
            ArrayList<void> partsList = new ArrayList<void>();
            File file = path;
            while (var8_9 != null) {
                partsList.add(var8_9);
                File file2 = var8_9.getParentFile();
            }
            pathParts.add(partsList);
        }
        int i = 1;
        File result = null;
        while (true) {
            File compareWith = null;
            for (List list : pathParts) {
                if (list.size() < i) {
                    return result;
                }
                File part = (File)list.get(list.size() - i);
                if (compareWith == null) {
                    compareWith = part;
                    continue;
                }
                if (compareWith.equals(part)) continue;
                return result;
            }
            result = compareWith;
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile() {
        try {
            if (!this.checkConfiguration()) {
                return false;
            }
            if (this.workspaceConfigProvider.getWorkspaceConfig() == null && !this.configureWorkspace()) {
                return false;
            }
            ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
            GeneratorConfigProvider.install((ResourceSet)resourceSet, (GeneratorConfig)this.generatorConfig);
            File classDirectory = this.createTempDir("classes");
            try {
                this.compilerPhases.setIndexing((Notifier)resourceSet, true);
                this.installJvmTypeProvider(resourceSet, classDirectory, true);
                this.loadXtendFiles(resourceSet);
                File sourceDirectory = this.createStubs(resourceSet);
                if (!this.preCompileStubs(sourceDirectory, classDirectory)) {
                    log.warn((Object)"Compilation of stubs had errors.");
                }
                if (!this.preCompileJava(sourceDirectory, classDirectory)) {
                    log.debug((Object)"Compilation of Java code against stubs had errors. This is expected and usually is not a probblem.");
                }
            }
            finally {
                this.compilerPhases.setIndexing((Notifier)resourceSet, false);
            }
            this.installJvmTypeProvider(resourceSet, classDirectory, false);
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            List<Issue> issues = this.validate(resourceSet);
            Iterable errors = Iterables.filter(issues, (Predicate)SeverityFilter.ERROR);
            Iterable warnings = Iterables.filter(issues, (Predicate)SeverityFilter.WARNING);
            this.reportIssues(Iterables.concat((Iterable)errors, (Iterable)warnings));
            if (!Iterables.isEmpty((Iterable)errors)) {
                return false;
            }
            this.generateJavaFiles(resourceSet);
            return true;
        }
        finally {
            this.annotationProcessorFactory.setClassLoader(null);
            this.destroyClassLoader(this.jvmTypesClassLoader);
            this.destroyClassLoader(this.annotationProcessingClassLoader);
            if (this.isDeleteTempDirectory()) {
                this.deleteTmpFolders();
            }
        }
    }

    protected void destroyClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)classLoader)).close();
            }
            catch (Exception e) {
                log.warn((Object)"Unable to close a classloader", (Throwable)e);
            }
        }
    }

    protected boolean checkConfiguration() {
        String absoluteOutputPath = this.getOutputPathFile().getAbsolutePath();
        for (String sourcePath : this.getSourcePathDirectories()) {
            if (!absoluteOutputPath.startsWith(sourcePath)) continue;
            log.error((Object)("The configured output path \"" + this.getOutputPathFile() + "\" cannot be a child of the configured source directory \"" + sourcePath + "\"."));
            return false;
        }
        return true;
    }

    protected ResourceSet loadXtendFiles(ResourceSet resourceSet) {
        this.encodingProvider.setDefaultEncoding(this.getFileEncoding());
        final NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setExtension(this.fileExtensionProvider.getPrimaryFileExtension());
        PathTraverser pathTraverser = new PathTraverser();
        List<String> sourcePathDirectories = this.getSourcePathDirectories();
        Multimap pathes = pathTraverser.resolvePathes(sourcePathDirectories, (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                boolean matches = nameBasedFilter.matches(input);
                return matches;
            }
        });
        for (String src : pathes.keySet()) {
            URI srcURI = URI.createFileURI((String)(String.valueOf(src) + "/"));
            URI relativeSrcURI = null;
            relativeSrcURI = this.baseURI != null ? srcURI.deresolve(this.baseURI) : srcURI;
            URI platformResourceURI = null;
            if (relativeSrcURI.isRelative()) {
                platformResourceURI = URI.createPlatformResourceURI((String)relativeSrcURI.toString(), (boolean)true);
            } else {
                String identifier = Joiner.on((String)"_").join((Object[])relativeSrcURI.segments());
                platformResourceURI = URI.createPlatformResourceURI((String)(String.valueOf(identifier) + "/"), (boolean)true);
            }
            resourceSet.getURIConverter().getURIMap().put(platformResourceURI, srcURI);
            for (URI uri : pathes.get((Object)src)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("load xtend file '" + uri + "'"));
                }
                URI uriToUse = uri.replacePrefix(srcURI, platformResourceURI);
                resourceSet.getResource(uriToUse, true);
            }
        }
        return resourceSet;
    }

    @Deprecated
    protected ResourceSet loadXtendFiles() {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        return this.loadXtendFiles(resourceSet);
    }

    protected File createStubs(ResourceSet resourceSet) {
        File outputDirectory = this.createTempDir("stubs");
        JavaIoFileSystemAccess fileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        fileSystemAccess.setOutputPath(outputDirectory.toString());
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            IResourceDescription description = this.resourceDescriptionManager.getResourceDescription(resource);
            this.stubGenerator.doGenerateStubs((IFileSystemAccess)fileSystemAccess, description);
        }
        return outputDirectory;
    }

    protected boolean preCompileStubs(File tmpSourceDirectory, File classDirectory) {
        return this.preCompile(tmpSourceDirectory, Collections.singletonList(tmpSourceDirectory.toString()), this.getClassPathEntries());
    }

    protected boolean preCompileJava(File tmpSourceDirectory, File classDirectory) {
        return this.preCompile(classDirectory, this.getSourcePathDirectories(), Iterables.concat(Collections.singletonList(tmpSourceDirectory.toString()), this.getClassPathEntries()));
    }

    protected boolean preCompile(File classDirectory, Iterable<String> sourcePathDirectories, Iterable<String> classPathEntries) {
        ArrayList commandLine = Lists.newArrayList();
        if (this.isVerbose()) {
            commandLine.add("-verbose");
        }
        if (!Strings.isEmpty((String)this.bootClassPath)) {
            commandLine.add("-bootclasspath \"" + Strings.concat((String)File.pathSeparator, this.getBootClassPathEntries()) + "\"");
        }
        if (!Strings.isEmpty((String)this.classPath)) {
            commandLine.add("-cp \"" + Joiner.on((String)File.pathSeparator).join(classPathEntries) + "\"");
        }
        commandLine.add("-d \"" + classDirectory.toString() + "\"");
        commandLine.add("-" + this.getComplianceLevel());
        commandLine.add("-proceedOnError");
        if (this.encodingProvider.getDefaultEncoding() != null) {
            commandLine.add("-encoding \"" + this.encodingProvider.getDefaultEncoding() + "\"");
        }
        ArrayList sourceDirectories = Lists.newArrayList(sourcePathDirectories);
        commandLine.add(Strings.concat((String)" ", (List)Lists.transform((List)sourceDirectories, (Function)new Function<String, String>(){

            public String apply(String path) {
                return "\"" + path + "\"";
            }
        })));
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke batch compiler with '" + Strings.concat((String)" ", (List)commandLine) + "'"));
        }
        PrintWriter outWriter = this.getStubCompilerOutputWriter();
        return BatchCompiler.compile((String)Strings.concat((String)" ", (List)commandLine), (PrintWriter)outWriter, (PrintWriter)outWriter, null);
    }

    private PrintWriter getStubCompilerOutputWriter() {
        Writer debugWriter = new Writer(){

            @Override
            public void write(char[] data, int offset, int count) throws IOException {
                String message = String.copyValueOf(data, offset, count);
                log.debug((Object)message);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        return new PrintWriter(debugWriter);
    }

    protected List<Issue> validate(ResourceSet resourceSet) {
        ArrayList issues = Lists.newArrayList();
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(resource.getURI());
            if (resourceServiceProvider == null || !this.isSourceFile(resource)) continue;
            IResourceValidator resourceValidator = resourceServiceProvider.getResourceValidator();
            List result = resourceValidator.validate(resource, CheckMode.ALL, null);
            Iterables.addAll((Collection)issues, (Iterable)result);
        }
        return issues;
    }

    protected boolean isSourceFile(Resource resource) {
        if (resource instanceof BatchLinkableResource) {
            return !((BatchLinkableResource)resource).isLoadedFromStorage();
        }
        return false;
    }

    @Deprecated
    protected void installJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory) {
        this.internalInstallJvmTypeProvider(resourceSet, tmpClassDirectory, false);
    }

    protected void installJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory, boolean skipIndexLookup) {
        if (skipIndexLookup) {
            this.internalInstallJvmTypeProvider(resourceSet, tmpClassDirectory, skipIndexLookup);
        } else {
            this.installJvmTypeProvider(resourceSet, tmpClassDirectory);
        }
    }

    private void internalInstallJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory, boolean skipIndexLookup) {
        ClassLoader parentClassLoader;
        Iterable classPathEntries = Iterables.concat(this.getClassPathEntries(), this.getSourcePathDirectories(), Arrays.asList(tmpClassDirectory.toString()));
        classPathEntries = Iterables.filter((Iterable)classPathEntries, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isEmpty((String)input.trim());
            }
        });
        Iterable classpath = Iterables.transform((Iterable)classPathEntries, TO_FILE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("classpath used for Xtend compilation : " + classpath));
        }
        if (this.useCurrentClassLoaderAsParent) {
            parentClassLoader = this.currentClassLoader;
        } else if (Strings.isEmpty((String)this.bootClassPath)) {
            parentClassLoader = ClassLoader.getSystemClassLoader().getParent();
        } else {
            List bootClassPathEntries = Lists.transform(this.getBootClassPathEntries(), TO_FILE);
            parentClassLoader = new AlternateJdkLoader(bootClassPathEntries);
        }
        this.jvmTypesClassLoader = this.createClassLoader(classpath, parentClassLoader);
        new ClasspathTypeProvider(this.jvmTypesClassLoader, resourceSet, skipIndexLookup ? null : this.indexedJvmTypeAccess, null);
        ((XtextResourceSet)resourceSet).setClasspathURIContext((Object)this.jvmTypesClassLoader);
        this.annotationProcessingClassLoader = this.createClassLoader(classpath, this.currentClassLoader);
        this.annotationProcessorFactory.setClassLoader(this.annotationProcessingClassLoader);
    }

    protected ClassLoader createClassLoader(Iterable<File> jarsAndFolders, ClassLoader parentClassLoader) {
        return new URLClassLoader((URL[])Iterables.toArray((Iterable)Iterables.transform(jarsAndFolders, TO_URL), URL.class), parentClassLoader);
    }

    protected void reportIssues(Iterable<Issue> issues) {
        for (Issue issue : issues) {
            StringBuilder issueBuilder = this.createIssueMessage(issue);
            if (Severity.ERROR == issue.getSeverity()) {
                log.error((Object)issueBuilder.toString());
                continue;
            }
            if (Severity.WARNING != issue.getSeverity()) continue;
            log.warn((Object)issueBuilder.toString());
        }
    }

    private StringBuilder createIssueMessage(Issue issue) {
        StringBuilder issueBuilder = new StringBuilder("\n");
        issueBuilder.append(issue.getSeverity()).append(": \t");
        URI uriToProblem = issue.getUriToProblem();
        if (uriToProblem != null) {
            URI resourceUri = uriToProblem.trimFragment();
            issueBuilder.append(resourceUri.lastSegment()).append(" - ");
            if (resourceUri.isFile()) {
                issueBuilder.append(resourceUri.toFileString());
            }
        }
        issueBuilder.append("\n").append(issue.getLineNumber()).append(": ").append(issue.getMessage());
        return issueBuilder;
    }

    protected void generateJavaFiles(ResourceSet resourceSet) {
        JavaIoFileSystemAccess javaIoFileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        javaIoFileSystemAccess.setOutputPath(this.outputPath);
        javaIoFileSystemAccess.setWriteTrace(this.writeTraceFiles);
        for (Resource resource : Lists.newArrayList((Iterable)resourceSet.getResources())) {
            if (!this.isSourceFile(resource)) continue;
            if (this.isWriteStorageFiles()) {
                StorageAwareResource storageAwareResource = (StorageAwareResource)resource;
                storageAwareResource.getResourceStorageFacade().saveResource(storageAwareResource, (IFileSystemAccessExtension3)javaIoFileSystemAccess);
            }
            this.generator.doGenerate(resource, (IFileSystemAccess)javaIoFileSystemAccess);
        }
    }

    protected ResourceSetBasedResourceDescriptions getResourceDescriptions(ResourceSet resourceSet) {
        ResourceSetBasedResourceDescriptions resourceDescriptions = (ResourceSetBasedResourceDescriptions)this.resourceSetDescriptionsProvider.get();
        resourceDescriptions.setContext((Notifier)resourceSet);
        resourceDescriptions.setRegistry(IResourceServiceProvider.Registry.INSTANCE);
        return resourceDescriptions;
    }

    protected XtendFile getXtendFile(Resource resource) {
        EObject model;
        XtextResource xtextResource = (XtextResource)resource;
        IParseResult parseResult = xtextResource.getParseResult();
        if (parseResult != null && (model = parseResult.getRootASTElement()) instanceof XtendFile) {
            XtendFile xtendFile = (XtendFile)model;
            return xtendFile;
        }
        return null;
    }

    protected List<String> getClassPathEntries() {
        return this.getDirectories(this.classPath);
    }

    protected List<String> getBootClassPathEntries() {
        return this.getDirectories(this.bootClassPath);
    }

    protected List<String> getSourcePathDirectories() {
        return this.getDirectories(this.sourcePath);
    }

    protected List<String> getDirectories(String path) {
        if (Strings.isEmpty((String)path)) {
            return Lists.newArrayList();
        }
        List split = Strings.split((String)Strings.emptyIfNull((String)path), (String)File.pathSeparator);
        return Lists.transform((List)split, (Function)new Function<String, String>(){

            public String apply(String from) {
                return new File(new File(from).getAbsoluteFile().toURI().normalize()).getAbsolutePath();
            }
        });
    }

    protected File createTempDir(String prefix) {
        File tempDir = new File(this.getTempDirectory(), String.valueOf(prefix) + System.nanoTime());
        XtendBatchCompiler.cleanFolder(tempDir, ACCEPT_ALL_FILTER, true, true);
        if (!tempDir.mkdirs()) {
            throw new RuntimeException("Error creating temp directory '" + tempDir.getAbsolutePath() + "'");
        }
        this.tempFolders.add(tempDir);
        return tempDir;
    }

    protected void deleteTmpFolders() {
        for (File file : this.tempFolders) {
            XtendBatchCompiler.cleanFolder(file, ACCEPT_ALL_FILTER, true, true);
        }
    }

    protected static boolean cleanFolder(File parentFolder, FileFilter filter, boolean continueOnError, boolean deleteParentFolder) {
        if (!parentFolder.exists()) {
            return true;
        }
        if (filter == null) {
            filter = ACCEPT_ALL_FILTER;
        }
        log.debug((Object)("Cleaning folder " + parentFolder.toString()));
        File[] contents = parentFolder.listFiles(filter);
        int j = 0;
        while (j < contents.length) {
            File file = contents[j];
            if (file.isDirectory()) {
                if (!XtendBatchCompiler.cleanFolder(file, filter, continueOnError, true) && !continueOnError) {
                    return false;
                }
            } else if (!file.delete()) {
                log.error((Object)("Couldn't delete " + file.getAbsolutePath()));
                if (!continueOnError) {
                    return false;
                }
            }
            ++j;
        }
        if (deleteParentFolder && parentFolder.list().length == 0 && !parentFolder.delete()) {
            log.error((Object)("Couldn't delete " + parentFolder.getAbsolutePath()));
            return false;
        }
        return true;
    }

    @Deprecated
    public Writer getOutputWriter() {
        log.warn((Object)"XtendBatchCompiler.getOutputWriter has been deprecated");
        return this.outputWriter;
    }

    @Deprecated
    public void setOutputWriter(Writer ouputWriter) {
        log.warn((Object)"XtendBatchCompiler.setOutputWriter has been deprecated");
        this.outputWriter = ouputWriter;
    }

    @Deprecated
    public Writer getErrorWriter() {
        log.warn((Object)"XtendBatchCompiler.getErrorWriter has been deprecated");
        return this.errorWriter;
    }

    @Deprecated
    public void setErrorWriter(Writer errorWriter) {
        log.warn((Object)"XtendBatchCompiler.setErrorWriter has been deprecated");
        this.errorWriter = errorWriter;
    }

    private static final class SeverityFilter
    implements Predicate<Issue> {
        private static final SeverityFilter WARNING = new SeverityFilter(Severity.WARNING);
        private static final SeverityFilter ERROR = new SeverityFilter(Severity.ERROR);
        private Severity severity;

        private SeverityFilter(Severity severity) {
            this.severity = severity;
        }

        public boolean apply(Issue issue) {
            return this.severity == issue.getSeverity();
        }
    }
}

